

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEGetIndexServerNodeStats.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SEGetIndexServerNodeStats.sp,v $ $Id: SEGetIndexServerNodeStats.sp,v 1.1.2.5 2020/09/29 19:40:38 canand Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SEGetIndexServerNodeStats')
BEGIN
	print '>>> Drop Stored Procedure: SEGetIndexServerNodeStats <<<'
	drop procedure SEGetIndexServerNodeStats
END
IF EXISTS (select * from GxQscripts where name='SEGetIndexServerNodeStats')
	delete from GxQscripts where name = 'SEGetIndexServerNodeStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetIndexServerNodeStats')
	delete from GXDBVersions where aliasname = 'SEGetIndexServerNodeStats'
GO
print '... Creating Procedure: SEGetIndexServerNodeStats'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SEGetIndexServerNodeStats
  @i_UserId INT,
  @i_GetUsageByRole TINYINT = 0,
  @i_IndexServerClientId INT = 0
AS
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
if OBJECT_ID('tempdb.dbo.#permissionIdTable') is not null
	drop table #permissionIdTable
if OBJECT_ID('tempdb.dbo.#getObjectsWithPermissionsV2WrapperExtTbl') is not null
    drop table #getObjectsWithPermissionsV2WrapperExtTbl
--
-- create necessary temp tables
--
CREATE TABLE #permissionIdTable (
    permissionId INT
)
CREATE TABLE #getObjectsWithPermissionsV2WrapperExtTbl (
    entityId INT,
    permissionId INT
)
insert into #permissionIdTable
SELECT 31  -- $$EV_VISIBILITY (31)
--
-- get clients allowed for logged-in user
--
exec sec_getObjectsWithPermissionsV2Wrapper @i_UserId, 3 /* $$CLIENT_ENTITY */ , 1 /* honorPrivacy */, 0 /* shouldSelectOutput */
--
-- Return
--
IF ISNULL(@i_GetUsageByRole,0) = 1
BEGIN
	DECLARE @CoresList TABLE ( coreName VARCHAR(256), indexServerClientId INTEGER, roleName varchar(256) )
	DECLARE @RolePropertyId INT = 0
	SELECT @RolePropertyId = PropertyId FROM seproperty where PropertyName = 'roletypename'
	INSERT INTO @CoresList
	SELECT * FROM dbo.GetAnalyticsStaticCores('', 0)
	;with CteDataByRole
	as
	(
	SELECT a.displayname,
	(CASE WHEN m.roleTypeName IS NOT NULL THEN m.roleTypeName ELSE SP.PropertyValue END) roleName,
	A.name clientName,
	A.Id ClientId,
	SE.Size,
	SE.ItemCount,
	S.DisplayName CloudDisplayName,
	S.CloudId
	FROM SEIndexServerNodeStats SE
	JOIN DM2SearchServerCoreInfo I ON SE.SearchServerCoreId = I.CoreId
	LEFT JOIN @CoresList CO ON CO.coreName = SE.CoreName
	LEFT JOIN SEDataSourceProperty SP ON SE.DataSourceId = SP.DataSourceId AND PropertyId = @RolePropertyId
	JOIN DM2CloudRoleMaster M ON (CO.roleName = M.RoleTypeName OR SP.PropertyValue = M.RoleTypeName)
	JOIN DM2CloudCoreRole CC ON I.CloudId = CC.CloudId AND M.RoleId = CC.RoleId
	JOIN DM2Cloud S ON CC.cloudid = S.cloudid
	JOIN APP_CLIENT A ON I.ClientId = A.Id
JOIN #getObjectsWithPermissionsV2WrapperExtTbl T ON A.id = T.entityId AND T.permissionId = 31
JOIN #getObjectsWithPermissionsV2WrapperExtTbl U ON S.pseudoClientId = U.entityId AND U.permissionId = 31
	WHERE SE.ItemCount > 0 AND (CO.roleName IS NOT NULL OR SP.PropertyValue IS NOT NULL) AND (@i_IndexServerClientId = 0 OR S.pseudoClientId = @i_IndexServerClientId)
	)
	SELECT roleName '@roleName',
	sum(Size) '@totalSizeOfFiles', sum(itemcount) '@totalDocs',
	DisplayName '@displayName', ClientId '@clientId', ClientName '@clientName',
	(SELECT CloudDisplayName '@cloudDisplayName', CloudId '@cloudId' FOR XML PATH('indexServer'), TYPE)
	FROM CteDataByRole
	GROUP BY DisplayName, ClientName, ClientId, roleName, CloudId, CloudDisplayName
	FOR XML PATH('diskUsage'), ROOT('DM2ContentIndexing_IndexServerNodeDiskResp')
END
ELSE
BEGIN
;with cteSum
as
(
SELECT S.ClientId AS NodeClientId, sum(size) TotalSize, sum(ItemCount) TotalItemCount
FROM SEIndexServerNodeStats SE, DM2SearchServerCoreInfo S
WHERE SE.SearchServerCoreId = S.CoreId AND SE.ItemCount > 0 AND SE.CoreName NOT IN (select distinct coreName from DBO.GetAnalyticsStaticCores('System Default', 0))
GROUP BY S.ClientId
)
SELECT R.NodeClientId as '@clientId', E.displayName '@displayName', e.name '@clientName',
R.TotalItemCount '@totalDocs', R.TotalSize '@totalSizeOfFiles', S.FreeSpace '@freeSpace',
DY.indexLocation '@indexLocation',
(SELECT CL.displayName '@cloudDisplayName', CL.cloudId '@cloudId', CL.name '@cloudName' FOR XML PATH('indexServer'), TYPE)
FROM cteSum R
JOIN #getObjectsWithPermissionsV2WrapperExtTbl T ON R.NodeClientId = T.entityId AND T.permissionId = 31
JOIN DM2SearchServerCoreInfo S ON R.NodeClientId = S.ClientId
JOIN DM2Cloud CL ON CL.cloudId = S.CloudId AND (@i_IndexServerClientId = 0 OR CL.pseudoClientId = @i_IndexServerClientId)
JOIN dbo.SEGetAllIndexLocations(0, 0) DY ON DY.cloudId = S.CloudId AND DY.ClientId = S.ClientId
JOIN APP_Client E ON E.Id = S.ClientId
JOIN #getObjectsWithPermissionsV2WrapperExtTbl U ON U.entityId = CL.pseudoClientId AND U.permissionId = 31
FOR XML PATH('diskUsage'), ROOT('DM2ContentIndexing_IndexServerNodeDiskResp')
END
--
-- Clean up
--
if OBJECT_ID('tempdb.dbo.#permissionIdTable') is not null
	drop table #permissionIdTable
if OBJECT_ID('tempdb.dbo.#getObjectsWithPermissionsV2WrapperExtTbl') is not null
    drop table #getObjectsWithPermissionsV2WrapperExtTbl
END
GO

IF EXISTS (select * from GxQscripts where name = 'SEGetIndexServerNodeStats')
	delete from GxQscripts where name = 'SEGetIndexServerNodeStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetIndexServerNodeStats')
	delete from GXDBVersions where aliasname = 'SEGetIndexServerNodeStats'
GO

insert into GXDBVersions values(2, 'SEGetIndexServerNodeStats',  '00010001000200050000', 'SEGetIndexServerNodeStats', '00010001000200050000')
GO

