

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEGetEdiscoveryDatasources.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--		  Given a list of Project Ids, this SP will return list of datasources
--		  If '0' is given in the list, this SP will return all datasources from all Projects to which user has access permissions.
--			To call this store procedure from another store procedure, temp table: #EdiscoveryDatasources (datasourceId INT)
--			IS REQUIRED to be created which is used to transfer list of datasources to the consuming store procedure.
--			After consuming store procedure is done using those values in this table, this table MUST be DROPPED.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SEGetEdiscoveryDatasources <<<'

IF EXISTS (select * from sysobjects where name='SEGetEdiscoveryDatasources')
	drop procedure SEGetEdiscoveryDatasources
IF EXISTS (select * from GxQscripts where name='SEGetEdiscoveryDatasources')
	delete from GxQscripts where name = 'SEGetEdiscoveryDatasources'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetEdiscoveryDatasources')
	delete from GXDBVersions where aliasname = 'SEGetEdiscoveryDatasources'
GO
print '... Creating Procedure: SEGetEdiscoveryDatasources'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SEGetEdiscoveryDatasources
  @i_UserId INT,
  @i_ProjectIdsList VARCHAR(MAX),
  @i_CallFromAnotherSp INT,
  @o_ErrorCode VARCHAR(MAX) OUTPUT,
  @o_ErrorMsg VARCHAR(MAX) OUTPUT
AS
BEGIN
	--
	DECLARE @numPJ INT = 0
	DECLARE @allEntities INT = 0
	DECLARE @projectFilter VARCHAR(100) = ''
	DECLARE @doDelete INT = 0
	--
	-- check input's validity
	IF (@i_UserId <= 0)
		BEGIN
			SET @o_ErrorCode = 1
			SET @o_ErrorMsg = 'Invalid user Id'
			GOTO exitLine
		END
	IF (@i_ProjectIdsList = '')
		BEGIN
			SET @o_ErrorCode = 1
			SET @o_ErrorMsg = 'Empty project Id list'
			GOTO exitLine
		END
	IF OBJECT_ID('tempdb.dbo.#InputProjectId') IS NOT NULL
	BEGIN
		DROP TABLE #InputProjectId
	END
	CREATE TABLE #InputProjectId (projectId INT);
	INSERT INTO #InputProjectId (projectId)
	SELECT a._ID FROM dbo.SplitIDs(@i_ProjectIdsList) a
	SET @numPJ = (SELECT COUNT(*) FROM #InputProjectId)
	IF (@numPJ = 0)
		BEGIN
			SET @o_ErrorCode = 1
			SET @o_ErrorMsg = 'Empty project Id list'
			GOTO exitLine
		END
	ELSE IF (@numPJ = 1)
		-- there are 2 cases when number of project Ids
		-- if project Id = 0 => get all datasources from all projects
		-- otherwise form project filter used to add to request when calling AppGetEDiscoveryClientProperties
		BEGIN
			DECLARE @projectId INT = (SELECT TOP 1 projectId FROM #InputProjectId)
			IF (@projectId = 0)
				BEGIN
					SET @allEntities = 1
					SET @projectFilter = ''
					SET @doDelete = 0
				END
			ELSE
				BEGIN
					SET @allEntities = 0
					SET @projectFilter = '<eDiscoveryClient clientId="' + CONVERT(varchar(13), @projectId) + '" />'
					SET @doDelete = 0
				END
		END
	ELSE
		BEGIN
			SET @allEntities = 1
			SET @projectFilter = ''
			SET @doDelete = 1
		END
	DECLARE @requestString VARCHAR(MAX) = '<App_GetEDiscoveryClientPropertiesRequest eDiscoverySubType="2">
		<processinginstructioninfo>
			<locale localeId="0" />
			<formatFlags skipIdToNameConversion="1" />
			<user userId="'+ CONVERT(varchar(13), @i_UserId) +'" />
		</processinginstructioninfo>
		'
		+
		@projectFilter
		+
		'
		<filterOptions allEntities="' + CONVERT(varchar(1), @allEntities) + '" propertyLevel="30" />
	</App_GetEDiscoveryClientPropertiesRequest>'
	DECLARE @request XML;
	SET @request = @requestString
	DECLARE @output XML;
	DECLARE @tblProjects TABLE ( outXML XML)
	INSERT INTO @tblProjects
	EXEC AppGetEDiscoveryClientProperties @request
	SELECT @output = outXML FROM @tblProjects
	IF OBJECT_ID('tempdb.dbo.#DatasourcesList') IS NOT NULL
	BEGIN
		DROP TABLE #DatasourcesList
	END
	CREATE TABLE #DatasourcesList (datasourceId INT, projectId INT);
	INSERT INTO #DatasourcesList
	SELECT
		tempTable.dsId.value('@seaDataSourceId','int') AS datasourceId,
		tempTable.dsId.value('(../../eDiscoveryClient/@clientId)[1]','int') AS projectId
	FROM @output.nodes('App_GetEDiscoveryClientPropertiesResponse/eDiscoveryClientProp/eDiscoveryClientInfo/dataSources') AS tempTable(dsId)
	IF(@doDelete = 1)
		BEGIN
			DELETE FROM #DatasourcesList
			WHERE projectId NOT IN (SELECT projectId FROM #InputProjectId)
		END
	-- return final list of datasources from given list of project Ids
	SET @o_ErrorCode = 0
	SET @o_ErrorMsg = ''
	-- if this is a call from another store procedure, put results into a temp table, so that consuming store procedure can get found values from there
	-- otherwise, return results by a select statement
	--
	IF (@i_CallFromAnotherSp = 1)
		BEGIN
			-- assume there is already a table named #EdiscoveryDatasources generated by consumer (calling stored procedure)
			-- consumer MUST drop the table when it is done getting data from this temp table
			--
			IF OBJECT_ID('tempdb.dbo.#EdiscoveryDatasources') IS NOT NULL
				BEGIN
					DELETE FROM #EdiscoveryDatasources
					INSERT INTO #EdiscoveryDatasources
					SELECT DISTINCT datasourceId FROM #DatasourcesList
				END
		END
	ELSE
		BEGIN
			SELECT DISTINCT datasourceId FROM #DatasourcesList
		END
	--	Clean up and exit
exitLine:
	IF OBJECT_ID('tempdb.dbo.#InputProjectId') IS NOT NULL
		BEGIN
			DROP TABLE #InputProjectId
		END
	IF OBJECT_ID('tempdb.dbo.#FinalResults') IS NOT NULL
		BEGIN
			DROP TABLE #FinalResults
		END
END
GO

IF EXISTS (select * from GxQscripts where name = 'SEGetEdiscoveryDatasources')
	delete from GxQscripts where name = 'SEGetEdiscoveryDatasources'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetEdiscoveryDatasources')
	delete from GXDBVersions where aliasname = 'SEGetEdiscoveryDatasources'
GO

insert into GXDBVersions values(2, 'SEGetEdiscoveryDatasources',  '00000000000000000000', 'SEGetEdiscoveryDatasources', '00000000000000000000')
GO

