

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEGetDynamicDataSourceInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SEGetDynamicDataSourceInfo')
BEGIN
	print '>>> Drop Stored Procedure: SEGetDynamicDataSourceInfo <<<'
	drop procedure SEGetDynamicDataSourceInfo
END
IF EXISTS (select * from GxQscripts where name='SEGetDynamicDataSourceInfo')
	delete from GxQscripts where name = 'SEGetDynamicDataSourceInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetDynamicDataSourceInfo')
	delete from GXDBVersions where aliasname = 'SEGetDynamicDataSourceInfo'
GO
print '... Creating Procedure: SEGetDynamicDataSourceInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SEGetDynamicDataSourceInfo
  @userId INT,
  @EntityType INT,
  @EntityIdList VARCHAR(MAX),
  @handlerName VARCHAR(100),
  @ErrorMsg VARCHAR(MAX) OUTPUT,
  @ExtendedSearch INT = 0,
  @dsTypeName VARCHAR(256) = '', /* [Anh] Datasource type name: DM2ContentIndexing.x/ SEDSType.tostring*/
  @debug INT = 0,
  @reportsSearch INT = 0	/* with this flag set, use the input entity directly to retrieve the search handler.*/
AS
BEGIN
	--
	DECLARE @permissionIdList VARCHAR(1000) = ''
	DECLARE	@i_start INT = 0
	DECLARE	@i_batchCnt INT = 100000
	DECLARE @i_includeCoreInfo INT = 1
	DECLARE @permissionId INT = 0
DECLARE	@ClientGroupEntityId int = 28
DECLARE	@CLIENT_ENTITY int = 3
DECLARE @DATASOURCE_ENTITY int = 132
DECLARE	@BACKUPSET_ENTITY int = 6 /* BACKUPSET_ENTITY = 6 */
DECLARE	@SUBCLIENT_ENTITY int = 7 /* SUBCLIENT_ENTITY = 7 */
DECLARE @HANDLER_ENTITY int = 157 /* SEA_SEARCH_HANDLER_ENTITY = 157*/
DECLARE @EDISCOVERY_PROJECT_ENTITY int = 188 /* EDISCOVERY_PROJECT_ENTITY  = 188*/
	DECLARE	@dataSourceType INT = 0
	DECLARE @typeGuid       VARCHAR(36) = ''
	DECLARE @isEnterpriseCommCell int = 1 /*  Find if current comm-cell is in MSP or Enterprise mode */
	DECLARE @tblDataSourceType TABLE(DataSourceTypeId int)
	DECLARE @ignoreDataSourceType INT = 1
	--
	SET @ErrorMsg = ''
	IF @debug IS NULL SET @debug = 0
	IF @ExtendedSearch IS NULL SET @ExtendedSearch = 0
	--
	IF @EntityType IS NULL SET @EntityType = 0
	IF @EntityIdList IS NULL SET @EntityIdList = ''
	IF ISNULL(@handlerName,'') = '' SET @handlerName = 'default'
	-- [Anh] if datasource type is provided, verify if it is valid before proceeding
	IF ISNULL(@EntityIdList, '') = 'all'
	BEGIN
		INSERT INTO @tblDataSourceType
		SELECT TypeId FROM SEDataSourceType
		WHERE TypeGuid  in ( 'BD7B9A6B-A824-47D5-AD9D-41CA34659D92' -- vm -- AS of SP22 and forward, global search is limited to VSA data and FS data - how-ever FS Datasources are fetched in different way at the end!
		)
	END
	IF ISNULL(@dsTypeName, '') <> ''
	BEGIN
		--retrieve typeguid
		SELECT @dataSourceType = T.TypeId, @typeGuid = T.TypeGuid
		FROM SEDataSourceType AS T WITH (NOLOCK) WHERE T.TypeName = @dsTypeName AND (T.Attribute & 4)  = 0
		IF ISNULL(@typeGuid,'')  = ''
		BEGIN
			SET @ErrorMsg = ' Input datasource type ' + @dsTypeName + ' is not valid'
			GOTO exitLine;
		END
		INSERT INTO @tblDataSourceType
		SELECT @dataSourceType
	END
	IF EXISTS (SELECT 1 FROM @tblDataSourceType)
	BEGIN
		SET @ignoreDataSourceType = 0
	END
	IF @debug = 1
	BEGIN
		SELECT DataSourceTypeId as RequestedDataSourceType FROM @tblDataSourceType
	END
	-- [Anh] if datasource type is provided, verify if it is validation before proceed
	--
	IF OBJECT_ID('tempdb.dbo.#InputEntityId') IS NOT NULL
	BEGIN
		DROP TABLE #InputEntityId
	END
	--
	CREATE TABLE #InputEntityId (
		entityId INT
	);
	--
	DECLARE @allData BIT = CASE WHEN @EntityIdList = 'all' THEN 1 ELSE 0 END
	IF @allData = 0
	BEGIN
		insert into #InputEntityId (entityId)
		SELECT a._ID FROM dbo.SplitIDs(@EntityIdList) a
		--
		IF @EntityType NOT IN (@ClientGroupEntityId, @CLIENT_ENTITY, @DATASOURCE_ENTITY, @BACKUPSET_ENTITY, @SUBCLIENT_ENTITY, @EDISCOVERY_PROJECT_ENTITY)
		BEGIN
			SET @ErrorMsg = 'Unsupported entity type [' + convert(varchar, @EntityType) + '] is supplied'
			GOTO exitLine
		END
		IF @EntityType = @ClientGroupEntityId AND EXISTS (select entityid from #InputEntityId a left join APP_ClientGroup B WITH(NOLOCK) ON a.entityId = b.id where b.id is null)
		BEGIN
			SET @ErrorMsg = 'EntityId input = [' + @EntityIdList + '] has invalid client group id.'
			GOTO exitLine
		END
		ELSE IF @EntityType = @CLIENT_ENTITY AND EXISTS (select entityid from #InputEntityId a left join APP_CLIENT B WITH(NOLOCK) ON a.entityId = b.id WHERE b.id is null)
		BEGIN
			SET @ErrorMsg = 'EntityId input = [' + @EntityIdList + '] has invalid client id.'
			GOTO exitLine
		END
		ELSE IF @EntityType = @DATASOURCE_ENTITY AND EXISTS (select entityid from #InputEntityId a left join SEDataSource B WITH(NOLOCK) ON a.entityId = b.DataSourceId WHERE b.DataSourceId is null)
		BEGIN
			SET @ErrorMsg = 'EntityId input = [' + @EntityIdList + '] has invalid data source id.'
			GOTO exitLine
		END
		-- [Anh]
		ELSE IF @EntityType = @BACKUPSET_ENTITY AND EXISTS (select entityid from #InputEntityId a left join App_BackupSetName B WITH(NOLOCK) ON a.entityId = b.id WHERE b.id is null)
		BEGIN
			SET @ErrorMsg = 'EntityId input = [' + @EntityIdList + '] has invalid backup set id.'
			GOTO exitLine
		END
		ELSE IF @EntityType = @SUBCLIENT_ENTITY AND EXISTS (select entityid from #InputEntityId a left join App_Application B WITH(NOLOCK) ON a.entityId = b.id WHERE b.id is null)
		BEGIN
			SET @ErrorMsg = 'EntityId input = [' + @EntityIdList + '] has invalid subclient id.'
			GOTO exitLine
		END
	END
	-- [Anh]
	--
	-- If entitytype is ediscovery project entity:
	--	--	It is required to get list of datasources from given projects
	--	--	by calling SEGetEdiscoveryDatasources
	--	--	To do that, temp table #EdiscoveryDatasources (datasourceId INT) is required to be generated beforehand
	IF @EntityType = @EDISCOVERY_PROJECT_ENTITY
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#EdiscoveryDatasources') IS NOT NULL
		BEGIN
			DROP TABLE #EdiscoveryDatasources
		END
		CREATE TABLE #EdiscoveryDatasources (datasourceId INT);
		DECLARE @errCode INT;
		DECLARE @errMsg VARCHAR(MAX);
		IF @reportsSearch = 1
		BEGIN
			INSERT INTO #EdiscoveryDatasources
			SELECT p.attrVal FROM app_clientProp p JOIN #InputEntityId I on
			p.componentNameId = I.entityId And p.attrName='Datasource Id' and modified=0
		END
		ELSE
		BEGIN
		EXEC SEGetEdiscoveryDatasources @userId, @EntityIdList, 1, @errCode OUT, @errMsg OUT
		IF (@errCode != 0)
		BEGIN
			SET @ErrorMsg = 'Failed to get list of associated datasources. Error:' + @errMsg
			GOTO exitLine
		END
		END
		IF ((SELECT COUNT(*) FROM #EdiscoveryDatasources) = 0)
		BEGIN
			SET @ErrorMsg = 'There is not associated datasources found for this user'
			GOTO exitLine
		END
		-- copy datasourceId to inputEntity, and assign @EntityType to DATASOURCE_ENTITY
		--
		SET @EntityType = @DATASOURCE_ENTITY
		DELETE FROM #InputEntityId
		INSERT INTO #InputEntityId(entityId)
		SELECT datasourceId FROM #EdiscoveryDatasources
	END
SELECT @permissionId = 13  -- EV_BROWSE (13)
	--
	IF OBJECT_ID('tempdb.dbo.#permissionIdTable') IS NOT NULL
	BEGIN
		DROP TABLE #permissionIdTable
	END
	--
	CREATE TABLE #permissionIdTable (
		permissionId INT
	);
	--
	--Tables to be used by SP sec_getObjectsWithPermissionsV2
	IF OBJECT_ID('tempdb.dbo.#getObjectsTable') IS NOT NULL
	BEGIN
		DROP TABLE #getObjectsTable
	END
	--
	CREATE TABLE #getObjectsTable (
		entityId INT,
		permissionId INT
	);
	--
	-- Table to be used by sec_getIDAObjectsForUserWithPrivacy
	--
	IF object_id('tempdb.dbo.#ClientsOutputTable') is not null
	BEGIN
		DROP TABLE #ClientsOutputTable
	END
	--
	CREATE TABLE #ClientsOutputTable
	(
		clientID INT,
		appTypeId INT,
		instanceId INT,
		backupsetID INT,
		subclientId INT
	);
	--
	-- This table helps with V1 VM clients permission checking
	--
	IF object_id('tempdb.dbo.#AdminClientsOutputTable') is not null
	BEGIN
		DROP TABLE #AdminClientsOutputTable
	END
	--
	CREATE TABLE #AdminClientsOutputTable
	(
		clientID INT,
		appTypeId INT,
		instanceId INT,
		backupsetID INT,
		subclientId INT
	);
	DECLARE @tblSearchview TABLE ( cnt INT IDENTITY (1,1), viewId INT, dsId INT, permissionType INT default 3 /*other*/, searchViewName NVARCHAR(128), searchViewAttribute INT, viewInfo NVARCHAR(128), referenceId INT);
	IF @EntityType = @DATASOURCE_ENTITY
	BEGIN
		IF @reportsSearch = 1
		BEGIN
			INSERT INTO @tblSearchview (viewId, permissionType)
			select DISTINCT SE.searchviewid, 0 as permissionType from SESearchView SE
				WHERE SE.SearchViewName = @handlerName
				AND SE.Status = 1 /* Handler */
				AND SE.DatasourceId IN (SELECT entityId FROM #InputEntityId)
		END
		ELSE
		BEGIN
			INSERT INTO #permissionIdTable
SELECT 204
			UNION
SELECT 202
			-- Find if current comm-cell is in MSP or Enterprise mode.
			--
			IF EXISTS (SELECT 1 FROM GXGlobalParam WITH(NOLOCK) WHERE name = N'IsMSPCommcell' and value = '1' AND modified = 0)
			BEGIN
				SET @isEnterpriseCommCell = 0
			END
			IF @isEnterpriseCommCell = 1
			BEGIN
				INSERT INTO #permissionIdTable
				SELECT @permissionId /* EV_BROWSE */
			END
			-- Get all handlers which this user has execute permission
			--
			-- so #getObjectsTable contains all HandlerId which user has execute permision
			-- NOT datasourceId
			EXEC sec_getObjectsWithPermissionsV2 @UserId, @HANDLER_ENTITY ,0
			-- filter datasources based on datasource type
			--
			IF (@ignoreDataSourceType = 0)
			BEGIN
				DELETE T
				FROM #getObjectsTable as T INNER JOIN
				SESearchView SE ON SE.SearchViewId = T.entityId AND SE.DatasourceId NOT IN (SELECT DataSourceId FROM SEDataSource A WHERE A.DataSourceType IN (SELECT DataSourceTypeId FROM @tblDataSourceType))
			END
			-- remove handler that are not part of the input datasource
			--
			DELETE T
			FROM #getObjectsTable as T INNER JOIN
				SESearchView SE ON SE.SearchViewId = T.entityId AND SE.DatasourceId NOT IN (SELECT entityId FROM #InputEntityId)
			INSERT INTO @tblSearchview (viewId, permissionType)
			SELECT DISTINCT G.entityId, 0 as permissionType
			FROM #getObjectsTable G
			JOIN SESearchView SE ON G.entityId = SE.SearchViewId
				AND SE.SearchViewName = @handlerName
				AND SE.Status = 1 /* Handler */
		END
	END
	ELSE
	BEGIN
		--
		-- we are only interested in requested capability
		--
		--
		INSERT INTO #permissionIdTable
		SELECT @permissionId
		--
		IF @ExtendedSearch = 1
		BEGIN
			INSERT INTO #permissionIdTable
SELECT 24		-- EV_FAST_ENDUSER_SEARCH (24)
			UNION
SELECT 25	-- EV_FAST_COMPLIANCE_SEARCH (25)
		END
		--
		-- concat all permissions into a comma separated string
		--
		SELECT @permissionIdList = STUFF((SELECT ',' "text()", permissionId "text()" FROM #permissionIdTable FOR XML PATH('')), 1, 1, '')
		--
		-- fetch sub clients irrespective of what ida entity type requested as this is most atomic level at which permissions could be given
		--
		EXEC sec_getIDAObjectsForUserWithPrivacy @UserId, @SUBCLIENT_ENTITY, 0, 0, '#ClientsOutputTable', 1, 0, @permissionIdList
		--
		-- populating the extra table data needed for v1 VMs
		-- We could have taken the clients info from #ClientsOutputTable table, but as v1 VMs have no subclients under them
		-- security layer is not returning any data here thus we are having to invoke security SP input entity as client..
		--
		IF @ExtendedSearch = 1
		BEGIN
EXEC sec_getIDAObjectsForUserWithPrivacy @UserId, @CLIENT_ENTITY, 0, 1, '#AdminClientsOutputTable', 1, 0, '13,25'
		END
		--
		IF OBJECT_ID('tempdb.dbo.#FinalEntities') IS NOT NULL
		BEGIN
			DROP TABLE #FinalEntities
		END
		--
		CREATE TABLE #FinalEntities (
			clientId INT,
			backupsetID INT default 0,
			subclientId INT default 0
		);
		if object_id('tempdb.dbo.#VMClients') is not null
			drop table #VMClients
		--
		CREATE TABLE #VMClients
		(
			VMClientId INT,
			VSASubClientId INT,
			VSABackupSetId INT,
			VSAClientId	int
		)
		--
		CREATE INDEX TempIDX_VSABackupSetId ON #VMClients(VSABackupSetId)
		--
		IF @EntityType = @CLIENT_ENTITY
		BEGIN
			CREATE INDEX TempIDX_VMClientId ON #VMClients(VMClientId)
			CREATE INDEX TempIDX_VSAClientId ON #VMClients(VSAClientId)
		END
		ELSE IF @EntityType = @SUBCLIENT_ENTITY
		BEGIN
			CREATE INDEX TempIDX_VSASubClientId ON #VMClients(VSASubClientId)
		END
		--
		CREATE INDEX TempIDX_ClientID ON #FinalEntities(clientID)
		CREATE INDEX TempIDX_BackupSetId ON #FinalEntities(backupsetID)
		CREATE INDEX TempIDX_SubClientId ON #FinalEntities(subclientId)
		--
		-- if client program is not filtering and looking to search all (global) data
		-- then capture all permitted clients
		--
		IF @EntityType = @ClientGroupEntityId
		BEGIN
			IF @reportsSearch = 1
			BEGIN
				INSERT INTO #FinalEntities (clientId)
				SELECT G.clientId from #InputEntityId I
				INNER JOIN APP_ClientGroupAssoc G ON I.entityId = G.clientGroupId
			END
			ELSE IF @allData = 1
			BEGIN
				--
				-- All permitted clients of all client groups in the system..
				--
				INSERT INTO #FinalEntities (clientId,backupsetID,subclientId)
				SELECT A.clientID, a.backupsetID, a.subclientId from #ClientsOutputTable a
				INNER JOIN app_client b on a.clientID = b.id
				INNER JOIN APP_ClientGroupAssoc G ON b.id = G.clientId
			END
			ELSE
			BEGIN
				--
				-- permitted clients in requested client groups
				--
				INSERT INTO #FinalEntities (clientId,backupsetID,subclientId)
				SELECT a.clientID, a.backupsetID, a.subclientId from #ClientsOutputTable a
				INNER JOIN app_client b on a.clientID = b.id
				INNER JOIN APP_ClientGroupAssoc G ON b.id = G.clientId
				INNER JOIN #InputEntityId I ON I.entityId = G.clientGroupId
			END
		END
		ELSE IF (@EntityType = @CLIENT_ENTITY)
		BEGIN
			IF @reportsSearch = 1
			BEGIN
				INSERT INTO #FinalEntities (clientId)
				SELECT entityId FROM #InputEntityId
			END
			ELSE IF @allData = 1
			BEGIN
				--
				-- all permitted clients
				--
				INSERT INTO #FinalEntities (clientId, backupsetID, subclientId)
				SELECT clientID, backupsetID, subclientId FROM #ClientsOutputTable
			END
			ELSE
			BEGIN
				--
				-- permitted clients intersection with requested clients
				--
				INSERT INTO #FinalEntities (clientId, backupsetID, subclientId)
				SELECT clientID, backupsetID, subclientId FROM #InputEntityId a INNER join #ClientsOutputTable B on a.entityId = b.clientID
			END
		END
		ELSE IF (@EntityType = @BACKUPSET_ENTITY)
		BEGIN
			IF @reportsSearch = 1
			BEGIN
				INSERT INTO #FinalEntities (backupsetID)
				SELECT A.entityId FROM #InputEntityId A
			END
			ELSE
			BEGIN
				INSERT INTO #FinalEntities (clientId, backupsetID, subclientId)
				SELECT C.clientId, C.backupsetID, C.subclientId FROM #InputEntityId A
				INNER JOIN #ClientsOutputTable C ON A.entityId = C.backupsetID
			END
		END
		ELSE IF (@EntityType = @SUBCLIENT_ENTITY)
		BEGIN
			IF @reportsSearch = 1
			BEGIN
				INSERT INTO #FinalEntities (subclientId)
				SELECT A.entityId FROM #InputEntityId A
			END
			ELSE
			BEGIN
				INSERT INTO #FinalEntities (clientId, backupsetID, subclientId)
				SELECT C.clientID, C.backupsetID, C.subclientId FROM #InputEntityId A
				INNER JOIN #ClientsOutputTable C ON A.entityId = C.subclientId
			END
		END
		IF @debug = 1
		BEGIN
			SELECT clientId, backupsetID, subclientId 'AllowedSubClientId' FROM #FinalEntities
		END
		--
		-- Reason we do this only for extended search is because of following reasons:
		-- Extended search takes care of building appropriate filter (fq param in solr query) in business layer based on VM Client Id though
		-- the data source linked at VM group may contain more VMs data than what's allowed for logged-in user
		-- Also the Indexing DataSource id property is linked at corresponding VM group and not the VM client level for v1 vms.
		--
		IF @ExtendedSearch = 1
		BEGIN
			INSERT INTO #VMClients(VMClientId, VSASubClientId, VSABackupSetId, VSAClientId)
			SELECT a.componentNameId as VMClientId, B.ID as VSASubClientId, B.BackupSet as VSABackupSetId, B.ClientId as VSAClientId
			FROM APP_ClientProp A WITH (NOLOCK)
			JOIN APP_Application B WITH (NOLOCK) on A.attrName = 'VSA Discover Subclient ID' AND a.modified = 0 AND a.attrVal = B.id
			JOIN #AdminClientsOutputTable C on A.componentNameId = C.clientID
		END
		--
		IF OBJECT_ID('tempdb.dbo.#tempDSIdTable') IS NOT NULL
		BEGIN
			DROP TABLE #tempDSIdTable
		END
		CREATE TABLE #tempDSIdTable (
			DataSourceId INT,
			CloudType INT default 0,
			DataSourceType INT default 0,
			EntityId		int default 0,
			EntityType		varchar(100)
		 );
		 --
		 IF @debug = 1
		 BEGIN
			SELECT VMClientId AllowedVMClientId, VSASubClientId, VSAClientId, VSABackupSetId FROM #VMClients
		 END
				--
				-- Fix for MR 298309: For V1 VMs, "Indexing DataSource id" property is set at the parent VSA backupset level unlike v2
				-- When @debug = 1, it is useful to check at what level (backupset, subclient etc.) during troubleshooting
				-- In all production scenarios @debug is set to 0 where we only care about the DataSourceId that's collected here
				--
				INSERT INTO #tempDSIdTable (DataSourceId, EntityId, EntityType)
				SELECT CONVERT(INT, cp.attrVal), (CASE WHEN @debug = 1 THEN CP.componentNameId ELSE 0 END) AS EntityId, (CASE WHEN @debug = 1 THEN 'Client' ELSE '' END) AS EntityType
				FROM APP_ClientProp CP  WITH (NOLOCK)
				INNER JOIN #FinalEntities CL ON CL.clientId = cp.componentNameId AND CP.attrName = 'Indexing datasource id' AND CP.modified = 0
				UNION
				SELECT CONVERT(INT, cp.attrVal), (CASE WHEN @debug = 1 THEN CP.componentNameId ELSE 0 END) AS EntityId, (CASE WHEN @debug = 1 THEN 'SubClient' ELSE '' END) AS EntityType
				FROM APP_SubClientProp CP WITH (NOLOCK)
				INNER JOIN APP_Application A WITH (NOLOCK) ON CP.componentNameId = A.id
				INNER JOIN #FinalEntities CL ON CL.clientId = A.clientId AND CP.attrName = 'Indexing datasource id' AND CP.modified = 0
					AND ((@EntityType = @BACKUPSET_ENTITY AND CL.backupsetID = A.backupSet) OR (@EntityType <> @BACKUPSET_ENTITY))
					AND ((@EntityType = @SUBCLIENT_ENTITY AND CL.subclientId = A.id) OR (@EntityType <> @SUBCLIENT_ENTITY))
				UNION
				SELECT CONVERT(INT, BSET.attrVal), (CASE WHEN @debug = 1 THEN BSET.componentNameId ELSE 0 END) AS EntityId, (CASE WHEN @debug = 1 THEN 'BackupSet' ELSE '' END) AS EntityType
				FROM APP_BackupSetProp BSET WITH (NOLOCK)
						 INNER JOIN APP_Application APP WITH (NOLOCK) ON BSET.componentNameId = APP.backupSet
				 INNER JOIN #FinalEntities CL ON CL.clientId = APP.clientId AND BSET.attrName = 'Indexing datasource id' AND BSET.modified = 0
					 AND ((@EntityType = @BACKUPSET_ENTITY AND CL.backupsetID = APP.backupSet) OR (@EntityType <> @BACKUPSET_ENTITY))
					 AND ((@EntityType = @SUBCLIENT_ENTITY AND CL.subclientId = APP.id) OR (@EntityType <> @SUBCLIENT_ENTITY))
				UNION
				SELECT CONVERT(INT, E.attrVal), (CASE WHEN @debug = 1 THEN A.VMClientId ELSE 0 END), (CASE WHEN @debug = 1 THEN 'VMClient' ELSE '' END) as EntityType
				FROM #VMClients A
				JOIN APP_BackupSetProp E WITH(NOLOCK) ON A.VSABackupSetId = E.componentNameId and E.attrName = 'Indexing datasource id' and E.modified = 0
				LEFT JOIN #InputEntityId F ON (@EntityType = @CLIENT_ENTITY and (A.VMClientId = F.entityId or a.VSAClientId = F.entityId)) -- either user searching at VM Client level or VSA client level
										   OR (A.VSASubClientId = F.entityId AND @EntityType = @SUBCLIENT_ENTITY) -- or user is searching at VM group, i.e., VSA Subclient level.
				WHERE @EntityIdList = 'ALL' OR F.entityId IS NOT NULL -- if user is searching at global level or at the requested level listed above.
		DECLARE @cloudTypeConfig int = 0
		DECLARE @countCloudType INT = 0
		UPDATE T
		SET T.CloudType = dc.CloudType , T.DataSourceType = D.DataSourceType
		FROM #tempDSIdTable T
		JOIN SEDataSource D ON T.DataSourceId = D.DataSourceId
		JOIN SECollectionInfo C ON D.CoreId = C.CoreId
		JOIN DM2Cloud DC ON C.CloudID = DC.cloudId
		IF @debug = 1
		BEGIN
			SELECT DataSourceId as LocatedDataSourceId, DataSourceType LocatedDSType, CloudType, EntityId, EntityType FROM #tempDSIdTable
		END
		--
		-- Delete everything irrelevant as per data source type if requested..
		--
		IF @ignoreDataSourceType = 0
		BEGIN
			DELETE FROM #tempDSIdTable WHERE DataSourceType NOT IN (SELECT DataSourceTypeId FROM @tblDataSourceType)
		END
		--
		-- Can't live without this, very useful info when dev need to debug..
		--
		IF @debug = 1
		BEGIN
			SELECT DataSourceId as FilteredDataSourceId, DataSourceType FilteredDSType, CloudType, EntityId, EntityType FROM #tempDSIdTable
		END
		IF @reportsSearch = 0 AND @AllData = 1
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#GlobalSearchStorage') IS NOT NULL  DROP TABLE #GlobalSearchStorage
			CREATE TABLE #GlobalSearchStorage (storagePolicyId INT)
			/*
				*** Capturing data sources eligible for file system data in global file search start here ***
					By this time we captured and filtered VSA data sources for global file search already using data source type
					We capture all file system data sources having multi-node datasouce associated with it
					also return collections only belong to index server that is used for play back of data originating from server plans
					where indexing is enabled
			*/
			/* Common logic to get global search enabled storage policies */
			IF OBJECT_ID('tempdb.dbo.#GlobalSearchPlans') IS NOT NULL DROP TABLE #GlobalSearchPlans
			IF OBJECT_ID('tempdb.dbo.#storageRulesTbl') IS NOT NULL DROP TABLE #storageRulesTbl
			CREATE TABLE #GlobalSearchPlans (planid INT)
			CREATE TABLE #storageRulesTbl (planid INT, storageRules XML)
			;WITH CTEGlobalSearchPlans
			as
			(
SELECT ISNULL(dbo.AppPlanGetEntityValueV2(Id, 'Enable Indexing', default), 0) IndexingEnabled, Id as planid FROM APP_Plan(NOLOCK)
			)
			INSERT INTO #GlobalSearchPlans (planid)
			SELECT planid FROM CTEGlobalSearchPlans WHERE IndexingEnabled = 1
			if @debug = 1
			SELECT * FROM #GlobalSearchPlans
			INSERT INTO #storageRulesTbl(planid, storageRules)
SELECT T.planid, dbo.AppPlanGetEntityValueV2(T.planid, 'Storage Rules', default) FROM #GlobalSearchPlans T
			INSERT INTO #GlobalSearchStorage (storagePolicyId)
SELECT dbo.AppPlanGetEntityValueV2(planid, 'Storage policy', default) FROM #GlobalSearchPlans
			UNION
			SELECT Z.ref.value('@storagePolicyId', 'INT') FROM #storageRulesTbl A CROSS APPLY A.storageRules.nodes('/Api_PlanRuleMaps/rules/policy') Z(ref)
			IF OBJECT_ID('tempdb.dbo.#GlobalSearchPlans') IS NOT NULL DROP TABLE #GlobalSearchPlans
			IF OBJECT_ID('tempdb.dbo.#storageRulesTbl') IS NOT NULL DROP TABLE #storageRulesTbl
			/* Common logic end */
			--
			-- All permitted data that is indexed by lucene solr and originating from storage of the plans whose indexing is enabled
			--
			DECLARE @fileDataSourceType INT = 0
			SELECT @fileDataSourceType = TypeId FROM SEDataSourceType (NOLOCK) WHERE TypeName = 'file'
			--
			;WITH CTEIndexServers
			AS
			(
				SELECT DISTINCT D.CloudId, D.CloudType FROM DM2Cloud D (NOLOCK)
				INNER JOIN App_IndexDBInfo E (NOLOCK) ON D.pseudoClientId = E.currentIdxServer AND E.idxDbEngineType = 2 -- IdxDbEngineType.LUCENE
				INNER JOIN APP_Application F (NOLOCK) ON E.backupSetId = F.backupSet
				INNER JOIN #GlobalSearchStorage G (NOLOCK) ON F.dataArchGrpID = G.storagePolicyId
				INNER JOIN #ClientsOutputTable H ON F.id = H.subclientId
			)
			INSERT INTO #tempDSIdTable (DataSourceId, CloudType, DataSourceType)
			SELECT
			ISNULL((SELECT MIN(T.DataSourceId) FROM SEDataSource T (NOLOCK) WHERE T.DataSourceType = @fileDataSourceType AND T.CoreId =
				(SELECT MIN(CoreId) FROM SECollectionInfo C (NOLOCK) WHERE C.actualcorename = CI.ActualCoreName AND C.CoreId <> M.CoreId)
			), 0) AS DataSourceId,
			T.CloudType,
			@fileDataSourceType AS DataSourceType
            FROM CTEIndexServers T, SEDataSource M (NOLOCK), SECollectionInfo CI(NOLOCK)
			WHERE T.CloudId = CI.CloudId AND M.attribute & 32 = 32 AND M.CoreId = CI.CoreId
			--
			-- some exchange case manager multi node collections wouldn't have any file datasources
			-- clear them here..
			--
			DELETE FROM #tempDSIdTable WHERE DataSourceId = 0
		END
		--
		-- when we have solr-cloud and also commvault cloud type engines
		-- we can't federate across them. In such case we look for preferred cloud type
		-- if preferred type found per global param, then default preference is given to commvault cloud.
		--
		SELECT @countCloudType = COUNT(DISTINCT CloudType) FROM #tempDSIdTable
WHERE CloudType IN ( 1, 5 )
		--
		-- we have conflict, so let's resolve it..
		--
		IF @countCloudType > 1
		BEGIN
			SELECT @cloudTypeConfig = value from GXGlobalParam WITH (NOLOCK) WHERE name = 'PerformDynamicFederationServerType' AND ISNUMERIC(value) = 1
IF @cloudTypeConfig = 0 SET @cloudTypeConfig = 1
		END
		--
		-- Get rid of data sources that belong to cloud type that we are not interested in..
		--
		IF ISNULL(@cloudTypeConfig, 0) > 0
		BEGIN
			DELETE FROM #tempDSIdTable WHERE CloudType <> @cloudTypeConfig
		END
		--
		-- More debug help
		--
		IF @debug = 1
		BEGIN
			SELECT DataSourceId as FinalDataSourceId, EntityId, EntityType FROM #tempDSIdTable
		END
		--
		-- Capture final handler id's..
		--
		INSERT INTO @tblSearchview (viewId, permissionType)
		SELECT DISTINCT H.SearchViewId, 0 as permissionType
			FROM SESearchView H
			JOIN #tempDSIdTable T ON H.DataSourceId = T.DataSourceId
			WHERE H.SearchViewName = @handlerName
					AND H.Status = 1 /* Handler */
	END
	--
	/* Leaving below code commented as of now no one using permissionType and we can save time and get better performance until then */
	/*
	--
	-- Clear and populate all handler IDs to which user has permission
	--
	DELETE #getObjectsTable
EXEC sec_getObjectsWithPermissionsV2 @userId, 133 /* SEA_SEARCH_VIEW_ENTITY */ , 0
	--
	-- First set permission type for owned one's
	--
	UPDATE A
	SET permissionType = 1 -- DM2OwnerType.Owner
	FROM @tblSearchview A
	JOIN SESearchView b on a.viewId = b.SearchViewId
	where b.OwnerUserID = @userId
	--
	-- Anything that is not owned but has permission are considered shared
	--
	UPDATE A
	SET A.permissionType = 2 -- DM2OwnerType.Shared
	FROM @tblSearchview A
	JOIN #getObjectsTable B ON A.viewId = B.entityId
	WHERE A.permissionType IS NULL
	--
	-- What-ever remaining are others
	--
	UPDATE @tblSearchview SET permissionType = 3 -- DM2OwnerType.others
	WHERE A.permissionType IS NULL
	*/
	--
	-- Logic from SEAGetSearchViewDetails.spb contains how to fetch entire details necessary
	--
	DECLARE @multinodeDSPropertyId INT = 0
	SELECT  @multinodeDSPropertyId = PropertyId FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'B2A95D3F-73F1-42DB-8419-382C2241ABAC'
	IF( @i_includeCoreInfo = 1)
	BEGIN
		;WITH CTE (viewId, dsId, searchViewName, searchViewAttribute, viewInfo, referenceId, permissionType) as
		(SELECT TOP (@i_batchCnt)  T.viewId, T.dsId, T.searchViewName, T.searchViewAttribute, T.viewInfo, T.referenceId, T.permissionType FROM @tblSearchview as T WHERE T.cnt >= @i_start)
		(SELECT V.SearchViewId, V.SearchViewName, V.ViewInfo, V.OwnerUserID, V.Status, V.Attribute, V.CreateTime, V.ModifiedTime, V.ModifiedBy,
				DS.DataSourceId, DS.DataSourceName, (SELECT TOP 1 TypeName FROM SEDataSourceType WHERE TypeId = ds.DataSourceType) as DataSourceType,
				CI.CoreId, CI.CloudID, CI.ClientId, CI.CoreName, CI.ActualCoreName,
				DS.Attribute as 'DataSourceAttribute', CI.Attribute as 'CoreAttribute', V.ReferenceId, CTE.permissionType as 'OwnerType', CASE WHEN PROP.PropertyValue IS NULL THEN 0 ELSE CAST(PROP.PropertyValue AS INT) END AS 'MultinodeDSId'
		FROM SESearchView AS V WITH (NOLOCK)
				INNER JOIN
			CTE ON V.SearchViewId = CTE.viewId
				INNER JOIN
			SEDataSource DS WITH (NOLOCK)	ON V.DataSourceId = DS.DataSourceId
				INNER JOIN
			SECollectionInfo CI WITH (NOLOCK) ON DS.CoreId = CI.CoreId
				LEFT JOIN
			SEDataSourceProperty PROP WITH (NOLOCK) ON V.DataSourceId = PROP.DataSourceId 	AND PROP.PropertyId = @multinodeDSPropertyId)
		UNION
		(SELECT CTE.viewId, CTE.searchViewName, CTE.viewInfo, NULL, 3, CTE.searchViewAttribute, NULL, NULL, NULL, DS.DataSourceId, DS.DataSourceName, (SELECT TOP 1 TypeName FROM SEDataSourceType WHERE TypeId = ds.DataSourceType),
				CI.CoreId, CI.CloudID, CI.ClientId, CI.CoreName, CI.ActualCoreName, DS.Attribute, CI.Attribute, CTE.referenceId, CTE.permissionType, CASE WHEN PROP.PropertyValue IS NULL THEN 0 ELSE CAST(PROP.PropertyValue AS INT) END
		FROM CTE
				INNER JOIN
			SEDataSource DS WITH (NOLOCK) ON CTE.viewId = -1 AND CTE.dsId = DS.DataSourceId
				INNER JOIN
			SECollectionInfo CI WITH (NOLOCK) ON DS.CoreId = CI.CoreId
				LEFT JOIN
			SEDataSourceProperty PROP WITH (NOLOCK) ON DS.DataSourceId = PROP.DataSourceId AND PROP.PropertyId = @multinodeDSPropertyId)
		ORDER BY CreateTime DESC
	END
	ELSE
	BEGIN
		;WITH CTE (viewId, dsId, searchViewName, searchViewAttribute, viewInfo, referenceId, permissionType) as
		(SELECT TOP (@i_batchCnt)  T.viewId, T.dsId, T.searchViewName, T.searchViewAttribute, T.viewInfo, T.referenceId, T.permissionType FROM @tblSearchview as T WHERE T.cnt >= @i_start)
		(SELECT V.SearchViewId, V.DataSourceId, DS.DataSourceName, (SELECT TOP 1 TypeName FROM SEDataSourceType WHERE TypeId = ds.DataSourceType) as DataSourceType,
				 V.SearchViewName, V.ViewInfo, V.OwnerUserID, V.Status,
				 V.Attribute, V.CreateTime, V.ModifiedTime, V.ModifiedBy , V.ReferenceId, CTE.permissionType  as OwnerType, CASE WHEN PROP.PropertyValue IS NULL THEN 0 ELSE CAST(PROP.PropertyValue AS INT) END AS MultinodeDSId
		FROM SESearchView AS V WITH (NOLOCK)
				INNER JOIN
			CTE ON V.SearchViewId = CTE.viewId
				INNER JOIN
			SEDataSource DS WITH (NOLOCK)	ON V.DataSourceId = DS.DataSourceId
				LEFT JOIN
			SEDataSourceProperty PROP WITH (NOLOCK) ON V.DataSourceId = PROP.DataSourceId 	AND PROP.PropertyId = @multinodeDSPropertyId)
		UNION
		(SELECT CTE.viewId, SD.DataSourceId, SD.DataSourceName, (SELECT TOP 1 TypeName FROM SEDataSourceType WHERE TypeId = SD.DataSourceType) as DataSourceType,
				CTE.searchViewName, CTE.viewInfo, NULL, 3, CTE.searchViewAttribute, NULL, NULL, NULL, CTE.referenceId, CTE.permissionType, CASE WHEN PROP.PropertyValue IS NULL THEN 0 ELSE CAST(PROP.PropertyValue AS INT) END
		FROM CTE
				INNER JOIN
			SEDataSource as SD WITH (NOLOCK) ON CTE.viewId = -1 AND SD.DataSourceId = CTE.dsId
				LEFT JOIN
			SEDataSourceProperty PROP WITH (NOLOCK) ON SD.DataSourceId = PROP.DataSourceId 	AND PROP.PropertyId = @multinodeDSPropertyId)
		ORDER BY CreateTime DESC
	END
	--	Clean up and exit
exitLine:
	--
	IF ISNULL(@ErrorMsg, '') <> '' AND @debug = 1
	BEGIN
		RAISERROR (@ErrorMsg, 16, 1)
	END
	IF OBJECT_ID('tempdb.dbo.#permissionIdTable') IS NOT NULL
	BEGIN
		DROP TABLE #permissionIdTable
	END
	IF OBJECT_ID('tempdb.dbo.#getObjectsTable') IS NOT NULL
	BEGIN
		DROP TABLE #getObjectsTable
	END
	IF OBJECT_ID('tempdb.dbo.#InputEntityId') IS NOT NULL
	BEGIN
		DROP TABLE #InputEntityId
	END
	IF OBJECT_ID('tempdb.dbo.#FinalEntities') IS NOT NULL
	BEGIN
		DROP TABLE #FinalEntities
	END
	IF OBJECT_ID('tempdb.dbo.#tempDSIdTable') IS NOT NULL
	BEGIN
		DROP TABLE #tempDSIdTable
	END
	IF OBJECT_ID('tempdb.dbo.#EdiscoveryDatasources') IS NOT NULL
	BEGIN
		DROP TABLE #EdiscoveryDatasources
	END
	IF OBJECT_ID('tempdb.dbo.#ClientsOutputTable') IS NOT NULL
	BEGIN
		DROP TABLE #ClientsOutputTable
	END
	IF OBJECT_ID('tempdb.dbo.#AdminClientsOutputTable') IS NOT NULL
	BEGIN
		drop table #AdminClientsOutputTable
	END
	IF OBJECT_ID('tempdb.dbo.#VMClients') IS NOT NULL
	BEGIN
		DROP TABLE #VMClients
	END
	IF OBJECT_ID('tempdb.dbo.#GlobalSearchStorage') IS NOT NULL
	BEGIN
		DROP TABLE #GlobalSearchStorage
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'SEGetDynamicDataSourceInfo')
	delete from GxQscripts where name = 'SEGetDynamicDataSourceInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetDynamicDataSourceInfo')
	delete from GXDBVersions where aliasname = 'SEGetDynamicDataSourceInfo'
GO

insert into GXDBVersions values(2, 'SEGetDynamicDataSourceInfo',  '00000000000000000000', 'SEGetDynamicDataSourceInfo', '00000000000000000000')
GO

