

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEGetDatasourceIdByCoreName.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SEGetDatasourceIdByCoreName')
BEGIN
	print '>>> Drop Stored Procedure: SEGetDatasourceIdByCoreName <<<'
	drop procedure SEGetDatasourceIdByCoreName
END
IF EXISTS (select * from GxQscripts where name='SEGetDatasourceIdByCoreName')
	delete from GxQscripts where name = 'SEGetDatasourceIdByCoreName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetDatasourceIdByCoreName')
	delete from GXDBVersions where aliasname = 'SEGetDatasourceIdByCoreName'
GO
print '... Creating Procedure: SEGetDatasourceIdByCoreName'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SEGetDatasourceIdByCoreName
  @i_cloudId INT,
  @i_coreName VARCHAR(128),
  @i_datasourceType INT
AS
BEGIN
	/*
		Supports for cloudmode, cvsolr and standalone
		cloudmode
			corename and actualcorename will  be same
			And are unique
		Standalone
			actualcorename will be unique
			corename can be duplicate
		CVSolr
			actualcorename can be duplicate and all pointing to multinode datasource
			corename wil be unique
		Flow:
			Fetch by comparing actualcorename
			if no or more than one found and standalone,
				then try to fetch by corename
					delete datasourceId which doesn't have multinode propertyid set
	*/
	DECLARE @o_outDSIDs TABLE(DataSourceId INT)
	INSERT INTO @o_outDSIDs
	SELECT SE.DataSourceId FROM SEDataSource AS SE WITH (NOLOCK)	INNER JOIN	SECollectionInfo CI WITH (NOLOCK) ON
		SE.CoreId = CI.CoreId AND
		CI.CloudID = @i_cloudId AND
		CI.ActualCoreName = @i_coreName AND
		(@i_datasourceType = 0 OR SE.DataSourceType = @i_datasourceType) AND
		SE.Attribute & 4 != 4
	-- for standalone and 0 or >1 entries found, then we additional processing required.
IF EXISTS(SELECT 1 FROM DM2Cloud D WHERE D.cloudId = @i_cloudId AND D.CloudType = 1)
		AND (SELECT COUNT(*) FROM @o_outDSIDs) <> 1
	BEGIN
		-- try to look up by corename
		INSERT INTO @o_outDSIDs
		SELECT SE.DataSourceId FROM SEDataSource AS SE WITH (NOLOCK)	INNER JOIN	SECollectionInfo CI WITH (NOLOCK) ON
		SE.CoreId = CI.CoreId AND
		CI.CloudID = @i_cloudId AND
		CI.CoreName = @i_coreName AND
		(@i_datasourceType = 0 OR SE.DataSourceType = @i_datasourceType) AND
		SE.Attribute & 4 != 4
		--delete datasourceId which doesn't have multinode property
		--
		DELETE d
		FROM @o_outDSIDs d
		WHERE NOT EXISTS(
			SELECT 1 FROM SEDataSourceProperty DSP INNER JOIN
						SEProperty P ON d.DataSourceId = DSP.DataSourceId AND
						DSP.PropertyId = P.PropertyId AND
						P.PropertyGuid = 'B2A95D3F-73F1-42DB-8419-382C2241ABAC' /*multinodefederatedid*/
		)
	END
	SELECT * FROM @o_outDSIDs
END
GO

IF EXISTS (select * from GxQscripts where name = 'SEGetDatasourceIdByCoreName')
	delete from GxQscripts where name = 'SEGetDatasourceIdByCoreName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetDatasourceIdByCoreName')
	delete from GXDBVersions where aliasname = 'SEGetDatasourceIdByCoreName'
GO

insert into GXDBVersions values(2, 'SEGetDatasourceIdByCoreName',  '00000000000000000000', 'SEGetDatasourceIdByCoreName', '00000000000000000000')
GO

