

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEGetDataSources.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SEGetDataSources')
BEGIN
	print '>>> Drop Stored Procedure: SEGetDataSources <<<'
	drop procedure SEGetDataSources
END
IF EXISTS (select * from GxQscripts where name='SEGetDataSources')
	delete from GxQscripts where name = 'SEGetDataSources'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetDataSources')
	delete from GXDBVersions where aliasname = 'SEGetDataSources'
GO
print '... Creating Procedure: SEGetDataSources'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SEGetDataSources
  @i_userId INT ,
  @i_datasourceId INT = 0,
  @i_coreId INT = 0,
  @i_type VARCHAR(32) = '',
  @i_ignoreInfo INT = 0,	
  @i_cloudId INT = 0,
  @i_flatTable INT = 0,
  @i_permission INT = 0,
  @i_OnlyIfHandlers INT = 0,
  @i_IgnoreFedSearch INT = 0,
  @i_datasourceIds VARCHAR(1024) = '',
  @i_ignoreMarkedForDelete INT = 1
AS
	DECLARE @DRILL_CONFIG_PROP_NAME NVARCHAR(256)='isDrillServerConfigured'
	DECLARE @DRILL_PORT_PROP_NAME NVARCHAR(256) ='Drill_zkPort'
	DECLARE @isEnterpriseCommCell int = 1
	--
	-- Find if current comm-cell is in MSP or Enterprise mode.
	--
	IF EXISTS (SELECT 1 FROM GXGlobalParam WITH(NOLOCK) WHERE name = N'IsMSPCommcell' and value = '1' AND modified = 0)
	BEGIN
		SET @isEnterpriseCommCell = 0
	END
	--contains the validated coreId and datasourceID based on #populateInputDsID
	--
	IF OBJECT_ID('tempdb.dbo.#tempCoreInfos') IS NOT NULL
		DROP TABLE #tempCoreInfos
	CREATE TABLE #tempCoreInfos(coreId INT, datasourceId INT, permissionType INT);
	CREATE INDEX tempCoreInfos_datasourceId_coreId_idx on #tempCoreInfos(datasourceId, coreId);
	--Contains the security based table that user have permission on it
	--
	IF OBJECT_ID('tempdb.dbo.#sec_GetDataSourceListByType') IS NOT NULL
		DROP TABLE #sec_GetDataSourceListByType
	CREATE  TABLE #sec_GetDataSourceListByType ( datasourceId INT, permissionType INT);
	CREATE INDEX sec_GetDataSourceListByType_datasourceId_idx on #sec_GetDataSourceListByType(datasourceId);
	IF OBJECT_ID('tempdb.dbo.#permissionIdTable') IS NOT NULL
		DROP TABLE #permissionIdTable
	CREATE TABLE #permissionIdTable (permissionId INT)
	--Contains objects tables to be used by SP.
	IF OBJECT_ID('tempdb.dbo.#getObjectsTable') IS NOT NULL
		DROP TABLE #getObjectsTable
	CREATE TABLE #getObjectsTable (entityId INT, permissionId INT)
	INSERT INTO #permissionIdTable
SELECT 201 /*CAT_DATACUBE_VIEW*/
	--
	IF @isEnterpriseCommCell = 1
	BEGIN
		INSERT INTO #permissionIdTable
SELECT 31 /* EV_VISIBILITY - View permission in an enterprise comm-cell mean we need to let user view data source */
	END
	--
	IF(@i_permission <> 0)
	BEGIN
		INSERT INTO #permissionIdTable
		SELECT @i_permission
IF @isEnterpriseCommCell = 1 AND @i_permission = 203  /*CAT_DATACUBE_DELETE*/
		BEGIN
			INSERT INTO #permissionIdTable
SELECT 35 /* CV_EV_DELETE */
		END
	END
EXEC sec_getObjectsWithPermissionsV2 @i_userId, 132 /*SEA_DATASOURCE_ENTITY*/ ,0
	-- we will clean up datasourceId that are not valid
	--
	IF(@i_permission <> 0)
	BEGIN
		;WITH ValidDSIds AS (
			SELECT DISTINCT entityId FROM #getObjectsTable WHERE permissionId = @i_permission
		)
		DELETE t
		FROM #getObjectsTable as T LEFT JOIN ValidDSIds
			ON 	T.entityId = ValidDSIds.entityId
		WHERE ValidDSIds.entityId IS NULL
	END
	INSERT INTO #sec_GetDataSourceListByType
	SELECT DISTINCT G.entityId, 2 /*VIEW*/ FROM #getObjectsTable AS G
	WHERE G.permissionId IN (
201 /*CAT_DATACUBE_VIEW*/ ,
31 /* EV_VISIBILITY */
	)
	DECLARE @l_haveValidTypeClause BIT = 0
	DECLARE @l_haveValidDsIDClause BIT = 0
	--temp table to populate datasourceIds based on input different criteria
	--
	IF OBJECT_ID('tempdb.dbo.#populateInputTypeDsId') IS NOT NULL
		DROP TABLE #populateInputTypeDsId
	CREATE TABLE #populateInputTypeDsId(datasourceId INT);
	IF(ISNULL(@i_type,'') != '')
	BEGIN
		CREATE INDEX populateInputTypeDsId_datasourceId_idx on #populateInputTypeDsId(datasourceId);
		SET @l_haveValidTypeClause = 1
		INSERT INTO #populateInputTypeDsId
		SELECT DS.DataSourceId FROM SEDataSource DS WITH(NOLOCK )
			INNER JOIN SEDataSourceType DST ON DST.TypeId = DS.DataSourceType
			WHERE TypeName = @i_type
	END
	--populate datasourceId column alone
	IF OBJECT_ID('tempdb.dbo.#populateInputDsId') IS NOT NULL
		DROP TABLE #populateInputDsId
	CREATE TABLE #populateInputDsId(datasourceId INT);
	CREATE INDEX populateInputDsId_datasourceId_idx on #populateInputDsId(datasourceId);
	IF(@i_datasourceId != 0)
	BEGIN
		SET @l_haveValidDsIDClause = 1
		INSERT INTO #populateInputDsId
		SELECT @i_datasourceId
	END
	IF(ISNULL(@i_datasourceIds,'') != '')
	BEGIN
		SET @l_haveValidDsIDClause = 1
		INSERT INTO #populateInputDsId
		SELECT _ID FROM dbo.SplitIDs(@i_datasourceIds)
	END
	INSERT INTO #tempCoreInfos(coreId, datasourceId)
	SELECT DISTINCT DS.CoreId, DS.DataSourceId
	FROM SEDataSource DS WITH (NOLOCK)
			INNER JOIN 	#sec_GetDataSourceListByType AS T ON DS.DataSourceId = T.datasourceId
			INNER JOIN SECollectionInfo SE WITH (NOLOCK)	ON Ds.CoreId = SE.CoreId
	WHERE ((@i_ignoreMarkedForDelete=0) OR (DS.Attribute & 4 = 0 AND SE.Attribute & 4 = 0))  AND
		(@l_haveValidTypeClause = 0 OR DS.DataSourceId IN ( SELECT I.datasourceId FROM  #populateInputTypeDsId AS I)) AND
		(@l_haveValidDsIDClause = 0 OR DS.DataSourceId IN(SELECT I.datasourceId FROM  #populateInputDsId AS I )) AND
		(@i_cloudId = 0 OR SE.CloudId = @i_cloudId) AND
		(@i_coreId = 0 OR DS.CoreId = @i_coreId)
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
	CREATE TABLE #getIndexServers
		(      serverURL NVARCHAR(512),
				clientId INT,
				clientName NVARCHAR(256),
				cloudId INT,
				hostName NVARCHAR(256),
				basePort INT,
				engineName  NVARCHAR(256),
				serverType INT,
				indexServerClientId INT,
				internalCloudName NVARCHAR(256)
		)
	EXEC DM2GetIndexServers
	--delete if there are no mapping cloud informatio
	--
	DELETE T
	FROM #tempCoreInfos T
		INNER JOIN SECollectionInfo AS CI WITH (NOLOCK) ON T.coreId = CI.CoreId AND CI.CloudID > 0
		LEFT JOIN #getIndexServers AE ON CI.CloudID = AE.cloudId AND AE.ServerType IN (1,4,5)
		WHERE  AE.cloudId IS NULL
	--user security
	UPDATE t SET
		t.permissionType = GT.permissionType
	FROM #tempCoreInfos as t 		INNER JOIN		#sec_GetDataSourceListByType as GT
		ON t.datasourceId = GT.datasourceId
	--Find if current user is creator of the datasource
	--
	UPDATE T SET T.permissionType = 1
	FROM  #tempCoreInfos  T
		INNER JOIN	UMSecurityAssociations SA WITH (NOLOCK)
ON entityType1 = 132 /*SEA_DATASOURCE_ENTITY*/ AND SA.entityId1 = T.datasourceId
		AND isCreator = 1 AND userOrGroupId = @i_userId AND isUser = 1
	--when this flag is enabled, return datasources that have only handlers
	IF(@i_OnlyIfHandlers = 1)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#sec_GetSearchViewList') IS NOT NULL
			DROP TABLE #sec_GetSearchViewList
		CREATE TABLE #sec_GetSearchViewList	(searchViewId INT)
		--
		-- Create index on searchViewId column
		--
		create index idxTmpSearchHanlderId on #sec_GetSearchViewList(searchViewId)
		--
		-- Data Cube View CAPABILITY
		--
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 157 /*SEA_SEARCH_HANDLER_ENTITY*/, 201 /*CAT_DATACUBE_VIEW*/,'#sec_GetSearchViewList'
		--
		IF @isEnterpriseCommCell = 1
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#sec_GetSearchViewListEnt') IS NOT NULL
				DROP TABLE #sec_GetSearchViewListEnt
			CREATE TABLE #sec_GetSearchViewListEnt	(searchViewId INT)
			--
		--View CAPABILITY
			--
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 157 /*SEA_SEARCH_HANDLER_ENTITY*/, 31 /*EV_VISIBILITY*/,'#sec_GetSearchViewListEnt'
			--
			-- Consolidate view and Data Cube View capability entries
			--
			INSERT INTO #sec_GetSearchViewList
			SELECT a.searchViewId from #sec_GetSearchViewListEnt a
			LEFT JOIN #sec_GetSearchViewList b on a.searchViewId = b.searchViewId
			WHERE b.searchViewId is null -- insert only those rows that are not already present
		END
		DELETE  t
		FROM #tempCoreInfos as t
		WHERE NOT EXISTS
			(SELECT TOP 1 SV.SearchViewId
			FROM SESearchView SV WITH (NOLOCK)
				INNER JOIN #sec_GetSearchViewList as SVL
				ON SV.SearchViewId = SVL.SearchViewId AND SV.datasourceId = t.DataSourceId AND SV.Status = 1)
		IF OBJECT_ID('tempdb.dbo.#sec_GetSearchViewList') IS NOT NULL
			DROP TABLE #sec_GetSearchViewList
		IF OBJECT_ID('tempdb.dbo.#sec_GetSearchViewListEnt') IS NOT NULL
			DROP TABLE #sec_GetSearchViewListEnt
	END
	--when this flag is set, remove the federated datasource from the list
	IF(@i_IgnoreFedSearch = 1)
	BEGIN
		DECLARE @l_federatedSourceType INT = 0
        SELECT @l_federatedSourceType = TypeId FROM SEDataSourceType WHERE TypeGuid = 'DB8BA53E-5342-4147-9AE0-059F894588A5'-- federated source
		DELETE t
		FROM #tempCoreInfos as t
			INNER JOIN
			SEDataSource as DS
			ON t.datasourceId = DS.datasourceId AND DS.DataSourceType = @l_federatedSourceType
	END
	--clean up tables
	--
	IF OBJECT_ID('tempdb.dbo.#permissionIdTable') IS NOT NULL
		DROP TABLE #permissionIdTable
	IF OBJECT_ID('tempdb.dbo.#getObjectsTable') IS NOT NULL
		DROP TABLE #getObjectsTable
	IF OBJECT_ID('tempdb.dbo.#sec_GetDataSourceListByType') IS NOT NULL
		DROP TABLE #sec_GetDataSourceListByType
	IF OBJECT_ID('tempdb.dbo.#populateInputTypeDsId') IS NOT NULL
		DROP TABLE #populateInputTypeDsId
	IF OBJECT_ID('tempdb.dbo.#populateInputDsId') IS NOT NULL
		DROP TABLE #populateInputDsId
	IF @i_flatTable = 0
	BEGIN
		Declare @tempClientInfo as TABLE( clientId INT, zkQuorum NVARCHAR(256))
		--GET all the clients on which Drill is configured with the Drill zkQuorum.
		;WITH CTE AS
		(
			SELECT DISTINCT componentNameId from APP_ClientProp c WITH (NOLOCK)
			inner join	#getIndexServers as engine on engine.ClientId = c.componentNameId
			WHERE attrName=@DRILL_CONFIG_PROP_NAME and modified = 0
		)
		INSERT into @tempClientInfo
		SELECT AC.Id,FORMATMESSAGE('%s:%s',AC.net_hostname,ACP.attrVal)
		FROM CTE INNER JOIN
			APP_Client AC WITH (NOLOCK) on cte.componentNameId = ac.id
				INNER JOIN APP_ClientProp ACP WITH (NOLOCK)
		ON ACP.componentNameId = AC.id AND ACP.attrName =@DRILL_PORT_PROP_NAME and  acp.modified=0
		--now constrct xml
		--
		/*
			<DM2ContentIndexing_GetCollectionsResp>
			  <collections coreId="3" coreName="Prabha" description="" clientId="2" cloudId="1" ownerUserId="1" attribute="0" computedCoreName="Prabha_3_1" schemaType="default" createUTCTime="1414290310">
				<datasources datasourceId="1" datasourceName="NewTestDS" datasourceType="1" attribute="0" datasourceGuid="F5D147FC-E017-4A0C-8E3F-F9C9156A1E98" userId="1" createUTCTime="1414472237" modifiedByUserId="1" modifiedUTCTime="1414472237">
				  <connectionProperty connectionId="1" connectionName="skn-nj2" />
				  <properties propertyId="10" propertyName="driver" propertyValue="com.microsoft.sqlserver.jdbc.SQLServerDriver" />
				  <properties propertyId="14" propertyName="sql_select_statement" propertyValue="SElect * from dmsetting;" />
				  <schedule scheduleId="1" repeatUnits="2" hour="10" minutes="15" day="0" isActive="0" updateUTCTime="1416288379" />
				</datasources>
			  </collections>
			  <collections coreId="4" coreName="Testingg" description="" clientId="2" cloudId="1" ownerUserId="1" attribute="0" computedCoreName="Testingg_4_1" schemaType="default" createUTCTime="1414442960" />
			</DM2ContentIndexing_GetCollectionsResp>
			*/
			SELECT
				(SELECT
					CI.CoreId '@coreId',
					CI.CoreName '@coreName',
					CI.Description '@description',
					CI.ClientId '@clientId',
					CI.CloudID '@cloudId',
					CI.OwnerUserId '@ownerUserId',
					CI.Attribute '@attribute',
					CI.ActualCoreName '@computedCoreName',
					CI.SchemaType '@schemaType',
					dbo.GetUnixTime(CI.CreateTime) '@createUTCTime' ,
					(SELECT
						ds.DataSourceId  '@datasourceId',
						ds.DataSourceName '@datasourceName',
						ds.DisplayName	'@displayName',
						(SELECT TOP 1 TypeName FROM SEDataSourceType WHERE TypeId = ds.DataSourceType) '@datasourceType',
						ds.Attribute '@attribute',
						ds.DataSourceGuid '@datasourceGuid' ,
						ds.Description	'@description',
						ds.InformationMsg '@infoMsg',
						ds.OwnerUserID '@userId',
						dbo.GetUnixTime(ds.CreateTime) '@createUTCTime' ,
						ds.ModifiedBy '@modifiedByUserId' ,
						T.permissionType '@ownerType',
						(CASE WHEN( @i_ignoreInfo = 0 AND @i_datasourceId>0) THEN
							TC.zkQuorum
							ELSE ''
						 END) AS '@zkQuorum',
						dbo.GetUnixTime(ds.ModifiedTime) '@modifiedUTCTime' ,
							(SELECT  Cp.ConnPropId '@connectionId',
									CP.ConnName '@connectionName'
								FROM SEConnectionProperty CP WITH (NOLOCK)
								WHERE CP.ConnPropId = ds.ConnPropId AND @i_ignoreInfo = 0
								FOR XML PATH('connectionProperty'), TYPE)	,
							(SELECT P.PropertyId	'@propertyId',
									P.PropertyName '@propertyName',
									P.SeaPropertyName '@propertyNameSEA',
									dsp.PropertyValue '@propertyValue'
								FROM SEDataSourceProperty dsp WITH (NOLOCK)
								INNER JOIN
								SEProperty as P WITH (NOLOCK)
								ON dsp.PropertyId = P.PropertyId AND dsp.DataSourceId = ds.DataSourceId
								WHERE @i_ignoreInfo = 0
								FOR XML PATH ('properties'), TYPE
							),
							(
								select DSS.ScheduleId '@scheduleId',
										DSS.RepeatUnits '@repeatUnits',
										DSS.SHour '@hour',
										DSS.SMinute '@minutes',
										DSS.SDay '@day',
										DSS.Status '@isActive',
										dbo.GetUnixTime(Dss.UpdateTime) '@updateUTCTime'
								FROM SEDataSourceSchedule AS DSS WITH (NOLOCK) WHERE DSS.DataSourceId = ds.DataSourceId  AND @i_ignoreInfo = 0
								FOR XML PATH('schedule'), TYPE
							)
						FROM SEDataSource ds WITH (NOLOCK)
								INNER JOIN #tempCoreInfos as T
							ON T.coreId = CI.CoreId AND ds.DataSourceId = T.datasourceId
							LEFT JOIN @tempClientInfo TC
							ON TC.clientId=CI.ClientId
							WHERE ds.CoreId = CI.CoreId
					FOR XML PATH('datasources'), TYPE)
				FROM SECollectionInfo AS CI WITH (NOLOCK)
					WHERE CI.CoreId IN ( SELECT DISTINCT t.coreId FROM #tempCoreInfos as T)
						ORDER BY CreateTime DESC
				FOR XML PATH('collections'), TYPE)
			FOR XML PATH(''), ROOT('DM2ContentIndexing_GetCollectionsResp')
		END
		ELSE
		BEGIN
			DECLARE @multinodeDSPropertyId INT = 0
			SELECT  @multinodeDSPropertyId = PropertyId FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'B2A95D3F-73F1-42DB-8419-382C2241ABAC'
			SELECT	DS.DataSourceId, DS.DataSourceName, DS.DisplayName, DST.TypeName as DataSourceType,
				CI.CoreId, CI.CloudID, CI.ClientId, CI.CoreName, CI.ActualCoreName,
				DS.Attribute as 'DataSourceAttribute', CI.Attribute as 'CoreAttribute', t.permissionType as 'ownerType', CASE WHEN PROP.PropertyValue IS NULL THEN 0 ELSE CAST(PROP.PropertyValue AS INT) END AS 'MultinodeDSId'
			FROM SEDataSource AS DS INNER JOIN #tempCoreInfos as t
					ON DS.DataSourceId = t.datasourceId
				INNER JOIN	SECollectionInfo AS CI
					ON CI.CoreId = DS.CoreId
				INNER JOIN SEDataSourceType as DST
					ON DS.DataSourceType = DST.TypeId
				LEFT JOIN SEDataSourceProperty PROP WITH (NOLOCK)
					ON DS.DataSourceId = PROP.DataSourceId 	AND PROP.PropertyId = @multinodeDSPropertyId
		END
		IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL    DROP TABLE #getIndexServers
GO

IF EXISTS (select * from GxQscripts where name = 'SEGetDataSources')
	delete from GxQscripts where name = 'SEGetDataSources'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetDataSources')
	delete from GXDBVersions where aliasname = 'SEGetDataSources'
GO

insert into GXDBVersions values(2, 'SEGetDataSources',  '00000000000000000000', 'SEGetDataSources', '00000000000000000000')
GO

