

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEGetDataSourceUrlFromClientIdXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SEGetDataSourceUrlFromClientIdXML.sp,v $ $Id: SEGetDataSourceUrlFromClientIdXML.sp,v 1.1.2.25 2020/08/05 00:52:51 rkulkarni Exp $";
--
--  +========================================================================+
--  |      Cursor:  SEGetDataSourceUrlFromClientIdXML()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SEGetDataSourceUrlFromClientIdXML')
BEGIN
	print '>>> Drop Stored Procedure: SEGetDataSourceUrlFromClientIdXML <<<'
	drop procedure SEGetDataSourceUrlFromClientIdXML
END
IF EXISTS (select * from GxQscripts where name='SEGetDataSourceUrlFromClientIdXML')
	delete from GxQscripts where name = 'SEGetDataSourceUrlFromClientIdXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetDataSourceUrlFromClientIdXML')
	delete from GXDBVersions where aliasname = 'SEGetDataSourceUrlFromClientIdXML'
GO
print '... Creating Procedure: SEGetDataSourceUrlFromClientIdXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SEGetDataSourceUrlFromClientIdXML
  @i_xmlText XML
AS
  DECLARE @o_xmlText XML;
SET NOCOUNT ON
BEGIN
DECLARE @o_solrURL NVARCHAR(256)
DECLARE @l_datasourceId INT = 0
DECLARE @l_cloudID INT
DECLARE @l_coreName VARCHAR(256)
DECLARE @SubClientID INT;
DECLARE @ClientID INT;
DECLARE @o_datasourceTypename NVARCHAR(256)
DECLARE @o_datasourcename NVARCHAR(256)
DECLARE @o_catargeturl NVARCHAR(256)
DECLARE @o_caconfig NVARCHAR(4000)
DECLARE @l_dcplanid INT = 0;
DECLARE @l_caenabled  INT = 0;
DECLARE @o_lookupparams NVARCHAR(4000);
DECLARE @auditServerXML XML;
DECLARE @auditServerXMLToSave nvarchar(MAX);
DECLARE @l_nodeClientID INT;
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
CREATE TABLE #getIndexServers
(     serverURL NVARCHAR(512),
        clientId INT,
        clientName NVARCHAR(256),
        cloudId INT,
        hostName NVARCHAR(256),
        basePort INT,
        engineName  NVARCHAR(256),
        serverType INT,
        indexServerClientId INT,
        internalCloudName NVARCHAR(256)
)
SET @SubClientID = ISNULL(( SELECT ref.value('@subclientId', 'int')
							FROM @i_xmlText.nodes('EVGui_GetClientDataSourceReq/subcliententity') R ( ref ) ), 0)
IF @SubClientID > 0
BEGIN
	-- in sp11, we will change this to get datasourceId from subclient id directly without the need to fetch client id
	SELECT @ClientID = A.ClientId FROM APP_Application AS A (NOLOCK) where A.id = @SubClientID
	--try to fetch datasourceid from sub client prop table
     SELECT @l_datasourceId = ISNULL(CONVERT(INT, CP.attrVal),0)
		FROM APP_SubClientProp AS CP (NOLOCK) WHERE CP.componentNameId = @SubClientID AND CP.attrName = 'Indexing datasource id' AND CP.modified = 0
END
ELSE
BEGIN
	SET @ClientID = ISNULL(( SELECT ref.value('@clientId', 'int')
							FROM @i_xmlText.nodes('EVGui_GetClientDataSourceReq') R ( ref ) ), 0)
END
IF @ClientID > 0
BEGIN
	--try to fetch datasourceid from client prop table
	IF @l_datasourceId = 0
     SELECT @l_datasourceId = CONVERT(INT, CP.attrVal)
					FROM APP_ClientProp AS CP (NOLOCK) WHERE CP.componentNameId = @ClientID AND CP.attrName = 'Indexing datasource id' AND CP.modified = 0
     IF(@l_datasourceId > 0)
     BEGIN
			SELECT @l_cloudID = CI.CloudID, @l_coreName = CI.ActualCoreName, @o_datasourceTypename = SEDT.TypeName, @o_datasourcename = DS.datasourcename,
			@l_nodeClientID = CI.ClientId
			FROM SEDataSource as DS WITH (NOLOCK) INNER JOIN SECollectionInfo aS CI WITH (NOLOCK)
            ON DS.coreId = CI.coreId AND DS.DataSourceId = @l_datasourceId
			INNER JOIN SEDataSourceType SEDT WITH (NOLOCK)  ON DS.DataSourceType = SEDT.TypeId
			-- use this SP to get the index server URL
			EXEC DM2GetIndexServers @i_cloudId= @l_cloudID,@i_nodeClientId=@l_nodeClientID
			SELECT TOP 1 @o_solrURL = ( SELECT TOP 1 serverURL from #getIndexServers ) + '/solr/'+ @l_coreName + '/update'
			DECLARE @l_minDocSize BIGINT = 0, @l_maxDocSize BIGINT = 0, @l_enableContent INT = 0, @l_portNo INT = 0, @l_serverType INT = 0
			DECLARE @l_includeFilters VARCHAR(MAX) = null, @l_excludeFilters VARCHAR(MAX) = null
			-- flag indicate whether to show user access monitoring panel on UI. This value is from datasource's property: enablemonitoring.The value was set by user when the datasource is created
			DECLARE @o_enableMonitoring INT = 0
			SELECT TOP 1 @l_portNo = ( SELECT TOP 1 basePort from #getIndexServers )
			SELECT TOP 1 @l_serverType = ( SELECT TOP 1 serverType from #getIndexServers )
			--min doc size
			SELECT @l_minDocSize = DSP.PropertyValue FROM SEDataSourceProperty DSP (NOLOCK)
									WHERE  DSP.DataSourceId = @l_datasourceId
									AND DSP.PropertyId =
									(SELECT TOP 1 PropertyId FROM SEProperty (NOLOCK) WHERE PropertyName = 'minumumdocumentsize')
		   --max doc size
		   SELECT @l_maxDocSize = DSP.PropertyValue FROM SEDataSourceProperty DSP (NOLOCK)
									WHERE  DSP.DataSourceId = @l_datasourceId
									AND DSP.PropertyId =
									(SELECT TOP 1 PropertyId FROM SEProperty (NOLOCK) WHERE PropertyName = 'maximumdocumentsize')
		   --enable content ( inverse of push only meta data property)
		   SELECT @l_enableContent =  (SELECT
										CASE WHEN DSP.PropertyValue = 'false' THEN 1
										ELSE 0 END
										FROM SEDataSourceProperty DSP (NOLOCK)
										WHERE  DSP.DataSourceId = @l_datasourceId
										AND DSP.PropertyId =
										(SELECT TOP 1 PropertyId FROM SEProperty (NOLOCK) WHERE PropertyName = 'pushonlymetadata') )
			--include filters
		   SELECT @l_includeFilters = DSP.PropertyValue FROM SEDataSourceProperty DSP (NOLOCK)
										WHERE  DSP.DataSourceId = @l_datasourceId
										AND DSP.PropertyId =
										(SELECT TOP 1 PropertyId FROM SEProperty (NOLOCK) WHERE PropertyName = 'includefilters')
			--iscaenabled
			IF(@l_enableContent = 0)
			BEGIN
				SELECT @l_enableContent =  (SELECT
										CASE WHEN DSP.PropertyValue = 'true' THEN 1
										ELSE 0 END
										FROM SEDataSourceProperty DSP (NOLOCK)
										WHERE  DSP.DataSourceId = @l_datasourceId
										AND DSP.PropertyId =
										(SELECT TOP 1 PropertyId FROM SEProperty (NOLOCK) WHERE PropertyName = 'iscaenabled') )
				--since ifind requires include filter to be mandated for pushing content, to resolve case when Content = false, EE = true we will fetch the filter from gxglobalparam
				IF(@l_enableContent = 1 AND ISNULL(@l_includeFilters,'') = '')
				BEGIN
						SELECT @l_includeFilters = value from GxGlobalParam WHERE name = 'Content Indexing Include Filters' and modified = 0
				END
			END
		   --exclude filters
		   SELECT @l_excludeFilters = DSP.PropertyValue FROM SEDataSourceProperty DSP (NOLOCK)
										WHERE DSP.DataSourceId = @l_datasourceId
										AND DSP.PropertyId =
										(SELECT TOP 1 PropertyId FROM SEProperty (NOLOCK) WHERE PropertyName = 'excludefilters')
		   --populate additional url params
		   DECLARE @tempPropTable Table( name VARCHAR(256),value nvarchar(512))
		   DECLARE @l_literalproperty VARCHAR(MAX) = null
		   SELECT @l_literalproperty = DSP.PropertyValue FROM SEDataSourceProperty DSP (NOLOCK)
										WHERE  DSP.DataSourceId = @l_datasourceId
										AND DSP.PropertyId =
										(SELECT TOP 1 PropertyId FROM SEProperty (NOLOCK) WHERE PropertyName = 'literalproperties')
			SELECT @l_caenabled = (SELECT
										CASE WHEN DSP.PropertyValue = 'true' THEN 1
										ELSE 0 END
										FROM SEDataSourceProperty DSP (NOLOCK)
										WHERE  DSP.DataSourceId = @l_datasourceId
										AND DSP.PropertyId =
										(SELECT TOP 1 PropertyId FROM SEProperty (NOLOCK) WHERE PropertyName = 'iscaenabled') )
			SELECT @o_catargeturl = DSP.PropertyValue FROM SEDataSourceProperty DSP (NOLOCK)
										WHERE DSP.DataSourceId = @l_datasourceId
										AND DSP.PropertyId =
										(SELECT TOP 1 PropertyId FROM SEProperty (NOLOCK) WHERE PropertyName = 'catargeturl')
			SELECT @o_caconfig =  DSP.PropertyValue FROM SEDataSourceProperty DSP (NOLOCK)
										WHERE DSP.DataSourceId = @l_datasourceId
										AND DSP.PropertyId =
										(SELECT TOP 1 PropertyId FROM SEProperty (NOLOCK) WHERE PropertyName = 'caconfig')
			SELECT @l_dcplanid =  DSP.PropertyValue FROM SEDataSourceProperty DSP (NOLOCK)
										WHERE DSP.DataSourceId = @l_datasourceId
										AND DSP.PropertyId =
										(SELECT TOP 1 PropertyId FROM SEProperty (NOLOCK) WHERE PropertyName = 'dcplanid')
			SELECT @o_lookupparams =  DSP.PropertyValue FROM SEDataSourceProperty DSP (NOLOCK)
										WHERE DSP.DataSourceId = @l_datasourceId
										AND DSP.PropertyId =
										(SELECT TOP 1 PropertyId FROM SEProperty (NOLOCK) WHERE PropertyName = 'lookupparams')
			SELECT @o_enableMonitoring =  (SELECT
											CASE WHEN DSP.PropertyValue = 'true' THEN 1
											ELSE 0 END
											FROM SEDataSourceProperty DSP (NOLOCK)
											WHERE  DSP.DataSourceId = @l_datasourceId
											AND DSP.PropertyId =
											(SELECT TOP 1 PropertyId FROM SEProperty (NOLOCK) WHERE PropertyName = 'enablemonitoring') )
			IF(@o_enableMonitoring = 1)
			BEGIN
				DECLARE @auditserverinfo VARCHAR(MAX) = null
				DECLARE @auditcoreid INT = @l_datasourceId % 4
				DECLARE @AuditServers TABLE (clientName    NVARCHAR(MAX)
								, clientId INT
                                , cloudId       INT
								, auditURL  NVARCHAR(MAX)
								, auditCoreName  NVARCHAR(MAX)
								, modifiedTime datetime
                              )
				SELECT @auditserverinfo = DSP.PropertyValue FROM SEDataSourceProperty DSP (NOLOCK)
										WHERE DSP.DataSourceId = @l_datasourceId
										AND DSP.PropertyId =
										(SELECT TOP 1 PropertyId FROM SEProperty (NOLOCK) WHERE PropertyName = 'auditserverinfo')
				IF(@auditserverinfo is null OR @auditserverinfo = '')
				BEGIN
					INSERT INTO @AuditServers (clientName, clientId, cloudId,auditURL, auditCoreName,modifiedTime)
					SELECT  TOP 1 IDXSERVERS.clientName AS clientName,
							IDXSERVERS.clientId AS clientId,
							IDXSERVERS.cloudId AS cloudId,
							concat(IDXSERVERS.serverURL , '/solr/','cvcoreaudit', @auditcoreid,'/update') AS auditURL,
							concat('cvcoreaudit',@auditcoreid),
							GETUTCDATE()
					FROM #getIndexServers AS IDXSERVERS	WHERE IDXSERVERS.clientId > 0
					SET @auditServerXMLToSave = CAST((SELECT cloudID as'@cloudId'
												,auditCoreName as'@auditCoreName'
												,modifiedTime as '@modifiedTime'
												,(SELECT TOP 1
													clientId as '@clientId'
													FOR XML PATH('client'), TYPE)
												FROM @AuditServers
												FOR XML PATH('auditServerInfo'), TYPE
												) AS nvarchar(max))
					INSERT INTO SEDataSourceProperty VALUES (@l_datasourceId, (SELECT PropertyID from SEProperty(NOLOCK) where PropertyName = 'auditserverinfo'), @auditServerXMLToSave,GETUTCDATE())
				END
				IF( @auditserverinfo is not null AND @auditserverinfo <> '' )
				BEGIN
					SET @auditServerXML =CAST( @auditserverinfo AS XML )
					INSERT INTO @AuditServers (clientName, clientId, cloudId, auditURL, auditCoreName, modifiedTime)
					SELECT TOP 1 IDXSERVERS.clientName AS clientName,
							IDXSERVERS.clientId AS clientId,
							IDXSERVERS.cloudId AS cloudId,
							concat(IDXSERVERS.serverURL , '/solr/','cvcoreaudit', @auditcoreid,'/update') AS auditURL,
							ref1.value('@auditCoreName', 'NVARCHAR(MAX)'),
							ref1.value('@modifiedTime', 'datetime')
					FROM @auditServerXML.nodes('auditServerInfo') as R1(ref1)
					INNER JOIN #getIndexServers AS IDXSERVERS ON IDXSERVERS.cloudId = ref1.value('@cloudId', 'INT')
					AND IDXSERVERS.clientId = ref1.value('client[1]/@clientId', 'INT')
					WHERE IDXSERVERS.clientId > 0
				END
			 SET @auditServerXML = (SELECT cloudID as'@cloudId'
										, auditURL as '@auditURL'
										,auditCoreName as'@auditCoreName'
								FROM @AuditServers
								FOR XML PATH('auditServerInfo'), TYPE
								)
			END
		   IF( @l_literalproperty is not null AND @l_literalproperty <> '' AND  CHARINDEX('<',@l_literalproperty,0) = 1)	--just small check to make sure we have xml
		   BEGIN
				DECLARE @l_literalXML XML = CAST(@l_literalproperty AS xml)
				INSERT INTO @tempPropTable
				SELECT DISTINCT ref1.value('@name', 'VARCHAR(256)'), ref1.value('@value', 'NVARCHAR(512)')
				FROM  @l_literalXML.nodes('DM2ContentIndexing_NameValueMaps/nameValues') as R1(ref1)
				IF EXISTS( SELECT TOP 1 1 FROM @tempPropTable)
				BEGIN
					UPDATE @tempPropTable SET name = 'cvliteral.'+ name
					INSERT INTO @tempPropTable
					SELECT 'cvliteral','true'
				END
		   END
		   INSERT INTO @tempPropTable
		   SELECT 'fm.ds',@l_datasourceId
		   INSERT INTO @tempPropTable
		   SELECT 'fm.dstypename',@o_datasourceTypename
		   INSERT INTO @tempPropTable
		   SELECT 'fm.dsname',@o_datasourcename
		   IF(@l_serverType = 5)
		    BEGIN
				IF(LEN(@o_lookupparams) > 0)
					BEGIN
						INSERT INTO @tempPropTable
						SELECT 'lookupparams',@o_lookupparams
					END
			END
			IF(@l_caenabled > 0 AND @l_serverType = 5)
			 BEGIN
				INSERT INTO @tempPropTable
				SELECT 'iscaenabled',@l_caenabled
				INSERT INTO @tempPropTable
				SELECT 'coreName',@l_coreName
				INSERT INTO @tempPropTable
				SELECT 'catargeturl',@o_catargeturl
				INSERT INTO @tempPropTable
				SELECT 'caconfig',@o_caconfig
			  END
			IF(@l_dcplanid > 0 AND @l_serverType = 5)
				BEGIN
					INSERT INTO @tempPropTable
					SELECT 'dcplanid',@l_dcplanid
				END
     END
	 SET @o_xmlText = ( SELECT  @o_solrURL as '@datasourceUrl',
								@l_minDocSize as '@minDocumentSizeInBytes',
								@l_maxDocSize as '@maxDocumentSizeInBytes',
								@l_includeFilters as '@includeContentFilter',
								@l_excludeFilters as '@excludeContentFilter',
								@l_enableContent as '@enableContent',
								@l_portNo as '@portNo',
								@l_serverType as '@serverType',
								@o_enableMonitoring as '@enableMonitoring',
								(SELECT
									( select  T.name as '@name', T.value as '@value' FROM  @tempPropTable T
									  FOR XML PATH ('nameValues') ,TYPE)
								 FOR XML PATH('literalProperties'), TYPE),
								 (SELECT TOP 1
									clientId as '@clientId',
									dbo.GetClientMangledHostName(clientId, hostName) as '@clientName',
									hostName as '@hostName'
									FROM #getIndexServers
								 FOR XML PATH('client'), TYPE),
								 @auditServerXML
						FOR XML PATH('EVGui_GetClientDataSourceResp'))
END
	IF @o_xmlText IS NULL
		SET @o_xmlText = '<EVGui_GetClientDataSourceResp/>'
	SELECT @o_xmlText AS [o_xmlText]
END
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'SEGetDataSourceUrlFromClientIdXML')
	delete from GxQscripts where name = 'SEGetDataSourceUrlFromClientIdXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetDataSourceUrlFromClientIdXML')
	delete from GXDBVersions where aliasname = 'SEGetDataSourceUrlFromClientIdXML'
GO

insert into GXDBVersions values(2, 'SEGetDataSourceUrlFromClientIdXML',  '00010001000200250000', 'SEGetDataSourceUrlFromClientIdXML', '00010001000200250000')
GO

