

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEGetDataSourceRoutes.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SEGetDataSourceRoutes')
BEGIN
	print '>>> Drop Stored Procedure: SEGetDataSourceRoutes <<<'
	drop procedure SEGetDataSourceRoutes
END
IF EXISTS (select * from GxQscripts where name='SEGetDataSourceRoutes')
	delete from GxQscripts where name = 'SEGetDataSourceRoutes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetDataSourceRoutes')
	delete from GXDBVersions where aliasname = 'SEGetDataSourceRoutes'
GO
print '... Creating Procedure: SEGetDataSourceRoutes'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SEGetDataSourceRoutes
  @i_xml XML
AS
DECLARE @o_xml	XML
DECLARE @clientName nvarchar(max) = @i_xml.value('(/DM2ContentIndexing_SEGetDataSourceRoutesReq/clientEntity/@clientName)[1]', 'nvarchar(max)')
DECLARE @i_fdsId INT = @i_xml.value('(/DM2ContentIndexing_SEGetDataSourceRoutesReq/@federatedDataSourceId)[1]', 'int')
DECLARE @hasAnyCore BIT = @i_xml.exist('(/DM2ContentIndexing_SEGetDataSourceRoutesReq/coreNames/@val)[1]')
DECLARE @hasMultiplefdsId BIT = @i_xml.exist('(/DM2ContentIndexing_SEGetDataSourceRoutesReq/federatedDataSourceIds/@val)[1]')
DECLARE @federatedDatasources table(fdsid int)
-- associated federated data source ids
IF @i_fdsId IS NOT NULL
BEGIN
	INSERT INTO @federatedDatasources values(@i_fdsId)
END
ELSE IF @hasMultiplefdsId = 1
BEGIN
	INSERT INTO @federatedDatasources
	SELECT DISTINCT T.N.value('@val', 'INT') FROM @i_xml.nodes('/DM2ContentIndexing_SEGetDataSourceRoutesReq/federatedDataSourceIds') AS T(N)
END
ELSE
BEGIN
	INSERT INTO @federatedDatasources
	SELECT DISTINCT SER.FederatedDataSourceId FROM SEDataSourceRoute SER
	INNER JOIN SEDataSource SED WITH(NOLOCK) ON SED.DataSourceId = SER.DataSourceId
	INNER JOIN SECollectionInfo SEC WITH(NOLOCK) ON SED.CoreId = SEC.CoreId
	INNER JOIN DM2SearchServerCoreInfo DC WITH(NOLOCK) ON DC.CloudId = SEC.CloudID
	INNER JOIN APP_Client CL WITH(NOLOCK) ON (DC.ClientId = CL.id AND (CL.name = @clientName OR ISNULL(@clientName, '') = ''))
	WHERE @hasAnyCore = 0 OR SEC.ActualCoreName IN (SELECT T.N.value('@val', 'nvarchar(256)') AS coreName
				FROM @i_xml.nodes('/DM2ContentIndexing_SEGetDataSourceRoutesReq/coreNames') AS T(N))
END
DECLARE @routingInfoPropertyId INT
SELECT @routingInfoPropertyId = PropertyId FROM SEProperty WITH(NOLOCK) WHERE PropertyGuid = 'A5465548-D1BD-4292-BF90-89B95885BD73' -- routinginfo property
SET @o_xml = (
SELECT (
	SELECT fdsid AS '@federatedDataSourceId',  SEFC.ActualCoreName  AS '@federatedDataSourceName', SEDP.PropertyValue AS '@routinginfo',
	(
		SELECT	SEC.ActualCoreName AS '@coreName',
				SER.RouteValue AS '@routeValue',
				SER.RouteType AS '@routeType',
				SER.Attribute AS '@attribute',
				SER.DataSourceId AS '@datasourceId',
				SCI.Portno AS 'routeNode/@portNumber',
				CL.net_hostname AS 'routeNode/clientEntity/@hostName',
				CL.GUID AS 'routeNode/clientEntity/@clientGUID'
		FROM SEDataSourceRoute SER
		INNER JOIN SEDataSource SED WITH(NOLOCK) ON SED.DataSourceId = SER.DataSourceId
		INNER JOIN SECollectionInfo SEC WITH(NOLOCK)ON SED.CoreId = SEC.CoreId
		INNER JOIN DM2SearchServerCoreInfo SCI WITH(NOLOCK) ON SCI.CloudId = SEC.CloudID AND SCI.ClientId = SEC.ClientId
		INNER JOIN APP_Client CL WITH(NOLOCK) ON CL.id = SCI.ClientId
		WHERE  SER.FederatedDataSourceId = fdsid AND SCI.CloudType IN (1,4,5)
		FOR XML PATH('entries'), TYPE
	 )
	FROM @federatedDatasources
	INNER JOIN SEDataSource SEFD WITH(NOLOCK) ON SEFD.DataSourceId = fdsid
	INNER JOIN SECollectionInfo SEFC WITH(NOLOCK) ON SEFD.CoreId = SEFC.CoreId
	INNER JOIN SEDataSourceProperty SEDP WITH(NOLOCK) ON SEDP.DataSourceId = fdsid AND SEDP.PropertyId = @routingInfoPropertyId
	FOR XML PATH('routes'),TYPE)
 FOR XML PATH('DM2ContentIndexing_SEDataSourceRoutes'), TYPE)
SELECT @o_xml
GO

IF EXISTS (select * from GxQscripts where name = 'SEGetDataSourceRoutes')
	delete from GxQscripts where name = 'SEGetDataSourceRoutes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetDataSourceRoutes')
	delete from GXDBVersions where aliasname = 'SEGetDataSourceRoutes'
GO

insert into GXDBVersions values(2, 'SEGetDataSourceRoutes',  '00000000000000000000', 'SEGetDataSourceRoutes', '00000000000000000000')
GO

