

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEGetDataSourceProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SEGetDataSourceProperties <<<'

IF EXISTS (select * from sysobjects where name='SEGetDataSourceProperties')
	drop procedure SEGetDataSourceProperties
IF EXISTS (select * from GxQscripts where name='SEGetDataSourceProperties')
	delete from GxQscripts where name = 'SEGetDataSourceProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetDataSourceProperties')
	delete from GXDBVersions where aliasname = 'SEGetDataSourceProperties'
GO
print '... Creating Procedure: SEGetDataSourceProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SEGetDataSourceProperties
  @i_datasourceIds varchar(256) = null,
  @i_datasourceId INT = 79,	
  @i_properties varchar(1024) = null,
  @i_property varchar(256) = null
AS
BEGIN
	If (@i_datasourceId > 0 and @i_property != null)
			  SELECT DISTINCT DSP.DataSourceId, P.PropertyName, DSP.PropertyValue FROM SEDataSourceProperty AS DSP WITH (NOLOCK)
				INNER JOIN SEProperty AS P
	ON P.PropertyId = DSP.PropertyId AND P.PropertyName  = @i_property AND DSP.DataSourceId = @i_datasourceId
	ELSE
	with CTE_DataSourceId AS
	(
		  SELECT Data FROM dbo.split(@i_datasourceIds,',')
				UNION
		  SELECT ISNULL(@i_datasourceId, '0')
	), CTE_PropertyName AS
	(
		  SELECT Data FROM dbo.split(@i_properties,',')
		  UNION
		  SELECT ISNULL(@i_property,'')
	)
	SELECT DISTINCT DSP.DataSourceId, P.PropertyName, DSP.PropertyValue FROM SEDataSourceProperty AS DSP WITH (NOLOCK)
		  INNER JOIN SEProperty AS P
	ON P.PropertyId = DSP.PropertyId AND P.PropertyName IN (SELECT Data FROM CTE_PropertyName)
	ANd DSP.DataSourceId IN (SELECT Data FROM CTE_DataSourceId)
END
GO

IF EXISTS (select * from GxQscripts where name = 'SEGetDataSourceProperties')
	delete from GxQscripts where name = 'SEGetDataSourceProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetDataSourceProperties')
	delete from GXDBVersions where aliasname = 'SEGetDataSourceProperties'
GO

insert into GXDBVersions values(2, 'SEGetDataSourceProperties',  '00000000000000000000', 'SEGetDataSourceProperties', '00000000000000000000')
GO

