

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEGetDataSourceInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SEGetDataSourceInfo')
BEGIN
	print '>>> Drop Stored Procedure: SEGetDataSourceInfo <<<'
	drop procedure SEGetDataSourceInfo
END
IF EXISTS (select * from GxQscripts where name='SEGetDataSourceInfo')
	delete from GxQscripts where name = 'SEGetDataSourceInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetDataSourceInfo')
	delete from GXDBVersions where aliasname = 'SEGetDataSourceInfo'
GO
print '... Creating Procedure: SEGetDataSourceInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SEGetDataSourceInfo
  @i_datasourceId INT,
  @i_userId INT = 0
as
BEGIN
	DECLARE @outTable As Table(
			DataSourceId		INT ,
			DataSourceName		VARCHAR(256),
			DisplayName			NVARCHAR(256),
			DataSourceType		VARCHAR(256),
			DataSourceAttribute	INT,
			CoreId				INT,
			CoreName			VARCHAR(256),
			ActualCoreName		VARCHAR(256),
			CoreAttribute		INT,
			CloudId				INT,
			ClientId				INT,
			PermissionIds		VARCHAR(1024),
			ErrorId				INT ,
			ErrorMsg			NVARCHAR(1024),
			MultinodeDSId		INT
		)
	DECLARE
			@DataSourceId		INT = @i_datasourceId,
			@DataSourceName		VARCHAR(256),
			@DisplayName		NVARCHAR(256),
			@DataSourceType		VARCHAR(256),
			@DataSourceAttribute	INT,
			@CoreId					INT,
			@CoreName			VARCHAR(256),
			@ActualCoreName		VARCHAR(256),
			@CoreAttribute		INT,
			@CloudId				INT,
			@ClientId				INT,
			@PermissionIds		VARCHAR(1024),
			@ErrorId				INT = 0,
			@ErrorMsg			NVARCHAR(1024) = '',
			@MultinodeDSId		INT = 0
	IF NOT EXISTS( SELECT TOP 1 DS.DataSourceId
				FROM SEDataSource as DS WITH (NOLOCK)
				WHERE DS.DataSourceId = @i_datasourceId AND (DS.Attribute & 4) = 0)
	BEGIN
		SELECT @ErrorId = 10627 /*DATASOURCE_ID_INVALID*/ ,
			@ErrorMsg = 'Input datasourceId doesnt exists'
		GOTO _EXIT;
	END
	--now check if anyuserinfo is present but doesnt match sedatasourcetype attribute, throw error
	IF @i_userId = 0 AND
		NOT EXISTS (SELECT TOP 1 DST.TypeId FROM SEDataSourceType as DST WITH (NOLOCK)
							INNER JOIN SEDataSource AS DS WITH (NOLOCK) ON
							DS.DataSourceId = @i_datasourceId AND
							DST.TypeId = DS.DataSourceType AND DST.Status & 256 /*ANY_USER_POSTINFO*/ > 0)
	BEGIN
		SELECT @ErrorId = 10628 /*PERMISSION_DENIED_ON_DATASOURCE*/ ,
				@ErrorMsg = 'Input datasource type doesnt qualify for any user info post'
		GOTO _EXIT;
	END
	IF(@i_userId > 0)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#datasourceInfoPermission') IS NOT NULL
			DROP TABLE #datasourceInfoPermission
		CREATE TABLE #datasourceInfoPermission (permissionId INT)
		INSERT INTO #datasourceInfoPermission
exec sec_getPermissionsOnEntityWrapper @i_userId,132, @i_datasourceId
		SELECT @PermissionIds = (select CONVERT(VARCHAR(32),permissionId)+',' [text()]
								from #datasourceInfoPermission WHERE
permissionId IN (201,202,203,204,107)  for xml path(''))
		--if user doesnt have permission throw error
		IF NOT EXISTS(SELECT TOP 1 * FROM #datasourceInfoPermission)
		BEGIN
			SELECT @ErrorId = 10628 /*PERMISSION_DENIED_ON_DATASOURCE*/ ,
				@ErrorMsg = 'Current user ' + CONVERT(VARCHAR(11),@i_userId) +
							' doesnt have any permission for datasource ' + CONVERT(VARCHAR(11),@i_datasourceId)
		GOTO _EXIT;
		END
	END
	DECLARE @multinodeDSPropertyId INT = 0
	SELECT  @multinodeDSPropertyId = PropertyId FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'B2A95D3F-73F1-42DB-8419-382C2241ABAC'
	SELECT @DataSourceName = DS.DataSourceName, @DisplayName = DS.DisplayName, @DataSourceType = DST.TypeName, @DataSourceAttribute = DS.Attribute,
			@CoreId = CI.CoreId ,@CoreName = CI.CoreName, @ActualCoreName = CI.ActualCoreName, @CoreAttribute = CI.Attribute, @CloudId = CI.CloudID, @ClientId = CI.ClientId, @MultinodeDSId = CASE WHEN PROP.PropertyValue IS NULL THEN 0 ELSE CAST(PROP.PropertyValue AS INT) END
	FROM SEDataSource AS DS WITH (NOLOCK)
			INNER JOIN
		SECollectionInfo AS CI WITH (NOLOCK) ON DS.CoreId = CI.CoreId
			INNER JOIN
		SEDataSourceType AS DST ON DS.DataSourceType = DST.TypeId
			LEFT JOIN
		SEDataSourceProperty PROP WITH (NOLOCK) ON DS.DataSourceId = PROP.DataSourceId 	AND PROP.PropertyId = @multinodeDSPropertyId
		WHERE DS.DataSourceId = @i_datasourceId
_EXIT:
	INSERT INTO @outTable(DataSourceId, DataSourceName, DisplayName, DataSourceType,
				DataSourceAttribute,CoreId ,CoreName, ActualCoreName, CoreAttribute,
				CloudId, PermissionIds, ErrorId, ErrorMsg,ClientId, MultinodeDSId)
	SELECT @DataSourceId, @DataSourceName, @DisplayName, @DataSourceType,
			@DataSourceAttribute, @CoreId ,@CoreName, @ActualCoreName ,@CoreAttribute,
			@CloudId,@PermissionIds, @ErrorId, @ErrorMsg, @ClientId, @MultinodeDSId
	SELECT * FROM @outTable
END;
GO

IF EXISTS (select * from GxQscripts where name = 'SEGetDataSourceInfo')
	delete from GxQscripts where name = 'SEGetDataSourceInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetDataSourceInfo')
	delete from GXDBVersions where aliasname = 'SEGetDataSourceInfo'
GO

insert into GXDBVersions values(2, 'SEGetDataSourceInfo',  '00000000000000000000', 'SEGetDataSourceInfo', '00000000000000000000')
GO

