

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEGetDataAccessNodes.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  SEGetDataAccessNodes()
--  | Description:  Retrive data access node for File System crawl
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SEGetDataAccessNodes.sp,v $ $Id: SEGetDataAccessNodes.sp,v 1.1.2.12 2020/09/26 02:46:08 bkharabe Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SEGetDataAccessNodes')
BEGIN
	print '>>> Drop Stored Procedure: SEGetDataAccessNodes <<<'
	drop procedure SEGetDataAccessNodes
END
IF EXISTS (select * from GxQscripts where name='SEGetDataAccessNodes')
	delete from GxQscripts where name = 'SEGetDataAccessNodes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetDataAccessNodes')
	delete from GXDBVersions where aliasname = 'SEGetDataAccessNodes'
GO
print '... Creating Procedure: SEGetDataAccessNodes'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SEGetDataAccessNodes
  @i_userId INTEGER,
  @i_indexServerClientId INTEGER = 0,
  @i_datasourceType VARCHAR(32) = '',
  @i_datasourceCrawlType INTEGER = 0
AS
  DECLARE @o_xmlText XML
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	DECLARE @nodeClientCurId INT
	DECLARE @errCode INT = 0
	DECLARE @errString  VARCHAR(255)= ''
	IF OBJECT_ID('tempdb.dbo.#tmpClientTbl') IS NOT NULL     DROP TABLE #tmpClientTbl
	CREATE  TABLE #tmpClientTbl (
				t_clientId      integer,
				t_clientName          nvarchar(255)
				)
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
    CREATE TABLE #getIndexServers
        (     serverURL NVARCHAR(512),
                clientId INT,
                clientName NVARCHAR(256),
                cloudId INT,
                hostName NVARCHAR(256),
                basePort INT,
                engineName  NVARCHAR(256),
                serverType INT,
                indexServerClientId INT,
                internalCloudName NVARCHAR(256)
        )
	IF OBJECT_ID('tempdb.dbo.#tmpRemoteClients') IS NOT NULL     DROP TABLE #tmpRemoteClients
    CREATE TABLE #tmpRemoteClients
        (       clientId INT,
                tunnelPort INT,
                cvdPort INT,
                isRoamingClient INT,
				additionalPorts  NVARCHAR(255),
				name NVARCHAR(255),
                guid NVARCHAR(255),
				generateConfig INT,
				tunnelPortValid INT
        )
	IF OBJECT_ID('tempdb.dbo.#tmpFWOutGoingClients') IS NOT NULL     DROP TABLE #tmpFWOutGoingClients
    CREATE TABLE #tmpFWOutGoingClients
        (       remoteClientId INT,
				remoteClientName NVARCHAR(255),
				remoteClientHostName NVARCHAR(255),
				remoteClientGUID NVARCHAR(255),
                tunnelPort INT,
                cvdPort INT,
                isRoamingClient INT,
				additionalPorts  VARCHAR(255),
                fwOutGoingRouteOptions XML,
				generateConfig INT,
				tunnelPortValid INT
        )
	IF OBJECT_ID('tempdb.dbo.#clientList') IS NOT NULL DROP TABLE #clientList
	CREATE TABLE #clientList
		(
                t_clientId INT,
				t_appTypeId INT,
				t_instanceId INT,
				t_backupsetId INT,
				t_subclientId INT
		)
	IF OBJECT_ID('tempdb.dbo.#packageInfo') IS NOT NULL     DROP TABLE #packageInfo
	CREATE TABLE #packageInfo
		(
				packageId INT
		)
	--check for view at commcell level, if not retrieve clients with any permission and perform cross check.
	--
	DECLARE @isAllAssociationsSetView INT = 0
	--get ALL association COMMCELL LEVEL check EV_VISIBILITY
EXEC sec_checkPermissionOnEntity @i_userId, 31  /*EV_VISIBILITY*/, @isAllAssociationsSetView OUTPUT, 1 /*COMMCELL_ENTITY*/, 2
	IF @isAllAssociationsSetView = 0
	BEGIN
            --dont check for View permission as it need not be set explicitly, looks for any permission.
			-- eg: in trial version, user have only Agent Management on index server with no View permission . And hence those clients dint get retrieved..
			--
EXEC sec_getIdaObjectsForUser @i_userId, 3 /*CLIENT_ENTITY*/ , 0 /*ANY*/, 0, '#clientList'
	END
	ELSE
	BEGIN
		--ALL CLIENTS
		INSERT INTO #clientList VALUES (0,0,0,0,0)
	END
	IF @i_datasourceType <> 'ldap'
	BEGIN
		--If IndexServerclientId is provided, then list all FSAdvance client that have CVNetwork access to this physical clients in indexserverclientId
		IF @i_indexServerClientId  > 0
		BEGIN
			--get nodes of index server client
			EXEC DM2GetIndexServers '', @i_indexServerClientId
			--get associated client for each nodes
			DECLARE nodeClientCur CURSOR LOCAL FORWARD_ONLY FOR
			SELECT  DISTINCT clientId FROM #getIndexServers
			OPEN nodeClientCur
			FETCH NEXT FROM nodeClientCur INTO @nodeClientCurId
			WHILE (@@FETCH_STATUS = 0)
			BEGIN
				EXEC AppGetRemoteClientConnectionInfoForAllClients @nodeClientCurId
				INSERT INTO #tmpFWOutGoingClients
				EXEC APPGetFWOutGoingRoutes @nodeClientCurId
				FETCH NEXT FROM nodeClientCur INTO @nodeClientCurId
			END
			CLOSE nodeClientCur
			DEALLOCATE nodeClientCur
			--
			--get all tppm clients
			INSERT INTO #tmpClientTbl
			SELECT DISTINCT clientId, Name FROM #tmpRemoteClients R JOIN #clientList T ON R.clientId =  T.t_clientId OR T.t_clientId = 0
			UNION
			SELECT DISTINCT remoteClientId, remoteClientName FROM #tmpFWOutGoingClients R JOIN #clientList T ON R.remoteClientId =  T.t_clientId OR T.t_clientId = 0
			--Delete pseudo clients
			DELETE T
			FROM #tmpClientTbl T
			JOIN App_ClientProp CP (NOLOCK) ON CP.componentNameId = T.t_clientId
WHERE  CP.attrname = 'Index Server Type'
				AND CP.modified = 0
AND CP.attrVal IN (	10,
12,
14,
15,
8
								  )
		END
		-- get all the applicable clients
		IF ( NOT EXISTS (SELECT TOP 1 1 FROM #tmpClientTbl)
			OR NOT EXISTS (SELECT TOP 1 1 FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'FetchOnlyFirewallEnabledNodes' AND value = 'TRUE'))
		BEGIN
		   -- store all the package ids in the temp table for FS
		   INSERT INTO #packageInfo(packageId) VALUES
(51),(1301), (252), (729),(1108), (55), (1306), (20), (263),(1156)
		END
	END
	ELSE
	BEGIN
		-- store all the package ids in the temp table for LDAP
		INSERT INTO #packageInfo(packageId) VALUES
(1601), (957)
	END
	IF @i_datasourceType = 'file' AND @i_datasourceCrawlType = 5
	BEGIN
		INSERT INTO #tmpClientTbl (t_clientId, t_clientName)
		SELECT DISTINCT C.Id, C.name FROM
		(select ClientId, [252] AS [Web Server], [263] AS [Index Gateway], [729] AS [Content Analyzer]  from
		 (
			SELECT ClientId, simPackageID
				FROM simInstalledPackagesHistory where simPackageID IN (252, 729, 263)
		 ) A
		 PIVOT
		 (
		   Max(simPackageID)
			  FOR simPackageID IN ([252], [729], [263])
		 ) AS PVTTable) AS PKG
		 INNER JOIN APP_Client C ON PKG.ClientId = C.id
		 JOIN #clientList T ON C.Id =  T.t_clientId OR T.t_clientId = 0
		 WHERE (ISNULL(PKG.[Web Server], 0) > 0 OR ISNULL(PKG.[Index Gateway], 0) > 0) AND ISNULL(PKG.[Content Analyzer], 0) > 0
	END
	ELSE
	BEGIN
	INSERT INTO #tmpClientTbl (t_clientId, t_clientName)
	SELECT DISTINCT C.Id, C.name
	FROM simInstalledPackages S
	JOIN APP_Client C ON S.clientId = C.id
	JOIN #clientList T ON C.Id =  T.t_clientId OR T.t_clientId = 0
	WHERE S.SimPackageId IN (SELECT packageId FROM #packageInfo)
	END
    SET @o_xmlText = (SELECT
    					(SELECT
    						(SELECT
    							t_clientId AS '@id', t_clientName AS '@name'
    							FOR XML PATH('entityInfo'), TYPE)
    						FROM #tmpClientTbl GROUP BY t_clientId, t_clientName
    					FOR XML PATH('response'), TYPE)
    				FOR XML PATH('App_GenericEntityResp'),TYPE)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errCode = ERROR_NUMBER()
    SET @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	;THROW @errCode, @errString, 1
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
SELECT @o_xmlText
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
IF OBJECT_ID('tempdb.dbo.#tmpClientTbl') IS NOT NULL     DROP TABLE #tmpClientTbl
IF OBJECT_ID('tempdb.dbo.#tmpFWOutGoingClients') IS NOT NULL     DROP TABLE #tmpFWOutGoingClients
IF OBJECT_ID('tempdb.dbo.#tmpRemoteClients') IS NOT NULL     DROP TABLE #tmpRemoteClients
IF OBJECT_ID('tempdb.dbo.#clientList') IS NOT NULL DROP TABLE #clientList
IF OBJECT_ID('tempdb.dbo.#packageInfo') IS NOT NULL DROP TABLE #packageInfo
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'SEGetDataAccessNodes')
	delete from GxQscripts where name = 'SEGetDataAccessNodes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetDataAccessNodes')
	delete from GXDBVersions where aliasname = 'SEGetDataAccessNodes'
GO

insert into GXDBVersions values(2, 'SEGetDataAccessNodes',  '00010001000200120000', 'SEGetDataAccessNodes', '00010001000200120000')
GO

