

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEGetCommcell.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SEGetCommcell <<<'

IF EXISTS (select * from sysobjects where name='SEGetCommcell')
	drop procedure SEGetCommcell
IF EXISTS (select * from GxQscripts where name='SEGetCommcell')
	delete from GxQscripts where name = 'SEGetCommcell'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetCommcell')
	delete from GXDBVersions where aliasname = 'SEGetCommcell'
GO
print '... Creating Procedure: SEGetCommcell'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SEGetCommcell
  @i_userId INT = 0,
  @i_commcellId INT = 0,
  @i_flaReq INT = 0
AS
	DECLARE @isUserAdmin integer =0,
		    @o_errorCode    INT = 0,
            @o_errorMsg     NVARCHAR(MAX) = ''
    IF @i_flaReq = 0
    BEGIN
        EXECUTE sec_isUserAdmin @i_userId ,@isUserAdmin OUTPUT
		IF @isUserAdmin = 0
		BEGIN
			SET @o_errorCode = 1121
			SET @o_errorMsg = 'Only admin Perform this operation'
			GOTO _EXIT;
		END
	END
	DECLARE @tblAppCommcell TABLE (
		id INTEGER,
		clientId INTEGER,
		csGUID VARCHAR(MAX),
		flags INTEGER,
		sqlInstance VARCHAR(MAX),
		sqlAccessInfo VARCHAR(MAX),
		ProxyClientName VARCHAR(MAX),
		ProxyHostName VARCHAR(MAX),
		ProxyPortNumber INTEGER,
		RemoteRegistered INTEGER,
		CommcellId INTEGER
	)
	insert into @tblAppCommcell(id, clientId, csGUID, flags, sqlInstance, sqlAccessInfo, ProxyClientName, ProxyHostName, ProxyPortNumber, RemoteRegistered, CommcellId)
		select CC.id, CC.clientId, CC.csGUID,  CC.flags ,info.sqlInstance, info.sqlAccessInfo,
				info.ProxyClientName, info.ProxyHostName, info.ProxyPortNumber, (CASE WHEN T.commcellId IS NULL THEN 0 ELSE 1 END) AS RemoteRegistered, info.commcellId
		from APP_CommCellInfo info
		inner join APP_CommCell CC on CC.id = info.commcellId
left outer join  (select distinct commcellId from GRC_CommCellProp where propId = 26 and longVal =1) T on T.commcellId = CC.id
	select T.id, T.clientId,CL.name as aliasName,CL.net_hostname as CCHostName, T.csGUID, T.flags, T.sqlInstance, T.sqlAccessInfo, T.ProxyClientName, T.ProxyHostName, T.ProxyPortNumber, T.RemoteRegistered
		from APP_Client CL
		inner join @tblAppCommcell as T on CL.id = T.clientId
where T.CommcellId NOT IN (SELECT CommcellId FROM GRC_CommCellProp WHERE PropId = 30 and longVal = 1)
				AND (@i_commcellId = 0 OR T.id = @i_commcellId)
		order by  aliasName
	RETURN
	_EXIT:
	    SELECT  @o_errorCode 'o_errorCode', @o_errorMsg 'o_errorMsg'
GO

IF EXISTS (select * from GxQscripts where name = 'SEGetCommcell')
	delete from GxQscripts where name = 'SEGetCommcell'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetCommcell')
	delete from GXDBVersions where aliasname = 'SEGetCommcell'
GO

insert into GXDBVersions values(2, 'SEGetCommcell',  '00000000000000000000', 'SEGetCommcell', '00000000000000000000')
GO

