

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEGetCollectionInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SEGetCollectionInfo')
BEGIN
	print '>>> Drop Stored Procedure: SEGetCollectionInfo <<<'
	drop procedure SEGetCollectionInfo
END
IF EXISTS (select * from GxQscripts where name='SEGetCollectionInfo')
	delete from GxQscripts where name = 'SEGetCollectionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetCollectionInfo')
	delete from GXDBVersions where aliasname = 'SEGetCollectionInfo'
GO
print '... Creating Procedure: SEGetCollectionInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SEGetCollectionInfo
  @i_coreId INT = 0,
  @i_coreName VARCHAR(128) = '',
  @i_clientId INT = 0,
  @i_cloudId INT	= 0,
  @i_userId INT = 0,
  @i_start INT = 0,
  @i_batchCnt INT	= 10,
  @i_actualCoreNames VARCHAR(512) = ''
AS
	;WITH CTE AS(
		SELECT
			S.CoreId,
			ROW_NUMBER() OVER (ORDER BY CoreName ASC) AS RowNumber
		FROM SECollectionInfo as S WITH (NOLOCK)
		WHERE (@i_coreId = 0 OR S.CoreId = @i_coreId) AND
				(ISNULL(@i_coreName,'') = '' OR S.CoreName = @i_coreName) AND
				(@i_clientId = 0 OR S.ClientId = @i_clientId) AND
				(@i_cloudId = 0 OR S.CloudID = @i_cloudId ) AND
				(@i_userId = 0  OR S.OwnerUserId = @i_userId) AND
				(ISNULL(@i_actualCoreNames,'') = '' OR S.ActualCoreName in (SELECT Data FROM dbo.split(@i_actualCoreNames, ','))) AND
				((Attribute & 4 ) = 0)
	)
	SELECT S.CoreId, S.CoreName, S.ClientId, S.CloudID, S.OwnerUserId, S.Description,
			S.CreateTime, S.Attribute, S.ActualCoreName, S.SchemaType
	FROM SECollectionInfo as S WITH (NOLOCK)
			INNER JOIN
			CTE AS C
	ON C.CoreId = S.CoreId
	WHERE C.RowNumber BETWEEN @i_start AND (@i_start + @i_batchCnt);
GO

IF EXISTS (select * from GxQscripts where name = 'SEGetCollectionInfo')
	delete from GxQscripts where name = 'SEGetCollectionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetCollectionInfo')
	delete from GXDBVersions where aliasname = 'SEGetCollectionInfo'
GO

insert into GXDBVersions values(2, 'SEGetCollectionInfo',  '00000000000000000000', 'SEGetCollectionInfo', '00000000000000000000')
GO

