

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEGetArchivingSubclientsInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SEGetArchivingSubclientsInfo')
BEGIN
	print '>>> Drop Stored Procedure: SEGetArchivingSubclientsInfo <<<'
	drop procedure SEGetArchivingSubclientsInfo
END
IF EXISTS (select * from GxQscripts where name='SEGetArchivingSubclientsInfo')
	delete from GxQscripts where name = 'SEGetArchivingSubclientsInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetArchivingSubclientsInfo')
	delete from GXDBVersions where aliasname = 'SEGetArchivingSubclientsInfo'
GO
print '... Creating Procedure: SEGetArchivingSubclientsInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SEGetArchivingSubclientsInfo
  @userId INT,
  @datasourceId INT
AS
BEGIN
	DECLARE @IndexingSubclientId	NVARCHAR(20)
	--
	-- Table to be used by sec_getIDAObjectsForUserWithPrivacy
	--
	IF OBJECT_ID('tempdb.dbo.#ClientsOutputTable') IS NOT NULL
	BEGIN
		DROP TABLE #ClientsOutputTable
	END
	--
	CREATE TABLE #ClientsOutputTable
	(
		clientID INT,
		appTypeId INT,
		instanceId INT,
		backupsetID INT,
		subclientId INT
	);
	CREATE INDEX subclientid_idx ON #ClientsOutputTable(subclientId)
	--
	-- Table to be used by sec_getIDAObjectsForUserWithPrivacy
	--
	IF OBJECT_ID('tempdb.dbo.#TempArchivingSubclients') IS NOT NULL
	BEGIN
		DROP TABLE #TempArchivingSubclients
	END
	--
	CREATE TABLE #TempArchivingSubclients
	(
		subclientId INT
	);
	IF OBJECT_ID('tempdb.dbo.#TempArchivingRulesInfo') IS NOT NULL
	BEGIN
		DROP TABLE #TempArchivingRulesInfo
	END
	--
	CREATE TABLE #TempArchivingRulesInfo
	(
		subclientId INT,
		subclientName	NVARCHAR(256),
		backupSetId	INT,
		instanceId	INT,
		clientId	INT,
		applicationId	INT,
		rulesInfo	XML
	);
	--
	-- fetch sub clients irrespective of what ida entity type requested as this is most atomic level at which permissions could be given
	--
EXEC sec_getIDAObjectsForUserWithPrivacy @userId, 7, 0, 0, '#ClientsOutputTable', 1, 0, '13,31'
	--
	-- get indexing subclient id
	--
	DECLARE @PropertyId INT = (SELECT TOP 1 PropertyId FROM SEProperty SP WITH (NOLOCK) WHERE PropertyName = N'subclientid')
	SELECT @IndexingSubclientId = DSP.PropertyValue
	FROM SEDataSourceProperty DSP WITH (NOLOCK)
	WHERE DSP.DataSourceId = @datasourceId AND DSP.PropertyId = @PropertyId
	-- get list of archiving subclients which point to the indexing subclient
	--
	INSERT INTO #TempArchivingSubclients(subclientId)
	SELECT DISTINCT componentNameId
	FROM APP_SubClientProp A WITH(NOLOCK)
	JOIN #ClientsOutputTable C
		ON C.subclientId = A.componentNameId
	JOIN APP_Application AP WITH (NOLOCK)
		ON AP.id = A.componentNameId
	WHERE 	A.attrName = 'Live Crawl SubClientId'
		AND A.cs_attrName = CHECKSUM(N'Live Crawl SubClientId')
		AND A.modified = 0
		AND A.attrVal = @IndexingSubclientId
AND AP.subclientStatus & 0x00010 <> 0x00010 --CV_STATUS_DUMMY
AND AP.subclientStatus & 0x00020 <> 0x00020  --CV_STATUS_HIDDEN
AND AP.subclientStatus & 0x00002 <> 0x00002  --CV_STATUS_UNINSTALLED
AND AP.subclientStatus & 0x00004 <> 0x00004  --CV_STATUS_DELETED
	-- Get archiving rules and path details
	-- Loop through each of subclientid in #TempArchivingSubclients
	--
	IF ( CURSOR_STATUS('global', 'archSubclientIdCursor') >= 0 OR CURSOR_STATUS('local', 'archSubclientIdCursor') >= 0 ) /* cursor is open */
		CLOSE archSubclientIdCursor
    IF ( CURSOR_STATUS('global','archSubclientIdCursor') = -1 OR CURSOR_STATUS('local','archSubclientIdCursor') = -1 ) /* cursor is closed */
		DEALLOCATE archSubclientIdCursor
	DECLARE @subclientId INT
	DECLARE @subclientProps XML
	DECLARE archSubclientIdCursor CURSOR FAST_FORWARD FOR
	SELECT subclientId FROM #TempArchivingSubclients
	--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	-- try catch is used to ensure cursor is closed
	BEGIN TRY
	OPEN archSubclientIdCursor
	FETCH NEXT FROM archSubclientIdCursor INTO @subclientId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF(@subclientId > 0)
		BEGIN
			EXEC APPGetSubclientFsIDAProperties @subclientId, 30 /*detail level to get Archiving rules*/, @subclientProps OUT, 1 /*include content*/
			IF (@subclientProps IS NOT NULL)
			BEGIN
				INSERT INTO #TempArchivingRulesInfo(subclientId, subclientName, backupSetId, instanceId, clientId, applicationId, rulesInfo)
				SELECT A.id, A.subclientName, A.backupSet, A.instance, A.clientId, A.appTypeId, @subclientProps
				FROM APP_Application A WITH(NOLOCK)
				WHERE id = @subclientId
			END
		END
		FETCH NEXT FROM archSubclientIdCursor INTO @subclientId
	END
	END TRY
	BEGIN CATCH
	END CATCH
	-- always ensure that cursor is closed
	--
    IF ( CURSOR_STATUS('global', 'archSubclientIdCursor') >= 0 OR CURSOR_STATUS('local', 'archSubclientIdCursor') >= 0 ) /* cursor is open */
		CLOSE archSubclientIdCursor
    IF ( CURSOR_STATUS('global','archSubclientIdCursor') = -1 OR CURSOR_STATUS('local','archSubclientIdCursor') = -1 ) /* cursor is closed */
		DEALLOCATE archSubclientIdCursor
	--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	SELECT * FROM #TempArchivingRulesInfo
	--	Clean up and exit
exitLine:
	IF OBJECT_ID('tempdb.dbo.#getObjectsTable') IS NOT NULL
	BEGIN
		DROP TABLE #getObjectsTable
	END
	IF OBJECT_ID('tempdb.dbo.#ClientsOutputTable') is not null
	BEGIN
		DROP TABLE #ClientsOutputTable
	END
	IF OBJECT_ID('tempdb.dbo.#TempArchivingSubclients') is not null
	BEGIN
		DROP TABLE #TempArchivingSubclients
	END
	IF OBJECT_ID('tempdb.dbo.#TempArchivingRulesInfo') IS NOT NULL
	BEGIN
		DROP TABLE #TempArchivingRulesInfo
	END
	--
END
GO

IF EXISTS (select * from GxQscripts where name = 'SEGetArchivingSubclientsInfo')
	delete from GxQscripts where name = 'SEGetArchivingSubclientsInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetArchivingSubclientsInfo')
	delete from GXDBVersions where aliasname = 'SEGetArchivingSubclientsInfo'
GO

insert into GXDBVersions values(2, 'SEGetArchivingSubclientsInfo',  '00000000000000000000', 'SEGetArchivingSubclientsInfo', '00000000000000000000')
GO

