

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEGetArchivingDatasources.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SEGetArchivingDatasources')
BEGIN
	print '>>> Drop Stored Procedure: SEGetArchivingDatasources <<<'
	drop procedure SEGetArchivingDatasources
END
IF EXISTS (select * from GxQscripts where name='SEGetArchivingDatasources')
	delete from GxQscripts where name = 'SEGetArchivingDatasources'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetArchivingDatasources')
	delete from GXDBVersions where aliasname = 'SEGetArchivingDatasources'
GO
print '... Creating Procedure: SEGetArchivingDatasources'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SEGetArchivingDatasources
  @userId INT
AS
BEGIN
	--
	-- Table to be used by sec_getIDAObjectsForUserWithPrivacy
	--
	IF OBJECT_ID('tempdb.dbo.#ClientsOutputTable') IS NOT NULL
	BEGIN
		DROP TABLE #ClientsOutputTable
	END
	--
	CREATE TABLE #ClientsOutputTable
	(
		clientID INT,
		appTypeId INT,
		instanceId INT,
		backupsetID INT,
		subclientId INT
	);
	CREATE INDEX subclientid_idx ON #ClientsOutputTable(subclientId)
	--
	-- Table to be used by sec_getIDAObjectsForUserWithPrivacy
	--
	IF OBJECT_ID('tempdb.dbo.#TempArchivingSubclients') IS NOT NULL
	BEGIN
		DROP TABLE #TempArchivingSubclients
	END
	--
	CREATE TABLE #TempArchivingSubclients
	(
		subclientId INT,
		livecrawlSubclientId	NVARCHAR(50)
	);
	--
	-- fetch sub clients irrespective of what ida entity type requested as this is most atomic level at which permissions could be given
	--
EXEC sec_getIDAObjectsForUserWithPrivacy @userId, 7, 0, 0, '#ClientsOutputTable', 1, 0, '13,31'
	-- get only archiving subclients which have "Live Crawl SubClientId" property
	--
	INSERT INTO #TempArchivingSubclients
	SELECT A.componentNameId, A.attrVal
	FROM APP_SubClientProp A WITH(NOLOCK)
	JOIN #ClientsOutputTable C
		ON A.componentNameId = C.subclientId
	JOIN APP_Application AP WITH (NOLOCK)
		ON AP.id = A.componentNameId
	WHERE A.attrName = 'Live Crawl SubClientId'
		AND A.cs_attrName = CHECKSUM(N'Live Crawl SubClientId')
        AND A.modified = 0
AND AP.subclientStatus & 0x00010 <> 0x00010 --CV_STATUS_DUMMY
AND AP.subclientStatus & 0x00020 <> 0x00020  --CV_STATUS_HIDDEN
AND AP.subclientStatus & 0x00002 <> 0x00002  --CV_STATUS_UNINSTALLED
AND AP.subclientStatus & 0x00004 <> 0x00004  --CV_STATUS_DELETED
	-- get list of datasources based on indexing subclient
	--
	DECLARE @PropertyId INT = (SELECT TOP 1 PropertyId FROM SEProperty SP WITH (NOLOCK) WHERE PropertyName = N'subclientid')
	SELECT S.DataSourceId, DataSourceName, DisplayName
	FROM SEDataSource S WITH(NOLOCK)
	JOIN SEDataSourceProperty DSP WITH(NOLOCK)
		ON S.DataSourceId = DSP.DataSourceId
	WHERE DSP.PropertyId = @PropertyId AND DSP.PropertyValue IN (SELECT DISTINCT livecrawlSubclientId FROM #TempArchivingSubclients)
	--	Clean up and exit
exitLine:
	IF OBJECT_ID('tempdb.dbo.#ClientsOutputTable') IS NOT NULL
	BEGIN
		DROP TABLE #ClientsOutputTable
	END
	IF OBJECT_ID('tempdb.dbo.#TempArchivingSubclients') IS NOT NULL
	BEGIN
		DROP TABLE #TempArchivingSubclients
	END
	--
END
GO

IF EXISTS (select * from GxQscripts where name = 'SEGetArchivingDatasources')
	delete from GxQscripts where name = 'SEGetArchivingDatasources'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetArchivingDatasources')
	delete from GXDBVersions where aliasname = 'SEGetArchivingDatasources'
GO

insert into GXDBVersions values(2, 'SEGetArchivingDatasources',  '00000000000000000000', 'SEGetArchivingDatasources', '00000000000000000000')
GO

