

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEDeleteDatasource.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SEDeleteDatasource')
BEGIN
	print '>>> Drop Stored Procedure: SEDeleteDatasource <<<'
	drop procedure SEDeleteDatasource
END
IF EXISTS (select * from GxQscripts where name='SEDeleteDatasource')
	delete from GxQscripts where name = 'SEDeleteDatasource'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEDeleteDatasource')
	delete from GXDBVersions where aliasname = 'SEDeleteDatasource'
GO
print '... Creating Procedure: SEDeleteDatasource'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SEDeleteDatasource
  @i_userId INT,
  @i_datasourceId INT = 0,
  @i_coreId INT = 0,
  @i_forceDelete INT  = 0,
  @i_cloudId INT = 0
AS
DECLARE @o_errorCode INT = 0,
			@o_errorMsg	NVARCHAR(MAX) ='No Error'
	/*
		Based on forcedelete flag, either we make it soft delete or hard delete.
		- if coreId is passed, all datasource related to it will be hard/soft deleted
		- if datasourceId is passed, then if core mapping to input datasourceid have no other reference, it will be deleted (based on forcedelete flag)
		- cloudID is passed in case of uninstall code, hard delete all datasource mapped to that cloudID
	*/
	DECLARE @l_dsId INT = 0,
			@l_handlerViewId INT = 0,
			@l_status INT = 0,
			@l_handlerEntityType INT = 0
	DECLARE @l_coreId INT = 0,
			@l_ignoreCoreUpdate BIT = 0,
            @l_dsType int = 0,
	        @l_dsCrawlType int = 0
	DECLARE @datasourceIdTbl AS TABLE( dsId int);
	DECLARE @collectionIdTbl AS TABLE( coreId int);
    DECLARE @datasourceSubclientTbl AS TABLE( scId int);
	--validation.
	--
	--perform validation
	--
	IF(@i_userId <= 0 OR NOT EXISTS (SELECT TOP 1 id FROM UMUsers WITH (NOLOCK) WHERE id = @i_userId))
	BEGIN
		SELECT @o_errorCode = 10551, @o_errorMsg = 'Input userinformation is not valid. UserID ' + CONVErT(vARCHAR(10),@i_userId)
		GOTO _EXIT;
	END
	IF (ISNULL(@i_cloudId,0) > 0)
	BEGIN
		INSERT INTO @datasourceIdTbl
		SELECT DISTINCT  DS.DataSourceId
		FROM SEDataSource DS WITH (NOLOCK) INNER JOIN SECollectionInfo C WITH (NOLOCK)
		ON DS.CoreId = C.CoreId AND C.CloudID = @i_cloudId
		INSERT INTO @collectionIdTbl
		SELECT DISTINCT C.CoreId
		FROM SECollectionInfo C WITH (NOLOCK) WHERE C.CloudID = @i_cloudId
	END
	ELSE
	BEGIN
		IF ( ISNULL(@i_datasourceId,0) = 0 AND ISNULL(@i_coreId,0) = 0)
		BEGIN
			SELECT @o_errorCode = /*INVALID_INPUT*/ 1001, @o_errorMsg = 'Both datasourceId and coreid is passed empty.'
			GOTO _EXIT;
		END
		IF( @i_datasourceId > 0)
		BEGIN
			--check user permission - EDIT permission is required to modify data source
			DECLARE @isPermissionSet INT  = 0
EXEC sec_checkPermissionOnEntity @i_userId, 203 /*CAT_DATACUBE_DELETE*/, @isPermissionSet OUTPUT, 132 /*SEA_DATASOURCE_ENTITY*/, @i_datasourceId
			IF @isPermissionSet = 0
			BEGIN
				SELECT @o_errorCode = 10628, @o_errorMsg = 'Input user doesnt have  Delete permission on datasource. UserId : ' + CONVERT(VARCHAR(10),@i_userId) + ' , DatasourceId : ' + CONVERT(VARCHAR(10),@i_datasourceId)
				GOTO _EXIT;
			END
		END
		IF (@i_coreId > 0)
		BEGIN
			IF NOT EXISTS (SELECT TOP 1 * FROM SECollectionInfo WITH (NOLOCK) WHERE CoreId = @i_coreId)
			BEGIN
				SELECT @o_errorCode = /*COLLECTION_ID_NOT_VALID*/ 10574, @o_errorMsg = 'Input coreid ' + CONVERT( VARCHAR(8),@i_coreId)+ ' doesnt exists'
				GOTO _EXIT;
			END
			INSERT INTO @datasourceIdTbl
			SELECT DISTINCT DataSourceId FROM SEDataSource WITH (NOLOCK) WHERE CoreId = @i_coreId
			--set coreid
			SET @l_coreId = @i_coreId
		END
		ELSE
		BEGIN
			IF NOT EXISTS (SELECT TOP 1 * FROM SEDataSource WITH (NOLOCK) WHERE DataSourceId = @i_datasourceId)
			BEGIN
				SELECT @o_errorCode = /*DATASOURCE_ID_INVALID*/ 10627, @o_errorMsg = 'Input datasourceId ' + CONVERT( VARCHAR(8),@i_datasourceId)+ ' doesnt exists'
				GOTO _EXIT;
			END
			SELECT @l_coreId = CoreId FROM SEDataSource  WITH (NOLOCK) WHERE DataSourceId = @i_datasourceId
			--case when there exists someother datasource mapping to same datasourceI
			IF EXISTS ( SELECT TOP 1 * FROM SEDataSource WITH (NOLOCK) WHERE CoreId = @l_coreId AND DataSourceId != @i_datasourceId AND (Attribute &4) = 4)
				SET @l_ignoreCoreUpdate = 1
			INSERT INTO @datasourceIdTbl
			SELECT @i_datasourceId
		END
	END
	BEGIN TRY
	BEGIN TRAN
	--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		-- case for hard delete
		--
		IF( @i_forceDelete = 1 )
		BEGIN
			-- delete entries from security tables if datasource is deleted
            --also clear the data collection flags for FS data sources
			DECLARE @propId INT
			select @propId = PropertyId from SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'D1459ABE-5BEB-47F7-9293-7F35D3CF9063'
			DECLARE dsIdCursor CURSOR FOR
			SELECT DISTINCT dsId FROM @datasourceIdTbl
			OPEN dsIdCursor
			FETCH NEXT FROM dsIdCursor INTO @l_dsId
			WHILE @@FETCH_STATUS = 0
			BEGIN
                -- clear the data collection flags
                SET @l_dsType = 0
			    SET @l_dsCrawlType = 0
                DELETE from @datasourceSubclientTbl
                SELECT @l_dsType = DataSourceType FROM SEDataSource with (nolock) WHERE DataSourceId = @l_dsId
                IF @l_dsType = 5
                BEGIN
                    SELECT @l_dsCrawlType = PropertyValue FROM SEDataSourceProperty with (nolock) WHERE DataSourceId = @l_dsId AND PropertyId = @propId
                    INSERT INTO @datasourceSubclientTbl
   				    SELECT SC.id FROM APP_Application SC WITH (NOLOCK) INNER JOIN APP_AppTypeGroups APT WITH (NOLOCK) ON SC.appTypeId = APT.appTypeId
				    WHERE SC.clientid IN (SELECT componentNameId FROM APP_ClientProp WITH (NOLOCK) WHERE attrName =  'indexing datasource id' AND modified = 0 AND attrval IN (SELECT dsId FROM @datasourceIdTbl))
					    AND APT.App = 'File System'
				    union
				    SELECT id from APP_Application WITH (NOLOCK) WHERE backupSet IN (SELECT id FROM APP_BackupSetProp WITH (NOLOCK) WHERE attrName =  'indexing datasource id' AND modified = 0 AND attrval IN (SELECT dsId FROM @datasourceIdTbl))
				    UNION
				    SELECT componentNameId FROM APP_subclientProp WITH (NOLOCK) WHERE attrName =  'indexing datasource id' AND modified = 0 AND attrval IN (SELECT dsId FROM @datasourceIdTbl)
                    IF @l_dsCrawlType = 2 --backed up data
                    BEGIN
                        -- reset backed up data flag
UPDATE archfile SET flags = flags ^ 33554432
WHERE fileType = 1 AND appId IN (SELECT scId FROM @datasourceSubclientTbl) and flags & 33554432 = 33554432
                        -- clear the restart table
                        DELETE FROM archContentIndexingRestart WHERE archFileId IN (SELECT AF.id FROM archFile AF
inner join @datasourceSubclientTbl SC ON AF.appId = SC.scId) AND operationType = 2
                    END
                    ELSE IF @l_dsCrawlType = 4 -- file analytics
                    BEGIN
                        DELETE FROM archFLAIndexingInfo WHERE appId in (SELECT scId FROM @datasourceSubclientTbl)
                    END
                END
EXEC sec_deleteSecurityAssociationsForEntity 132, @l_dsId
				EXEC RemoveTPPMConfigurationForCA 0 , @l_dsId 			--Delete any TPPM related configuration for IS with CA
				FETCH NEXT FROM dsIdCursor INTO @l_dsId
			END
			CLOSE dsIdCursor
			DEALLOCATE dsIdCursor
			--
			--for handlers, search veiw - delete entries from security tables if datasource is deleted
			DECLARE handlerIdCursor CURSOR FOR
			SELECT DISTINCT searchviewId, status FROM SESearchView WITH (NOLOCK)
					 INNER JOIN  @datasourceIdTbl ON DataSourceId = dsId
			OPEN handlerIdCursor
			FETCH NEXT FROM handlerIdCursor INTO @l_handlerViewId, @l_status
			WHILE @@FETCH_STATUS = 0
			BEGIN
			SET @l_handlerEntityType = CASE @l_status
WHEN /*SearchView */ 0 THEN 133		/*SEA_SEARCH_VIEW_ENTITY */
WHEN /*Handler*/   1 THEN 157	/*SEA_SEARCH_HANDLER_ENTITY*/
										 --WHEN /*Federated*/ 2
										 --WHEN /*Reports*/   3
										 ELSE 0
									END
				EXEC sec_deleteSecurityAssociationsForEntity  @l_handlerEntityType, @l_handlerViewId
				FETCH NEXT FROM handlerIdCursor INTO @l_handlerViewId, @l_status
			END
			CLOSE handlerIdCursor
			DEALLOCATE handlerIdCursor
			---
			DELETE SEDataSourceSchedule WHERE DataSourceId IN (SELECT dsId FROM @datasourceIdTbl)
			DELETE SEDataSourceProperty WHERE DataSourceId IN (SELECT dsId FROM @datasourceIdTbl)
			DELETE SEDataSourceRoute WHERE DataSourceId IN (SELECT dsId FROM @datasourceIdTbl)
			DELETE SEIndexServerNodeStatsProp WHERE DataSourceId IN (SELECT dsId FROM @datasourceIdTbl)
			DELETE SEDataSource	WHERE DataSourceId IN (SELECT dsId FROM @datasourceIdTbl)
			--remove association at client, subclient & backupset level
			DELETE APP_ClientProp WHERE attrName =  'indexing datasource id' AND attrval IN (SELECT dsId FROM @datasourceIdTbl)
			DELETE APP_subclientProp WHERE attrName =  'indexing datasource id' AND attrval IN (SELECT dsId FROM @datasourceIdTbl)
			DELETE APP_BackupSetProp WHERE attrName =  'indexing datasource id' AND attrval IN (SELECT dsId FROM @datasourceIdTbl)
			IF ( @l_ignoreCoreUpdate != 1)
				DELETE SECollectionInfo WHERE CoreId = @l_coreId OR CoreId IN (SELECT coreId FROM @collectionIdTbl)
		END
		ELSE
		BEGIN
			UPDATE SEDataSource SET Attribute = Attribute | 4 WHERE DataSourceId IN (SELECT dsId FROM @datasourceIdTbl)
			IF ( @l_ignoreCoreUpdate != 1)
			BEGIN
				UPDATE SECollectionInfo SET Attribute = 4 WHERE CoreId = @l_coreId  OR CoreId IN (SELECT coreId FROM @collectionIdTbl) ;
			END
		END
	--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	COMMIT TRAN
	END TRY
	---------------------------------------------
	-- CHECK FOR ERRORS ----
	---------------------------------------------
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		-- Call procedure to print error information.
		-- Call procedure to get error information.
		EXECUTE dbo.GetError @o_errorMsg OUTPUT , @o_errorCode OUTPUT
		-- Rollback any active or uncommittable transactions before
		-- inserting information in the ErrorLog
		IF XACT_STATE() <> 0
		BEGIN
			ROLLBACK TRANSACTION;
		END
		;THROW
	END CATCH;
_EXIT:
	-- Rollback any active or uncommittable transactions before
	-- inserting information in the ErrorLog
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRANSACTION;
	END
	SELECT @o_errorCode 'errorCode', @o_errorMsg 'errorMsg'
GO

IF EXISTS (select * from GxQscripts where name = 'SEDeleteDatasource')
	delete from GxQscripts where name = 'SEDeleteDatasource'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEDeleteDatasource')
	delete from GXDBVersions where aliasname = 'SEDeleteDatasource'
GO

insert into GXDBVersions values(2, 'SEDeleteDatasource',  '00000000000000000000', 'SEDeleteDatasource', '00000000000000000000')
GO

