

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SECreateDataSourceRoutes.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SECreateDataSourceRoutes')
BEGIN
	print '>>> Drop Stored Procedure: SECreateDataSourceRoutes <<<'
	drop procedure SECreateDataSourceRoutes
END
IF EXISTS (select * from GxQscripts where name='SECreateDataSourceRoutes')
	delete from GxQscripts where name = 'SECreateDataSourceRoutes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SECreateDataSourceRoutes')
	delete from GXDBVersions where aliasname = 'SECreateDataSourceRoutes'
GO
print '... Creating Procedure: SECreateDataSourceRoutes'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SECreateDataSourceRoutes
  @i_xml XML
AS
DECLARE @o_errorCode INT = 0
DECLARE @o_errorMsg NVARCHAR(MAX) ='No Error'
DECLARE @l_multinodeFedDsId INT = @i_xml.value('(/DM2ContentIndexing_SEDataSourceRoutesFDS/@federatedDataSourceId)[1]', 'int')
IF @l_multinodeFedDsId IS NULL
BEGIN
    SELECT @o_errorCode = 10627, @o_errorMsg = 'Multinode federated datasource id not provided'
    GOTO _EXIT;
END
IF object_id('tempdb.dbo.#tmpMultinodeEntries') IS NOT NULL
    DROP TABLE #tmpMultinodeEntries
CREATE TABLE #tmpMultinodeEntries
(
  FederatedDataSourceId   INT DEFAULT NULL,
  DataSourceId        INT DEFAULT NULL,
  RouteValue          VARCHAR(256),
  RouteType         INT DEFAULT NULL,
  Attribute         INT DEFAULT NULL
);
INSERT INTO #tmpMultinodeEntries (FederatedDataSourceId, DataSourceId, RouteValue, RouteType, Attribute)
SELECT @l_multinodeFedDsId,
       Route.value('@datasourceId[1]', 'int'),
       Route.value('@routeValue[1]', 'varchar(256)'),
       Route.value('@routeType[1]', 'int'),
       Route.value('@attribute[1]', 'int')
FROM @i_xml.nodes('/DM2ContentIndexing_SEDataSourceRoutesFDS/entries') AS R(Route)
BEGIN TRY
BEGIN TRAN
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  MERGE SEDataSourceRoute AS TARGET
  USING #tmpMultinodeEntries AS SOURCE
  ON(TARGET.FederatedDataSourceId = SOURCE.FederatedDataSourceId AND TARGET.DataSourceId = SOURCE.DataSourceId)
  WHEN MATCHED THEN
  UPDATE SET TARGET.RouteValue = SOURCE.RouteValue,  TARGET.RouteType = SOURCE.RouteType, TARGET.Attribute = SOURCE.Attribute
  WHEN NOT MATCHED BY TARGET THEN
  INSERT (FederatedDataSourceId, DataSourceId, RouteValue, RouteType, Attribute)
  VALUES (SOURCE.FederatedDataSourceId, SOURCE.DataSourceId, SOURCE.RouteValue, SOURCE.RouteType, SOURCE.Attribute);
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
COMMIT TRAN
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    -- Call procedure to print error information.
    -- Call procedure to get error information.
    EXECUTE dbo.GetError @o_errorMsg OUTPUT , @o_errorCode OUTPUT
    -- Rollback any active or uncommittable transactions before
    -- inserting information in the ErrorLog
    IF XACT_STATE() <> 0
    BEGIN
        ROLLBACK TRANSACTION;
    END
    ;THROW
END CATCH;
_EXIT:
    -- Rollback any active or uncommittable transactions before
    -- inserting information in the ErrorLog
    IF XACT_STATE() <> 0
    BEGIN
        ROLLBACK TRANSACTION;
    END
    IF object_id('tempdb.dbo.#tmpMultinodeEntries') IS NOT NULL
      DROP TABLE #tmpMultinodeEntries
    SELECT @o_errorCode 'errorCode', @o_errorMsg 'errorMsg'
GO

IF EXISTS (select * from GxQscripts where name = 'SECreateDataSourceRoutes')
	delete from GxQscripts where name = 'SECreateDataSourceRoutes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SECreateDataSourceRoutes')
	delete from GXDBVersions where aliasname = 'SECreateDataSourceRoutes'
GO

insert into GXDBVersions values(2, 'SECreateDataSourceRoutes',  '00000000000000000000', 'SECreateDataSourceRoutes', '00000000000000000000')
GO

