

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SECreateDataSource.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SECreateDataSource')
BEGIN
	print '>>> Drop Stored Procedure: SECreateDataSource <<<'
	drop procedure SECreateDataSource
END
IF EXISTS (select * from GxQscripts where name='SECreateDataSource')
	delete from GxQscripts where name = 'SECreateDataSource'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SECreateDataSource')
	delete from GXDBVersions where aliasname = 'SECreateDataSource'
GO
print '... Creating Procedure: SECreateDataSource'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SECreateDataSource
  @i_coreId INT ,
  @i_userId INT ,
  @i_typeName VARCHAR(256),
  @i_xmlText XML
AS
	/*
	 Sample:
	 	<DM2ContentIndexing_SEDataSource datasourceType="1" datasourceName="NewTestDS" datasourceId="3" attribute="0">
			<connectionProperty connectionId="1" />
			<properties propertyName="driver" propertyValue="com.microsoft.sqlserver.jdbc.SQLServerDriver" />
			<properties propertyName="sql_select_statement" propertyValue="SElect * from dmsetting;" />
		</DM2ContentIndexing_SEDataSource>
	*/
	DECLARE @o_dataSourceId	INT = 0,
			@o_errorCode	INT = 0,
			@o_errorMsg		NVARCHAR(MAX) = ''
	DECLARE @dataSourceType	INT	= 0,
			@typeGuid		VARCHAR(36) = '',
			@parentTypeGuid		VARCHAR(36) = '',
			@dataSourceName	NVARCHAR(256) = '',
			@displayName	NVARCHAR(256) = '',
			@dataSourceId	INT = 0,
			@connectionPropertyID	INT = '',
			@attribute		INT = 0,
			@description NVARCHAR(MAX),
			@EXCLUDE_ATTRIBUTE	INT=2,
			@dcPlanID		INT=0
	SELECT @dataSourceName = R.ref.value('@datasourceName','NVARCHAR(256)'),
		   @displayName = ISNULL(R.ref.value('@displayName','NVARCHAR(256)'),''),
		   @dataSourceId = ISNULL(R.ref.value('@datasourceId','INT'),0),
		   @attribute	= ISNULL(R.ref.value('@attribute','INT') , 0),
		   @description = R.ref.value('@description','NVARCHAR(MAX)')
	FROM @i_xmlText.nodes('DM2ContentIndexing_SEDataSource') R ( ref )
	SELECT @connectionPropertyID = R.ref.value('@connectionId','INT')
	FROM @i_xmlText.nodes('DM2ContentIndexing_SEDataSource/connectionProperty') R ( ref )
	--perform validation
	--
	IF(@i_userId <= 0 OR NOT EXISTS (SELECT TOP 1 id FROM UMUsers WITH (NOLOCK) WHERE id = @i_userId))
	BEGIN
		SELECT @o_errorCode = 10551, @o_errorMsg = 'Input userinformation is not valid. UserID ' + CONVErT(vARCHAR(10),@i_userId)
		GOTO _EXIT;
	END
	--check coreId
	IF( @i_coreId <= 0 OR NOT EXISTS (SELECT TOP 1 CoreId FROM SECollectionInfo WITH (NOLOCK) WHERE CoreId = @i_coreId AND (Attribute & 4) = 0))
	BEGIN
		SELECT @o_errorCode = 10574, @o_errorMsg = 'Input core valid. coreId ' + CONVErT(vARCHAR(10),@i_coreId)
		GOTO _EXIT;
	END
	--retrieve typeguid
	SELECT @dataSourceType = T.TypeId, @typeGuid = T.TypeGuid , @parentTypeGuid = T.ParentTypeGuid
	FROM SEDataSourceType AS T WITH (NOLOCK) WHERE T.TypeName = @i_TypeName AND (T.Attribute & 4)  = 0
	IF (@dataSourceId=0) AND (ISNULL(@typeGuid,'')  = '')
	BEGIN
		SELECT @o_errorCode = 10629, @o_errorMsg = ' Input datasource type ' + @i_TypeName + ' is not valid'
		GOTO _EXIT;
	END
	--check if connectionProperty Is valid
	IF @connectionPropertyID > 0	 ANd NOT EXISTS (SELECT TOP 1 ConnPropId FROM SEConnectionProperty WHERE ConnPropId = @connectionPropertyID AND OwnerUserID = @i_userId)
	BEGIN
		SELECT @o_errorCode = 10601, @o_errorMsg = ' Input connectionId doesnt exists for current user. Connection ' + CONVERT(VARCHAR(10),@connectionPropertyID) + ' , UserId : ' + CONVErT(vARCHAR(10),@i_userId)
		GOTO _EXIT;
	ENd
	--case there shouldnt be another datasource name for that user
	IF EXISTS( SELECT TOP 1 D.DataSourceId FROM SEDataSource AS D WITH (NOLOCK)
				WHERE @dataSourceId = 0 AND OwnerUserID = @i_userId AND  D.DataSourceName = @dataSourceName AND (Attribute & 4) = 0)
	BEGIN
		SELECT @o_errorCode = 10631,
				@o_errorMsg = 'Datasource name ' + @dataSourceName + ' already exists for user ' + CONVErT(vARCHAR(10),@i_userId)
		GOTO _EXIT;
	END
	--check if datasourceID exists
	IF @dataSourceId > 0
	BEGIN
		DECLARE @t_dsId INT =0,
				@t_userId	INT =0,
				@t_dsName	NVARCHAR(256) = '',
				@t_displayName	NVARCHAR(256) = ''
		SELECT @t_dsId = DataSourceId, @t_userId = OwnerUserID, @t_dsName = DataSourceName, @t_displayName = DisplayName FROM SEDataSource WITH (NOLOCK) WHERE DataSourceId = @dataSourceId AND (Attribute & 4) = 0
		IF @t_dsId <= 0
		BEGIN
			SELECT @o_errorCode = 10627, @o_errorMsg = 'Input datasourceId doesnt exists. Value ' + CONVERT(VARCHAR(10),@dataSourceId)
			GOTO _EXIT;
		END
		--check user permission - EDIT permission is required to modify data source
		DECLARE @isPermissionSet INT  = 0
EXEC sec_checkPermissionOnEntity @i_userId, 202 /*CAT_DATACUBE_EDIT*/, @isPermissionSet OUTPUT, 132 /*SEA_DATASOURCE_ENTITY*/, @dataSourceId
		IF @isPermissionSet = 0
		BEGIN
			SELECT @o_errorCode = 10628, @o_errorMsg = 'Input user doesnt have permission on datasource. UserId : ' + CONVERT(VARCHAR(10),@i_userId) + ' , DatasourceId : ' + CONVERT(VARCHAR(10),@dataSourceId)
			GOTO _EXIT;
		END
		IF @t_dsName != @dataSourceName
		BEGIN
			SELECT @o_errorCode = 10632, @o_errorMsg = 'Datasource name cant be changed. Input : ' + @dataSourceName + ' , existing : ' + @t_dsName
			GOTO _EXIT;
		END
		IF(@displayName = '')
		BEGIN
			SET @displayName = @t_displayName
		END
	END
	ELSE
	BEGIN
		IF(@displayName = '')
		BEGIN
			SET @displayName = @dataSourceName
		END
	END
	-- retrieve properties fields
	--
	IF object_id('tempdb.dbo.#tmpDSProperties') IS NOT NULL
		DROP TABLE #tmpDSProperties
	CREATE TABLE #tmpDSProperties
	(
		PropertyId		int DEFAULT 0,
		PropertyName	VARCHAR(256) ,
		PropertyValue	NVARCHAR(MAX),
		Attribute		INT DEFAULT 0
	);
	INSERT INTO #tmpDSProperties (PropertyName, PropertyValue)
	SELECT R.ref.value('@propertyName','VARCHAR(1024)'), R.ref.value('@propertyValue','NVARCHAR(MAX)')
	FROM @i_xmlText.nodes('DM2ContentIndexing_SEDataSource/properties') R ( ref )
	--Update properties table which ever belong to input satisfies condition
	--
	UPDATE t
		SET PropertyId = SP.PropertyId,
			Attribute = SP.Attribute
	FROM #tmpDSProperties as t
		INNER JOIN 	SEProperty AS SP
	ON t.PropertyName = SP.PropertyName AND
		(SP.Attribute & 4)  = 0 AND
		(SP.DSTypeAttribute = -1 OR
			EXISTS ( SELECT TOP 1 * FROM SEDataSourceTypePropertyMap AS M WITH (NOLOCK)
			WHERE SP.PropertyGuid = M.PropertyGuid AND M.TypeGuid IN (@typeGuid, @parentTypeGuid) AND (M.Attribute & 4)  = 0) )
	--if any invalid properties exists return back error
	If EXISTS ( SELECT top 1 * FROM #tmpDSProperties WHERE ISNULL(PropertyId,0) = 0 )
	BEGIN
		SELECT @o_errorCode = 10630, @o_errorMsg = 'Properties ' + Stuff(  (SELECT ',' + t.PropertyName  from #tmpDSProperties as T WHERE ISNULL(T.PropertyId,0) = 0
								FOR XML PATH('')), 1, 1, '' )	+ ' doesnt exist'
		GOTO _EXIT;
	ENd
	DELETE #tmpDSProperties WHERE Attribute & @EXCLUDE_ATTRIBUTE = @EXCLUDE_ATTRIBUTE
	BEGIN TRY
	BEGIN TRAN
	--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	IF(@dataSourceId = 0)
	BEGIN
		-- Add a new entry
		INSERT INTO SEDataSource ( DataSourceGuid, CoreId, DataSourceName, DisplayName, DataSourceType, ConnPropId, OwnerUserID, Status, Attribute, ModifiedBy)
		SELECT NEWID(), @i_coreId, @dataSourceName, @displayName, @dataSourceType,
			CASE WHEN @connectionPropertyID = 0 THEN NULL ELSE @connectionPropertyID END,
			@i_userId, 0, @attribute, @i_userId
		SELECT @o_dataSourceId = SCOPE_IDENTITY()
		--insert properties
		INSERT INTO SEDataSourceProperty (DataSourceId, PropertyId, PropertyValue)
		SELECT @o_dataSourceId, PropertyId, PropertyValue FROM #tmpDSProperties
		--Add to security
exec sec_setCreatorForEntity @i_userId,0,N'201,202,203,204,107' /*View,Add,Append,Delete,107*/,@o_errorCode output, @o_errorMsg output, 132 /*SEA_DATASOURCE_ENTITY*/,@o_dataSourceId
		--case where above SP returns deadlock/timeout error, we need to explicitly throw to caller to perform retry.
		--
		IF(@o_errorCode > 0)
		BEGIN
			IF @o_errorCode IN (1205, 1204, 1222)
			BEGIN
				SET @o_errorMsg = 'Explicit Raise Error - ' + CAST(@o_errorCode as VARCHAR(10)) + ':' + @o_errorMsg;
				THROW 57001, @o_errorMsg , 1
			END
			ELSE
				GOTO _EXIT;
		END
	END
	ELSE
	BEGIN
		-- Update datasource details
		IF (@attribute=4)
		BEGIN
			DECLARE @prev_attribute INT
			SELECT @prev_attribute=attribute from SEDataSource where DataSourceId=@dataSourceId
			SET @attribute=@prev_attribute | @attribute
		END
		UPDATE SEDataSource SET ConnPropId = CASE WHEN @connectionPropertyID = 0 THEN NULL ELSE @connectionPropertyID END,
			Attribute = CASE WHEN @attribute = 0 THEN Attribute ELSE @attribute END, Description	= @description, ModifiedBy = @i_userId, DisplayName = @displayName, ModifiedTime = GETUTCDATE()
		WHERE DataSourceId = @dataSourceId
		-- insert new entry,
		-- update existing value
		-- delete if value is empty
		MERGE SEDataSourceProperty AS TARGET
		USING #tmpDSProperties AS SOURCE
		ON(TARGET.DataSourceId = @dataSourceId AND TARGET.PropertyId = SOURCE.PropertyId)
		-- Update If the property exists and the new value isn't empty
		WHEN MATCHED AND ISNULL(SOURCE.PropertyValue, '') <> '' THEN
		UPDATE SET TARGET.PropertyValue = SOURCE.PropertyValue
		-- If the property exists and the new value is empty we assume it is to nullify hence delete it
		WHEN MATCHED AND ISNULL(SOURCE.PropertyValue, '') = '' THEN
		DELETE
		-- Insert if the property doesn't exists and isn't empty, if property is empty skip it.
		WHEN NOT MATCHED BY TARGET AND ISNULL(SOURCE.PropertyValue, '') <> '' THEN
		INSERT (DataSourceId, PropertyId, PropertyValue)
		VALUES(@dataSourceId, SOURCE.PropertyId, SOURCE.PropertyValue);
		SELECT @o_dataSourceId = @dataSourceId
	END
	-- Add firewall configuration for the data source
	IF @o_dataSourceId <> 0
	BEGIN
		SELECT @dcPlanID =  DSP.PropertyValue FROM SEDataSourceProperty DSP (NOLOCK)
		WHERE DSP.DataSourceId = @o_dataSourceId AND DSP.PropertyId =(SELECT TOP 1 PropertyId FROM SEProperty (NOLOCK) WHERE PropertyGuid = '9DE33247-4068-46F3-BB4D-8D7F1A48534E')
		EXEC CreateTPPMForISToCA @dcPlanID, @o_dataSourceId
	END
	--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	IF(@o_errorCode > 0)
		ROLLBACK TRAN
	ELSE
		COMMIT TRAN
	END TRY
	---------------------------------------------
	-- CHECK FOR ERRORS ----
	---------------------------------------------
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		-- Call procedure to print error information.
		-- Call procedure to get error information.
		EXECUTE dbo.GetError @o_errorMsg OUTPUT , @o_errorCode OUTPUT
		-- Rollback any active or uncommittable transactions before
		-- inserting information in the ErrorLog
		IF XACT_STATE() <> 0
		BEGIN
			ROLLBACK TRANSACTION;
		END
		--caller have logic to perform retry on timeout or deadlock
		--
		;THROW
	END CATCH;
_EXIT:
	-- Rollback any active or uncommittable transactions
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRANSACTION;
	END
	SELECT @o_dataSourceId 'o_dataSourceId', @o_errorCode 'o_errorCode', @o_errorMsg 'o_errorMsg'
GO

IF EXISTS (select * from GxQscripts where name = 'SECreateDataSource')
	delete from GxQscripts where name = 'SECreateDataSource'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SECreateDataSource')
	delete from GXDBVersions where aliasname = 'SECreateDataSource'
GO

insert into GXDBVersions values(2, 'SECreateDataSource',  '00000000000000000000', 'SECreateDataSource', '00000000000000000000')
GO

