

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SECreateCollectionInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SECreateCollectionInfo <<<'

IF EXISTS (select * from sysobjects where name='SECreateCollectionInfo')
	drop procedure SECreateCollectionInfo
IF EXISTS (select * from GxQscripts where name='SECreateCollectionInfo')
	delete from GxQscripts where name = 'SECreateCollectionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SECreateCollectionInfo')
	delete from GXDBVersions where aliasname = 'SECreateCollectionInfo'
GO
print '... Creating Procedure: SECreateCollectionInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SECreateCollectionInfo
  @i_coreName VARCHAR(128),
  @i_clientId INT,
  @i_cloudId INT,
  @i_userID INT,
  @i_description NVARCHAR(max) = '',
  @i_schemaType VARCHAR(36) = 'default',
  @i_attribute INT = 0,
  @i_dsType VARCHAR(128)
AS
DECLARE @o_coreId INT = 0,
		@o_errorCode	INT = 0,
		@o_errorMsg		NVARCHAR(MAX) = '',
		@actualCoreName		NVARCHAR(256) = '',
		@status INT = 0
	-- check if value exists
	IF NOT EXISTS (SELECT TOP 1 id FROM UMUSers WITH (NOLOCK) WHERE id = @i_userID AND enabled = 1)
	BEGIN
		SELECT @o_errorCode = 10551, @o_errorMsg = 'Input user information doesnt exists'
		GOTO _EXIT;
	END
	--check if clientId is valid against DM2SearchServerCoreInfo
	--
	IF (@i_attribute & 16 /*DUMMY_CI_INFO*/ = 0) AND
	NOT EXISTS (SELECT TOP 1 CloudId FROM DM2Cloud C WITH (NOLOCK) WHERE C.CloudId = @i_cloudId)
	BEGIN
		SELECT @o_errorCode = 10552, @o_errorMsg = 'Input search server info is not valid'
		GOTO _EXIT;
	END
	/*
	--if for same client, user, corename exists, we dont duplicate
	IF EXISTS ( SELECT * FROM SECollectionInfo WITH (NOLOCK)
				WHERE CoreName = @i_CoreName AND ClientId = @i_Clientid AND OwnerUserId = @i_userID AND (Attribute&4) = 0)
	BEGIN
		SELECT @o_errorCode = 10580, @o_errorMsg = 'Core '+ @i_CoreName + ' already exists for the user'
		GOTO _EXIT;
	END
	*/
	INSERT INTO SECollectionInfo ( CoreName, ClientId, CloudID, OwnerUserId, Description, Attribute,SchemaType,ActualCoreName)
	SELECT @i_CoreName, @i_Clientid, @i_cloudId, @i_userID, @i_description, @i_attribute,@i_schemaType,@i_CoreName
	SELECT @o_coreId = SCOPE_IDENTITY()
_EXIT:
	SELECT @o_coreId 'o_coreId' , @o_errorCode 'o_errorCode', @o_errorMsg 'o_errorMsg'
GO

IF EXISTS (select * from GxQscripts where name = 'SECreateCollectionInfo')
	delete from GxQscripts where name = 'SECreateCollectionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SECreateCollectionInfo')
	delete from GXDBVersions where aliasname = 'SECreateCollectionInfo'
GO

insert into GXDBVersions values(2, 'SECreateCollectionInfo',  '00000000000000000000', 'SECreateCollectionInfo', '00000000000000000000')
GO

