

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEAUpdateReportView.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SEAUpdateReportView <<<'

IF EXISTS (select * from sysobjects where name='SEAUpdateReportView')
	drop procedure SEAUpdateReportView
IF EXISTS (select * from GxQscripts where name='SEAUpdateReportView')
	delete from GxQscripts where name = 'SEAUpdateReportView'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEAUpdateReportView')
	delete from GXDBVersions where aliasname = 'SEAUpdateReportView'
GO
print '... Creating Procedure: SEAUpdateReportView'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SEAUpdateReportView
  @i_reportId INT,
  @i_userId INT,
  @i_dataSourceIds NVARCHAR(MAX),
  @i_searchViewName NVARCHAR(MAX),	
  @i_referenceIds NVARCHAR(MAX),
  @i_status INT = 0,
  @i_attribute INT = 0
AS
SET NOCOUNT ON
BEGIN
	DECLARE @l_sReportId NVARCHAR(8) = CONVERT(NVARCHAR(8),@i_reportId)
	DECLARE @tempDsIDs TABLE (
		id int not null identity(1,1),
		dsId int
	)
	DECLARE @tempHandlerIDs TABLE (
		id int not null identity(1,1),
		handlerId int
	)
	DECLARE @searchViews Table (
		dsId int,
		handlerId int,
		searchViewId int
	)
	-- populating @tempDsIDs temp table
	INSERT INTO @tempDsIDs
	SELECT _ID FROM dbo.SplitIDs(@i_dataSourceIds)
	-- populating @tempHandlerIDs temp table
	INSERT INTO @tempHandlerIDs
	SELECT _ID FROM dbo.SplitIDs(@i_referenceIds)
	-- populating @searchViews temp table
	INSERT INTO @searchViews(dsId,handlerId)
	SELECT DISTINCT D.dsId , H.handlerId
	FROM @tempDsIDs D INNER JOIN @tempHandlerIDs H
	ON D.id=H.id
	-- delete entries when dsId is not there in SEDataSource to avoid merge failures
	DELETE SV
	FROM @searchViews SV LEFT JOIN
		SEDataSource DS WITH(NOLOCK) ON SV.dsId = DS.DataSourceId
		WHERE DS.DataSourceId IS NULL
	-- delete views where dsId is not in @searchViews
	DELETE FROM SESearchView WHERE ViewInfo = @l_sReportId AND Status = 3 AND DataSourceId NOT IN (SELECT dsId from @searchViews)
	-- insert or update searchViewId in @searchViews
	MERGE SESearchView SE
	USING (SELECT * FROM @searchViews) TS
	ON SE.ViewInfo=@l_sReportId AND TS.dsId = SE.DataSourceId AND TS.handlerId=SE.ReferenceId AND SE.Status = 3
	WHEN MATCHED THEN
	update set SE.SearchViewName=@i_searchViewName, SE.ModifiedTime=GETUTCDATE(), SE.ModifiedBy = @i_userId
	WHEN NOT MATCHED BY TARGET THEN
	insert (DataSourceId, SearchViewName, ViewInfo, OwnerUserID, Status, Attribute, CreateTime, ModifiedBy, ModifiedTime, ReferenceId)
	VALUES (
		TS.dsId,
		@i_searchViewName,
		@l_sReportId,
		@i_userId,
		3, -- for reports
		0,
		GETUTCDATE(),
		@i_userId,
		GETUTCDATE(),
		TS.handlerId
	);
END
GO

IF EXISTS (select * from GxQscripts where name = 'SEAUpdateReportView')
	delete from GxQscripts where name = 'SEAUpdateReportView'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEAUpdateReportView')
	delete from GXDBVersions where aliasname = 'SEAUpdateReportView'
GO

insert into GXDBVersions values(2, 'SEAUpdateReportView',  '00000000000000000000', 'SEAUpdateReportView', '00000000000000000000')
GO

