

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEAGetStatusInfoUserDatasources.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--		  Given a list of Project Ids, this SP will return list of datasources, associated entities of those projects
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SEAGetStatusInfoUserDatasources')
BEGIN
	print '>>> Drop Stored Procedure: SEAGetStatusInfoUserDatasources <<<'
	drop procedure SEAGetStatusInfoUserDatasources
END
IF EXISTS (select * from GxQscripts where name='SEAGetStatusInfoUserDatasources')
	delete from GxQscripts where name = 'SEAGetStatusInfoUserDatasources'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEAGetStatusInfoUserDatasources')
	delete from GXDBVersions where aliasname = 'SEAGetStatusInfoUserDatasources'
GO
print '... Creating Procedure: SEAGetStatusInfoUserDatasources'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SEAGetStatusInfoUserDatasources
  @i_userId INT,
  @i_Syncall INT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
IF OBJECT_ID('tempdb.dbo.#tempStatusInfoDatasources') IS NOT NULL     DROP TABLE #tempStatusInfoDatasources
	CREATE TABLE #tempStatusInfoDatasources (
		DataSourceId INTEGER,
		DataSourceName NVARCHAR(256),
		DataSourceType NVARCHAR(256),
		CloudID INTEGER,
		ClientID INTEGER,
		ActualCoreName NVARCHAR(256),
		AppName NVARCHAR(256),
		StatusInfo NVARCHAR(MAX),
		MultinodeDSId	INTEGER
	)
	DECLARE @t_statusPropId INT = ISNULL((SELECT TOP 1 PropertyId FROM SEProperty WHERE PropertyName = 'statusinfo'), 0)
	DECLARE @t_appNamePropId INT = ISNULL((SELECT TOP 1 PropertyId FROM SEProperty WHERE PropertyName = 'appname'), 0)
	DECLARE @t_multinodePropId INT = ISNULL((SELECT TOP 1 PropertyId FROM SEProperty WHERE PropertyGuid = 'B2A95D3F-73F1-42DB-8419-382C2241ABAC'), 0)
	DECLARE @t_multinodeDSTypeId INT = (SELECT TOP 1 TypeId FROM SEDataSourceType WHERE TypeGuid = '04854E90-76E5-47D2-8C7F-28026DAABCC6')
	IF(@i_Syncall = 1)
		BEGIN
			INSERT INTO #tempStatusInfoDatasources(DatasourceId, DatasourceName, DataSourceType, CloudID, ClientID, ActualCoreName, AppName, StatusInfo, MultinodeDSId)
			SELECT DS.DataSourceId, DS.DataSourceName, DST.TypeName as DataSourceType, CI.CloudID, CI.ClientId AS ClientID, CI.ActualCoreName, DSP2.PropertyValue AS appName, DSP.PropertyValue AS StatusInfo, ISNULL(DSP3.PropertyValue, 0) AS MultinodeDSId
			FROM SEDataSourceType AS DST WITH(NOLOCK)
			INNER JOIN SEDataSource as DS WITH (NOLOCK) ON DST.TypeId = DS.DataSourceType AND DST.Status & 2 != 2 AND DST.TypeId != @t_multinodeDSTypeId
			INNER JOIN SECollectionInfo as CI WITH(NOLOCK) ON DS.CoreId = CI.CoreId AND DS.Attribute & 4 != 4
			LEFT JOIN SEDataSourceProperty AS DSP WITH(NOLOCK) ON DSP.DataSourceId = DS.DataSourceId AND DSP.PropertyId = @t_statusPropId
			LEFT JOIN SEDataSourceProperty AS DSP2 WITH(NOLOCK) ON DSP2.DataSourceId = DS.DataSourceId AND DSP2.PropertyId = @t_appNamePropId
			LEFT JOIN SEDataSourceProperty AS DSP3 WITH(NOLOCK) ON DSP3.DataSourceId = DS.DataSourceId AND DSP3.PropertyId = @t_multinodePropId
			ORDER BY CI.CloudID
		END
	ELSE
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#tempDatasourcesInfo') IS NOT NULL DROP TABLE #tempDatasourcesInfo
			CREATE TABLE #tempDatasourcesInfo (
				DataSourceId INTEGER,
				DataSourceName NVARCHAR(256),
				DisplayName NVARCHAR(256),
				DataSourceType NVARCHAR(256),
				CoreId INTEGER,
				CloudID INTEGER,
				ClientId INTEGER,
				CoreName NVARCHAR(256),
				ActualCoreName NVARCHAR(256),
				DataSourceAttribute INTEGER,
				CoreAttribute INTEGER,
				ownerType INTEGER,
				MultinodeDSId INTEGER
			)
			--CALL EXISTING SP TO GET DS INFO FOR USER
			INSERT INTO #tempDatasourcesInfo
			EXEC SEGetDataSources @i_userId, @i_flatTable=1
			INSERT INTO #tempStatusInfoDatasources(DatasourceId, DatasourceName, DataSourceType, CloudID, ClientID, ActualCoreName, AppName, StatusInfo, MultinodeDSId)
			SELECT T.DataSourceId, T.DataSourceName, T.DataSourceType, T.CloudID, T.ClientId, T.ActualCoreName, DSP2.PropertyValue AS AppName, DSP.PropertyValue AS StatusInfo, ISNULL(T.MultinodeDSId, 0) AS MultinodeDSId FROM #tempDatasourcesInfo T
			INNER JOIN  SEDataSourceType DST WITH(NOLOCK) ON DST.TypeName =  T.DataSourceType AND DST.Status & 2 != 2 AND DST.TypeId != @t_multinodeDSTypeId
			INNER JOIN SECollectionInfo AS CI WITH(NOLOCK) ON T.CoreId = CI.CoreId AND T.CoreAttribute & 4 != 4
			LEFT JOIN SEDataSourceProperty AS DSP WITH(NOLOCK) ON DSP.DataSourceId = T.DataSourceId AND DSP.PropertyId = @t_statusPropId
			LEFT JOIN SEDataSourceProperty AS DSP2 WITH(NOLOCK) ON DSP2.DataSourceId = T.DataSourceId AND DSP2.PropertyId = @t_appNamePropId
		END
	-- Delete all shards of cvcloud data sources from the final set of data sources
	DELETE FROM #tempStatusInfoDatasources
	WHERE DataSourceId IN (SELECT SDR.DataSourceId FROM SEDataSourceRoute AS SDR WITH(NOLOCK))
	select * from #tempStatusInfoDatasources
	IF OBJECT_ID('tempdb.dbo.#tempDatasourcesInfo') IS NOT NULL DROP TABLE #tempDatasourcesInfo
	IF OBJECT_ID('tempdb.dbo.#tempStatusInfoDatasources') IS NOT NULL DROP TABLE #tempStatusInfoDatasources
END
GO

IF EXISTS (select * from GxQscripts where name = 'SEAGetStatusInfoUserDatasources')
	delete from GxQscripts where name = 'SEAGetStatusInfoUserDatasources'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEAGetStatusInfoUserDatasources')
	delete from GXDBVersions where aliasname = 'SEAGetStatusInfoUserDatasources'
GO

insert into GXDBVersions values(2, 'SEAGetStatusInfoUserDatasources',  '00000000000000000000', 'SEAGetStatusInfoUserDatasources', '00000000000000000000')
GO

