

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEAGetSearchView.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SEAGetSearchView')
BEGIN
	print '>>> Drop Stored Procedure: SEAGetSearchView <<<'
	drop procedure SEAGetSearchView
END
IF EXISTS (select * from GxQscripts where name='SEAGetSearchView')
	delete from GxQscripts where name = 'SEAGetSearchView'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEAGetSearchView')
	delete from GXDBVersions where aliasname = 'SEAGetSearchView'
GO
print '... Creating Procedure: SEAGetSearchView'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SEAGetSearchView
  @i_userId INT,
  @i_datasourceId INT = 0,	
  @i_searchViewId INT = 0,	
  @i_status INT = 0,
  @i_start INT = 0,
  @i_batchCnt INT = 0,
  @i_includeCoreInfo BIT = 0,
  @i_searchViewIds VARCHAR(MAX) = '',
  @i_permissionId INT = 0
AS
SET NOCOUNT ON
BEGIN
	DECLARE @isEnterpriseCommCell int = 1
	DECLARE @l_handlerEntityType INT = 0
	DECLARE @SETemplateDefaultViewId INT = -1
	SET @l_handlerEntityType = CASE @i_status
										  WHEN /*SearchView */ 0 THEN 133 /*SEA_SEARCH_VIEW_ENTITY */
										 WHEN /*Handler*/   1 THEN 157/*SEA_SEARCH_HANDLER_ENTITY*/
										 --WHEN /*Federated*/ 2
										 --WHEN /*Reports*/   3
										 ELSE 0
									END
	--
	-- Find if current comm-cell is in MSP or Enterprise mode.
	--
	IF EXISTS (SELECT 1 FROM GXGlobalParam WITH(NOLOCK) WHERE name = N'IsMSPCommcell' and value = '1' AND modified = 0)
	BEGIN
		SET @isEnterpriseCommCell = 0
	END
	--
	DECLARE @tblSearchview TABLE ( cnt INT IDENTITY (1,1), viewId INT, dsId INT, permissionType INT default 3 /*other*/, searchViewName NVARCHAR(128), searchViewAttribute INT, viewInfo NVARCHAR(128), referenceId INT);
	IF OBJECT_ID('tempdb.dbo.#sec_GetSearchViewListByType') IS NOT NULL
		DROP TABLE #sec_GetSearchViewListByType
	-- as of now, if input permission type is defined, we set permissiontype = 2
	-- else, for owner we set to 1 and other = 2
	CREATE  TABLE #sec_GetSearchViewListType ( searchViewId INT, permissionType INT);
	IF( @l_handlerEntityType <> 0)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#permissionIdTable') IS NOT NULL
			DROP TABLE #permissionIdTable
		CREATE TABLE #permissionIdTable (permissionId INT)
		--Contains objects tables to be used by SP.
		IF OBJECT_ID('tempdb.dbo.#getObjectsTable') IS NOT NULL
			DROP TABLE #getObjectsTable
		CREATE TABLE #getObjectsTable (entityId INT, permissionId INT)
		--for now everything retrieved are shared
		--Later make changes if needed for others when data retrieved have only commcell level permission
		--
		DECLARE @l_defaultOwnerType INT = 2 /*Shared*/
IF (@i_permissionId = 204 /*CAT_DATACUBE_EXECUTE*/ )
		BEGIN
			INSERT INTO #permissionIdTable
SELECT 204 /*CAT_DATACUBE_EXECUTE*/ UNION
SELECT 202 /*CAT_DATACUBE_EDIT*/ UNION
SELECT 13 /*EV_BROWSE*/ WHERE @isEnterpriseCommCell = 1
		END
ELSE IF (@i_permissionId = 201 /*CAT_DATACUBE_VIEW*/ )
		BEGIN
			INSERT INTO #permissionIdTable
SELECT 201 /*CAT_DATACUBE_VIEW*/UNION
SELECT 202 /*CAT_DATACUBE_EDIT*/ UNION
SELECT 31 /*EV_VISIBILITY*/ WHERE @isEnterpriseCommCell = 1
		END
ELSE IF (@i_permissionId = 202)
		BEGIN
			INSERT INTO #permissionIdTable
SELECT 202 /*CAT_DATACUBE_EDIT*/
		END
ELSE IF (@i_permissionId = 203)
		BEGIN
			INSERT INTO #permissionIdTable
SELECT 203 /*CAT_DATACUBE_DELETE*/ UNION
SELECT 35 /*CV_EV_DELETE*/ WHERE @isEnterpriseCommCell = 1
		END
		ELSE IF (@i_permissionId = 0)
		BEGIN
			INSERT INTO #permissionIdTable
SELECT 201 /*CAT_DATACUBE_VIEW*/UNION
SELECT 202 /*CAT_DATACUBE_EDIT*/ UNION
---SELECT 107 /*CAT_USER_MANAGMENT_ASSOC_ON_ENTITY*/ UNION
SELECT 31 /*EV_VISIBILITY*/ WHERE @isEnterpriseCommCell = 1
		END
		EXEC sec_getObjectsWithPermissionsV2 @i_userId, @l_handlerEntityType ,0
		INSERT INTO #sec_GetSearchViewListType (searchViewId, permissionType)
SELECT DISTINCT entityId, @l_defaultOwnerType FROM #getObjectsTable WHERE PermissionId != 107 /*CAT_USER_MANAGMENT_ASSOC_ON_ENTITY*/
		-- Just update the table to Owner if ownerUserId column matches input userID
		--
		UPDATE T
		SET permissionType = 1 /*DM2OwnerType.Owner*/
		FROM #sec_GetSearchViewListType T INNER JOIN
		SESearchView SV ON T.searchViewId = SV.searchViewId AND SV.OwnerUserID = @i_userId
	END
	INSERT INTO @tblSearchview(viewId, dsId)
	SELECT V.SearchViewId, V.DataSourceId FROM SESearchView as V WITH (NOLOCK) WHERE
		( @i_datasourceId = 0 OR V.DataSourceId = @i_datasourceId) AND
		( @i_searchViewId = 0 OR V.SearchViewId = @i_searchViewId) AND
		( V.status = @i_status) AND
		( ISNULL(@i_searchViewIds,'') = '' OR V.SearchViewId IN (SELECT S._ID FROM dbo.SplitIDs(@i_searchViewIds) as S))
	IF(@l_handlerEntityType <> 0)
	BEGIN
		DELETE 	FROM t
		FROM  @tblSearchview t
		LEFT OUTER JOIN #sec_GetSearchViewListType as LT
			ON t.viewId = LT.searchViewId
		WHERE LT.searchViewId IS NULL
		--user security
		UPDATE t SET
			t.permissionType = GT.permissionType
		FROM @tblSearchview as t
		INNER JOIN	#sec_GetSearchViewListType as GT
			ON t.viewId = GT.searchViewId
		DROP TABLE #sec_GetSearchViewListType
		IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL
			DROP TABLE #getIndexServers
		CREATE TABLE #getIndexServers
			(      serverURL NVARCHAR(512),
					clientId INT,
					clientName NVARCHAR(256),
					cloudId INT,
					hostName NVARCHAR(256),
					basePort INT,
					engineName  NVARCHAR(256),
					serverType INT,
					indexServerClientId INT,
					internalCloudName NVARCHAR(256)
			)
		EXEC DM2GetIndexServers
		-- Delete the entries if there is no mapping cloud information
		DELETE T
		FROM @tblSearchview T
		INNER JOIN SEDataSource AS DS WITH (NOLOCK) ON T.dsId = DS.DataSourceId
		INNER JOIN SECollectionInfo AS CI WITH (NOLOCK) ON DS.CoreId = CI.CoreId AND CI.CloudID > 0
		LEFT JOIN #getIndexServers AE ON CI.CloudID = AE.cloudId AND AE.ServerType IN (1,4,5) WHERE AE.cloudId IS NULL
	END
	--do batching
	--
	IF( @i_batchCnt <= 0) SET @i_batchCnt = 10000
	IF (@i_start <= 0) SET @i_start = 1
	-- get default report information from SETemplate table and store it
	--
	IF(@i_status = 3)
	BEGIN
		INSERT INTO @tblSearchview(viewId, dsId, searchViewName, searchViewAttribute, viewInfo, referenceId)
		SELECT @SETemplateDefaultViewId, DS.DataSourceId,
			r.value('(./ReportName)[1]', 'VARCHAR(128)'),
			r.value('(./ReportAttribute)[1]', 'INT'), CONCAT('{"handlerName":"', SV.SearchViewName, '"}'), SV.SearchViewId
		FROM SETemplate AS SE WITH (NOLOCK)
			CROSS APPLY
		TemplateProperties.nodes('/TemplateProperties/ReportInfo') t(r)
			INNER JOIN
		SEDataSource AS DS WITH (NOLOCK) ON SE.SourceDsType = DS.DataSourceType AND SE.TemplateType = 2 AND (@i_datasourceId = 0 OR DS.DataSourceId = @i_datasourceId)
			CROSS APPLY
		(SELECT TOP 1 SearchViewName, SearchViewId FROM SESearchView WHERE DataSourceId = DS.DataSourceId AND Status = 1 AND Attribute = 2) SV
	END
	DECLARE @multinodeDSPropertyId INT = 0
	SELECT  @multinodeDSPropertyId = PropertyId FROM SEProperty WITH (NOLOCK) WHERE PropertyGuid = 'B2A95D3F-73F1-42DB-8419-382C2241ABAC'
	IF( @i_includeCoreInfo = 1)
	BEGIN
		;WITH CTE (viewId, dsId, searchViewName, searchViewAttribute, viewInfo, referenceId, permissionType) as
		(SELECT TOP (@i_batchCnt)  T.viewId, T.dsId, T.searchViewName, T.searchViewAttribute, T.viewInfo, T.referenceId, T.permissionType FROM @tblSearchview as T WHERE T.cnt >= @i_start)
		(SELECT V.SearchViewId, V.SearchViewName, V.ViewInfo, V.OwnerUserID, V.Status, V.Attribute, V.CreateTime, V.ModifiedTime, V.ModifiedBy,
				DS.DataSourceId, DS.DataSourceName, (SELECT TOP 1 TypeName FROM SEDataSourceType WHERE TypeId = ds.DataSourceType) as DataSourceType,
				CI.CoreId, CI.CloudID, CI.ClientId, CI.CoreName, CI.ActualCoreName,
				DS.Attribute as 'DataSourceAttribute', CI.Attribute as 'CoreAttribute', V.ReferenceId, CTE.permissionType as 'OwnerType', CASE WHEN PROP.PropertyValue IS NULL THEN 0 ELSE CAST(PROP.PropertyValue AS INT) END AS 'MultinodeDSId'
		FROM SESearchView AS V WITH (NOLOCK)
				INNER JOIN
			CTE ON V.SearchViewId = CTE.viewId
				INNER JOIN
			SEDataSource DS WITH (NOLOCK)	ON V.DataSourceId = DS.DataSourceId
				INNER JOIN
			SECollectionInfo CI WITH (NOLOCK) ON DS.CoreId = CI.CoreId
				LEFT JOIN
			SEDataSourceProperty PROP WITH (NOLOCK) ON V.DataSourceId = PROP.DataSourceId 	AND PROP.PropertyId = @multinodeDSPropertyId)
		UNION
		(SELECT CTE.viewId, CTE.searchViewName, CTE.viewInfo, NULL, 3, CTE.searchViewAttribute, NULL, NULL, NULL, DS.DataSourceId, DS.DataSourceName, (SELECT TOP 1 TypeName FROM SEDataSourceType WHERE TypeId = ds.DataSourceType),
				CI.CoreId, CI.CloudID, CI.ClientId, CI.CoreName, CI.ActualCoreName, DS.Attribute, CI.Attribute, CTE.referenceId, CTE.permissionType, CASE WHEN PROP.PropertyValue IS NULL THEN 0 ELSE CAST(PROP.PropertyValue AS INT) END
		FROM CTE
				INNER JOIN
			SEDataSource DS WITH (NOLOCK) ON CTE.viewId = -1 AND CTE.dsId = DS.DataSourceId
				INNER JOIN
			SECollectionInfo CI WITH (NOLOCK) ON DS.CoreId = CI.CoreId
				LEFT JOIN
			SEDataSourceProperty PROP WITH (NOLOCK) ON DS.DataSourceId = PROP.DataSourceId AND PROP.PropertyId = @multinodeDSPropertyId)
		ORDER BY CreateTime DESC
	END
	ELSE
	BEGIN
		;WITH CTE (viewId, dsId, searchViewName, searchViewAttribute, viewInfo, referenceId, permissionType) as
		(SELECT TOP (@i_batchCnt)  T.viewId, T.dsId, T.searchViewName, T.searchViewAttribute, T.viewInfo, T.referenceId, T.permissionType FROM @tblSearchview as T WHERE T.cnt >= @i_start)
		(SELECT V.SearchViewId, V.DataSourceId, DS.DataSourceName, (SELECT TOP 1 TypeName FROM SEDataSourceType WHERE TypeId = ds.DataSourceType) as DataSourceType,
				 V.SearchViewName, V.ViewInfo, V.OwnerUserID, V.Status,
				 V.Attribute, V.CreateTime, V.ModifiedTime, V.ModifiedBy , V.ReferenceId, CTE.permissionType  as OwnerType, CASE WHEN PROP.PropertyValue IS NULL THEN 0 ELSE CAST(PROP.PropertyValue AS INT) END AS MultinodeDSId
		FROM SESearchView AS V WITH (NOLOCK)
				INNER JOIN
			CTE ON V.SearchViewId = CTE.viewId
				INNER JOIN
			SEDataSource DS WITH (NOLOCK)	ON V.DataSourceId = DS.DataSourceId
				LEFT JOIN
			SEDataSourceProperty PROP WITH (NOLOCK) ON V.DataSourceId = PROP.DataSourceId 	AND PROP.PropertyId = @multinodeDSPropertyId)
		UNION
		(SELECT CTE.viewId, SD.DataSourceId, SD.DataSourceName, (SELECT TOP 1 TypeName FROM SEDataSourceType WHERE TypeId = SD.DataSourceType) as DataSourceType,
				CTE.searchViewName, CTE.viewInfo, NULL, 3, CTE.searchViewAttribute, NULL, NULL, NULL, CTE.referenceId, CTE.permissionType, CASE WHEN PROP.PropertyValue IS NULL THEN 0 ELSE CAST(PROP.PropertyValue AS INT) END
		FROM CTE
				INNER JOIN
			SEDataSource as SD WITH (NOLOCK) ON CTE.viewId = -1 AND SD.DataSourceId = CTE.dsId
				LEFT JOIN
			SEDataSourceProperty PROP WITH (NOLOCK) ON SD.DataSourceId = PROP.DataSourceId 	AND PROP.PropertyId = @multinodeDSPropertyId)
		ORDER BY CreateTime DESC
	END
	--
	-- clean up temp table
	--
	IF OBJECT_ID('tempdb.dbo.#sec_GetSearchViewListByType') IS NOT NULL
		DROP TABLE #sec_GetSearchViewListByType
	IF OBJECT_ID('tempdb.dbo.#permissionIdTable') IS NOT NULL
		DROP TABLE #permissionIdTable
	IF OBJECT_ID('tempdb.dbo.#getObjectsTable') IS NOT NULL
		DROP TABLE #getObjectsTable
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL
		DROP TABLE #getIndexServers
	--
	-- clean up temp table done.
	--
END
GO

IF EXISTS (select * from GxQscripts where name = 'SEAGetSearchView')
	delete from GxQscripts where name = 'SEAGetSearchView'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEAGetSearchView')
	delete from GXDBVersions where aliasname = 'SEAGetSearchView'
GO

insert into GXDBVersions values(2, 'SEAGetSearchView',  '00000000000000000000', 'SEAGetSearchView', '00000000000000000000')
GO

