

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEAGetEDiscoveryProjectsDataSource.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--		  Given a list of Project Ids, this SP will return list of datasources with which they associate
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SEAGetEDiscoveryProjectsDataSource')
BEGIN
	print '>>> Drop Stored Procedure: SEAGetEDiscoveryProjectsDataSource <<<'
	drop procedure SEAGetEDiscoveryProjectsDataSource
END
IF EXISTS (select * from GxQscripts where name='SEAGetEDiscoveryProjectsDataSource')
	delete from GxQscripts where name = 'SEAGetEDiscoveryProjectsDataSource'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEAGetEDiscoveryProjectsDataSource')
	delete from GXDBVersions where aliasname = 'SEAGetEDiscoveryProjectsDataSource'
GO
print '... Creating Procedure: SEAGetEDiscoveryProjectsDataSource'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SEAGetEDiscoveryProjectsDataSource
  @i_userId INT,
  @i_ProjectIdsList VARCHAR(MAX) = '',	-- list of GDPR projects, separated by comma (,)
  @o_ErrorCode INT OUTPUT,
  @o_ErrorMsg VARCHAR(MAX) OUTPUT
AS
SET NOCOUNT ON
BEGIN
	SET @o_ErrorCode = 0
	SET @o_ErrorMsg = ''
	-- check input's validity
	IF (@i_UserId <= 0)
		BEGIN
			SET @o_ErrorCode = 1
			SET @o_ErrorMsg = 'Invalid user Id'
			GOTO exitLine
		END
	IF (@i_ProjectIdsList = '')
		BEGIN
			SET @o_ErrorCode = 1
			SET @o_ErrorMsg = 'Empty project Id list'
			GOTO exitLine
		END
	IF OBJECT_ID('tempdb.dbo.#InputProjectId') IS NOT NULL
		DROP TABLE #InputProjectId
	CREATE TABLE #InputProjectId (projectId INT)
	INSERT INTO #InputProjectId (projectId)
		SELECT a._ID FROM dbo.SplitIDs(@i_ProjectIdsList) a
	IF ((SELECT COUNT(*) FROM #InputProjectId) = 0)
		BEGIN
			SET @o_ErrorCode = 1
			SET @o_ErrorMsg = 'Invalid project Id list'
			GOTO exitLine
		END
	-- get list of all clients which user has permission to view/edit
	IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
		DROP TABLE #getIdaObjects
	CREATE TABLE #getIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
EXEC sec_getIdaObjectsForUser @i_UserId,3,0,1,'#getIdaObjects'
	-- filter list of projects which user has permission to
	DELETE FROM #InputProjectId
	WHERE projectId NOT IN (SELECT clientId FROM #getIdaObjects)
	-- check if user has permission on those provided projects
	-- if yes, start getting datasources
	-- if no, assign appropriate error and return
	--
	IF (EXISTS(SELECT projectId FROM #InputProjectId))
		BEGIN
			-- there are valid projects, start getting datasources
			--
			SELECT componentNameId AS ProjectId, attrVal AS DatasourceId
			FROM APP_ClientProp A WITH (NOLOCK)
				INNER JOIN #InputProjectId I ON A.componentNameId = I.projectId
WHERE attrName = 'Datasource Id' and modified = 0
		END
	ELSE
		BEGIN
			SET @o_ErrorCode = 2
			SET @o_ErrorMsg = 'User does not have permission to view those projects'
			GOTO exitLine
		END
	--	Clean up and exit
exitLine:
	IF OBJECT_ID('tempdb.dbo.#InputProjectId') IS NOT NULL
		DROP TABLE #InputProjectId
	IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
		DROP TABLE #getIdaObjects
END
GO

IF EXISTS (select * from GxQscripts where name = 'SEAGetEDiscoveryProjectsDataSource')
	delete from GxQscripts where name = 'SEAGetEDiscoveryProjectsDataSource'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEAGetEDiscoveryProjectsDataSource')
	delete from GXDBVersions where aliasname = 'SEAGetEDiscoveryProjectsDataSource'
GO

insert into GXDBVersions values(2, 'SEAGetEDiscoveryProjectsDataSource',  '00000000000000000000', 'SEAGetEDiscoveryProjectsDataSource', '00000000000000000000')
GO

