

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEAGetEDiscoveryGDPRSummary.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--		  Given a list of Project Ids, this SP will return list of datasources, associated entities of those projects
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SEAGetEDiscoveryGDPRSummary')
BEGIN
	print '>>> Drop Stored Procedure: SEAGetEDiscoveryGDPRSummary <<<'
	drop procedure SEAGetEDiscoveryGDPRSummary
END
IF EXISTS (select * from GxQscripts where name='SEAGetEDiscoveryGDPRSummary')
	delete from GxQscripts where name = 'SEAGetEDiscoveryGDPRSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEAGetEDiscoveryGDPRSummary')
	delete from GXDBVersions where aliasname = 'SEAGetEDiscoveryGDPRSummary'
GO
print '... Creating Procedure: SEAGetEDiscoveryGDPRSummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SEAGetEDiscoveryGDPRSummary
  @i_inputXML XML
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	IF OBJECT_ID('tempdb.dbo.#tempGDPRProjects') IS NOT NULL    DROP TABLE #tempGDPRProjects
	CREATE TABLE #tempGDPRProjects (
		clientId INT
	)
	IF OBJECT_ID('tempdb.dbo.#tempProjectDetails') IS NOT NULL     DROP TABLE #tempProjectDetails
	CREATE TABLE #tempProjectDetails (
		gdprDetailsXML XML
	)
	--Get applicable clients XML  from existing common SP
	INSERT INTO #tempProjectDetails ( gdprDetailsXML )
	EXEC AppGetEDiscoveryClientProperties @i_inputXML
	DECLARE @xmlText XML = (SELECT TOP 1 gdprDetailsXML FROM #tempProjectDetails)
	--Retrive all clientId from XML
	INSERT INTO #tempGDPRProjects
	SELECT  ref.value('@clientId', 'int')
    FROM    @xmlText.nodes('App_GetEDiscoveryClientPropertiesResponse/eDiscoveryClientProp/eDiscoveryClient') R ( ref )
	--Get DataSource details
	IF OBJECT_ID('tempdb.dbo.#tempgGlobalDSInfos') IS NOT NULL DROP TABLE #tempgGlobalDSInfos
	CREATE TABLE #tempgGlobalDSInfos      (
			DatasourceId int,
			DatasourceName NVARCHAR(1024),
			TotalCount BIGINT,
			LastSyncTime BIGINT,
			LastModified BIGINT,
			IndexDirectorySizeInBytes BIGINT,
			FSSizeAnalyzedSourceCount BIGINT,
			UsersCount INT,
			DataSourceType VARCHAR(100),
			AppName VARCHAR(20),
			EntitiesCount BIGINT,
			FilesCount BIGINT
		);
	--retrieve all datasources
	INSERT INTO #tempgGlobalDSInfos(DatasourceId, DatasourceName, DataSourceType, AppName)
	SELECT SE.DataSourceId, SE.DataSourceName, UPPER(DST.TypeDisplayName), 'DataCube'
	FROM #tempGDPRProjects P
	JOIN APP_ClientProp CP ON P.clientId = CP.componentNameId
	join SEDataSource SE on cast (cp.attrVal as int) = se.DataSourceId
	JOIN SEDataSourceType AS DST ON SE.DataSourceType = DST.TypeId --AND SE.Attribute & 4 != 4
	WHERE CP.attrName = 'Datasource Id' and cp.modified =0
--fetch the total docs, index directory size,
;WITH CTE(datasourceId,statusInfo) as
(
				SELECT T.datasourceId, CONVERT(XML,T.PropertyValue)
				FROM SEDataSourceProperty as T
								INNER JOIN SEProperty  AS P ON T.PropertyId = P.PropertyId AND P.PropertyName = 'statusinfo'
				WHERE T.PropertyValue is not null AND T.PropertyValue != ''
)
UPDATE tGDS SET
TotalCount = ISNULL(m.c.value('@TotalDocs','BIGINT'),0),
LastModified = ISNULL(m.c.value('@LastModified','BIGINT'),0)/1000,
IndexDirectorySizeInBytes = ISNULL(m.c.value('@TotalSizeInBytes','BIGINT'),0),
FSSizeAnalyzedSourceCount = ISNULL(m.c.value('(TypeStatusInfo/FileInfo/@SizeAnalyzed)[1]','BIGINT'),0),
EntitiesCount = ISNULL(m.c.value('(TypeStatusInfo/@EntitiesCount)[1]','BIGINT'),0),
FilesCount = ISNULL(m.c.value('(TypeStatusInfo/FileInfo/@FilesCount)[1]','BIGINT'),0),
UsersCount = ISNULL(m.c.value('(TypeStatusInfo/FileInfo/@UsersCount)[1]','INT'),0),
LastSyncTime = ISNULL(m.c.value('@LastSyncTime','BIGINT'),0)
FROM #tempgGlobalDSInfos tGDS INNER JOIN  CTE ON CTE.datasourceId = tGDS.DatasourceId outer apply CTE.statusInfo.nodes('/StatusInfo') as m(c)
--if FilesCount > 0 then use filecount otherwise use totalCount
UPDATE tGDS
SET  tGDS.TotalCount = tGDS.FilesCount
FROM #tempgGlobalDSInfos tGDS
WHere tGDS.FilesCount > 0
--update gdpr flag by property
UPDATE tGDS SET
				AppName = 'GDPR'
FROM #tempgGlobalDSInfos AS tGDS
				INNER JOIN  SEDataSourceProperty DSP ON tGDS .DatasourceId = DSP.DataSourceId
				INNER JOIN SEProperty SP
								ON SP.PropertyGuid = '4526224E-BB52-4870-84D1-21D12FDC41AB' /*appname*/ AND
								DSP.PropertyId = SP.PropertyId AND DSP.PropertyValue = 'GDPR'
--update gdpr flag by property
UPDATE tGDS SET
AppName = 'GDPR'
FROM #tempgGlobalDSInfos AS tGDS
				INNER JOIN  SEDataSourceProperty DSP  ON tGDS .DatasourceId = DSP.DataSourceId
				INNER JOIN SEProperty SP
								ON SP.PropertyGuid = 'd215e7ec-014c-4e98-a22d-9c1f384abeda' /*ediscoveryproperty*/ AND
								DSP.PropertyId = SP.PropertyId AND DSP.PropertyValue IS NOT NULL
--GDPR by name
UPDATE tGDS SET
AppName = 'GDPR'
FROM #tempgGlobalDSInfos AS tGDS
WHERE datasourcename like 'eDiscovery%_%' COLLATE SQL_Latin1_General_CP1_CS_AS AND tGDS.AppName = 'DataCube'
--GDPR by client prop
UPDATE tGDS SET
AppName = 'GDPR'
FROM #tempgGlobalDSInfos as tGDS INNER JOIN
				App_ClientProp AC ON AC.attrVal = tGDS.DatasourceId
where AC.attrName = 'Federated Datasource Id' and AC.modified = 0
UPDATE #tempgGlobalDSInfos  SET
AppName = 'GDPR'
WHERE DatasourceName = 'EDiscoveryGlobal_federated'
--set File archiving source
UPDATE tGDS SET
AppName = 'File Archiving'
FROM #tempgGlobalDSInfos AS tGDS
				INNER JOIN APP_ClientProp cp ON CP.attrVal = tGDS.DatasourceId AND cp.attrname ='indexing datasource id'
				WHERE tGDS.AppName = 'DataCube'
	DECLARE @TotalGDPRProjects INT = 0
	DECLARE @TotalGDPRDocs BIGINT = 0
	DECLARE @FSSizeAnalyzedGDPR BIGINT = 0
	DECLARE @LastSyncTime BIGINT = 0
	DECLARE @TotalEntitiesCount BIGINT = 0
	--Get GDPR details
	SELECT @TotalGDPRProjects = ISNULL(COUNT(DISTINCT clientId), 0) FROM #tempGDPRProjects
	SELECT @TotalGDPRDocs = ISNULL(SUM(TotalCount), 0),
		   @FSSizeAnalyzedGDPR= ISNULL(SUM(FSSizeAnalyzedSourceCount),0),
		   @LastSyncTime = ISNULL(MAX(LastSyncTime), 0),
		   @TotalEntitiesCount = ISNULL(SUM(EntitiesCount), 0) FROM #tempgGlobalDSInfos WHERE AppName = 'GDPR'
	--output
	SELECT 	@TotalGDPRProjects as 'TotalGDPRProjects',	@TotalGDPRDocs as 'TotalGDPRDocs',	@FSSizeAnalyzedGDPR as 'FSSizeAnalyzedGDPR', @LastSyncTime as 'LastSyncTime', @TotalEntitiesCount as 'TotalEntitiesCount'
	IF OBJECT_ID('tempdb.dbo.#tempgGlobalDSInfos') IS NOT NULL 		DROP TABLE #tempgGlobalDSInfos
	IF OBJECT_ID('tempdb.dbo.#tempDsProjectDetails') IS NOT NULL     DROP TABLE #tempDsProjectDetails
END
GO

IF EXISTS (select * from GxQscripts where name = 'SEAGetEDiscoveryGDPRSummary')
	delete from GxQscripts where name = 'SEAGetEDiscoveryGDPRSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEAGetEDiscoveryGDPRSummary')
	delete from GXDBVersions where aliasname = 'SEAGetEDiscoveryGDPRSummary'
GO

insert into GXDBVersions values(2, 'SEAGetEDiscoveryGDPRSummary',  '00000000000000000000', 'SEAGetEDiscoveryGDPRSummary', '00000000000000000000')
GO

