

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEAGetEDiscoveryDatasourceJobOptions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--		  Given a list generic entities, this stored procedure returns list of corresponding job options values to form CreateTaskReqs for each datasource within a project
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SEAGetEDiscoveryDatasourceJobOptions')
BEGIN
	print '>>> Drop Stored Procedure: SEAGetEDiscoveryDatasourceJobOptions <<<'
	drop procedure SEAGetEDiscoveryDatasourceJobOptions
END
IF EXISTS (select * from GxQscripts where name='SEAGetEDiscoveryDatasourceJobOptions')
	delete from GxQscripts where name = 'SEAGetEDiscoveryDatasourceJobOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEAGetEDiscoveryDatasourceJobOptions')
	delete from GXDBVersions where aliasname = 'SEAGetEDiscoveryDatasourceJobOptions'
GO
print '... Creating Procedure: SEAGetEDiscoveryDatasourceJobOptions'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SEAGetEDiscoveryDatasourceJobOptions
  @i_EntityId INT,
  @i_EntityType INT,
  @i_DatasourceId INT,
  @i_ClientId INT,
  @o_ErrorCode INT OUTPUT,
  @o_ErrorMsg VARCHAR(MAX) OUTPUT,
  @o_IsInventory INT OUTPUT
AS
SET NOCOUNT ON
BEGIN
	-- crawl type
	DECLARE @LIVE_CRAWL INT = 1
	DECLARE @BACKEDUP_CRAWL INT = 2
	DECLARE @IMPORT_INDEX_CRAWL INT = 3
	DECLARE @FILE_ANALYTICS INT = 4
	DECLARE @BACKEDUPV2_CRAWL INT = 5
	-- cloud type
	DECLARE @ANALYTICS_ENGINE_CLOUD_TYPE INT = 1
	-- datasource type
	DECLARE @EXCHANGE VARCHAR(10) = 'exchange'
	DECLARE @EMAIL VARCHAR(10) = 'email'
	DECLARE @GMAIL	VARCHAR(10) = 'gmail'
	DECLARE @FILEDS	VARCHAR(10) = 'file'
	DECLARE @SHAREPOINT	VARCHAR(15) = 'sharepoint'
	DECLARE @ONEDRIVE	VARCHAR(10) = 'onedrive'
	--datasource property's name
	DECLARE @CRAWL_TYPE				VARCHAR(50) = 'crawltype'
	DECLARE @DO_INCREMENTAL_SCAN	VARCHAR(50) = 'doincrementalscan'
	DECLARE @ADDITIONAL_INFO		VARCHAR(50) = 'additionalinfo'
	DECLARE @LITERAL_PROPERTY		VARCHAR(50) = 'literalproperties'
	DECLARE @CLIENTGROUPID_PROPERTY	VARCHAR(50) = 'clientgroupid'
	DECLARE @ACCESSNODE_CLIENTID	VARCHAR(50) = 'accessnodeclientid'
	SET @o_ErrorCode = 0
	SET @o_ErrorMsg = ''
	SET @o_IsInventory = 0
	-- check input's validity
	IF (@i_EntityId <= 0 OR @i_EntityType <= 0 OR @i_DatasourceId <= 0)
		BEGIN
			SET @o_ErrorCode = 1
			SET @o_ErrorMsg = 'Invalid Input'
			GOTO exitLine
		END
	BEGIN TRY
	-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	-- Get CrawlType and DatasourceType to help form CreateTaskReq
	--
	DECLARE @crawl INT = 0
	DECLARE @dsType VARCHAR(256)
	DECLARE @doIncrementalCrawl INT = 0
	DECLARE @operationType BIGINT = 0
	DECLARE @ownerId	INT = 0
	DECLARE @PropsTable TABLE
	(
		PropertyName	VARCHAR(256),
		PropertyValue	VARCHAR(MAX)
	)
	-- Get datasource type, index server client's id for further use to return appropriate job options
	--
	SELECT  @dsType = ST.TypeName, @ownerId = S.OwnerUserID
	FROM SEDataSource AS S WITH(NOLOCK)
		JOIN SEDataSourceType AS ST WITH(NOLOCK)
			ON S.DataSourceType = ST.TypeId
	WHERE S.DataSourceId = @i_DatasourceId
	-- check if it is from an inventory
	--
	IF (@dsType = 'blank')
	BEGIN
		SET @o_IsInventory = 1 -- from inventory, not from project
		SET @i_ClientId = 2 -- run inventory crawl on commserver. This is mandatory until we have access node support to run CVODS process
	END
	-------------------------------------------------------------------------------------
	-- Insert job options
	-------------------------------------------------------------------------------------
	-- get index server information
	DECLARE @dsIndexServerClientId INT
	DECLARE @dsCloudId 	INT
	DECLARE @coreName 	NVARCHAR(256)
	DECLARE @importUrl	NVARCHAR(1024)
	DECLARE @literalproperties	NVARCHAR(MAX)
	DECLARE @urlParamsTemplate 	NVARCHAR(MAX)
	DECLARE @query				NVARCHAR(MAX)
	DECLARE @remoteSolr NVARCHAR(MAX) = ''
    DECLARE @clientGroupID INT = 0
	SELECT DISTINCT @dsCloudId = CI.CloudID, @coreName = CI.ActualCoreName
	FROM SEDataSource AS DS WITH (NOLOCK)
	INNER JOIN SECollectionInfo AS CI WITH (NOLOCK)
	ON DS.coreId = CI.coreId
	WHERE DS.DataSourceId = @i_DatasourceId
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL
		DROP TABLE #getIndexServers
	CREATE TABLE #getIndexServers
	(
			serverURL NVARCHAR(512),
			clientId INT,
			clientName NVARCHAR(256),
			cloudId INT,
			hostName NVARCHAR(256),
			basePort INT,
			engineName  NVARCHAR(256),
			serverType INT,
			indexServerClientId INT,
			internalCloudName NVARCHAR(256)
	)
	EXEC DM2GetIndexServers @i_cloudId= @dsCloudId
	-- get index server clientId
	SET @dsIndexServerClientId = ISNULL((SELECT TOP 1 indexServerClientId FROM #getIndexServers),0)
	--table to store job option returned
	--	OptionId: Id which represents option section -- https:--cvs.commvault.com/source/xref/11.0-win/vaultcx/Source/Include/Shared/TaskMgr/TaskOptionDefsRef.h#8543
	--	OptionType: Type of the value of each option -- https:--cvs.commvault.com/source/xref/11.0-win/vaultcx/Source/Include/Shared/TaskMgr/TaskOptionDefsRef.h#51
	--	OptionValue: value to fill in the corresponding job option
	--	AnalyticObject: value indicate whether it is project/inventory: project -> 1, inventory -> 2
	IF OBJECT_ID('tempdb.dbo.#EJobOptionsTable') IS NOT NULL
			DROP TABLE #EJobOptionsTable
		CREATE TABLE #EJobOptionsTable
		(
			OptionId BIGINT,
			OptionType INT,
			OptionValue VARCHAR(MAX)
		)
	-- clients' value
	DECLARE @clients VARCHAR(100)
	SET @clients = '<clients clientId="' + CAST (@i_ClientId AS VARCHAR(10)) + '" />'
	-- job option ids are retrieved from TaskOptionDefs.h. That is the file which is generated on runtime
	-- If this is for project
	IF 	@o_IsInventory = 0
	BEGIN
		-- get crawltype and incremental's property
		--
		INSERT INTO @PropsTable(PropertyName, PropertyValue)
		SELECT P.PropertyName, DSP.PropertyValue
		FROM SEDataSource AS S WITH(NOLOCK)
			JOIN SEDataSourceProperty AS DSP WITH (NOLOCK)
				ON S.DataSourceId = DSP.DataSourceId
			JOIN SEProperty AS P WITH (NOLOCK)
					ON P.PropertyId = DSP.PropertyId AND P.PropertyName IN (@CRAWL_TYPE, @DO_INCREMENTAL_SCAN, @ADDITIONAL_INFO, @LITERAL_PROPERTY, @CLIENTGROUPID_PROPERTY, @ACCESSNODE_CLIENTID)
		WHERE S.DataSourceId = @i_DatasourceId
		SELECT @crawl = CAST (PropertyValue AS INT)
		FROM @PropsTable
		WHERE PropertyName = @CRAWL_TYPE
        IF EXISTS (SELECT 1 FROM @PropsTable
		WHERE PropertyName = @CLIENTGROUPID_PROPERTY)
        BEGIN
		    SELECT @clientGroupID = CAST (PropertyValue AS INT)
		    FROM @PropsTable
		    WHERE PropertyName = @CLIENTGROUPID_PROPERTY
        END
    	-- reanalyze
		SELECT @doIncrementalCrawl =
				(CASE
					WHEN PropertyValue = 'False' THEN 0
					ELSE 1
				END)
		FROM @PropsTable
		WHERE PropertyName = @DO_INCREMENTAL_SCAN
		DECLARE @reanalyze VARCHAR(10) = '0'
		IF (@doIncrementalCrawl = 0)
			SET @reanalyze = '1'
		-- live crawl
		IF (@crawl = @LIVE_CRAWL)
		BEGIN
SET @operationType = 4022 -- TASK_OPERATION_TYPE_OFFLINE_CONTENT_INDEX
				IF (@dsType = @ONEDRIVE OR @dsType = @SHAREPOINT)
			BEGIN
				-- adminOpts
				INSERT INTO #EJobOptionsTable(OptionId, OptionType, OptionValue)
				VALUES
(1810277523, 					1, @clients) 	--CONTENTINDEXINGOPTION_CLIENTS), TM_OPTION_TYPE_STRING)
,	(300510029, 	2, '1')		--CONTENTINDEXINGOPTION_SUB_CLIENT_BASED_ANALYTICS), TM_OPTION_TYPE_BOOLEAN)
,	(747575566, 					2, @reanalyze) --CONTENTINDEXINGOPTION_REANALYZE), TM_OPTION_TYPE_BOOLEAN)
			END
			ELSE IF (@dsType = 'dbanalysis')
			BEGIN
				-- adminOpts
				INSERT INTO #EJobOptionsTable(OptionId, OptionType, OptionValue)
				VALUES
(136250708, 			2, '1') 		--CONTENTINDEXINGOPTION_ONLINE_CRAWL_JOB), TM_OPTION_TYPE_BOOLEAN)
,	(747575566, 					2, @reanalyze) --CONTENTINDEXINGOPTION_REANALYZE), TM_OPTION_TYPE_BOOLEAN)
,	(300510029, 	2, '1') 		--CONTENTINDEXINGOPTION_SUB_CLIENT_BASED_ANALYTICS), TM_OPTION_TYPE_BOOLEAN)
,	(1153534787, 				2, '1') 		--CONTENTINDEXINGOPTION_DB_ANALYTICS), TM_OPTION_TYPE_BOOLEAN)
,	(1810277523, 					1, @clients) 	--CONTENTINDEXINGOPTION_CLIENTS), TM_OPTION_TYPE_STRING)
,	(742723196, 					7, '0') 		--ANALYTICSREQUESTOPTION_OP_TYPE), TM_OPTION_TYPE_INTEGER)
,	(1006933952, 		7, CAST (@i_EntityId AS VARCHAR(10))) --ANALYTICSDBOPTIONS_SUBCLIENT_SUBCLIENT_ID), TM_OPTION_TYPE_INTEGER)
			END
				ELSE IF (@dsType = @FILEDS OR @dsType = 'cloudstorage')
			BEGIN
				-- adminOpts
				INSERT INTO #EJobOptionsTable(OptionId, OptionType, OptionValue)
				VALUES
(136250708, 			2, '1') 		--CONTENTINDEXINGOPTION_ONLINE_CRAWL_JOB),			TM_OPTION_TYPE_BOOLEAN)
,	(747575566, 					2, @reanalyze) --CONTENTINDEXINGOPTION_REANALYZE), 					TM_OPTION_TYPE_BOOLEAN)
,	(300510029, 	2, '1')		--CONTENTINDEXINGOPTION_SUB_CLIENT_BASED_ANALYTICS), 	TM_OPTION_TYPE_BOOLEAN)
,	(1810277523, 					1, @clients)	--CONTENTINDEXINGOPTION_CLIENTS), 					TM_OPTION_TYPE_STRING)
			END
				-- insert subclientId of the association
				INSERT INTO #EJobOptionsTable(OptionId, OptionType, OptionValue)
				VALUES
				-- association
(140007, 					7, @i_EntityId) --COM_SUBCLIENT_ID), 					TM_OPTION_TYPE_INTEGER)
		END
		-- backedup crawl
		ELSE IF (@crawl = @BACKEDUP_CRAWL)
		BEGIN
			-- in case of exchange/email, subclient based should be used
			IF (@dsType = @EXCHANGE OR @dsType = @EMAIL)
			BEGIN
SET @operationType = 5020 -- TASK_OPERATION_TYPE_CONTENT_INDEX_FROM_SUBCLIENT
				-- get mailbox info
				DECLARE @mailbox VARCHAR(MAX)
				SELECT @mailbox = PropertyValue
				FROM @PropsTable
				WHERE PropertyName = @ADDITIONAL_INFO
				IF (ISNULL(@mailbox,'') != '')
				BEGIN -- if there are mailboxes selected, then pass that to C# layer as json. C# layer will take care of parsing this json to get mailboxes's info as IdaMsg.UserMailBoxInfo
						DECLARE @ConvertedMailboxString VARCHAR(MAX) = REPLACE(@Mailbox,'},{','};{')
					INSERT INTO #EJobOptionsTable(OptionId, OptionType, OptionValue)
					VALUES
							-- remove [,] before sending to be parsed
(354465909, 1, SUBSTRING(@ConvertedMailboxString, 2, LEN(@ConvertedMailboxString)-2))	--EXCHONEPASSOPTIONS_MAIL_BOXES), TM_OPTION_TYPE_STRING)
				END
				-- get backupSetId, instanceId, apptypeId
				DECLARE @BackupSetId INT
				DECLARE @InstanceId INT
				DECLARE @AppTypeId INT
				SELECT @BackupSetId = backupSet, @InstanceId = instance, @AppTypeId = appTypeId
				FROM APP_Application WITH(NOLOCK)
				WHERE id = @i_EntityId
				-- adminOpts
				INSERT INTO #EJobOptionsTable(OptionId, OptionType, OptionValue)
				VALUES
(300510029, 	2, '0') --	CONTENTINDEXINGOPTION_SUB_CLIENT_BASED_ANALYTICS), 	TM_OPTION_TYPE_BOOLEAN)
,	(747575566, 					2, @reanalyze) --CONTENTINDEXINGOPTION_REANALYZE), 					TM_OPTION_TYPE_BOOLEAN)
,	(140004, 									7, @AppTypeId) --COM_APPTYPE_ID), 	TM_OPTION_TYPE_INTEGER)
,	(140005, 									7, @InstanceId) --COM_INSTANCE_ID), 	TM_OPTION_TYPE_INTEGER)
,	(140006, 									7, @BackupSetId) --COM_BACKUPSET_ID), 	TM_OPTION_TYPE_INTEGER)
					-- insert subclientId of the association
					INSERT INTO #EJobOptionsTable(OptionId, OptionType, OptionValue)
					VALUES
					-- association
(140007, 					7, @i_EntityId) --COM_SUBCLIENT_ID), 					TM_OPTION_TYPE_INTEGER)
			END
			ELSE -- remaining will be processed with storage policy
			BEGIN
SET @operationType = 4022 -- TASK_OPERATION_TYPE_OFFLINE_CONTENT_INDEX
				-- adminOpts
				INSERT INTO #EJobOptionsTable(OptionId, OptionType, OptionValue)
				VALUES
				-- backupOpts
(1810277523, 					1, @clients) --CONTENTINDEXINGOPTION_CLIENTS), 					TM_OPTION_TYPE_STRING)
,	(300510029, 	2, '0') --	CONTENTINDEXINGOPTION_SUB_CLIENT_BASED_ANALYTICS), 	TM_OPTION_TYPE_BOOLEAN)
,	(747575566, 					2, @reanalyze) --CONTENTINDEXINGOPTION_REANALYZE), 					TM_OPTION_TYPE_BOOLEAN)
					-- association
,	(140008, 					7, CAST (@i_EntityId AS VARCHAR(10))) --COM_POLICY_ID, 					TM_OPTION_TYPE_INTEGER
			END
		END
		-- import index crawl
		ELSE IF (@crawl = @IMPORT_INDEX_CRAWL)
		BEGIN
			-- always running importing index on Commserver
			SET @clients = '<clients clientId="2" />'
			-- import job has operation type as
SET @operationType = 4022 -- TASK_OPERATION_TYPE_OFFLINE_CONTENT_INDEX
			SELECT @importUrl = serverURL + '/solr/rest/' + @coreName + '/import'
			FROM #getIndexServers
			-- insert basic job options for importing index
			INSERT INTO #EJobOptionsTable(OptionId, OptionType, OptionValue)
			VALUES
(136250708, 			2, '1') 		--CONTENTINDEXINGOPTION_ONLINE_CRAWL_JOB), TM_OPTION_TYPE_BOOLEAN)
,	(756574890, 					7, '1') 		--CONTENTINDEXINGOPTION_CRAWL_TYPE), TM_OPTION_TYPE_INTEGER -- SolrImport)
,	(1810277523, 					1, @clients) 	--CONTENTINDEXINGOPTION_CLIENTS), TM_OPTION_TYPE_STRING)
,	(742723196, 					7, '1') 		--ANALYTICSREQUESTOPTION_OP_TYPE), TM_OPTION_TYPE_INTEGER)
,	(1344911810, 					1, @importUrl) 		--ANALYTICSSOLRIMPORTOPTION_URL), TM_OPTION_TYPE_STRING)
,	(1878303522, 				1, '<urlParams name="solr.fm.ds" value="' + CAST(@i_DatasourceId AS VARCHAR(10)) + '" />') 		--ANALYTICSSOLRIMPORTREQ_URL_PARAMS), TM_OPTION_TYPE_STRING)
			-- insert literalproperties job options if available
			SELECT @literalproperties = PropertyValue
			FROM @PropsTable
			WHERE PropertyName = @LITERAL_PROPERTY
			-- if literalproperties is available, need to add cvliteral and exclude fields in the urlParams
			IF (ISNULL(@literalproperties, '') != '')
			BEGIN
				-- form literalproperties
				DECLARE @LiteralPropTempTable TABLE
				(
					LitName		NVARCHAR(256),
					LitValue	NVARCHAR(MAX)
				)
				DECLARE @convertedXML XML = CAST(@literalproperties AS XML)
				INSERT INTO @LiteralPropTempTable
				SELECT c.value('@name','nvarchar(256)'), c.value('@value','nvarchar(MAX)')
				FROM   @convertedXML.nodes('DM2ContentIndexing_NameValueMaps/nameValues') T(c)
				-- if there is entries (able to parse the literalproperties, then insert into job option)
				IF (EXISTS(SELECT TOP 1 1 FROM @LiteralPropTempTable))
				BEGIN
					-- insert literalproperties urlParams
					INSERT INTO #EJobOptionsTable(OptionId, OptionType, OptionValue)
SELECT 1878303522,	1, '<urlParams name="cvliteral.' + LitName + '" value="' + LitValue + '" />' --	ANALYTICSSOLRIMPORTREQ_URL_PARAMS, TM_OPTION_TYPE_STRING)
					FROM @LiteralPropTempTable
					-- insert exclude fields urlParams
					DECLARE @excludeFields NVARCHAR(MAX) = ''
					SELECT @excludeFields = @excludeFields + LitName + ','
					FROM @LiteralPropTempTable
					INSERT INTO #EJobOptionsTable(OptionId, OptionType, OptionValue)
					VALUES
(1878303522,	1, '<urlParams name="excludeFields" value="' + SUBSTRING(@excludeFields, 1, LEN(@excludeFields)-1) + '" />') --	ANALYTICSSOLRIMPORTREQ_URL_PARAMS, TM_OPTION_TYPE_STRING)
,	(1878303522,	1, '<urlParams name="cvliteral" value="true" />') --	ANALYTICSSOLRIMPORTREQ_URL_PARAMS, TM_OPTION_TYPE_STRING)
				END
			END
			IF (@dsType = @EXCHANGE OR @dsType = @EMAIL)
			BEGIN
				-- default option for email
				INSERT INTO #EJobOptionsTable(OptionId, OptionType, OptionValue)
					VALUES
(1878303522,	1, '<urlParams name="remotesolr.exclude" value="false" />') --	ANALYTICSSOLRIMPORTREQ_URL_PARAMS, TM_OPTION_TYPE_STRING)
,	(1878303522,	1, '<urlParams name="remotesolr.defType" value="edismax" />') --	ANALYTICSSOLRIMPORTREQ_URL_PARAMS, TM_OPTION_TYPE_STRING)
,	(1878303522,	1, '<urlParams name="extractZippedFieldsDocs" value="false" />') --	ANALYTICSSOLRIMPORTREQ_URL_PARAMS, TM_OPTION_TYPE_STRING)
,	(1878303522,	1, '<urlParams name="useBinDoc" value="false" />') --	ANALYTICSSOLRIMPORTREQ_URL_PARAMS, TM_OPTION_TYPE_STRING)
,	(1878303522,	1, '<urlParams name="solr.transformfieldoption.fieldsmapoverride" value="body:content" />') --	ANALYTICSSOLRIMPORTREQ_URL_PARAMS, TM_OPTION_TYPE_STRING)
,	(1878303522,	1, '<urlParams name="solr.transformfieldoption.skipallmergefields" value="true" />') --	ANALYTICSSOLRIMPORTREQ_URL_PARAMS, TM_OPTION_TYPE_STRING)
				-- form remote URL
				DECLARE @ExchangeSearchServers TABLE
				(
					ciServerXML XML
				)
				DECLARE @ServerType TABLE
				(
					serverType INT,
					isMultiNode INT,
					ciURL NVARCHAR(MAX)
				)
				INSERT INTO @ExchangeSearchServers
				EXEC AppGetAnalyticsServerByRole @i_EntityId,'Exchange','edge'
				DECLARE @ciServerXML XML
				SET @ciServerXML = (SELECT TOP 1 ciServerXML FROM @ExchangeSearchServers)
				IF (@ciServerXML IS NOT NULL)
				BEGIN
					INSERT INTO @ServerType
					SELECT  ISNULL(c.value('@serverType','INT'), 0), ISNULL(c.value('@isMultiNodeDataSource','INT'), 0), c.value('@cIServerURL','nvarchar(MAX)')
					FROM   @ciServerXML.nodes('DM2ContentIndexing_CIServers/listOfCIServer') T(c)
				END
				-- this is to check whether this is cloud mode or cvsolr
				-- so that appropriate fields are being used to filter exchange ci jobid and application id
				DECLARE @cijidField NVARCHAR(50) = 'cijid'
				DECLARE @apid NVARCHAR(50) = 'apid'
				IF (EXISTS(SELECT 1 FROM @ServerType WHERE serverType IN (4,5) OR isMultiNode = 1)) --https:--cvs.commvault.com/source/xref/11.0-SP17-win/vaultcx/Source/Common/XmlMessage/App.x#21090 4,5 is solrcloud
				BEGIN
					SET @cijidField = 'CIJobId'
					SET @apid = 'ApplicationId'
				END
				-- form query. Sample: <urlParams name="q" value="((cijid:*) AND (apid:8266))" />
				SET @query = '<urlParams name="q" value="((' + @cijidField + ':*) AND ('+ @apid +':' + CAST(@i_EntityId AS NVARCHAR(10)) + '))" />'
				-- form remote url: sample: http:--ExchSearchEngine.Testexch.commvault.com:20000/solr/usermbx0,http:--ExchSearchEngine.Testexch.commvault.com:20000/solr/usermbx1,http:--ExchSearchEngine.Testexch.commvault.com:20000/solr/usermbx2,http:--ExchSearchEngine.Testexch.commvault.com:20000/solr/usermbx3,http:--ExchSearchEngine.Testexch.commvault.com:20000/solr/usermbx4,http:--ExchSearchEngine.Testexch.commvault.com:20000/solr/usermbx5,http:--ExchSearchEngine.Testexch.commvault.com:20000/solr/usermbx6,http:--ExchSearchEngine.Testexch.commvault.com:20000/solr/usermbx7,
				-- fix for MR 276047: The source is solr cloud server, we are querying the same collection for the same data
				-- but from two different nodes and hence duplicate documents are returned, which results in the variations in the numbers.
				-- When the source is in cloud mode we just need to get the data from the collection of the leader node.
				-- Here we pick the first in the list as leader node
				--
				IF (EXISTS(SELECT 1 FROM @ServerType WHERE serverType IN (4,5)))
				BEGIN
					SET @remoteSolr = (SELECT TOP 1 ciURL FROM @ServerType) + ','
				END
				ELSE
				BEGIN
					SELECT @remoteSolr = @remoteSolr + ciURL + ','
				FROM @ServerType
				END
			END
			ELSE
			BEGIN
				DECLARE @appType INT = CASE
WHEN @dsType = @FILEDS	THEN	33
WHEN @dsType = @SHAREPOINT THEN 78
WHEN @dsType = @ONEDRIVE OR @dsType = 'googledrive' OR @dsType = @GMAIL THEN 134
											ELSE 0
										END
				SET @query = '<urlParams name="q" value="((clid:' + CAST(@i_ClientId AS NVARCHAR(10)) + ') AND (atyp:' + CAST(@appType AS NVARCHAR(10)) + '))" />'
				IF (@dsType = @GMAIL)
				BEGIN
					-- default option for gmail
					INSERT INTO #EJobOptionsTable(OptionId, OptionType, OptionValue)
						VALUES
(1878303522,	1, '<urlParams name="solr.transformfieldoption.fieldsmapoverride" value="body:content" />') --	ANALYTICSSOLRIMPORTREQ_URL_PARAMS, TM_OPTION_TYPE_STRING)
,	(1878303522,	1, '<urlParams name="solr.transformfieldoption.skipallmergefields" value="true" />') --	ANALYTICSSOLRIMPORTREQ_URL_PARAMS, TM_OPTION_TYPE_STRING)
				END
				-- default option for remaining
				INSERT INTO #EJobOptionsTable(OptionId, OptionType, OptionValue)
					VALUES
(1878303522,	1, '<urlParams name="extractZippedFieldsDocs" value="true" />') --	ANALYTICSSOLRIMPORTREQ_URL_PARAMS, TM_OPTION_TYPE_STRING)
,	(1878303522,	1, '<urlParams name="useBinDoc" value="true" />') --	ANALYTICSSOLRIMPORTREQ_URL_PARAMS, TM_OPTION_TYPE_STRING)
,	(1878303522,	1, '<urlParams name="nosort" value="true" />') --	ANALYTICSSOLRIMPORTREQ_URL_PARAMS, TM_OPTION_TYPE_STRING)
				-- form remote solr url (source from which index is imported)
				-- get cloudId from client Id
				IF OBJECT_ID('tempdb.dbo.#SearchServers') IS NOT NULL
					DROP TABLE #SearchServers
				CREATE TABLE #SearchServers
				(
					serverName NVARCHAR(MAX),
					clientId INT,
					clientName NVARCHAR(MAX),
					cloudId INT,
					hostName VARCHAR(MAX),
					baseport INT,
					version VARCHAR(MAX),
					engineName VARCHAR(MAX) ,
					serverType INT
				)
				-- get all search servers
				INSERT INTO #SearchServers
				EXEC AppGetFastServerList
				SELECT  @remoteSolr = @remoteSolr +
					CASE
						WHEN ISNULL(serverName, '') != '' THEN serverName + '/solr/collection1'
						ELSE 'http://' + hostName + ':' + CAST (baseport AS NVARCHAR(10)) + '/solr/collection1'
					END + ','
				FROM #SearchServers
				WHERE cloudId IN (	SELECT DISTINCT cloudId
									FROM archContentIndexingRules ACI  WITH(NOLOCK)
										INNER JOIN APP_Application App  WITH(NOLOCK)
										ON App.dataArchGrpID = ACI.archGroupId
									WHERE App.clientId = @i_ClientId
									AND ACI.enabled = 1)
			END
			-- insert main query into url params
			INSERT INTO #EJobOptionsTable(OptionId, OptionType, OptionValue)
					VALUES
(1878303522,	1, @query) --	ANALYTICSSOLRIMPORTREQ_URL_PARAMS, TM_OPTION_TYPE_STRING)
,	(1878303522,	1, '<urlParams name="remoteSolrs" value="' + SUBSTRING(@remoteSolr, 1, LEN(@remoteSolr)-1) +'" />') --	ANALYTICSSOLRIMPORTREQ_URL_PARAMS, TM_OPTION_TYPE_STRING)
		END
		-- File analytics job
		ELSE IF (@crawl = @FILE_ANALYTICS)
		BEGIN
SET @operationType = 4022 -- TASK_OPERATION_TYPE_OFFLINE_CONTENT_INDEX
				-- adminOpts
				INSERT INTO #EJobOptionsTable(OptionId, OptionType, OptionValue)
				VALUES
(300510029, 	2, '1') --	CONTENTINDEXINGOPTION_SUB_CLIENT_BASED_ANALYTICS), 	TM_OPTION_TYPE_BOOLEAN)
,	(1458825153, 					2, '0') --CONTENTINDEXINGOPTION_FILE_ANALYTICS), 					TM_OPTION_TYPE_BOOLEAN)
,	(747575566, 					2, '0') --CONTENTINDEXINGOPTION_REANALYZE), 					TM_OPTION_TYPE_BOOLEAN)
,	(900055445, 					7, '1') --CONTENTINDEXINGOPTION_IDA_TYPE), 					TM_OPTION_TYPE_INTEGER)
                -- insert associations
                IF @i_EntityType = 3 -- EntityType_CLIENT_ENTITY
                BEGIN
				    INSERT INTO #EJobOptionsTable(OptionId, OptionType, OptionValue)
				    VALUES
(1810277523, 					1, @clients) 	--CONTENTINDEXINGOPTION_CLIENTS), TM_OPTION_TYPE_STRING)
,	(140003, 					7,CAST (@i_ClientId AS VARCHAR(10))) --COM_CLIENT_ID), 					TM_OPTION_TYPE_INTEGER)
                END
                ELSE IF @i_EntityType = 28 -- EntityType_CLIENT_GROUP_ENTITY
                BEGIN
				    INSERT INTO #EJobOptionsTable(OptionId, OptionType, OptionValue)
				    VALUES
(1152211801, 					7, CAST (@clientGroupID AS VARCHAR(10))) 	--CLIENTGROUPENTITY_CLIENT_GROUP_ID), TM_OPTION_TYPE_INTEGER)
,	(140002, 					7, CAST (@i_EntityId AS VARCHAR(10))) --COM_CLIENT_GROUP_ID), 					TM_OPTION_TYPE_INTEGER)
                END
		END
		-- File analytics job
		ELSE IF (@crawl = @BACKEDUPV2_CRAWL)
		BEGIN
                DECLARE @accessNodeClients VARCHAR(100) = ''
SET @operationType = 5022 -- TASK_OPERATION_TYPE_CONTENT_INDEX_FROM_POLICY
                IF EXISTS (SELECT 1 FROM @PropsTable
		        WHERE PropertyName = @ACCESSNODE_CLIENTID)
                BEGIN
		            SELECT @accessNodeClients = '<accessNodes clientId="' + CAST (PropertyValue AS VARCHAR(10)) + '" />'
		            FROM @PropsTable
		            WHERE PropertyName = @ACCESSNODE_CLIENTID
                END
				-- adminOpts
				INSERT INTO #EJobOptionsTable(OptionId, OptionType, OptionValue)
				VALUES
				-- backupOpts
(1810277523, 					1, @clients) --CONTENTINDEXINGOPTION_CLIENTS), 					TM_OPTION_TYPE_STRING)
,	(980988950, 					7, '2') --CONTENTINDEXINGOPTION_OPERATION_TYPE), 					TM_OPTION_TYPE_INTEGER)
,   (591022677, 					1, @accessNodeClients) --ANALYTICSDATACRAWLOPTION_ACCESS_NODES), 					TM_OPTION_TYPE_STRING)
		END
	END
	ELSE
	-- this is for Inventory
	-- there are 2 options for Inventory that need to be returned
	-- clientId where the CVODS process (AnalyticsMgrService) run and userId which is used to submit request to webserver
	BEGIN
SET @operationType = 4022 -- TASK_OPERATION_TYPE_OFFLINE_CONTENT_INDEX
		-- userId's value
		DECLARE @userParams VARCHAR(100)
		SET @userParams = '<urlParams name="userid" value="' + CAST (@ownerId AS VARCHAR(10)) + '" />'
		-- get webserver url which is used to submit crawl request
		--
		DECLARE @WebServerTable TABLE
		(
			Hostname VARCHAR(256),
			PortNum VARCHAR(10)
		)
		INSERT INTO @WebServerTable(Hostname, PortNum)
		SELECT TOP 1 c.net_hostname, cp.attrVal
		FROM APP_Client c WITH (NOLOCK)
		JOIN APP_ClientProp cp WITH (NOLOCK)
			ON c.id = cp.componentNameId AND attrname = 'DM2WebService Web Site Port'
WHERE c.id IN (SELECT ClientId FROM simInstalledPackages WITH (NOLOCK) WHERE simPackageID = 803) -- WebServer package
AND NOT ((c.status & 0x00010) <> 0) --CV_STATUS_DUMMY
AND NOT ((c.status & 0x00020) <> 0) --CV_STATUS_HIDDEN
AND NOT ((c.status & 0x00002) <> 0) --CV_STATUS_UNINSTALLED
AND NOT ((c.status & 0x00004) <> 0) --CV_STATUS_DELETED
		-- from webserver url
		DECLARE @WebServerHostName VARCHAR(256) = ''
		DECLARE @WebServerPort VARCHAR(10) = ''
		DECLARE @WebServerUrl VARCHAR(256) = ''
		SELECT @WebServerHostName = Hostname, @WebServerPort = PortNum
		FROM @WebServerTable
		SET @WebServerUrl = 'http://' + @WebServerHostName + ':' + @WebServerPort +'/SearchSvc/CvWebService.svc'
		-- adminOpts
				INSERT INTO #EJobOptionsTable(OptionId, OptionType, OptionValue)
				VALUES
(1810277523, 	1, 	@clients) 		--CONTENTINDEXINGOPTION_CLIENTS), TM_OPTION_TYPE_STRING)
,	(1878303522,	1,	@userParams)	--	ANALYTICSSOLRIMPORTREQ_URL_PARAMS, TM_OPTION_TYPE_STRING)
,	(1344911810,		1,	@WebServerUrl)	--  ANALYTICSSOLRIMPORTOPTION_URL, TM_OPTION_TYPE_STRING
	END
	-- insert operationType into joboption table
	INSERT INTO #EJobOptionsTable(OptionId, OptionType, OptionValue)
	VALUES
(140018, 					7, CAST (@operationType AS VARCHAR(10))) --COM_OPERATION_TYPE), 					TM_OPTION_TYPE_LONG)
,	(2101836446, 				7, CAST (@dsIndexServerClientId AS VARCHAR(10)))
, 	(608389867, 				7, CAST (@i_DatasourceId AS VARCHAR(10))) -- this option is required for all analytics jobs so that jobs can be filtered by datasourceId
	SELECT * FROM #EJobOptionsTable
	--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		EXECUTE dbo.GetError @o_ErrorMsg OUTPUT , @o_ErrorCode OUTPUT
	END CATCH
	--	Clean up and exit
exitLine:
	IF OBJECT_ID('tempdb.dbo.#EJobOptionsTable') IS NOT NULL
		DROP TABLE #EJobOptionsTable
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL
		DROP TABLE #getIndexServers
	IF OBJECT_ID('tempdb.dbo.##SearchServers') IS NOT NULL
		DROP TABLE #SearchServers
END
GO

IF EXISTS (select * from GxQscripts where name = 'SEAGetEDiscoveryDatasourceJobOptions')
	delete from GxQscripts where name = 'SEAGetEDiscoveryDatasourceJobOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEAGetEDiscoveryDatasourceJobOptions')
	delete from GXDBVersions where aliasname = 'SEAGetEDiscoveryDatasourceJobOptions'
GO

insert into GXDBVersions values(2, 'SEAGetEDiscoveryDatasourceJobOptions',  '00000000000000000000', 'SEAGetEDiscoveryDatasourceJobOptions', '00000000000000000000')
GO

