

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEAGetCloudStorageInstanceId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--		  Given a list generic entities, this stored procedure returns list of corresponding job options values to form CreateTaskReqs for each datasource within a project
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SEAGetCloudStorageInstanceId')
BEGIN
	print '>>> Drop Stored Procedure: SEAGetCloudStorageInstanceId <<<'
	drop procedure SEAGetCloudStorageInstanceId
END
IF EXISTS (select * from GxQscripts where name='SEAGetCloudStorageInstanceId')
	delete from GxQscripts where name = 'SEAGetCloudStorageInstanceId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEAGetCloudStorageInstanceId')
	delete from GXDBVersions where aliasname = 'SEAGetCloudStorageInstanceId'
GO
print '... Creating Procedure: SEAGetCloudStorageInstanceId'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SEAGetCloudStorageInstanceId
  @i_ClientId INT,
  @i_InstanceType INT
AS
SET NOCOUNT ON
BEGIN
	SELECT DISTINCT I.id
	FROM APP_InstanceName I WITH(NOLOCK)
		JOIN APP_Application A WITH(NOLOCK)
			ON A.instance = I.id AND A.clientId = @i_ClientId
		JOIN APP_InstanceProp P WITH(NOLOCK)
			ON P.componentNameId = I.id AND P.attrName = 'Cloud Apps Instance Type' AND CAST(ISNULL(P.attrVal,'0') AS INT) = @i_InstanceType AND P.modified = 0
END
GO

IF EXISTS (select * from GxQscripts where name = 'SEAGetCloudStorageInstanceId')
	delete from GxQscripts where name = 'SEAGetCloudStorageInstanceId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEAGetCloudStorageInstanceId')
	delete from GXDBVersions where aliasname = 'SEAGetCloudStorageInstanceId'
GO

insert into GXDBVersions values(2, 'SEAGetCloudStorageInstanceId',  '00000000000000000000', 'SEAGetCloudStorageInstanceId', '00000000000000000000')
GO

