

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEADeleteSearchView.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SEADeleteSearchView <<<'

IF EXISTS (select * from sysobjects where name='SEADeleteSearchView')
	drop procedure SEADeleteSearchView
IF EXISTS (select * from GxQscripts where name='SEADeleteSearchView')
	delete from GxQscripts where name = 'SEADeleteSearchView'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEADeleteSearchView')
	delete from GXDBVersions where aliasname = 'SEADeleteSearchView'
GO
print '... Creating Procedure: SEADeleteSearchView'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SEADeleteSearchView
  @i_userId INT,
  @i_searchViewId INT,
  @i_statusType INT
AS
SET NOCOUNT ON
DECLARE @REPORTS INT = 3
DECLARE @l_status INT = 0,
			@l_handlerEntityType INT = 0,
			@l_attribute INT = 0
BEGIN
	/*
	-- this will get list of searchviewid applicable for the user, and use this to delete the view
	IF OBJECT_ID('tempdb.dbo.#sec_getNonIdaObjectsForThisUserWrapperTbl') IS NOT NULL
		DROP TABLE #sec_getNonIdaObjectsForThisUserWrapperTbl
	CREATE TABLE #sec_getNonIdaObjectsForThisUserWrapperTbl	(entityId INT)
	EXEC sec_getNonIdaObjectsForThisUser @i_userId,133,35 / * DELETE * /, '#sec_getNonIdaObjectsForThisUserWrapperTbl'
	*/
	DECLARE @o_errorCode INT =0,
			@o_errorMsg		NVARCHAR(MAX) =''
	IF(@i_userId <= 0 OR NOT EXISTS (SELECT TOP 1 * FROM UMUsers WITH (NOLOCK) WHERE id = @i_userId))
	BEGIN
		SELECT @o_errorCode = 10551, @o_errorMsg = 'Input userinformation is not valid. UserID ' + CONVErT(vARCHAR(10),@i_userId)
		GOTO _EXIT;
	END
	/*
		IF NOT EXISTS ( SELECT TOP 1 * FROM #sec_getNonIdaObjectsForThisUserWrapperTbl WHERE entityId = @i_searchViewId)
		BEGIN
			SELECT @o_errorCode = 10676, @o_errorMsg = 'Input User ('+ CONVErT(vARCHAR(10),@i_userId) +') doesnt have delete permission on SearchViewId (' + CONVERT(VARCHAR(10),@i_searchViewId) + ')'
			GOTO _EXIT;
		END
	*/
	IF @i_statusType = @REPORTS
	BEGIN
		IF NOT EXISTS (SELECT TOP 1 * FROM SESearchView WITH (NOLOCK) WHERE ViewInfo = CONVERT(nvarchar(10),@i_searchViewId) AND Status = @REPORTS)
		BEGIN
			SELECT @o_errorCode = 10671, @o_errorMsg = 'Input reportView doesnt exists. Value ' + CONVERT(VARCHAR(10),@i_searchViewId)
			GOTO _EXIT;
		END
		DELETE SESearchView WHERE ViewInfo = CONVERT(nvarchar(10),@i_searchViewId) AND Status = @REPORTS
		SET @o_errorMsg = 'Deleted search view. Id : ' + CONVERT(VARCHAR(10),@i_searchViewId)
	END
	ELSE
	BEGIN
		IF NOT EXISTS (SELECT TOP 1 * FROM SESearchView WITH (NOLOCK) WHERE SearchViewId = @i_searchViewId)
		BEGIN
			SELECT @o_errorCode = 10671, @o_errorMsg = 'Input SearchViewId doesnt exists. Value ' + CONVERT(VARCHAR(10),@i_searchViewId)
			GOTO _EXIT;
		END
		--for handlers, search veiw - delete entries from security tables if datasource is deleted
			SELECT  @l_status= status, @l_attribute= attribute FROM SESearchView WITH (NOLOCK) WHERE SearchViewId =  @i_searchViewId
			SET @l_handlerEntityType = CASE @l_status
WHEN /*SearchView */ 0 THEN 133		/*SEA_SEARCH_VIEW_ENTITY */
WHEN /*Handler*/   1 THEN 157	/*SEA_SEARCH_HANDLER_ENTITY*/
										 --WHEN /*Federated*/ 2
										 --WHEN /*Reports*/   3
										 ELSE 0
									END
			--Check Default Handler cannot be deleted.
			IF @l_attribute = 2 /*default*/ AND @l_status  = 1 /*handler*/
			BEGIN
				SELECT @o_errorCode = 10679, @o_errorMsg = 'Default Handler Cannot be Deleted. Value ' + CONVERT(VARCHAR(10),@i_searchViewId)
				GOTO _EXIT;
			END
			EXEC sec_deleteSecurityAssociationsForEntity  @l_handlerEntityType, @i_searchViewId
			---
			DELETE SESearchView WHERE SearchViewId =  @i_searchViewId
			SET @o_errorMsg = 'Deleted report view. Id : ' + CONVERT(VARCHAR(10),@i_searchViewId)
	END
	_EXIT:
		SELECT @o_errorCode 'ErrorCode', @o_errorMsg 'ErrorMsg'
END
GO

IF EXISTS (select * from GxQscripts where name = 'SEADeleteSearchView')
	delete from GxQscripts where name = 'SEADeleteSearchView'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEADeleteSearchView')
	delete from GXDBVersions where aliasname = 'SEADeleteSearchView'
GO

insert into GXDBVersions values(2, 'SEADeleteSearchView',  '00000000000000000000', 'SEADeleteSearchView', '00000000000000000000')
GO

