

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEACreateSearchView.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SEACreateSearchView')
BEGIN
	print '>>> Drop Stored Procedure: SEACreateSearchView <<<'
	drop procedure SEACreateSearchView
END
IF EXISTS (select * from GxQscripts where name='SEACreateSearchView')
	delete from GxQscripts where name = 'SEACreateSearchView'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEACreateSearchView')
	delete from GXDBVersions where aliasname = 'SEACreateSearchView'
GO
print '... Creating Procedure: SEACreateSearchView'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SEACreateSearchView
  @i_datasourceId INT,
  @i_searchViewName NVARCHAR(512),
  @i_userId INT,
  @i_viewInfo NVARCHAR(MAX),
  @i_searchViewId INT = 0,
  @i_status INT = 0,
  @i_attribute INT = 0,
  @i_referenceId INT = 0,
  @o_errorCode INT OUTPUT,
  @o_errorMsg NVARCHAR(MAX) OUTPUT
AS
BEGIN
		DECLARE @l_searchViewId	INT = 0
		DECLARE @l_handlerEntityType INT = 0
		DECLARE @l_referenceEntityType INT = 0
		DECLARE @isPermissionSet INT  = 0
		SELECT @o_errorCode	= 0, @o_errorMsg = ''
		/*
		@TODO:
			 Add security check who can modify search view.
			 If referenceId is provided, then validate if user have permission on it.
		*/
		IF(@i_userId <= 0 OR NOT EXISTS (SELECT TOP 1 * FROM UMUsers WITH (NOLOCK) WHERE id = @i_userId))
		BEGIN
			SELECT @o_errorCode = 10551, @o_errorMsg = 'Input userinformation is not valid. UserID ' + CONVErT(vARCHAR(10),@i_userId)
			GOTO _EXIT;
		END
		IF(@i_datasourceId <= 0 OR NOT EXISTS (SELECT TOP 1 * FROM SEDataSource WITH (NOLOCK) WHERE DataSourceId = @i_datasourceId AND (Attribute & 4) = 0 ))
		BEGIN
			SELECT @o_errorCode = 10627, @o_errorMsg = 'Input datasourceId doesnt exists. Value ' + CONVERT(VARCHAR(10),@i_datasourceId)
			GOTO _EXIT;
		END
		IF EXISTS (SELECT TOP 1 SearchViewId FROM SESearchView WITH (NOLOCK) WHERE
					DatasourceId = @i_datasourceId AND SearchViewName = @i_searchViewName AND
					OwnerUserID = @i_UserId AND SearchViewId != @i_searchViewId AND Status = @i_status )
		BEGIN
			SELECT @o_errorCode = 10672,
					@o_errorMsg = 'Search view name [' + @i_searchViewName + '] already exists for the input userid [' + CONVErT(vARCHAR(10),@i_userId) + '] on the datasource ['+ CONVERT(VARCHAR(10),@i_datasourceId) + ']'
			GOTO _EXIT;
		END
		IF(@i_referenceId > 0)
		BEGIN
			IF( NOT EXISTS (SELECT TOP 1 * FROM SESearchView WITH (NOLOCK) WHERE SearchViewId = @i_referenceId))
		BEGIN
			SELECT @o_errorCode = 10859, @o_errorMsg = 'Input reference doesnt exists. Value ' + CONVERT(VARCHAR(10),@i_referenceId)
			GOTO _EXIT;
		END
			--we need to find out for which input type reference check is required for handlers
			/*
				SearchView = 0,
				Handler = 1,
				Federated = 2,
				Reports = 3
			*/
			IF(@i_status IN ( 0, 1, 3))
				SET @l_referenceEntityType = 157/*SEA_SEARCH_HANDLER_ENTITY*/
			if(@l_referenceEntityType > 0)
			BEGIN
				-- check if logged current user have atleast view permission on input referenceId
				--
EXEC sec_checkPermissionOnEntity @i_userId, 201 /*CAT_DATACUBE_VIEW*/, @isPermissionSet OUTPUT, @l_referenceEntityType , @i_referenceId
				IF @isPermissionSet = 0
				BEGIN
					SELECT @o_errorCode = 10678, @o_errorMsg =
						'Input user doesnt have view permission. UserId : ' + CONVERT(VARCHAR(10),@i_userId) +
						' , Id : ' + CONVERT(VARCHAR(10), @i_referenceId) +
						', type : ' + CONVERT(VARCHAR(10),@l_referenceEntityType)
					GOTO _EXIT;
				END
			END
		END
		--fetch the input handler entity type
		SET @l_handlerEntityType = CASE @i_status
										 WHEN /*SearchView */ 0 THEN 133 /*SEA_SEARCH_VIEW_ENTITY */
										 WHEN /*Handler*/   1 THEN 157/*SEA_SEARCH_HANDLER_ENTITY*/
										 --WHEN /*Federated*/ 2
										 --WHEN /*Reports*/   3
										 ELSE 0
									END
		BEGIN TRY
		BEGIN TRAN
		--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
			IF @i_searchViewId > 0
			BEGIN
				IF NOT EXISTS (SELECT TOP 1 * FROM SESearchView WITH (NOLOCK) WHERE SearchViewId = @i_searchViewId)
				BEGIN
					SELECT @o_errorCode = 10671, @o_errorMsg = 'Input SearchViewId doesnt exists. Value ' + CONVERT(VARCHAR(10),@i_searchViewId)
					GOTO _EXIT;
				END
				ELSE
				BEGIN
					IF(@l_handlerEntityType > 0 )
					BEGIN
						-- check if logged current user have atleast edit permission on input searchId
						--
						SET @isPermissionSet = 0
EXEC sec_checkPermissionOnEntity @i_userId, 202 /*CAT_DATACUBE_EDIT */, @isPermissionSet OUTPUT, @l_handlerEntityType , @i_searchViewId
						IF @isPermissionSet = 0
				BEGIN
							SELECT @o_errorCode = 10678, @o_errorMsg =
								'Input user doesnt have edit permission. UserId : ' + CONVERT(VARCHAR(10),@i_userId) +
								' , Id : ' + CONVERT(VARCHAR(10), @i_searchViewId) +
								', type : ' + CONVERT(VARCHAR(10),@l_handlerEntityType)
							GOTO _EXIT;
						END
					END
					--update
					Update SESearchView SET
							ModifiedTime = GETUTCDATE(),
							SearchViewName = @i_searchViewName,
							Status = @i_status,
							ViewInfo = @i_viewInfo,
							Attribute = @i_attribute,
							ModifiedBy = @i_userId
					WHERE SearchViewId = @i_searchViewId
					SET @l_searchViewId = @i_searchViewId
				END
			END
			ELSE
			BEGIN
				--INSERT NEW ENTRY
				INSERT INTO SESearchView( DataSourceId, OwnerUserID,SearchViewName,ViewInfo,Status, Attribute, ModifiedBy, ReferenceId)
				SELECT @i_datasourceId, @i_userId, @i_searchViewName, @i_viewInfo, @i_status, @i_attribute, @i_userId,@i_referenceId
				SET @l_searchViewId = SCOPE_IDENTITY()
				--Add to security
				IF(@l_handlerEntityType > 0 )
				BEGIN
					exec sec_setCreatorForEntity @i_userId,0,N'201,202,203,204,107' /*View,Add/Append,Delete,Execute,107 */,
						@o_errorCode output, @o_errorMsg output, @l_handlerEntityType, @l_searchViewId
					-- Case where above SP returns deadlock/timeout error, we need to explicitly throw to caller to perform retry.
					--
					-- Error 1205 : Transaction (Process ID) was deadlocked on resources with another process and has been chosen as the deadlock victim.
					-- Error 1204: cannot obtain a LOCK resource
					-- Error 1222 lock request time out
					--
					IF(@o_errorCode > 0)
					BEGIN
						IF @o_errorCode IN (1205, 1204, 1222)
						BEGIN
							SET @o_errorMsg = 'Explicit Raise Error - ' + CAST(@o_errorCode as VARCHAR(10)) + ':' + @o_errorMsg
							;THROW 57001, @o_errorMsg , 1
						END
						ELSE
							GOTO _EXIT;
					END
				END
			END
			--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
			IF(@o_errorCode > 0)
				ROLLBACK TRAN
			ELSE
				COMMIT TRAN
		END TRY
	---------------------------------------------
	-- CHECK FOR ERRORS ----
	---------------------------------------------
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		-- Call procedure to print error information.
		-- Call procedure to get error information.
		EXECUTE dbo.GetError @o_errorMsg OUTPUT , @o_errorCode OUTPUT
		-- Rollback any active or uncommittable transactions before
		-- inserting information in the ErrorLog
		IF XACT_STATE() <> 0
		BEGIN
			ROLLBACK TRANSACTION;
		END
		--caller have logic to perform retry on timeout or deadlock
		--
		;THROW
	END CATCH;
	_EXIT:
		-- Rollback any active or uncommittable transactions
		IF XACT_STATE() <> 0
		BEGIN
			ROLLBACK TRANSACTION;
		END
		EXEC SEAGetSearchView @i_userId, @i_searchViewId = @l_searchViewId, @i_status= @i_status
END
GO

IF EXISTS (select * from GxQscripts where name = 'SEACreateSearchView')
	delete from GxQscripts where name = 'SEACreateSearchView'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEACreateSearchView')
	delete from GXDBVersions where aliasname = 'SEACreateSearchView'
GO

insert into GXDBVersions values(2, 'SEACreateSearchView',  '00000000000000000000', 'SEACreateSearchView', '00000000000000000000')
GO

