

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RunTMRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RunTMRule.sp,v $ $Id: RunTMRule.sp,v 1.136.12.14 2020/11/17 16:43:05 rsivadas Exp $";
--  +========================================================================+
--  | Stored Precedure: RunTMRule()
--  |
--  | Description:  Run the media movement rule to return a list of media
--	|				qualify for given vault tracker policy or rule.
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RunTMRule')
BEGIN
	print '>>> Drop Stored Procedure: RunTMRule <<<'
	drop procedure RunTMRule
END
IF EXISTS (select * from GxQscripts where name='RunTMRule')
	delete from GxQscripts where name = 'RunTMRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RunTMRule')
	delete from GXDBVersions where aliasname = 'RunTMRule'
GO
print '... Creating Procedure: RunTMRule'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RunTMRule
  @i_VTFlags INTEGER,
  @i_policyId INTEGER,
  @i_ruleId INTEGER
AS
  DECLARE @r_mediaId integer;
  DECLARE @r_DuebackDate bigint;
SET NOCOUNT ON
	DECLARE @isDueBackPolicy		integer
	DECLARE @checkOriginalLibrary	integer
	DECLARE @origLibForDueBack		integer
	DECLARE @sourceExportLocation	integer
	DECLARE @l_ruleId				integer
	DECLARE @param					bigint
	DECLARE @type					integer
	DECLARE @flag					integer
	DECLARE @limitcount				integer
	DECLARE @copycount				integer
	DECLARE @destlibraryid			integer
	DECLARE @destexportlocationid	integer
	DECLARE @destislibrary			integer
	DECLARE @DueBackError			INTEGER
	DECLARE @CurrentTime			INTEGER
	DECLARE @percentFreeSlots		INTEGER
	DECLARE @numSlotsTobeFreed		INTEGER
	DECLARE @mediaStatusSelected	integer
	DECLARE @filterSpare			INTEGER
	DECLARE @filterToBeCopied		INTEGER
	DECLARE @filterToBeVerified		INTEGER
	DECLARE @filterExtended			INTEGER
	DECLARE @filterExtendedParam	INTEGER
	DECLARE	@skipMediaInDrive		INTEGER
	DECLARE	@appendableMedia		INTEGER
	DECLARE	@activeMedia			INTEGER
	DECLARE	@percentSpaceUsed		INTEGER
	DECLARE	@actionFlag				INTEGER
	DECLARE @filterBackupLevel		INTEGER = 0
	DECLARE @filterBackupLevelParam	INTEGER = 0
	DECLARE @filterBackupLevelFlag	INTEGER = 0
	SET @isDueBackPolicy = 0
	SET @checkOriginalLibrary = 0
	SET @origLibForDueBack = 0
	SET @sourceExportLocation = 0
	SET	@filterSpare = 0
	SET	@filterToBeCopied = 0
	SET	@filterToBeVerified = 0
	SET	@filterExtended = 0
	SET	@filterExtendedParam = 0
	SET	@skipMediaInDrive = 0
	SET	@mediaStatusSelected = 0
	SET @appendableMedia = 0
	SET @percentSpaceUsed = 0
	SET @activeMedia = 0
	SET	@limitcount = 0
	SET	@copycount = 0
	SET @l_ruleId = @i_ruleId
	SET	@destlibraryid = 0
	SET	@destexportlocationid = 0
	SET @destislibrary = 0
	SET @percentFreeSlots = 0
	SET @numSlotsTobeFreed = 0
	set @actionFlag = 0
	--	MMS2_CONFIG_VT_DUEBACK_SELECT_ORIG_LIB -- 'VaultTracker dueback policy and report: Treat Library selection as original library'
	IF EXISTS (SELECT value FROM MMConfigs WHERE name = 'MMS2_CONFIG_VT_DUEBACK_SELECT_ORIG_LIB' AND Value <> 0)
		SET @checkOriginalLibrary = 1
	SET @CurrentTime = dbo.getUnixTime(getUTCDate())
	if object_id('tempdb.dbo.#tmRuleReturnMediaListtmp') is not null DROP TABLE #tmRuleReturnMediaListtmp
	if object_id('tempdb.dbo.#tmRuleMediaListtmp') is not null DROP TABLE #tmRuleMediaListtmp
	if object_id('tempdb.dbo.#tmRuleAndSchematmp') is not null DROP TABLE #tmRuleAndSchematmp
	if object_id('tempdb.dbo.#srcLibraries') is not null DROP TABLE #srcLibraries
	declare @tblVolList table (volumeId int, mediaId int)
	declare @tblAppendable table (mediaId int, TotalSpaceMB bigint, FreeBytesMB bigint)
	declare @tblChunkList table (archChunkId bigint, commCellId int, mediaId int)
	declare @tblArchFileCopyList table (archfileId int, commCellId int, copyId int, mediaId int)
	declare @tblJobCopyList table (jobId int, commCellId int, copyId int, fileType int, mediaId int, appId int)
	/************************************ Create tmp tables  **************************************/
	CREATE TABLE #tmRuleReturnMediaListtmp (ID							INT IDENTITY(1, 1),
											MediaId						INT,
											Barcode						varchar(256),
											DueBackDate					BIGINT,
											Attributes					INT,
											LibraryId					INT)
	CREATE TABLE #tmRuleAndSchematmp (RuleId INT, SchemaId INT, SchemaType INT, Param INT, Flag INT)
	CREATE TABLE #tmRuleMediaListtmp (MediaId INT,
									Barcode varchar(256),
									SpareGroupId INT,
									SpareGroupType INT,
									LastBackupTime INT,
									LastRestoreTime INT,
									ReformatTime INT,
									MediaFlags INT,
									LibraryId INT,
									LibraryTypeId INT,
									MediaLocation INT,
									ExportLocationId INT,
									AtLocation INT,
									Attributes INT,
									DuebackDate	BIGINT,
									IsAged INT,
									IsCleaningMedia INT,
									IsInMediaGroup INT
									)
		create index tmRuleMediaListtmp_index on #tmRuleMediaListtmp(MediaId)
		CREATE TABLE #srcLibraries(	LibraryId			INT,
									BayId				INT,
									TotalSlots			INT,
									NumFreeSlots		INT,
									NumSlotsTobeFreed	INT,
									BeginId				INT)
	/************************************ Get all media that might qualify *************************/
	IF @i_policyId > 0
	BEGIN
		SELECT	@copycount = COUNT(*)
		FROM	VTPolicyToCopy with (readuncommitted)
		WHERE	PolicyId = @i_policyId
		SELECT	@destislibrary = 1, @destlibraryid = a.Value
		FROM	VTLocation a with (readuncommitted), VTPolicy b with (readuncommitted)
		WHERE	a.LocationId = b.DestinationId
		AND		b.PolicyId = @i_policyId
AND		a.Type = 1
		SELECT	@destexportlocationid = a.Value
		FROM	VTLocation a with (readuncommitted), VTPolicy b with (readuncommitted)
		WHERE	a.LocationId = b.DestinationId
		AND		b.PolicyId = @i_policyId
AND		a.Type = 2
		INSERT	INTO #tmRuleMediaListtmp
		SELECT	distinct MediaId, barcode, SpareGroupId,
				(select SpareGroupType from MMSpareGroup with (readuncommitted) where SpareGroupId = MMMedia.SpareGroupId),
				LastBackupTime, LastRestoreTime, 0,
				MediaFlags, LibraryId, 0, MediaLocation, ExportLocationId, 0,
				Attributes, retentionExpireTime, IsAged,
				(SELECT IsCleaningMedia FROM MMMediaType WHERE mediaTypeId = MMMedia.mediaTypeId),
				IsInMediaGroup
		FROM	MMMedia with (readuncommitted)
		WHERE	MediaId > 0
		AND		MediaTypeId != 10001
		AND		(  ( (@destlibraryid > 0) AND (LibraryId != @destlibraryid) )
				OR ( (@destlibraryid > 0) AND (LibraryId = @destlibraryid) AND (MediaLocation = 3) )
				OR ( (@destislibrary > 0) AND (@destlibraryid = 0) AND (MediaLocation = 3) )
				OR ( (@destexportlocationid > 0) AND ((ExportLocationId != @destexportlocationid) or (MediaLocation in (1,2))) )
				)
AND		((Attributes & 16777216) = 0)
		IF @copycount > 0
		BEGIN
			DECLARE	@tblMediaGroup TABLE (MediaGroupId int)
			DECLARE	@tblMediaInMediaGroup TABLE (MediaId int)
			DECLARE @tblGACPCopies TABLE(archGroupId int, copyId int, destMediaCopyId int)
			INSERT INTO @tblGACPCopies
			SELECT a.archGroupId, a.id, a.destMediaCopyId
			FROM archGroupCopy a with (readuncommitted), VTPolicyToCopy b with (readuncommitted)
			WHERE b.PolicyId = @i_policyId
			AND		( b.ArchGroupId > 0 AND b.ArchGroupId = a.archGroupId OR b.ArchGroupId = 0 )
			AND		( b.CopyId > 0 AND b.CopyId = a.id OR b.CopyId = 0 )
AND ((a.extendedFlags & 1 > 0) OR (a.extendedFlags & 2 > 0))
			-- we need only GACP dependent copies where GACP is not selected.
			-- if gacp is selected then the above mediaGroup method works fine.
			-- cleanup the rest.
			DELETE T
			FROM @tblGACPCopies T
			WHERE T.destMediaCopyId IN (SELECT DISTINCT copyId FROM @tblGACPCopies)
			-- now cleanup GACPs also
			DELETE T
			FROM @tblGACPCopies T
			WHERE T.destMediaCopyId = 0
			-- for all the copies remaining, get the chunks-vol-media and insert
			INSERT INTO @tblMediaInMediaGroup
			SELECT DISTINCT a.MediaId
			FROM	MMVolume a with (readuncommitted), archChunk b with (readuncommitted),
				archChunkMapping c with (readuncommitted), @tblGACPCopies d
			WHERE a.VolumeId = b.VolumeId AND b.id = c.archChunkId AND b.commCellId = c.chunkCommCellId
			AND c.archCopyId = d.copyId
			INSERT	INTO @tblMediaGroup
			SELECT	a.MediaGroupId
			FROM	archStream a with (readuncommitted), VTPolicyToCopy b with (readuncommitted)
			WHERE	b.PolicyId = @i_policyId
			AND		( b.ArchGroupId > 0 AND b.ArchGroupId = a.archGroupId OR b.ArchGroupId = 0 )
			AND		( b.CopyId > 0 AND b.CopyId = a.archGroupCopyId OR b.CopyId = 0 )
			-- this ensures that GACP dependent copies mediaGroup is not selected
			AND	a.archGroupCopyId NOT IN (SELECT DISTINCT copyId FROM @tblGACPCopies)
			INSERT	INTO @tblMediaInMediaGroup
			SELECT	a.MediaId
			FROM	MMVolume a with (readuncommitted), @tblMediaGroup b
			WHERE	a.MediaGroupId = b.MediaGroupId
			DELETE	#tmRuleMediaListtmp
			FROM	#tmRuleMediaListtmp a LEFT JOIN @tblMediaInMediaGroup b ON a.MediaId = b.MediaId
			WHERE	b.MediaId IS NULL
		END
		IF @l_ruleId = 0
		BEGIN
			SELECT @l_ruleId = RuleId
			FROM VTPolicyToRule with (readuncommitted)
			WHERE PolicyId = @i_policyId
		END
		IF EXISTS (SELECT * FROM VtRuleToSchema WHERE schemaId = 7 AND ruleId = @l_ruleId AND param <> -1)
			SET @isDueBackPolicy = 1
		SELECT	@actionFlag = Flag
		FROM	VTPolicy
		WHERE	PolicyId = @i_policyId
	END
	-- Called by vault tracker report
	IF @i_policyId = 0
	BEGIN
		INSERT	INTO #tmRuleMediaListtmp
		SELECT	distinct MediaId, Barcode, SpareGroupId,
				(select SpareGroupType from MMSpareGroup with (readuncommitted) where SpareGroupId = MMMedia.SpareGroupId),
				LastBackupTime, LastRestoreTime, 0,
				MediaFlags, LibraryId, 0, MediaLocation, ExportLocationId, 0,
				Attributes, retentionExpireTime, IsAged,
				(SELECT IsCleaningMedia FROM MMMediaType WHERE mediaTypeId = MMMedia.mediaTypeId),
				IsInMediaGroup
		FROM	MMMedia with (readuncommitted)
		WHERE	MediaId > 0
		AND		MediaTypeId != 10001
AND		((Attributes & 16777216) = 0)
		ORDER	BY LastBackupTime, LastRestoreTime
	END
	UPDATE #tmRuleMediaListtmp
	SET	 LibraryTypeId = a.LibraryTypeId
	FROM MMLibrary a with (readuncommitted), #tmRuleMediaListtmp b
	WHERE	b.LibraryId = a.LibraryId
	UPDATE #tmRuleMediaListtmp
	SET	 ReformatTime = a.ReformatTime
	FROM MMVolume a with (readuncommitted), #tmRuleMediaListtmp b
	WHERE	b.MediaId = a.MediaId AND a.ReformatTime > 0
	/************************************ Get all rule schema for give rule ***********************/
	/* rule id could be zero, means get all media for the policy */
	INSERT INTO #tmRuleAndSchematmp
	SELECT rts.RuleId, rts.SchemaId, rs.Type, rts.Param, rts.Flag
	FROM	VTRuleSchema rs with (readuncommitted), VTRuleToSchema rts with (readuncommitted)
	WHERE	rs.SchemaId = rts.SchemaId
	AND		rts.RuleId = @l_ruleId
	/*********** Check source location *****************************/
	DECLARE @locationDefined INTEGER
	SET		@locationDefined = 0
	DECLARE locationCur CURSOR FOR
			SELECT	DISTINCT Param, Flag
			FROM	#tmRuleAndSchematmp
WHERE	SchemaType = 2
	OPEN	locationCur
	FETCH	NEXT FROM locationCur INTO @param, @flag
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		SET		@locationDefined = 1
IF (@flag & 2) > 0
		BEGIN
			SET @sourceExportLocation = 1
			UPDATE  #tmRuleMediaListtmp
			SET		AtLocation = AtLocation | 1
			WHERE	MediaLocation = 3
			AND		( (@param > 0 AND ExportLocationId = @param)
			OR		  (@param = 0 AND ExportLocationId = 0 AND LibraryTypeId != 8)
			OR		  (@param < 0) )
		END
IF (@flag & 1) > 0
			AND @isDueBackPolicy > 0
			AND @checkOriginalLibrary > 0
		BEGIN
			SET @origLibForDueBack = 1
			UPDATE  #tmRuleMediaListtmp
			SET		AtLocation = AtLocation | 2
			WHERE	LibraryTypeId != 8
			AND		( (@param > 0 AND LibraryId = @param)
			OR		  (@param < 0) )
		END
		ELSE
IF (@flag & 1) > 0
		BEGIN
			UPDATE  #tmRuleMediaListtmp
			SET		AtLocation = 1
			WHERE	MediaLocation in (1,2)
			AND		LibraryTypeId != 8
			AND		( (@param > 0 AND LibraryId = @param)
			OR		  (@param < 0) )
		END
IF (@flag & 4) > 0
		BEGIN
			UPDATE  #tmRuleMediaListtmp
			SET		AtLocation = 1
			WHERE	LibraryId > 0
			AND		LibraryTypeId = 8
			AND		MediaLocation = 3 and ExportLocationId = 0
			AND		( (@param > 0 AND LibraryId = @param)
			OR		  (@param < 0) )
		END
		FETCH	NEXT FROM locationCur INTO @param, @flag
	END
	CLOSE		locationCur
	DEALLOCATE	locationCur
	IF	@locationDefined > 0
	BEGIN
		-- Remove media not at selected source location
		DELETE FROM #tmRuleMediaListtmp
		WHERE	AtLocation = 0
		IF @origLibForDueBack > 0
		BEGIN
			-- Remove media not at export location and original library
			DELETE FROM #tmRuleMediaListtmp
			WHERE	@sourceExportLocation > 0 AND AtLocation <> 3
			OR		@sourceExportLocation = 0 AND AtLocation <> 2
		END
	END
	/************************************ Run each schema to get media *****************************/
	DECLARE @lt_MediaIdsByStatus TABLE (MediaId integer)
	DECLARE @lt_MediaIdsByGroups TABLE (MediaId integer)
	DECLARE @lt_MediaIdsByBadness TABLE (MediaId integer)
	DECLARE @lt_MediaIdsToKeep TABLE (MediaId integer)
	DECLARE @lt_MediaIdsNotSpare TABLE (MediaId integer)
	DECLARE ruleCursortmp CURSOR FOR
			SELECT	DISTINCT SchemaType, Param, Flag
			FROM	#tmRuleAndSchematmp
WHERE	SchemaType <> 2
	OPEN	ruleCursortmp
	FETCH	NEXT FROM ruleCursortmp
	INTO	@type, @param, @flag
	WHILE	@@FETCH_STATUS = 0
	BEGIN
IF		@type = 16
			BEGIN
				/* Rule is get limited number of media to export */
				/* @param is the number */
				SET		@limitcount = @param
			END
IF		@type = 512
			BEGIN
				/* Rule is to limit by percentage slots to be emptied */
				SET @percentFreeSlots = @param
			END
IF		@type = 1024
			BEGIN
				/* Rule is to limit by number slots to be emptied */
				SET @numSlotsTobeFreed = @param
			END
			/* Rule is retention based on due back time, */
IF		@type = 32
AND		@param >= 0
			BEGIN
				-- Remove cleaning media
				DELETE FROM #tmRuleMediaListtmp
				WHERE isCleaningMedia <> 0
				-- Remove media inside library
				DELETE FROM #tmRuleMediaListtmp
				WHERE MediaLocation in (1,2)
IF @param = 0
				BEGIN
					DELETE FROM #tmRuleMediaListtmp
					WHERE	MediaLocation = 3
					AND		IsInMediaGroup = 1
				END
ELSE IF @flag = 2
				BEGIN
					DELETE FROM #tmRuleMediaListtmp
					WHERE	MediaLocation = 3
					AND		IsInMediaGroup = 1
					AND		(DueBackDate = -1 or DueBackDate > @param)
				END
ELSE IF @flag = 1
				BEGIN
					DELETE FROM #tmRuleMediaListtmp
					WHERE	MediaLocation = 3
					AND		IsInMediaGroup = 1
					AND		(DueBackDate = -1 or DueBackDate > (@CurrentTime + 60*60*24*@param))
				END
			END
IF		@type = 4
AND		@param >= 0
			BEGIN
				DECLARE @tblMediaPicked TABLE ( MediaId int)
				DECLARE @paramStart INTEGER
				DECLARE @paramEnd INTEGER
				SET @paramStart = 0
				SET @paramEnd = 0
IF	( @flag & 4 ) > 0
				BEGIN
IF (@flag & 64) > 0
						SET @paramStart = @CurrentTime - 60*60*24*@param
					ELSE
						SET @paramEnd = @CurrentTime - 60*60*24*@param
				END
ELSE IF	( @flag & 8 ) > 0
				BEGIN
IF (@flag & 64) > 0
						SET @paramStart = @CurrentTime - 60*60*@param
					ELSE
						SET @paramEnd = @CurrentTime - 60*60*@param
				END
ELSE IF	( @flag & 16 ) > 0
				BEGIN
IF (@flag & 64) > 0
						SET @paramStart = @param
ELSE IF (@flag & 32) > 0
						SET @paramEnd = @param
				END
				-- Get media last read after given time
IF  (@flag & 1) > 0
				BEGIN
					INSERT	INTO @tblMediaPicked
					SELECT	MediaId
					FROM	#tmRuleMediaListtmp
					WHERE	LastRestoreTime > 0 AND @paramStart > 0 AND LastRestoreTime > @paramStart OR
							LastRestoreTime > 0 AND @paramEnd > 0 AND LastRestoreTime < @paramEnd
				END
				-- Get media last written after given time
IF  (@flag & 2) > 0
				BEGIN
					INSERT	INTO @tblMediaPicked
					SELECT	MediaId
					FROM	#tmRuleMediaListtmp
					WHERE	LastBackupTime > 0 AND @paramStart > 0 AND LastBackupTime > @paramStart OR
							LastBackupTime > 0 AND @paramEnd > 0 AND LastBackupTime < @paramEnd
				END
				-- Get media first written after given time
IF  (@flag & 128) > 0
				BEGIN
					INSERT	INTO @tblMediaPicked
					SELECT	MediaId
					FROM	#tmRuleMediaListtmp
					WHERE	ReformatTime > 0 AND @paramStart > 0 AND ReformatTime > @paramStart OR
							ReformatTime > 0 AND @paramEnd > 0 AND ReformatTime < @paramEnd
				END
IF (@flag & 256) > 0
				BEGIN
					SET @paramEnd = 0
					SET @paramStart = 0
IF	( @flag & 4 ) > 0
					BEGIN
IF (@flag & 64) > 0
							SET @paramEnd = @CurrentTime + 60*60*24*@param
						ELSE
							SET @paramStart = @CurrentTime + 60*60*24*@param
					END
ELSE IF	( @flag & 8 ) > 0
					BEGIN
IF (@flag & 64) > 0
							SET @paramEnd = @CurrentTime + 60*60*@param
						ELSE
							SET @paramStart = @CurrentTime + 60*60*@param
					END
ELSE IF	( @flag & 16 ) > 0
					BEGIN
IF (@flag & 64) > 0
							SET @paramStart = @param
ELSE IF (@flag & 32) > 0
							SET @paramEnd = @param
					END
					INSERT	INTO @tblMediaPicked
					SELECT	MediaId
					FROM	#tmRuleMediaListtmp
					WHERE	DueBackDate = -1 AND @paramStart > 0 OR
							DueBackDate > 0 AND @paramStart > 0 AND DueBackDate > @paramStart OR
							DueBackDate > 0 AND @paramEnd > 0 AND DueBackDate < @paramEnd
				END
				-- Remove all media not picked
				DELETE	#tmRuleMediaListtmp
				FROM	#tmRuleMediaListtmp a LEFT JOIN @tblMediaPicked b ON a.MediaId = b.MediaId
				WHERE	b.MediaId IS NULL
			END
			-- Media status criteria are bits set flags
IF		@type = 1
			BEGIN
IF	@param = 131072 | 262144 | 16
			BEGIN
				SET @appendableMedia = 1
				SET @activeMedia = 1
			END
			ELSE
			BEGIN
				SET	@mediaStatusSelected = 1
				SET	@filterSpare = 1
IF	@param & (131072
| 128
| 256
| 4
| 2
| 1
							) = 0
				BEGIN
					SET	@mediaStatusSelected = 0
				END
				-- Do not filter spare media if option NEW or SCRATCH are selected or no media status are selected.
IF @param & (131072 | 128) > 0
OR @param & (262144 | 2048) > 0
				OR @mediaStatusSelected = 0
				BEGIN
					SET @filterSpare = 0
				END
				/* Find media by status */
				INSERT INTO @lt_MediaIdsByStatus
				SELECT	distinct a.MediaId
				FROM	#tmRuleMediaListtmp a, MMVolume e with (NOLOCK)
				WHERE	a.MediaId = e.MediaId
AND	   (((@param & (131072 | 1)) > 0 AND e.VolumeFlags = 2) /* full */
OR		((@param & (131072 | 2)) > 0 AND e.VolumeFlags = 7  AND e.PhysicalBytesMB> 0) /* appendable */
OR		((@param & 1048576) = 0 AND @param & (131072 | 1) > 0 AND e.VolumeFlags = 4) /* bad */
OR		((@param & (131072 | 4)) > 0 AND (e.VolumeFlags = 1 OR e.VolumeFlags = 8) AND e.PhysicalBytesMB> 0) /* active */
OR		((@param & (131072 | 128)) > 0 AND a.IsInMediaGroup = 0 AND a.IsCleaningMedia = 0) /* empty */
OR		((@param & (131072 | 256)) > 0 AND a.IsAged = 1)) /* aged */
				/* Find bad media */
				INSERT INTO @lt_MediaIdsByBadness
				SELECT	distinct a.MediaId
				FROM	#tmRuleMediaListtmp a, MMVolume e with (NOLOCK)
				WHERE	a.MediaId = e.MediaId
				AND		(a.MediaFlags = 2 or e.VolumeFlags = 4)
				-- Find media by groups - 1:
				INSERT INTO @lt_MediaIdsByGroups
				SELECT	distinct a.MediaId
				FROM	#tmRuleMediaListtmp a
WHERE  (((@param & (262144 | 32)) > 0			AND a.SpareGroupType = 8 AND a.MediaFlags = 3) /* retired */
OR		((@param & (262144 | 512)) > 0			AND a.SpareGroupType = 16 AND a.IsInMediaGroup = 0) /* foreign */
OR		((@param & (262144 | 64)) > 0			AND a.SpareGroupType = 32 AND a.IsCleaningMedia > 0) /* cleaning */
OR		((@param & (262144 | 1024)) > 0			AND a.SpareGroupType = 128) /* catalog */
OR		((@param & (262144 | 8)) > 0	AND a.SpareGroupType = 64)) /* overwrite protected */
				IF	@filterSpare = 1
				BEGIN
					-- Do not filter out spare media in above groups
					INSERT INTO @lt_MediaIdsNotSpare
					SELECT MediaId FROM @lt_MediaIdsByGroups
				END
				-- Find media by groups - 2:
				INSERT INTO @lt_MediaIdsByGroups
				SELECT	distinct a.MediaId
				FROM	#tmRuleMediaListtmp a
WHERE  (((@param & (262144 | 2048)) > 0 AND a.SpareGroupType IN (1, 2) AND a.IsInMediaGroup = 0)) /* scratch */
IF @param & 65536 > 0
				BEGIN
					INSERT INTO @lt_MediaIdsToKeep
					SELECT  a.MediaId
					FROM	#tmRuleMediaListtmp a, @lt_MediaIdsByStatus b, @lt_MediaIdsByGroups c
					WHERE	a.MediaId = b.MediaId
					AND		a.MediaId = c.MediaId
				END
				ELSE
				BEGIN
					INSERT INTO @lt_MediaIdsToKeep
					SELECT  a.MediaId
					FROM	#tmRuleMediaListtmp a, @lt_MediaIdsByStatus b
					WHERE	a.MediaId = b.MediaId
					INSERT INTO @lt_MediaIdsToKeep
					SELECT  a.MediaId
					FROM	#tmRuleMediaListtmp a, @lt_MediaIdsByGroups b
					WHERE	a.MediaId = b.MediaId
				END
IF	@param & 1048576 > 0
				BEGIN
					-- Filter out bad media
					DELETE @lt_MediaIdsToKeep
					FROM @lt_MediaIdsToKeep a, @lt_MediaIdsByBadness b
					WHERE a.MediaId = b.MediaId
				END
				ELSE
IF	@param & 524288 > 0
				BEGIN
					-- Filter out good media
					DELETE	@lt_MediaIdsToKeep
					FROM	@lt_MediaIdsToKeep a LEFT JOIN @lt_MediaIdsByBadness b ON a.MediaId = b.MediaId
					WHERE	b.MediaId IS NULL
				END
				IF	@filterSpare = 1
				BEGIN
					-- Do not filter out any bad media
					INSERT INTO @lt_MediaIdsNotSpare
					SELECT	distinct a.MediaId
					FROM	@lt_MediaIdsToKeep a, @lt_MediaIdsByBadness b
					WHERE	a.MediaId = b.MediaId
				END
				-- Filter out media not to keep based on status and group selected
				DELETE #tmRuleMediaListtmp
				FROM #tmRuleMediaListtmp a LEFT JOIN @lt_MediaIdsToKeep b ON a.MediaId = b.MediaId
				WHERE	b.MediaId IS NULL
IF	@param & (131072 | 2) > 0
					SET @appendableMedia = 1
IF	@param & (131072 | 4) > 0
					SET @activeMedia = 1
IF	@mediaStatusSelected > 0 AND @param & (131072 | 256) = 0
AND @param & (262144 | 2048) = 0
				BEGIN
					-- Filter out aged media
					DELETE #tmRuleMediaListtmp
					FROM #tmRuleMediaListtmp a LEFT JOIN @lt_MediaIdsNotSpare b ON a.MediaId = b.MediaId
					WHERE	a.IsAged = 1 AND b.MediaId IS NULL
				END
IF	@param & (262144 | 32) = 0
				BEGIN
					-- Filter out retired media
					DELETE FROM #tmRuleMediaListtmp
					WHERE	SpareGroupType = 8
					AND		MediaFlags = 3
				END
IF	@param & (262144 | 512) = 0
				BEGIN
					-- Filter out foreign media
					DELETE	FROM #tmRuleMediaListtmp
					WHERE	SpareGroupType = 16
					AND		IsInMediaGroup = 0
				END
IF	@param & (262144 | 64) = 0
				BEGIN
					-- Filter out cleaning media
					DELETE	FROM #tmRuleMediaListtmp
					WHERE	SpareGroupType = 32
					AND		IsCleaningMedia > 0
				END
IF	@mediaStatusSelected > 0 AND @param & (131072 | 4) = 0
				BEGIN
					-- Filter out active media
					DELETE	#tmRuleMediaListtmp
					FROM	#tmRuleMediaListtmp a, MMVolume b with (readuncommitted)
					WHERE	a.MediaId = b.MediaId
					AND		(b.VolumeFlags = 1 OR b.VolumeFlags = 8)
				END
			END
			END
IF		@type = 128
AND		@param > 0
			BEGIN
					SET @filterExtended = 1
					SET	@filterExtendedParam = @param
			END
IF		@type = 8
AND		@param > 0
			BEGIN
					SET @filterBackupLevel = 1
					SET	@filterBackupLevelParam = @param
					SET @filterBackupLevelFlag = @flag
			END
IF		@type = 256
AND		@param > 0
					SET @filterToBeCopied = 1
IF		@type = 2048
AND		@param > 0
					SET @filterToBeVerified = 1
IF		@type = 4096
AND		@param > 0
					SET @skipMediaInDrive = 1
IF		@type = 8192
AND		@param > 0
					SET @percentSpaceUsed = @param
			/****************************************************************************/
			FETCH	NEXT FROM ruleCursortmp
			INTO	@type, @param, @flag
	END
	-- close and deallocate cursor
	CLOSE		ruleCursortmp
	DEALLOCATE	ruleCursortmp
	------------------------------------------------------------------------------
	IF		@percentSpaceUsed > 0 AND (@appendableMedia > 0 OR @activeMedia > 0)
	BEGIN
			INSERT INTO @tblAppendable
			SELECT a.MediaId, sum(b.TotalSpaceMB), sum(b.FreeBytesMB)
			FROM #tmRuleMediaListtmp a, MMMediaSide b with (nolock)
			WHERE a.mediaId = b.mediaId
			AND   a.mediaId IN (SELECT distinct c.mediaId
								FROM #tmRuleMediaListtmp c, MMVolume d with (nolock)
								WHERE c.mediaId = d.mediaId and d.volumeFlags in (1 /*VOL_ACTIVE*/
																				,7/*VOL_ACTIVE_APPEND*/
																				,8/*VOL_ACTIVE_REFRESH*/))
			GROUP BY a.mediaId
			DELETE #tmRuleMediaListtmp
			FROM #tmRuleMediaListtmp a, @tblAppendable b
			WHERE a.mediaId = b.mediaId
			AND (b.TotalSpaceMB - b.FreeBytesMB) * 100 < (b.TotalSpaceMB * @percentSpaceUsed)
	END
	IF		@filterSpare > 0 OR @filterToBeCopied > 0 OR @filterExtended > 0
			OR @filterToBeVerified > 0
			OR @filterBackupLevel > 0
	BEGIN
		insert into @tblVolList
		select a.VolumeId, a.MediaId
		from MMVolume a with (readuncommitted), #tmRuleMediaListtmp b
		where a.mediaId = b.mediaId
		insert into @tblChunkList
		select a.id, a.commcellid, b.mediaId
		from archChunk a with (readuncommitted), @tblVolList b
		where a.volumeId = b.volumeId
		insert into @tblArchFileCopyList
		select distinct a.archFileId, a.commCellId, a.archCopyId, b.mediaId
		from archChunkMapping a with (readuncommitted), @tblChunkList b
		where a.archChunkId = b.archChunkId
		and a.chunkCommCellId = b.commCellId
		IF @filterBackupLevel > 0
		BEGIN
			DECLARE @bkplevel_FULL int = CONVERT(INT, 0x1)
			DECLARE @bkplevel_INCR int = CONVERT(INT, 0x2)
			DECLARE @bkplevel_DIFFERENTIAL int = CONVERT(INT, 0x4)
			DECLARE @bkplevel_ANYLEVEL int = CONVERT(INT, 0x8)
			DECLARE @bkplevel_SYNTHETIC_FULL int = CONVERT(INT, 0x40)
			DECLARE @bkplevel_SYNTHETIC_FULL_AND_INCR int = CONVERT(INT, 0x80)
			DECLARE @bkplevel_INCR_NOTRUNC int = CONVERT(INT, 0x100)
			DECLARE @bkplevel_ASR int = CONVERT(INT, 0x200)
			DECLARE @bkplevel_SEL_OFFLINE_FULL int = CONVERT(INT, 0x400)
			DECLARE @bkplevel_SNAPSHOTBKP int = CONVERT(INT, 0x800)
			DECLARE @bkplevel_CREATEREPLICABKP int = CONVERT(INT, 0x1000)
			DECLARE @bkplevel_UPDATEREPLICABKP int = CONVERT(INT, 0x2000)
			DECLARE @bkplevel_SYNTHETIC_FULL_AND_INCR_BEFORE int = CONVERT(INT, 0x4000)
			DECLARE @bkplevel_SEL_ONLINE_FULL int = CONVERT(INT, 0x8000)
			DECLARE @bkplevel_QNET_BKP_LEVEL int = CONVERT(INT, 0x10000)
			DECLARE @bkplevel_SRM_ANALYSIS int = CONVERT(INT, 0x20000)
			DECLARE @bkplevel_SRM_DISCOVERY int = CONVERT(INT, 0x40000)
			DECLARE @bkplevel_QNET_BKP_LEVEL2 int = CONVERT(INT, 0x80000)
			DECLARE @bkplevel_BACKUPCOPYLEVEL int = CONVERT(INT, 0x100000)
			DECLARE @bkplevel_STUB int = CONVERT(INT, 0x200000)
			IF @filterBackupLevelParam & @bkplevel_FULL = @bkplevel_FULL
			BEGIN
				SET @filterBackupLevelParam = @filterBackupLevelParam
												| @bkplevel_SYNTHETIC_FULL
												| @bkplevel_SEL_OFFLINE_FULL
												| @bkplevel_SEL_ONLINE_FULL
			END
			IF @filterBackupLevelParam & @bkplevel_INCR = @bkplevel_INCR
			BEGIN
				SET @filterBackupLevelParam = @filterBackupLevelParam
												| @bkplevel_INCR_NOTRUNC
			END
			-- Remove media without selected job level
IF @filterBackupLevelFlag & 512 > 0
			BEGIN
				DELETE #tmRuleMediaListtmp
				FROM #tmRuleMediaListtmp m
				WHERE NOT EXISTS (
					select * from @tblArchFileCopyList a, Archfile b
					where a.archfileid = b.id and a.commcellid = b.commcellid
					and b.backupLevel & @filterBackupLevelParam > 0
					and a.MediaId = m.MediaId
				)
			END
			-- Remove media with selected job level
ELSE IF @filterBackupLevelFlag & 1024 > 0
			BEGIN
				DELETE #tmRuleMediaListtmp
				FROM #tmRuleMediaListtmp m
				WHERE EXISTS (
					select * from @tblArchFileCopyList a, Archfile b
					where a.archfileid = b.id and a.commcellid = b.commcellid
					and b.backupLevel & @filterBackupLevelParam > 0
					and a.MediaId = m.MediaId
				)
			END
		END
		IF	@filterToBeVerified > 0
		BEGIN
			-- Filter out to be verified media
			DELETE #tmRuleMediaListtmp
			FROM #tmRuleMediaListtmp m
			WHERE	exists (
					select 1
					from archChunkMapping a with (readuncommitted), @tblChunkList b
					where a.archChunkId = b.archChunkId
					and a.chunkCommCellId = b.commCellId
and a.flags & 1 > 0
					and b.MediaId = m.MediaId
			)
		END
		IF	@filterSpare > 0
		BEGIN
			-- Filter out spare media
			INSERT	INTO @lt_MediaIdsNotSpare
			SELECT	distinct b.mediaId
			FROM	archFile a with (readuncommitted), @tblArchFileCopyList b
			WHERE	a.id = b.archFileId
			AND		a.commCellId = b.commCellId
			AND		a.isvalid = 1
			DELETE	#tmRuleMediaListtmp
			FROM	#tmRuleMediaListtmp a LEFT JOIN @lt_MediaIdsNotSpare b ON a.MediaId = b.MediaId
			WHERE	b.MediaId IS NULL
		END
		IF		@filterToBeCopied > 0 OR @filterExtended > 0
		BEGIN
			insert into @tblJobCopyList
			select distinct a.jobId, a.commCellId, b.copyId, a.fileType, b.mediaId, a.appId
			from archFile a with (readuncommitted), @tblArchFileCopyList b
			where a.id = b.archFileId
			and a.commCellId = b.commCellId
		END
		--	MMS2_CONFIG_VT_EXPORT_MANUALLY_RETAINED -- 'VaultTracker export policy and report: Treat manually retained job the same way as jobs retained through extented retention rules'
		DECLARE @checkManuallyRetainedJob INTEGER = 0
		IF EXISTS (SELECT value FROM MMConfigs WHERE name = 'MMS2_CONFIG_VT_EXPORT_MANUALLY_RETAINED' AND Value <> 0)
			SET @checkManuallyRetainedJob = 1
IF		@filterExtended > 0 AND @filterExtendedParam = 1
		BEGIN
			/* retained by extended retention */
			/* delete media from #tmRuleMediaListtmp that don't fit into extended rule */
			DECLARE @lt_MediasToDeleteExtRet1 TABLE (MediaId Integer)
			INSERT INTO @lt_MediasToDeleteExtRet1
			select distinct b.mediaId
			from JMJobDataStats a with (readuncommitted), @tblJobCopyList b
			where a.jobId = b.jobId
			and a.archGrpCopyId = b.copyId
			and a.dataType = b.filetype
			and a.commCellId = b.commCellId
			and a.disabled & 256 = 0
			and a.status <> 1000
			and (a.retentionFlags > 0
or @checkManuallyRetainedJob = 1 AND A.disabled & 2 = 2 AND (A.manualRetentionEndTime = -1 OR A.manualRetentionEndTime > @CurrentTime)
				)
			DELETE	#tmRuleMediaListtmp
			FROM	#tmRuleMediaListtmp a LEFT JOIN @lt_MediasToDeleteExtRet1 b ON a.MediaId = b.MediaId
			WHERE	b.MediaId IS NULL
		END
IF		@filterExtended > 0 AND @filterExtendedParam = 2
		BEGIN
			/* not retained by extended retention */
			/* delete media from #tmRuleMediaListtmp that fit into extended rule */
			DECLARE @lt_MediasToDeleteExtRet2 TABLE (MediaId Integer)
			INSERT INTO @lt_MediasToDeleteExtRet2
			select distinct b.mediaId
			from JMJobDataStats a with (readuncommitted), @tblJobCopyList b
			where a.jobId = b.jobId
			and a.archGrpCopyId = b.copyId
			and a.dataType = b.filetype
			and a.commCellId = b.commCellId
			and a.disabled & 256 = 0
			and a.status <> 1000
			and (a.retentionFlags > 0
or @checkManuallyRetainedJob = 1 AND A.disabled & 2 = 2 AND (A.manualRetentionEndTime = -1 OR A.manualRetentionEndTime > @CurrentTime)
				)
			DELETE	#tmRuleMediaListtmp
			FROM	#tmRuleMediaListtmp a, @lt_MediasToDeleteExtRet2 b
			WHERE	a.MediaId = b.MediaId
		END
		IF		@filterToBeCopied > 0
		BEGIN
			-- delete media that don't satisfy preserve media not copied rule
			declare @tblAuxCopySource table (archgroupid int, copyId int, sourceCopyId int, flags int, waitSelect int)
			insert into @tblAuxCopySource
			select archgroupid, id, sourceCopyId, flags, 0
			from archgroupcopy with (readuncommitted)
			where  isactive > 0
			update @tblAuxCopySource
			set sourceCopyId = b.defaultCopy
			from @tblAuxCopySource a, archgroup b
			where a.archgroupid = b.id
			and a.sourceCopyId = 0
			delete @tblAuxCopySource
			from @tblAuxCopySource a, archgroupcopy b
			where a.sourceCopyId = b.id
			and b.isactive = 0
			update @tblAuxCopySource
			set waitSelect = 1
			from @tblAuxCopySource a, archSelectiveCopy b
			where a.copyId = b.copyId
and ( b.type in (8, 9)
				  OR
b.type IN (10, 3, 2, 4, 6)
AND (a.flags & (4096|8192)) = (4096|8192)
				)
			delete @tblJobCopyList
			from @tblJobCopyList a LEFT JOIN @tblAuxCopySource b ON a.copyId = b.sourceCopyId
			where b.sourceCopyId is null
			-- We only care jobs that can be copied
			delete @tblJobCopyList
			from JMJobDataStats a, @tblJobCopyList b
			where a.jobId = b.jobId
			and a.archGrpCopyId = b.copyId
			and a.dataType = b.filetype
			and a.commCellId = b.commCellId
			and (a.disabled > 0 or a.status <> 100)
			DECLARE @lt_MediaIdsToBeDeletedJobInfo TABLE (MediaId integer)
			INSERT INTO @lt_MediaIdsToBeDeletedJobInfo
			select distinct b.mediaId
			from JMJobInfo a with (readuncommitted), @tblJobCopyList b
			where a.jobId = b.jobId
			and a.commCellId = b.commCellId
			DELETE	#tmRuleMediaListtmp
			FROM	#tmRuleMediaListtmp a, @lt_MediaIdsToBeDeletedJobInfo b
			WHERE	a.MediaId = b.MediaId
			DECLARE @lt_MediaIdsToBeDeletedJobDataStats TABLE (MediaId integer)
			INSERT INTO @lt_MediaIdsToBeDeletedJobDataStats
			select distinct b.mediaId
			from JMJobDataStats a with (readuncommitted), @tblJobCopyList b, @tblAuxCopySource c
			where a.jobId = b.jobId
			and a.archGrpCopyId = c.copyId
			and a.dataType = b.filetype
			and a.commCellId = b.commCellId
			and a.disabled = 0
			and a.status in (101, 102, 103)
			and b.copyId = c.sourceCopyId
			-- Keep last full on source copy
			if exists (select * from @tblAuxCopySource where waitSelect > 0)
			begin
				declare @tblAppCopyJob table (appId int, copyId int, servStartDate int, jobId int, commCellId int)
				-- Get the last full on source copy even if it is not yet copied
				insert into @tblAppCopyJob
				select a.appId, a.archGrpCopyId, max(b.servStartDate), 0, 0
				FROM   JMJobDataStats A WITH (NOLOCK), JMBkpStats B WITH (NOLOCK), APP_iDAType I WITH (NOLOCK), App_Application APP WITH (NOLOCK)
				WHERE	B.appId = APP.id AND a.appId in (select distinct appId from @tblJobCopyList)
				AND a.archGrpCopyId in (select distinct sourceCopyId from @tblAuxCopySource where waitSelect > 0)
				AND B.appId = A.appId AND B.jobId = A.jobId and B.commCellId = A.commCellId and b.fullCycleNum > 0
				AND a.disabled = 0 and a.status <> 1000
				-- The following code is similar to UpdateToBeCopiedJobs.sp
				AND	I.type = B.appType AND (B.status IN (1, 14) OR B.status = 3 AND I.isCWEjobValid = 1)
				AND (B.bkpLevel IN (1, 64, 128, 16384, 1024, 32768) OR dbo.GetBkpLevelOfSnapJobs(B.JobId, B.CommCellId, a.archGrpCopyId) = 1 )
				-- Only take SEL_OFFLINE_FULL and SEL_ONLINE_FULL for Oracle
				AND (
B.appType NOT IN (2, 22, 23, 80,
61, 79)
					OR (B.bkpLevel IN (1024, 32768) AND (B.bkpAttributes & 0x2000000000000) = 0) -- ORACLE_RMAN_CUSTOMSCRIPT_BKP = 0x2000000000000
OR (B.openChain = 0 AND (B.bkpAttributes & 0x1000) <> 0)
					)
				-- Only take FULL with data for SAP, Informix and DB2
AND (B.appType NOT IN (3, 5, 37, 62, 103, 128, 135) OR
B.openChain = 0 AND ((B.bkpAttributes & 0x1000) <> 0 OR B.appType IN (5, 135)))
AND APP.subclientStatus & 0x1000 = 0
				-- Take jobs only from the default subclient for SQL iDAs
AND (B.appType NOT IN (4, 16, 70) OR
					EXISTS (SELECT * FROM APP_Application WITH (NOLOCK) WHERE id = B.appId AND (subclientStatus & 8) <> 0))
				-- Exclude FFG subclients for SQL iDAs from selective copies since 6.1
AND (B.appType <> 81 OR NOT EXISTS (SELECT * FROM APP_SubClientProp WITH (NOLOCK)
					WHERE componentNameId = B.appId AND attrName = N'mssql subclient type' AND attrVal = N'2' AND modified = 0))
				group by a.appId, a.archGrpCopyId
				-- Get jobId
				update @tblAppCopyJob
				set jobId = b.jobId, commCellId = b.commCellId
				from @tblAppCopyJob a, jmBkpStats b WITH (NOLOCK)
				where a.appId = b.appId
				and a.servStartDate = b.servStartDate
				-- Get media of last full on source copy
				INSERT INTO @lt_MediaIdsToBeDeletedJobDataStats
				select distinct a.mediaId
				from @tblJobCopyList a, @tblAppCopyJob b
				where a.appId = b.appId
				and a.jobId = b.jobId
				and a.commCellId = b.commCellId
				and a.copyId = b.copyId
			end
			DELETE	#tmRuleMediaListtmp
			FROM	#tmRuleMediaListtmp a, @lt_MediaIdsToBeDeletedJobDataStats b
			WHERE	a.MediaId = b.MediaId
		END
	END
	------------------------------------------------------------------------------
	-- If @i_VTFlags is VT_FLAGS_INCLUDE_MEDIA_IN_ACTION, then all media found are returned including media in existing actions.
	-- Otherwise, media in existing actions will be filtered out.
IF((@i_VTFlags & 1024) = 0)
	BEGIN
		-- Remove media in existing actions
		DELETE	#tmRuleMediaListtmp
		FROM	#tmRuleMediaListtmp a, VTActionMedia b with (nolock)
		WHERE	a.MediaId = b.MediaId
	END
	IF	@skipMediaInDrive > 0
	BEGIN
		-- Skip all media in drive
		DELETE	#tmRuleMediaListtmp
		FROM	#tmRuleMediaListtmp a, MMDrive b with (nolock)
		WHERE	a.MediaId = b.MediaId
	END
	ELSE
	BEGIN
		-- Skip media stuck in drive
		DELETE	#tmRuleMediaListtmp
		FROM	#tmRuleMediaListtmp a, MMVolume b with (nolock)
		WHERE	a.MediaId = b.MediaId AND b.VolumeId > 0 AND b.VolumeState = 2
	END
	DELETE	#tmRuleMediaListtmp
	FROM	#tmRuleMediaListtmp a, MMResource b with (nolock)
	WHERE	a.MediaId = b.MediaId
	/****************************** Exclude the non-encrypted media if the flag is set *************************/
	--You need to find out archFileCopy entries with encKeyType > 0 for sw encryption. And you need to check archChunk table for hwEncKey <> ''
IF @actionFlag & 64 > 0 AND @isDueBackPolicy = 0
	BEGIN
		-- Get all media with non-encrypted data
		declare @tblMediaNoEnc table (mediaId int)
		INSERT INTO @tblMediaNoEnc
		SELECT DISTINCT f.MediaId
		FROM archfile a with (nolock), archFileCopy b with (nolock), archChunkMapping c with (nolock), archChunk d with (nolock), mmvolume e with (nolock), #tmRuleMediaListtmp f
		WHERE a.id = b.archFileId and a.commCellId = b.commCellId
		AND a.isValid = 1 and b.isValid = 1
		AND a.fileType in (1, 4)
		AND b.archFileId = c.archFileId and b.commCellId = c.commCellId
		AND b.archCopyId = c.archCopyId
		AND c.archChunkId = d.id AND c.commCellId = d.commCellId
		AND d.volumeId = e.volumeId
		AND e.mediaId = f.mediaId
		AND b.encKeyType = 0
		AND d.hwEncKey = ''
		-- Filter all media with non-encrypted data
		DELETE TMP
		FROM #tmRuleMediaListtmp TMP INNER JOIN @tblMediaNoEnc N ON TMP.MediaId = N.MediaId
	END
	/****************************** Combine all media into one table *************************/
	IF exists (select * from MMConfigs where name = 'MMCONFIG_EXPORT_MEDIA_BY_BARCODE_ORDER' and value = 1)
	INSERT INTO #tmRuleReturnMediaListtmp
		SELECT MediaId, Barcode, DuebackDate, Attributes, LibraryId
		FROM #tmRuleMediaListtmp
		ORDER BY Barcode
	else
		INSERT INTO #tmRuleReturnMediaListtmp
		SELECT MediaId, Barcode, DuebackDate, Attributes, LibraryId
	FROM #tmRuleMediaListtmp
	ORDER BY LibraryId, LastBackupTime, LastRestoreTime
	/****************************** Retain limited count of media is specified ***************/
IF	@i_VTFlags & 2048 = 0 and @limitcount != 0
	BEGIN
		DELETE FROM #tmRuleReturnMediaListtmp
		WHERE	ID > @limitcount
	END
ELSE IF @i_VTFlags & 2048 = 0 and ( @percentFreeSlots > 0 OR @numSlotsTobeFreed > 0)
	BEGIN
		/* Get the number of slots that are empty */
		/* Get the number of slots to be empty per this rule */
		/* Compare these two values and set the limit count accordingly*/
		INSERT INTO #srcLibraries
		SELECT LibraryId, 0, 0, 0, @numSlotsTobeFreed, 0
		FROM #tmRuleMediaListtmp
		WHERE MediaLocation IN(1, 2) AND LibraryId > 0
		GROUP BY LibraryId
		IF(@@ROWCOUNT > 0)
		BEGIN
			UPDATE #srcLibraries
			SET BayId = MB.BayId
			From #srcLibraries as tt, MMBay as MB
			WHERE tt.LibraryId = MB.LibraryId
			UPdate #srcLibraries
			SET TotalSlots = CC.TotalCount
			From (select S.BayId AS BayId, Count(*) AS TotalCount
			from MMSlot as S, #srcLibraries as tt
			where S.SlotType = 1 AND S.BayId = tt.BayId
			Group by S.BayId) AS CC
			UPdate #srcLibraries
			SET NumFreeSlots = CC.TotalCount
			From (select S.BayId AS BayId, Count(*) AS TotalCount
			from MMSlot as S, #srcLibraries as tt
			where S.SlotType = 1 AND S.IsOccupied = 0 AND S.BayId = tt.BayId
			Group by S.BayId) AS CC
			IF(@percentFreeSlots > 0)
			BEGIN
				UPDATE #srcLibraries
				SET NumSlotsTobeFreed = (((TotalSlots * @percentFreeSlots)/100) - NumFreeSlots)
			END
			ELSE
			BEGIN
				UPDATE #srcLibraries
				SET NumSlotsTobeFreed = (NumSlotsTobeFreed - NumFreeSlots)
			END
			UPDATE #srcLibraries
			SET BeginId = (Select top 1 ID FROM #tmRuleReturnMediaListtmp
			WHERE #tmRuleReturnMediaListtmp.LibraryId = #srcLibraries.LibraryId
			ORDER BY ID ASC)
			DELETE #tmRuleReturnMediaListtmp
			FROM #tmRuleReturnMediaListtmp a, #srcLibraries b
			WHERE a.LibraryId = b.LibraryId AND b.NumSlotsTobeFreed <= 0
			DELETE FROM #tmRuleReturnMediaListtmp
			FROM #srcLibraries as tt1, #tmRuleReturnMediaListtmp as tt2
			WHERE tt2.ID >= (tt1.BeginId + tt1.NumSlotsTobeFreed)
			AND tt1.LibraryId = tt2.LibraryId
			AND tt1.NumSlotsTobeFreed > 0
		END
	END
	UPDATE #tmRuleReturnMediaListtmp
	SET DueBackDate = 0
	WHERE @CurrentTime > DueBackDate
	AND DueBackDate > 0
	SELECT MediaId, DueBackDate
	FROM   #tmRuleReturnMediaListtmp
	if object_id('tempdb.dbo.#tmRuleReturnMediaListtmp') is not null DROP TABLE #tmRuleReturnMediaListtmp
	if object_id('tempdb.dbo.#tmRuleMediaListtmp') is not null DROP TABLE #tmRuleMediaListtmp
	if object_id('tempdb.dbo.#tmRuleAndSchematmp') is not null DROP TABLE #tmRuleAndSchematmp
	if object_id('tempdb.dbo.#srcLibraries') is not null DROP TABLE #srcLibraries
	return
GO

IF EXISTS (select * from GxQscripts where name = 'RunTMRule')
	delete from GxQscripts where name = 'RunTMRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RunTMRule')
	delete from GXDBVersions where aliasname = 'RunTMRule'
GO

insert into GXDBVersions values(2, 'RunTMRule',  '00010136001200140000', 'RunTMRule', '00010136001200140000')
GO

