

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RunTMRemoveLibrary.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RunTMRemoveLibrary.sp,v $ $Id: RunTMRemoveLibrary.sp,v 1.11.294.2 2018/03/20 19:53:49 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RunTMRemoveLibrary()
--  |
--  | Description:  remove library references in tm tables
--  |
--  |	    Input:  integer i_commcellId, i_libraryId
--  |
--  |
--  |      Return:  Return code and error string.
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        awang    Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RunTMRemoveLibrary <<<'

IF EXISTS (select * from sysobjects where name='RunTMRemoveLibrary')
	drop procedure RunTMRemoveLibrary
IF EXISTS (select * from GxQscripts where name='RunTMRemoveLibrary')
	delete from GxQscripts where name = 'RunTMRemoveLibrary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RunTMRemoveLibrary')
	delete from GXDBVersions where aliasname = 'RunTMRemoveLibrary'
GO
print '... Creating Procedure: RunTMRemoveLibrary'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RunTMRemoveLibrary
  @i_commCellId INTEGER,
  @i_libraryId INTEGER
AS
  DECLARE @retVal INTEGER;
  DECLARE @errorString VARCHAR(1024);
  DECLARE @numDestination INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN TRANSACTION VTRemoveLibraryTran
/****************************************************************************************/
/************ Initialize and declare temparary variables ********************************/
/****************************************************************************************/
	DECLARE @locationId				INTEGER
	DECLARE	@newLocationId			INTEGER
	DECLARE	@checkTransaction	INTEGER
	SET	@numDestination = 0
	SET @retVal = 0
	SET @errorString = 'Fail to remove library references from VaultTracker tables: '
	CREATE	TABLE #ptor (
			RuleId INT,
			PolicyId INT,
			LocationCount INT,
			NewLocationCount INT
	)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'fail to create temprary table.'
			GOTO CX_ERROR_EXIT
	END
	INSERT	INTO	#ptor
	SELECT	r.RuleId, pr.PolicyId, 0, 0
	FROM	VTRuleToSchema r, VTPolicyToRule pr
	WHERE	r.Param = @i_libraryId
AND		( (r.Flag & 1) > 0
OR		(r.Flag & 4) > 0 )
	AND		r.RuleId = pr.RuleId
AND		r.SchemaId IN (SELECT SchemaId FROM VTRuleSchema WHERE Type = 2)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'fail to look up source location.'
			GOTO CX_ERROR_EXIT
	END
	/* first find the location id for this library */
	SET	@locationId = (SELECT	ISNULL(LocationId, 0)
						FROM	VTLocation
WHERE	Type = 1
						AND		Value = @i_libraryId)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'fail to look up the location.'
			GOTO CX_ERROR_EXIT
	END
	IF	@locationId = 0
	OR  @locationId IS null
	BEGIN
		/* if location id does not exist, create one */
		INSERT INTO VTLocation (Type, Value)
values (1, @i_libraryId)
		SELECT	@retVal = @@ERROR, @locationId = @@IDENTITY
		IF		@retVal != 0
		BEGIN
				SET @errorString = @errorString + 'fail to create location for library.'
				GOTO CX_ERROR_EXIT
		END
	END
	IF		@locationId != 0
	BEGIN
		/* only do something when there is location id */
		/* find alternate location id which is own library */
		SET	@newLocationId = (SELECT	ISNULL(LocationId, 0)
							FROM	VTLocation
WHERE	Type = 1
							AND		Value = 0)
		SELECT	@retVal = @@ERROR
		IF		@retVal != 0
		BEGIN
				SET @errorString = @errorString + 'fail to look up the location.'
				GOTO CX_ERROR_EXIT
		END
		IF	@newLocationId = 0
		OR  @newLocationId IS null
		BEGIN
			/* if alternate location id does not exist, create one */
			INSERT INTO VTLocation (Type, Value)
values (1, 0)
			SELECT	@retVal = @@ERROR, @newLocationId = @@IDENTITY
			IF		@retVal != 0
			BEGIN
					SET @errorString = @errorString + 'fail to create location for own library.'
					GOTO CX_ERROR_EXIT
			END
		END
		/* change the destination id of policy to alternate location, but disable the policy */
		UPDATE	VTPolicy
SET		DestinationId = @newLocationId, Flag = Flag & ~1, OfflineReason = 8
		WHERE	DestinationId = @locationId
		SELECT	@retVal = @@ERROR, @numDestination = @@ROWCOUNT
		IF		@retVal != 0
		BEGIN
				SET @errorString = @errorString + 'fail to update destination for policy.'
				GOTO CX_ERROR_EXIT
		END
		/* remove references in VTRuleToSchema table */
		UPDATE	#ptor
		SET		LocationCount = r.RuleId
		FROM	#ptor p, VTRuleToSchema r
WHERE	r.SchemaId IN (SELECT SchemaId FROM VTRuleSchema WHERE Type = 2)
		AND		r.RuleId = p.RuleId
AND		( (r.Flag & 1) > 0
OR		(r.Flag & 2) > 0
OR		(r.Flag & 4) > 0)
		SELECT	@retVal = @@ERROR
		IF		@retVal != 0
		BEGIN
				SET @errorString = @errorString + 'fail to count location reference for the policy.'
				GOTO CX_ERROR_EXIT
		END
		DELETE	FROM VTRuleToSchema
WHERE	SchemaId IN (SELECT SchemaId FROM VTRuleSchema WHERE Type = 2)
		AND		Param = @i_libraryId
AND		( (Flag & 1) > 0
OR		(Flag & 4) > 0 )
		SELECT	@retVal = @@ERROR
		IF		@retVal != 0
		BEGIN
				SET @errorString = @errorString + 'fail to remove library references from VTRuleToSchema table.'
				GOTO CX_ERROR_EXIT
		END
		UPDATE	#ptor
		SET		NewLocationCount = r.RuleId
		FROM	#ptor p, VTRuleToSchema r
WHERE	r.SchemaId IN (SELECT SchemaId FROM VTRuleSchema WHERE Type = 2)
		AND		r.RuleId = p.RuleId
AND		( (r.Flag & 1) > 0
OR		(r.Flag & 2) > 0
OR		(r.Flag & 4) > 0)
		SELECT	@retVal = @@ERROR
		IF		@retVal != 0
		BEGIN
				SET @errorString = @errorString + 'fail to count location reference for the policy.'
				GOTO CX_ERROR_EXIT
		END
		UPDATE	VTPolicy
SET		Flag = Flag & ~1, OfflineReason = 2
		WHERE	PolicyId IN (SELECT PolicyId FROM #ptor WHERE LocationCount > 0 AND NewLocationCount = 0)
		SELECT	@retVal = @@ERROR
		IF		@retVal != 0
		BEGIN
				SET @errorString = @errorString + 'fail to disable policy.'
				GOTO CX_ERROR_EXIT
		END
		DECLARE @tblActionCmdReturn table (retVal int, mediaProcessed int, mediaSkipped int, errString VARCHAR(1024))
		DECLARE @open_VTActionCur integer
		DECLARE @open_VTMediaCur integer
		DECLARE @actionId integer
		DECLARE @mediaId integer
		set @open_VTActionCur = 0
		set @open_VTMediaCur = 0
		DECLARE	VTActionCur CURSOR FOR
		SELECT ActionId FROM VTAction
		WHERE sourceId = @locationId OR destinationId = @locationId
		OPEN VTActionCur
		set @open_VTActionCur = 1
		FETCH NEXT FROM VTActionCur INTO @actionId
		WHILE	@@FETCH_STATUS = 0
		BEGIN
			DELETE FROM @tblActionCmdReturn
			INSERT INTO @tblActionCmdReturn
EXEC VTRunActionCmd 2, @actionId, 0, 0
			IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
			FETCH NEXT FROM VTActionCur INTO @actionId
		END
		DECLARE	VTMediaCur CURSOR FOR
		SELECT ActionId, MediaId FROM VTActionMedia
		WHERE currentId = @locationId
		OPEN VTMediaCur
		set @open_VTMediaCur = 1
		FETCH NEXT FROM VTMediaCur INTO @actionId, @mediaId
		WHILE	@@FETCH_STATUS = 0
		BEGIN
			DELETE FROM @tblActionCmdReturn
			INSERT INTO @tblActionCmdReturn
EXEC VTRunActionCmd 2, @actionId, @mediaId, 0
			IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
			FETCH NEXT FROM VTMediaCur INTO @actionId, @mediaId
		END
		/* finally remove from VTLocation table */
		DELETE	FROM VTLocation
		WHERE	LocationId = @locationId
		SELECT	@retVal = @@ERROR
		IF		@retVal != 0
		BEGIN
				SET @errorString = @errorString + 'fail to remove library references from VTLocation table.'
				GOTO CX_ERROR_EXIT
		END
	END
/****************************************************************************************/
/****************************************************************************************/
--  +----------------------------+
--  |	NORMAL, "HAPPY" EXIT:    |
--  +----------------------------+
	DROP	TABLE #ptor
	IF @open_VTActionCur = 1
	BEGIN
		CLOSE VTMediaCur
		DEALLOCATE VTMediaCur
	END
	IF @open_VTMediaCur = 1
	BEGIN
		CLOSE VTActionCur
		DEALLOCATE VTActionCur
	END
	COMMIT	TRANSACTION VTRemoveLibraryTran
	SELECT	@checkTransaction = @@ERROR
	IF		@checkTransaction != 0
	BEGIN
			SET	@retVal = @checkTransaction
			SET @errorString = 'fail to commit transaction'
	END
	IF		@retVal = 0
	BEGIN
			SET @errorString = ''
	END
	SELECT	@retVal, @errorString, @numDestination
	RETURN	@retVal;
--  +----------------------------+
--  |   ABNORMAL, "ERROR" EXIT:  |
--  +----------------------------+
CX_ERROR_EXIT:
	DROP	TABLE #ptor
	IF @open_VTActionCur = 1
	BEGIN
		CLOSE VTMediaCur
		DEALLOCATE VTMediaCur
	END
	IF @open_VTMediaCur = 1
	BEGIN
		CLOSE VTActionCur
		DEALLOCATE VTActionCur
	END
	ROLLBACK	TRANSACTION VTRemoveLibraryTran
	SELECT	@checkTransaction = @@ERROR
	IF		@checkTransaction != 0
	BEGIN
			SET	@retVal = @checkTransaction
			SET @errorString = 'cannot rollback transaction'
	END
	SELECT	@retVal, @errorString, @numDestination
	RETURN	@retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'RunTMRemoveLibrary')
	delete from GxQscripts where name = 'RunTMRemoveLibrary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RunTMRemoveLibrary')
	delete from GXDBVersions where aliasname = 'RunTMRemoveLibrary'
GO

insert into GXDBVersions values(2, 'RunTMRemoveLibrary',  '00010011029400020000', 'RunTMRemoveLibrary', '00010011029400020000')
GO

