

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RunTMHistoryCommand.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RunTMHistoryCommand.sp,v $ $Id: RunTMHistoryCommand.sp,v 1.25.302.2 2018/03/20 20:02:53 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RunTMHistoryCommand()
--  |
--  | Description:  run media movement policy.
--  |
--  |	    Input:  integer i_command, i_actionId, i_historyId
--  |
--  |
--  |      Return:  Return code and error string.
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        awang    Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RunTMHistoryCommand <<<'

IF EXISTS (select * from sysobjects where name='RunTMHistoryCommand')
	drop procedure RunTMHistoryCommand
IF EXISTS (select * from GxQscripts where name='RunTMHistoryCommand')
	delete from GxQscripts where name = 'RunTMHistoryCommand'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RunTMHistoryCommand')
	delete from GXDBVersions where aliasname = 'RunTMHistoryCommand'
GO
print '... Creating Procedure: RunTMHistoryCommand'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RunTMHistoryCommand
  @i_command INTEGER,
  @i_commCellId INTEGER,
  @i_actionId INTEGER,
  @i_historyId INTEGER,
  @i_olderdays INTEGER
AS
  DECLARE @retVal INTEGER;
  DECLARE @errorString VARCHAR(1024);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN TRANSACTION
/****************************************************************************************/
/************ Initialize and declare temparary variables ********************************/
/****************************************************************************************/
	DECLARE @historyId				INTEGER
	DECLARE @mediaId				INTEGER
DECLARE	@barCode				varchar(256)
	DECLARE @sourceId				INTEGER
	DECLARE	@destinationId			INTEGER
	DECLARE	@state					INTEGER
	DECLARE	@libraryId				INTEGER
	DECLARE	@exportLocationId		INTEGER
	DECLARE	@rowCount				INTEGER
	DECLARE	@checkTransaction		INTEGER
	DECLARE	@retValFlag				INTEGER
	DECLARE	@sourceLocationType		INTEGER
	DECLARE	@destLocationType		INTEGER
	DECLARE	@processed				INTEGER
	DECLARE	@isexist				INTEGER
	DECLARE	@sourceLocationValue	INTEGER
	DECLARE	@destLocationValue		INTEGER
	DECLARE	@actionId				INTEGER
	DECLARE	@initiator				varchar(255)
	DECLARE @policyId				INTEGER
DECLARE @policyName				varchar(128)
	DECLARE @jobId_h				INTEGER
	DECLARE @jobId_l				INTEGER
DECLARE	@userName				VARCHAR(255)
	DECLARE @mediaCursorFlag		INTEGER
	SET @retVal = 0
	SET @retValFlag = 0
	SET	@initiator = ''
	SET @mediaCursorFlag = 0
	SET @errorString = 'Failed to run command for history: '
/****************************************************************************************/
/********************** Do delete command before *****************************************/
/****************************************************************************************/
IF	@i_command = 128
	BEGIN
		IF		@i_historyId != 0
		BEGIN
			/* command is on one history, which has one media */
			DELETE FROM VTHistory
			WHERE	HistoryId = @i_historyId
			SELECT	@retVal = @@ERROR
			IF		@retVal != 0
			BEGIN
					SET @errorString = @errorString + 'fail to remove media movement history'
					GOTO CX_ERROR_EXIT
			END
			SET	@retVal = 0
			GOTO CX_NORMAL_EXIT
		END
		IF	@i_actionId != 0
		BEGIN
			/* command is on one action */
			DELETE FROM VTHistory
			WHERE	ActionId = @i_actionId
			SELECT	@retVal = @@ERROR
			IF		@retVal != 0
			BEGIN
					SET @errorString = @errorString + 'fail to remove media movement history for action'
					GOTO CX_ERROR_EXIT
			END
			SET	@retVal = 0
			GOTO CX_NORMAL_EXIT
		END
		IF	@i_olderdays = 0
		BEGIN
			/* command is on all history */
			DELETE FROM VTHistory
			WHERE	HistoryId > 0
			SELECT	@retVal = @@ERROR
			IF		@retVal != 0
			BEGIN
					SET @errorString = @errorString + 'fail to remove all media movement history'
					GOTO CX_ERROR_EXIT
			END
			SET	@retVal = 0
			GOTO CX_NORMAL_EXIT
		END
		IF	@i_olderdays < 0
		BEGIN
			SET	@i_olderdays = (select value from MMConfigs where name = 'MMS2_CONFIG_STRING_VAULTTRACKER_HISTORY_PRUNE_DAYS')
			SELECT	@retVal = @@ERROR
			IF		@retVal != 0
			BEGIN
					SET @errorString = @errorString + 'fail to look up VaultTracker history pruning time in MMS2Config table'
					GOTO CX_ERROR_EXIT
			END
		END
		IF	@i_olderdays > 0
		BEGIN
			/* delete entries that are older than days */
			DELETE FROM VTHistory
			WHERE	DATEDIFF(day, EndTime, GETUTCDATE()) > @i_olderdays
			SELECT	@retVal = @@ERROR
			IF		@retVal != 0
			BEGIN
					SET @errorString = @errorString + 'fail to remove media movement history for action'
					GOTO CX_ERROR_EXIT
			END
			SET	@retVal = 0
			GOTO CX_NORMAL_EXIT
		END
		SET	@retVal = 0
		GOTO CX_NORMAL_EXIT
	END
/****************************************************************************************/
/********************** Create temparary tables *****************************************/
/****************************************************************************************/
	CREATE TABLE #tmMediaListtmp (
			HistoryId INT,
			MediaId INT,
BarCode varchar(256),
			SourceId INT,
			DestinationId INT,
			State	INT,
			LibraryId INT,
			ExportLocationId INT
	)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'fail to create table #tmMediaListtmp'
			GOTO CX_ERROR_EXIT
	END
/****************************************************************************************/
/******************** Insert into temprary tables ***************************************/
/****************************************************************************************/
	--Get Media
	IF		@i_historyId != 0
	BEGIN
		/* command is on one history, which has one media */
		INSERT	INTO #tmMediaListtmp
		SELECT	HistoryId, MediaId, BarCode, SourceId, DestinationId, State, 0, 0
		FROM	VTHistory
		WHERE	HistoryId = @i_historyId
		SELECT	@retVal = @@ERROR, @rowCount = @@ROWCOUNT
		IF		@retVal != 0
		BEGIN
				SET @errorString = @errorString + 'fail to insert into #tmMediaListtmp'
				GOTO CX_ERROR_EXIT
		END
	END
	IF	@i_actionId != 0 AND @i_historyId = 0
	BEGIN
		/* command is on the action */
		INSERT	INTO #tmMediaListtmp
		SELECT	HistoryId, MediaId, BarCode, SourceId, DestinationId, State, 0, 0
		FROM	VTHistory
		WHERE	ActionId = @i_actionId
		SELECT	@retVal = @@ERROR, @rowCount = @@ROWCOUNT
		IF		@retVal != 0
		BEGIN
				SET @errorString = @errorString + 'fail to insert into #tmMediaListtmp'
				GOTO CX_ERROR_EXIT
		END
	END
	IF	@i_actionId = 0 AND @i_historyId = 0
	BEGIN
			SET	@retValFlag = -1
			SET @errorString = @errorString + 'no history is selected'
			GOTO CX_ERROR_EXIT
	END
	IF		@rowCount = 0
	BEGIN
			/* not really an error */
			SET @errorString = @errorString + 'no media is associated with specified action and media'
			GOTO CX_ERROR_EXIT
	END
/****************************************************************************************/
	/* fill in LibraryId and ExportLocationId */
	UPDATE	#tmMediaListtmp
	SET		LibraryId = a.LibraryId, ExportLocationId = a.ExportLocationId
	FROM	MMMedia a, #tmMediaListtmp b
	WHERE	b.MediaId > 0
	AND		b.MediaId = a.MediaId
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'fail to get media location info'
			GOTO CX_ERROR_EXIT
	END
/****************************************************************************************/
/****************** For every MediaId, run command **************************************/
/****************************************************************************************/
	DECLARE mediaCursor CURSOR FOR
			SELECT	DISTINCT HistoryId, MediaId, BarCode, SourceId, DestinationId, State,
					LibraryId, ExportLocationId
			FROM	#tmMediaListtmp
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'fail to declare cursor mediaCursor'
			GOTO CX_ERROR_EXIT
	END
/****************************************************************************************/
/****************************************************************************************/
	SET		@mediaCursorFlag = 1
	OPEN	mediaCursor
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'fail to open cursor mediaCursor'
			GOTO CX_ERROR_EXIT
	END
/****************************************************************************************/
	FETCH	NEXT FROM mediaCursor
	INTO	@historyId, @mediaId, @barCode, @sourceId, @destinationId,
			@state, @libraryId, @exportLocationId
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'fail to fetch cursor mediaCursor'
			GOTO CX_ERROR_EXIT
	END
/****************************************************************************************/
	WHILE	@@FETCH_STATUS = 0
	BEGIN
			SET	@processed = 0
			/* get source location type and destination location type */
			SELECT	@sourceLocationType = Type, @sourceLocationValue = Value
			FROM	VTLocation
			WHERE	LocationId = @sourceId
			SELECT	@retVal = @@ERROR
			IF		@retVal != 0
			BEGIN
					SET @errorString = @errorString + 'fail to retrieve info for action source'
					GOTO CX_ERROR_EXIT
			END
			SELECT	@destLocationType = Type, @destLocationValue = Value
			FROM	VTLocation
			WHERE	LocationId = @destinationId
			SELECT	@retVal = @@ERROR
			IF		@retVal != 0
			BEGIN
					SET @errorString = @errorString + 'fail to retrieve info for action destination'
					GOTO CX_ERROR_EXIT
			END
			SELECT	@policyName	= PolicyName, @userName = UserName,
					@jobId_h = JobId_h, @jobId_l = JobId_l
			FROM	VTHistory
			WHERE	HistoryId = @historyId
			IF @policyName is null or @policyName = ''
			BEGIN
				if @jobId_l > 0
					SET @initiator = 'Job: ' + CONVERT(VARCHAR(10), @jobId_l)
				else
					SET @initiator = 'User: ' + @userName
			END
			ELSE
			BEGIN
				SET @initiator = 'Policy: ' + @policyName
			END
			/*********************** for rollback command *********************************/
IF		@i_command = 64
			BEGIN
IF	(@state & 4) > 0 OR
(@state & 1) > 0 OR
(@state & 8) > 0
				BEGIN
					SET	@retValFlag = -1
IF	(@state & 4) > 0
					BEGIN
						SET @errorString = @errorString + 'media location has already been rolled back to its source location.'
					END
					ELSE
					BEGIN
						SET @errorString = @errorString + 'cannot rollback from failure or aborted state. Please use Media Property Window to change its export location.'
					END
					GOTO CX_ERROR_EXIT
				END
IF	@sourceLocationType = 2 AND
@destLocationType = 2
				BEGIN
					IF	@destLocationValue != @exportLocationId
					BEGIN
						SET	@retValFlag = -1
						SET @errorString = @errorString + 'cannot rollback because media is no longer at expected destination specified by its pending action.'
						GOTO CX_ERROR_EXIT
					END
					SELECT	@isexist = COUNT(*)
					FROM	MMMedia
					WHERE	MediaId > 0
					AND		MediaId = @mediaId
					SELECT	@retVal = @@ERROR
					IF		@retVal != 0
					BEGIN
							SET @errorString = @errorString + 'fail to retrieve media info'
							GOTO CX_ERROR_EXIT
					END
					IF		@isexist > 0
					BEGIN
						UPDATE	MMMedia
						SET		ExportLocationId = @sourceLocationValue
						WHERE	MediaId > 0
						AND		MediaId = @mediaId
						SELECT	@retVal = @@ERROR
						IF		@retVal != 0
						BEGIN
								SET @errorString = @errorString + 'fail to restore export location for media'
								GOTO CX_ERROR_EXIT
						END
						SET		@processed = 1
						UPDATE	VTHistory
SET		state = state | 4
						WHERE	HistoryId = @historyId;
						SELECT	@retVal = @@ERROR
						IF		@retVal != 0
						BEGIN
								SET @errorString = @errorString + 'fail to set rollback flag for the history'
								GOTO CX_ERROR_EXIT
						END
						INSERT  INTO VTAlerts (AlertAction, Initiator, ActionId, MediaId, SourceId, InTransitId, DestinationId)
values(2059, @initiator, @i_actionId, @mediaId, @sourceId, 0, @destinationId)
						SELECT	@retVal = @@ERROR
						IF		@retVal != 0
						BEGIN
								SET @errorString = @errorString + 'fail to create alert for media rolled back'
								GOTO CX_ERROR_EXIT
						END
					END
					ELSE
					BEGIN
						SET	@retValFlag = -1
						SET @errorString = @errorString + 'cannot rollback because media has been removed from Galaxy.'
						GOTO CX_ERROR_EXIT
					END
				END
				ELSE
				BEGIN
IF	@sourceLocationType = 1
					BEGIN
						SET	@retValFlag = -1
						SET @errorString = @errorString + 'rollback is not valid operation when media has been exported from library. Please use import to put media back to library.'
						GOTO CX_ERROR_EXIT
					END
					ELSE
					BEGIN
						SET	@retValFlag = -1
						SET @errorString = @errorString + 'rollback is not valid operation when media has been imported to library. Please use export to move media outside library.'
						GOTO CX_ERROR_EXIT
					END
				END
			END
			IF	@processed = 0
			BEGIN
				SET	@retValFlag = -1
				SET @errorString = @errorString + 'unknown command is specfied.'
				GOTO CX_ERROR_EXIT
			END
			/****************************************************************************/
			FETCH	NEXT FROM mediaCursor
			INTO	@historyId, @mediaId, @barCode, @sourceId, @destinationId,
					@state, @libraryId, @exportLocationId
			SELECT	@retVal = @@ERROR
			IF		@retVal != 0
			BEGIN
					SET @errorString = @errorString + 'fail to fetch cursor mediaCursor'
					GOTO CX_ERROR_EXIT
			END
			/****************************************************************************/
	END
/****************************************************************************************/
/**************** Drop temparary table **************************************************/
/****************************************************************************************/
	DROP TABLE #tmMediaListtmp
/****************************************************************************************/
/****************************************************************************************/
--  +----------------------------+
--  |	NORMAL, "HAPPY" EXIT:    |
--  +----------------------------+
CX_NORMAL_EXIT:
	IF @mediaCursorFlag = 1
	BEGIN
			CLOSE		mediaCursor
			DEALLOCATE	mediaCursor
	END
	COMMIT	TRANSACTION
	SELECT	@checkTransaction = @@ERROR
	IF		@checkTransaction != 0
	BEGIN
			SET @retVal = @checkTransaction
			SET @errorString = @errorString + 'fail to commit transaction'
	END
	IF		@retVal = 0
	BEGIN
			SET @errorString = ''
	END
	SELECT	@retVal, @errorString
	RETURN	@retVal;
--  +----------------------------+
--  |   ABNORMAL, "ERROR" EXIT:  |
--  +----------------------------+
CX_ERROR_EXIT:
	DROP TABLE #tmMediaListtmp
	IF @mediaCursorFlag = 1
	BEGIN
			CLOSE		mediaCursor
			DEALLOCATE	mediaCursor
	END
	ROLLBACK	TRANSACTION
	SELECT	@checkTransaction = @@ERROR
	IF		@checkTransaction != 0
	BEGIN
			SET @retVal = @checkTransaction
			SET @errorString = @errorString + 'fail to rollback transaction'
	END
	IF		@retVal = 0
	BEGIN
			SET	@retVal = @retValFlag
	END
	SELECT	@retVal, @errorString
	RETURN	@retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'RunTMHistoryCommand')
	delete from GxQscripts where name = 'RunTMHistoryCommand'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RunTMHistoryCommand')
	delete from GXDBVersions where aliasname = 'RunTMHistoryCommand'
GO

insert into GXDBVersions values(2, 'RunTMHistoryCommand',  '00010025030200020000', 'RunTMHistoryCommand', '00010025030200020000')
GO

