

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RssPublishFeeds.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RssPublishFeeds.sp,v $ $Id: RssPublishFeeds.sp,v 1.7.278.1 2018/03/27 08:15:11 jiechen Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   RssPublishFeeds   - Generate feeds from RssItem table and prune if necessary
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RssPublishFeeds <<<'

IF EXISTS (select * from sysobjects where name='RssPublishFeeds')
	drop procedure RssPublishFeeds
IF EXISTS (select * from GxQscripts where name='RssPublishFeeds')
	delete from GxQscripts where name = 'RssPublishFeeds'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RssPublishFeeds')
	delete from GXDBVersions where aliasname = 'RssPublishFeeds'
GO
print '... Creating Procedure: RssPublishFeeds'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RssPublishFeeds
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @channelId integer,
  @retVal INT  OUTPUT
AS
  DECLARE @xmlFeed XML
BEGIN
DECLARE @str nvarchar (1024)
DECLARE @rssRefreshString NVARCHAR (64)
DECLARE @rssRefreshValue NVARCHAR(max)
DECLARE @baseUrlKey NVARCHAR(64)
DECLARE @baseUrl NVARCHAR(max)
SET @rssRefreshString = 'Notification RSS Feed Refresh Time Minutes'
SET @baseUrlKey = 'RSS Base URL'
SELECT @rssRefreshValue = GXGlobalParam.value from GXGlobalParam where GXGlobalParam.name = @rssRefreshString
IF(@rssRefreshValue is null)
 set @rssRefreshValue = '5'
SELECT @baseUrl =  GXGlobalParam.value from GXGlobalParam where GXGlobalParam.name = @baseUrlKey
IF(@baseUrl IS NULL)
SET @baseUrl = ''
SELECT @str = feedLocation from RssChannel where channelID = @channelId
-------------------
---    BEGIN    ---
-------------------
SET @xmlFeed =
	(SELECT '<?xml version="1.0" encoding="utf-16" ?>' +
	(SELECT
	'2.0' aS '@version',
		(SELECT
		 Host_Name() + ':' + LEFT(@str,CHARINDEX('.', @str)-1) as title,
		 @baseUrl+ '/' + feedLocation  as link,
		 @rssRefreshValue as ttl,
			(SELECT
			 title as title,
			 link as link,
			 source as source,
			 LEFT(DATENAME(dw, dbo.GetDateTime(triggerTime)),3) + ', ' +
			 STUFF(CONVERT(nvarchar,dbo.GetDateTime(triggerTime),113),21,4,' GMT') as pubDate,
			 RssFeedItemList.description as description,
			 name as category
			 FROM RSSItem as RssFeedItemList, NTNotificationRule as NotificationList , NTCategory as categoryList where RssFeedItemList.channelID = @channelId AND RssFeedItemList.externID = NotificationList.id AND NotificationList.categoryId = categoryList.id ORDER BY RssFeedItemList.triggerTime DESC,RssFeedItemList.link DESC
			 FOR XML PATH('item'), TYPE
			 )
		 FROM RSSChannel as RssCh where RssCh.channelID = @channelId
		 FOR XML PATH('channel'), TYPE
		)
	 FOR XML PATH('rss')
	)
	)
SET @retVal = @@error
if (@retVal = 0)
	UPDATE RSSChannel SET publish = 0 where channelID = @channelId		-- reset the flag
SELECT @xmlFeed
END
-------------------
---     END     ---
-------------------
GO

IF EXISTS (select * from GxQscripts where name = 'RssPublishFeeds')
	delete from GxQscripts where name = 'RssPublishFeeds'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RssPublishFeeds')
	delete from GXDBVersions where aliasname = 'RssPublishFeeds'
GO

insert into GXDBVersions values(2, 'RssPublishFeeds',  '00010007027800010000', 'RssPublishFeeds', '00010007027800010000')
GO

