

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RssPruneFeeds.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RssPruneFeeds.sp,v $ $Id: RssPruneFeeds.sp,v 1.4.278.1 2018/03/27 08:18:16 jiechen Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   RssPruneFeeds   - Generate feeds from RssItem table and prune if necessary
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RssPruneFeeds <<<'

IF EXISTS (select * from sysobjects where name='RssPruneFeeds')
	drop procedure RssPruneFeeds
IF EXISTS (select * from GxQscripts where name='RssPruneFeeds')
	delete from GxQscripts where name = 'RssPruneFeeds'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RssPruneFeeds')
	delete from GXDBVersions where aliasname = 'RssPruneFeeds'
GO
print '... Creating Procedure: RssPruneFeeds'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RssPruneFeeds
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @maxFeedCount integer,
  @maxdays integer,
  @retVal INT  OUTPUT
AS
DECLARE @now			DATETIME
DECLARE @channelID integer
DECLARE @itemTitle nvarchar(MAX)
DECLARE @link  nvarchar(MAX)
DECLARE @source nvarchar(MAX)
DECLARE @triggerTime integer
DECLARE @description nvarchar(MAX)
DECLARE @filter integer
DECLARE @externId integer
DECLARE @status integer
DECLARE @count integer
DECLARE @tempChannelID integer
SET @now = GETDATE()
-------------------
---    BEGIN    ---
-------------------
BEGIN TRAN
-- Remove the previously set entries that are to be removed
DELETE FROM RssItem where status = 1
DELETE FROM RssChannel where refCount = 0
-- PRUNE entries that have been long enough as determined by the user
UPDATE RssItem set status = 1 where DATEDIFF(dd, @now, dbo.GetDateTime(triggerTime)) > @maxdays
-- PRUNE entries as there are too many feeds for this channel as determined by the user
DECLARE tmpRssChannelCursor CURSOR FOR
SELECT channelID from RssChannel where feedCount > @maxFeedCount
OPEN tmpRssChannelCursor
FETCH NEXT FROM tmpRssChannelCursor INTO @channelID
WHILE @@FETCH_STATUS = 0
BEGIN
DECLARE tmpRssPruneCursor CURSOR  FOR
SELECT title,link,source,description,channelId,externId,filter,status,triggerTime from RssItem where channelID IN (@channelID)
ORDER BY RssItem.triggerTime DESC
OPEN tmpRssPruneCursor
FETCH NEXT FROM tmpRssPruneCursor INTO @itemTitle, @link, @source, @description,@tempChannelID,@externId,@filter,@status,@triggerTime
SET @count = 1
WHILE @@FETCH_STATUS = 0
BEGIN
		SET @count = @count + 1
		if (@count > @maxFeedCount)
		UPDATE RssItem set status = 1 WHERE link = @link;
		FETCH NEXT FROM tmpRssPruneCursor INTO @itemTitle, @link, @source, @description,@tempChannelID,@externId,@filter,@status,@triggerTime
END
CLOSE tmpRssPruneCursor
DEALLOCATE tmpRssPruneCursor
FETCH NEXT FROM tmpRssChannelCursor INTO @channelID
END
CLOSE tmpRssChannelCursor
DEALLOCATE tmpRssChannelCursor
-- Update the feedCount, publish flag
UPDATE RssChannel SET publish = 1, feedCount = (SELECT count(*) FROM RssItem where RssItem.channelID = RssChannel.channelID), oldestTime = (SELECT min(triggerTime) FROM RssItem where RssItem.channelID = RssChannel.channelID) where RssChannel.channelID in
(SELECT RssChannel.channelID from RssItem, RssChannel where RssItem.channelID = RssChannel.channelID
 GROUP BY RssChannel.channelID, RssChannel.feedCount
 HAVING RssChannel.feedCount <> count(*))
SET @retVal = @@error
	if (@retVal = 0)
		COMMIT TRAN
	else
		ROLLBACK TRAN
-------------------
---     END     ---
-------------------
GO

IF EXISTS (select * from GxQscripts where name = 'RssPruneFeeds')
	delete from GxQscripts where name = 'RssPruneFeeds'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RssPruneFeeds')
	delete from GXDBVersions where aliasname = 'RssPruneFeeds'
GO

insert into GXDBVersions values(2, 'RssPruneFeeds',  '00010004027800010000', 'RssPruneFeeds', '00010004027800010000')
GO

