

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptgetClientNameList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptgetClientNameList')
BEGIN
	print '>>> Drop Stored Procedure: RptgetClientNameList <<<'
	drop procedure RptgetClientNameList
END
IF EXISTS (select * from GxQscripts where name='RptgetClientNameList')
	delete from GxQscripts where name = 'RptgetClientNameList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptgetClientNameList')
	delete from GXDBVersions where aliasname = 'RptgetClientNameList'
GO
print '... Creating Procedure: RptgetClientNameList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptgetClientNameList
  @i_jobId integer
-- Following are the "columns" returned, in the order in which they are returned
--		clientId	  	integer
--		clientName 	  	char(MAX_VARCHAR_SIZE)
--		ownerName		char(1024)
--		emails			char(1024)
AS
  DECLARE @r_clientId integer
  DECLARE @r_clientName nvarchar(255)
  DECLARE @r_ownerName nvarchar(1024)
  DECLARE @r_emails nvarchar(1024)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @tblClientGrps	TABLE (id int)
DECLARE @xmlText XML;
DECLARE @handle INT;
DECLARE @includeAll INT;
DECLARE @includeOutlookAddinClients INT;
SET @xmlText = (SELECT dbo.GetXMLJobOptions(@i_jobid))
EXEC sp_xml_preparedocument @handle OUTPUT, @xmlText
SET @includeOutlookAddinClients		= dbo.GetOptionInt(1742658279, @i_jobId, 0, 0)
DECLARE @clientList TABLE
(
	clientId int,
clientName nvarchar(255),
	deleted int
)
DECLARE @ownersList	TABLE
(
	clientId int,
	ownerId  int,
	ownerName nvarchar(1024) DEFAULT NULL,
	emails nvarchar(1024) DEFAULT NULL
)
SET @includeAll = ISNULL((SELECT TOP 1 includeAll FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/reportOption/computerSelectionList', 1) WITH (includeAll int)), 0)
IF @includeAll = 1	--all clients selected
	BEGIN
		-- Get all the client List
		INSERT INTO @clientList
			SELECT id, name, 0
			FROM	APP_Client C INNER JOIN App_Platform P ON
			C.id = P.clientId AND P.platformType = 4
		WHERE C.specialClientFlags & 0x1 = 0
		-- Return " non deleted" clients, set the "isDeleted" column (below) to false
		UPDATE @clientList
		SET deleted  = 1
		WHERE EXISTS	(
						SELECT attrVal FROM APP_ClientProp
						WHERE componentNameId = clientId
						AND attrName='platformdeleted 4'
						AND modified =0 AND attrVal = '1'
					)
		DELETE FROM @clientList WHERE deleted = 1
		INSERT INTO @ownersList
			SELECT DISTINCT UUG.clientId, id, name, NULL
			FROM @clientList C
			INNER JOIN sec_getClientOwners(1) UUG
			ON UUG.clientId = C.clientId
			INNER JOIN UMUsers U
			ON U.id = UUG.userId
		UPDATE @ownersList
		SET emails  = ISNULL(dbo.getclientownersemails(W.ownerId), NULL)
		FROM @ownersList W
		INSERT INTO @ownersList
			SELECT DISTINCT clientId, 0, NULL, NULL
			FROM @clientList C WHERE C.clientId NOT IN (SELECT UUG.clientId
														FROM sec_getClientOwners(1) UUG INNER JOIN UMUsers U
														ON UUG.userID = U.id)
	END
ELSE	--some clients selected
	BEGIN
		INSERT INTO @clientList
		SELECT clientId, name, 0 FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/reportOption/computerSelectionList/clientList', 1) WITH (clientId int), APP_Client where clientId = id
		INSERT INTO @tblClientGrps
		SELECT clientGroupId FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/reportOption/computerSelectionList/clientGroupList', 1) WITH (clientGroupId int)
		INSERT INTO @clientList
		SELECT clientId, name, 0 FROM APP_ClientGroupAssoc, App_client WHERE clientGroupId in (SELECT id FROM @tblClientGrps)
		AND clientId = id
		INSERT INTO @ownersList
			SELECT DISTINCT UUG.clientId, id, name, NULL
			FROM @clientList C
			INNER JOIN sec_getCLientOwners(1) UUG
			ON UUG.clientId = C.clientId
			INNER JOIN UMUsers U
			ON U.id = UUG.userId
		UPDATE @ownersList
		SET emails  = ISNULL(dbo.getclientownersemails(W.ownerId), NULL)
		FROM @ownersList W
		INSERT INTO @ownersList
			SELECT DISTINCT clientId, 0, NULL, NULL
			FROM @clientList C WHERE C.clientId NOT IN (SELECT UUG.clientId
														FROM sec_getClientOwners(1) UUG INNER JOIN UMUsers U
														ON UUG.userID = U.id )
	END
EXIT_OUT:
SET NOCOUNT OFF
SELECT W.clientId, CL.displayName as clientName, W.ownerName, W.emails
	FROM  @ownersList W
	INNER JOIN @clientList C  ON W.clientId = C.clientId
	INNER JOIN  APP_Client CL ON CL.id = C.clientId
	ORDER BY W.ownerName DESC
GO

IF EXISTS (select * from GxQscripts where name = 'RptgetClientNameList')
	delete from GxQscripts where name = 'RptgetClientNameList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptgetClientNameList')
	delete from GXDBVersions where aliasname = 'RptgetClientNameList'
GO

insert into GXDBVersions values(2, 'RptgetClientNameList',  '00000000000000000000', 'RptgetClientNameList', '00000000000000000000')
GO

