

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptUpdateSLAExclusion.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptUpdateSLAExclusion.sp,v $ $Id: RptUpdateSLAExclusion.sp,v 1.1.2.22.6.1 2021/03/20 05:41:19 junlu Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptUpdateSLAExclusion')
BEGIN
	print '>>> Drop Stored Procedure: RptUpdateSLAExclusion <<<'
	drop procedure RptUpdateSLAExclusion
END
IF EXISTS (select * from GxQscripts where name='RptUpdateSLAExclusion')
	delete from GxQscripts where name = 'RptUpdateSLAExclusion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptUpdateSLAExclusion')
	delete from GXDBVersions where aliasname = 'RptUpdateSLAExclusion'
GO
print '... Creating Procedure: RptUpdateSLAExclusion'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptUpdateSLAExclusion
-- Stored Procedure Inputs
  @IsEDC INT = 0
AS
SET NOCOUNT ON
DECLARE @TblCommCell TABLE (id INT)
IF @IsEDC > 0
	INSERT INTO @TblCommCell SELECT id FROM APP_CommCell WHERE type >= 100
ELSE
IF EXISTS (SELECT 1 FROM APP_CommCell WHERE id > 2)
    INSERT INTO @TblCommCell
    SELECT  DISTINCT origCCId
    FROM    APP_Application A WITH (NOLOCK)
            INNER JOIN (SELECT DISTINCT appId FROM JMBkpStats WITH (NOLOCK) WHERE commCellId = 2) S ON A.id = S.appId
ELSE
	INSERT INTO @TblCommCell SELECT 2
DECLARE @CS_SLADays	INT = 30
SELECT	@CS_SLADays = longVal
FROM	APP_ComponentProp WITH (NOLOCK)
WHERE	componentType = 1 AND componentId = 2 AND propertyTypeId = 3300 AND modified = 0
-- ClientType: 1 for Server, 2 for Laptop, 4 for VM
IF OBJECT_ID('tempdb.dbo.#tblClient') IS NOT NULL DROP TABLE #tblClient
CREATE TABLE #tblClient	(ClientId INT, ClientGroupId INT, ClientType INT, vsaAppId INT, Category INT)
IF OBJECT_ID('tempdb.dbo.#tblSubclient') IS NOT NULL DROP TABLE #tblSubclient
CREATE TABLE #tblSubclient (ClientId INT, AppTypeId INT, InstanceId INT, BackupsetId INT, AppId INT, Category INT)
IF OBJECT_ID('tempdb.dbo.#VSASubclient') IS NOT NULL DROP TABLE #VSASubclient
CREATE TABLE #VSASubclient (ClientId INT, AppTypeId INT, InstanceId INT, BackupsetId INT, AppId INT, Category INT, PlanId INT)
IF OBJECT_ID('tempdb.dbo.#SLAExclusion') IS NOT NULL DROP TABLE #SLAExclusion
CREATE TABLE #SLAExclusion (clientId INT, clientGroupId INT, appTypeId INT, instanceId INT, backupsetId INT, appId INT, category INT, slaDays INT, planId INT)
-- Only installed clients and active VMs are counted for SLA. All these clients and VMs should be shown as Met SLA or Missed SLA or Excluded.
-- Installed clients
INSERT	INTO #tblClient
SELECT	DISTINCT C.id, 0, 1+(C.status&0x1000)/0x1000, 0, 0
FROM	APP_Client C WITH (NOLOCK)
		INNER JOIN @TblCommCell CC ON C.origCCId = CC.id
		INNER JOIN APP_IDAName I WITH (NOLOCK) ON C.id = I.clientId AND (I.status&(2|4) = 0 OR I.appTypeId = 106 OR @IsEDC > 0)
		LEFT OUTER JOIN APP_ClientProp CP WITH (NOLOCK)
			ON C.id = CP.componentNameId AND CP.attrName = 'PlatformDeleted 4' AND CP.attrVal = '1' AND CP.modified = 0
WHERE	C.id > 1 AND (C.specialClientFlags&1 <> 1 OR @IsEDC > 0) AND (CP.componentNameId IS NULL OR I.appTypeId = 106 OR @IsEDC > 0)
-- Remove the physical machine on the cluster CS
DELETE FROM #tblClient WHERE ClientId IN (SELECT PMClientId FROM APP_VMToPMMap WITH (NOLOCK) WHERE VMClientId = 2)
-- Active VMs
INSERT	INTO #tblClient
SELECT	DISTINCT C.id, 0, 4, 0, 0
FROM	APP_Client C WITH (NOLOCK)
		INNER JOIN (
			SELECT	DISTINCT Q.clientId
			FROM	JMQinetixUpdateStatus Q WITH (NOLOCK)
					INNER JOIN JMBkpStats B WITH (NOLOCK) ON B.jobId = Q.jobId AND B.commCellId = Q.commCellId
							 AND B.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
							 AND B.bkpLevel IN (1, 2, 4, 256, 1024, 32768)
					INNER JOIN @TblCommCell CC ON B.commCellId = CC.id
			) VM ON C.id = VM.clientId
		INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON C.id = CP.componentNameId
			AND	CP.attrName = 'Virtual Server Discovered Clients' AND CP.attrVal = '1' AND CP.modified =0
		LEFT OUTER JOIN (
			SELECT	DISTINCT componentNameId
			FROM	APP_ClientProp WITH (NOLOCK)
			WHERE	attrName = 'Virtual Machine Deletion Time' AND ISNULL(attrVal, '0') <> '0' AND modified = 0
		) T ON C.id = T.componentNameId
WHERE	T.componentNameId IS NULL
CREATE INDEX Idx_tblClient_ClientId ON #tblClient(ClientId)
-- VMs de-configured at client level
UPDATE	T SET Category = 7
FROM	#tblClient T
		INNER JOIN APP_Client CL WITH (NOLOCK) ON T.ClientId = CL.id AND CL.status&(2|4) > 0
		INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON T.ClientId = CP.componentNameId
			AND CP.attrName = 'IndexingV2_VSA' AND CP.attrVal = '1' AND CP.modified = 0
WHERE	T.ClientType = 4
-- Exclude CommServe Failover clients
UPDATE	T SET Category = 11
FROM	#tblClient T
		INNER JOIN (
			SELECT	DISTINCT clientId
			FROM	App_Application WITH (NOLOCK)
WHERE	clientId IN (SELECT DISTINCT ClientId FROM simInstalledPackages WITH (NOLOCK) WHERE simPackageId IN (24, 1024))
AND appTypeId = 81
		) F ON T.ClientId = F.clientId
UPDATE	T SET Category = 11
FROM	#tblClient T
		INNER JOIN APP_Client CL WITH (NOLOCK) ON T.ClientId = CL.id
WHERE	(CL.specialClientFlags & 34) = 34 -- Pseudo Commserve Client
		OR (CL.specialClientFlags & 2) > 0 AND (CL.name LIKE '%_AnalyticsServer' OR CL.name LIKE '%_IndexServer')
		OR (CL.status & 268435456) > 0 -- Edge Drive Pseudo Client
		OR CL.simOperatingSystemId = 117 -- Reference Copy Client
		OR CL.id IN (SELECT componentNameId FROM APP_ClientProp WITH (NOLOCK) WHERE attrName = 'Content Index Server' AND attrVal = '1')
		OR CL.id IN (SELECT CAST(attrVal AS INT) FROM APP_ClientProp WITH (NOLOCK) WHERE attrName = 'Physical Client Id' AND modified = 0 AND componentNameId IN (
			SELECT componentNameId FROM APP_ClientProp WITH (NOLOCK) WHERE attrName = 'User Centric Client' AND modified = 0 AND CAST(attrVal AS INT) = 1))
INSERT	INTO #SLAExclusion
SELECT	ClientId, 0, 0, 0, 0, 0, Category, @CS_SLADays, 0
FROM	#tblClient
WHERE	Category IN (7, 11)
-- VSA Discover Subclient ID is saved in APP_ClientProp for V2
UPDATE	T SET vsaAppId = S.vsaAppId
FROM	#tblClient T
		INNER JOIN (
		SELECT	CP.componentNameId AS ClientId, CAST(CP.attrVal AS INT) AS vsaAppId,
				ROW_NUMBER() OVER (PARTITION BY CP.componentNameId ORDER BY CP.id DESC) AS RowNo
		FROM	#tblClient C INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON C.ClientId = CP.componentNameId
			AND	CP.attrName = 'Last Backup Subclient' AND CP.modified =0
		WHERE	C.ClientType = 4 AND C.vsaAppId = 0
		) S ON T.ClientId = S.ClientId
WHERE	RowNo = 1 AND T.ClientType = 4
-- For VMs discovered before V2
UPDATE	T SET vsaAppId = BKP.appId
FROM	#tblClient T
		INNER JOIN (
			SELECT	J.clientId, MAX(J.jobId) AS jobId, J.commCellId
			FROM	JMQinetixUpdateStatus J WITH (NOLOCK)
					INNER JOIN JMBkpStats B WITH (NOLOCK) ON B.jobId = J.jobId AND B.commCellId = J.commCellId
			GROUP BY J.clientId, J.commCellId
		) QUS ON T.ClientId = QUS.clientId
		INNER JOIN JMBkpStats BKP WITH (NOLOCK) ON BKP.jobId = QUS.jobId AND BKP.commCellId = QUS.commCellId
WHERE	T.ClientType = 4 AND T.vsaAppId = 0
-- Excluded from SLA at client Group or client level
INSERT	INTO #SLAExclusion
SELECT	C.ClientId, C.ClientGroupId, 0, 0, 0, 0, 8, @CS_SLADays, 0
FROM	#tblClient T
		INNER JOIN (
		SELECT	CGA.ClientId, MAX(CGA.ClientGroupId) AS ClientGroupId
		FROM	APP_ComponentProp CP WITH (NOLOCK)
				INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON CGA.ClientGroupId = CP.componentId
WHERE	CP.componentType = 8 AND CP.propertyTypeId = 3301 AND CP.longVal = 1 AND CP.modified = 0
		GROUP BY CGA.ClientId
		) C ON T.ClientId = C.ClientId
		LEFT OUTER JOIN #SLAExclusion E ON T.ClientId = E.clientId
WHERE	E.clientId IS NULL
INSERT	INTO #SLAExclusion
SELECT	T.ClientId, 0, 0, 0, 0, 0, 8, @CS_SLADays, 0
FROM	#tblClient T
		INNER JOIN (
		SELECT componentNameId FROM APP_ClientProp WITH (NOLOCK) WHERE attrName = 'Exclude From SLA' AND attrVal = '1' AND modified = 0
		) C ON T.ClientId = C.componentNameId
		LEFT OUTER JOIN #SLAExclusion E ON T.ClientId = E.clientId
WHERE	E.clientId IS NULL
-- Laptops Excluded from SLA at plan level
INSERT	INTO #SLAExclusion
SELECT	T.ClientId, 0, 0, 0, 0, 0, 8, @CS_SLADays, P.componentNameId
FROM	#tblClient T
		INNER JOIN APP_ClientProp C WITH (NOLOCK) ON T.ClientId = C.componentNameId
AND C.attrName = 'Associated Plan' AND C.modified = 0
		INNER JOIN APP_PlanProp P WITH (NOLOCK) ON P.componentNameId = CAST(C.attrVal AS INT)
AND P.attrName = 'SLA option excluded' AND P.attrVal = '1' AND P.modified = 0
		LEFT OUTER JOIN #SLAExclusion E ON T.ClientId = E.clientId
WHERE	E.clientId IS NULL
-- Backup Activity is disabled at client group or client level
IF @IsEDC = 0
BEGIN
	INSERT	INTO #SLAExclusion
	SELECT	C.ClientId, CGA.ClientGroupId, 0, 0, 0, 0, 5, @CS_SLADays, 0
	FROM	#tblClient C
			INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON C.ClientId = CGA.clientId
			INNER JOIN JMJobAction J WITH (NOLOCK) ON CGA.clientGroupId = J.clientGroupId
				AND J.clientGroupId > 0 AND J.ClientId = 1 AND J.AppType = 0 AND J.AppId = 1
				AND J.opType = 4 AND J.action = 1
			LEFT OUTER JOIN #SLAExclusion E ON C.ClientId = E.clientId
	WHERE	E.clientId IS NULL
	INSERT	INTO #SLAExclusion
	SELECT	C.ClientId, 0, 0, 0, 0, 0, 5, @CS_SLADays, 0
	FROM	#tblClient C
			INNER JOIN JMJobAction J WITH (NOLOCK) ON J.opType = 4 AND J.action = 1
				AND J.clientId = C.ClientId AND J.appType = 0
			LEFT OUTER JOIN #SLAExclusion E ON C.ClientId = E.clientId
	WHERE	E.clientId IS NULL
END
-- Get subclients that client is not excluded or disabled
INSERT	INTO #tblSubclient
SELECT	A.clientId, A.appTypeId, A.instance, A.backupSet, A.id, 0
FROM	APP_Application A WITH (NOLOCK)
		INNER JOIN #tblClient C ON A.clientId = C.ClientId AND C.ClientType IN (1, 2)
		LEFT OUTER JOIN #SLAExclusion E ON C.ClientId = E.clientId
WHERE	A.subClientStatus&(16|32) = 0 AND A.appTypeId < 600 AND A.appTypeId NOT IN (72, 84, 85, 107, 121, 122, 127) AND (A.appTypeId NOT IN (24, 25, 40, 47, 48, 50, 65, 66, 67, 68, 73, 75, 76) OR A.subClientStatus&8 = 0)
	AND (@IsEDC > 0 OR (A.subclientStatus & 6) = 0)
	AND A.id NOT IN (SELECT componentNameId FROM APP_subclientProp WITH (NOLOCK)
			WHERE attrName IN ('DDB Backup', 'Index SubClient', 'SILO Copy ID') AND attrVal <> '0' AND modified = 0)
	AND E.clientId IS NULL
UNION
SELECT	C.clientId, 106, 0, 0, 0, 0
FROM	#tblClient C
		LEFT OUTER JOIN #SLAExclusion E ON C.ClientId = E.clientId
WHERE	C.ClientType = 4 AND E.clientId IS NULL
CREATE INDEX Idx_tblSubclient_ClientId ON #tblSubclient(ClientId)
CREATE INDEX Idx_tblSubclient_AppId ON #tblSubclient(AppId)
-- Remove instances of Migrated SRM Agent
DELETE	#tblSubclient
FROM	APP_InstanceName INST WITH (NOLOCK)
WHERE	#tblSubclient.InstanceId = INST.id AND (INST.status & 2048) <> 0
-- Remove all dummy instances of UNIX DB agents
DELETE	#tblSubclient
FROM	APP_InstanceName INST WITH (NOLOCK)
WHERE	#tblSubclient.InstanceId = INST.id AND (INST.status & 16) <> 0
	AND #tblSubclient.AppTypeId IN (3,22,37,61,62,79,80,103,104,128,135)
-- Remove all dummy backupsets of UNIX DB agents
DELETE	#tblSubclient
FROM	APP_BackupSetName BS WITH (NOLOCK)
WHERE	#tblSubclient.BackupsetId = BS.id AND (BS.status & 16) <> 0
	AND #tblSubclient.AppTypeId IN (3,22,37,61,62,79,80,103,104,128,135)
-- Remove all hidden backupsets of SAP HANA agents
DELETE	#tblSubclient
FROM	APP_BackupSetName BS WITH (NOLOCK)
WHERE	#tblSubclient.BackupsetId = BS.id AND (BS.status & 32) <> 0
	AND #tblSubclient.AppTypeId = 135
-- Remove subclients with no mailbox associated for new exchange agent (appType 137)
DELETE	T
FROM	#tblSubclient T
		LEFT OUTER JOIN APP_EmailConfigPolicyAssoc E WITH (NOLOCK) ON T.AppId = E.subClientId
WHERE	T.AppTypeId = 137 AND E.subClientId IS NULL
-- Remove all subclients of de-configured agents
DELETE	T
FROM	#tblSubclient T
		INNER JOIN APP_iDAName I WITH (NOLOCK) ON T.ClientId = I.clientId AND T.AppTypeId = I.appTypeId
WHERE	I.status&(2|4) > 0
-- Subclients excluded from SLA at plan level
INSERT	INTO #SLAExclusion
SELECT	T.ClientId, 0, T.AppTypeId, T.InstanceId, T.BackupsetId, 0, 8, @CS_SLADays, P.componentNameId
FROM	#tblSubclient T
		INNER JOIN APP_BackupsetProp S WITH (NOLOCK) ON T.AppId = S.componentNameId
AND S.attrName = 'Associated Plan' AND S.modified = 0
		INNER JOIN APP_PlanProp P WITH (NOLOCK) ON P.componentNameId = CAST(S.attrVal AS INT)
AND P.attrName = 'SLA option excluded' AND P.attrVal = '1' AND P.modified = 0
		LEFT OUTER JOIN #SLAExclusion E ON T.ClientId = E.clientId AND E.Category = 8
WHERE	E.clientId IS NULL
-- Subclients excluded from SLA at plan level
INSERT	INTO #SLAExclusion
SELECT	T.ClientId, 0, T.AppTypeId, T.InstanceId, T.BackupsetId, T.AppId, 8, @CS_SLADays, P.componentNameId
FROM	#tblSubclient T
		INNER JOIN APP_SubclientProp S WITH (NOLOCK) ON T.AppId = S.componentNameId
AND S.cs_attrName = CHECKSUM(N'Associated Plan')
AND S.attrName = 'Associated Plan' AND S.modified = 0
		INNER JOIN APP_PlanProp P WITH (NOLOCK) ON P.componentNameId = CAST(S.attrVal AS INT)
AND P.attrName = 'SLA option excluded' AND P.attrVal = '1' AND P.modified = 0
		LEFT OUTER JOIN #SLAExclusion E ON T.ClientId = E.clientId
			AND E.BackupsetId IN (0, T.BackupsetId) AND E.Category = 8
WHERE	E.clientId IS NULL
-- Excluded from SLA at subclient level
INSERT	INTO #SLAExclusion
SELECT	T.ClientId, 0, T.AppTypeId, T.InstanceId, T.BackupsetId, T.AppId, 8, @CS_SLADays, 0
FROM	#tblSubclient T
		INNER JOIN APP_SubclientProp S WITH (NOLOCK) ON T.AppId = S.componentNameId
			AND S.attrName = 'Exclude From SLA' AND S.attrVal = '1' AND S.modified = 0
		LEFT OUTER JOIN #SLAExclusion E ON T.ClientId = E.clientId
			AND E.BackupsetId IN (0, T.BackupsetId) AND E.BackupsetId IN (0, T.BackupsetId) AND E.Category = 8
WHERE	E.clientId IS NULL
-- Backup Activity is disabled at agent, instance or subclient level
IF @IsEDC = 0
BEGIN
	INSERT	INTO #SLAExclusion
	SELECT	S.ClientId, 0, S.AppTypeId, 0, 0, 0, 5, @CS_SLADays, 0
	FROM	#tblSubclient S
			INNER JOIN JMJobAction J WITH (NOLOCK)
				ON J.clientId = S.ClientId AND J.appType = S.AppTypeId
				AND J.opType = 4 AND J.action = 1
			LEFT OUTER JOIN #SLAExclusion E ON S.ClientId = E.clientId AND E.Category = 5
	WHERE	E.clientId IS NULL
	GROUP BY S.ClientId, S.AppTypeId
	INSERT	INTO #SLAExclusion
	SELECT	S.ClientId, 0, S.AppTypeId, S.instanceId, 0, 0, 5, @CS_SLADays, 0
	FROM	#tblSubclient S
			INNER JOIN JMJobAction J WITH (NOLOCK)
				ON	J.opType = 4 AND J.action = 1
				AND J.instanceID = S.InstanceId AND J.instanceID > 1
			LEFT OUTER JOIN #SLAExclusion E ON S.ClientId = E.clientId AND E.appTypeId IN (0, S.AppTypeId) AND E.Category = 5
	WHERE	E.clientId IS NULL
	GROUP BY S.ClientId, S.AppTypeId, S.instanceId
	INSERT	INTO #SLAExclusion
	SELECT	S.ClientId, 0, S.AppTypeId, S.instanceId, S.BackupsetId, S.appId, 5, @CS_SLADays, 0
	FROM	#tblSubclient S
			INNER JOIN JMJobAction J WITH (NOLOCK)
				ON	J.opType = 4 AND J.action = 1
				AND J.appId = S.AppId
			LEFT OUTER JOIN #SLAExclusion E ON S.ClientId = E.clientId AND E.appTypeId IN (0, S.AppTypeId)
				AND E.instanceId IN (0, S.instanceId) AND E.Category = 5
	WHERE	E.clientId IS NULL
	GROUP BY S.ClientId, S.AppTypeId, S.instanceId, S.BackupsetId, S.appId
	INSERT	INTO #SLAExclusion
	SELECT	S.ClientId, 0, S.AppTypeId, S.instanceId, S.BackupsetId, S.appId, 5, @CS_SLADays, 0
	FROM	#tblSubclient S
			INNER JOIN (
				SELECT	SP.componentNameId AS appId
				FROM	JMJobAction J WITH (NOLOCK)
						INNER JOIN APP_SubclientProp AS SP WITH (NOLOCK) ON CAST(J.appId AS NVARCHAR(MAX)) = SP.attrVal
				WHERE	J.opType = 4 AND J.action = 1
						AND SP.attrName = 'Associated subclient Policy'
						AND SP.cs_attrName = CHECKSUM(N'Associated subclient Policy') AND SP.modified = 0
			) T ON S.appId = T.appId
			LEFT OUTER JOIN #SLAExclusion E ON S.ClientId = E.clientId AND E.appTypeId IN (0, S.AppTypeId)
				AND E.instanceId IN (0, S.instanceId) AND E.appId IN (0, S.appId) AND E.Category = 5
	WHERE	E.clientId IS NULL
	GROUP BY S.ClientId, S.AppTypeId, S.instanceId, S.BackupsetId, S.appId
END
-- Check for VMs excluded or disabled from VSA subclient side
INSERT	INTO #VSASubclient
SELECT	DISTINCT A.clientId, A.appTypeId, A.instance, A.backupset, A.id,
		CASE WHEN A.subclientStatus&(2|4) > 0 THEN 7 ELSE 0 END, 0
FROM	#tblClient T
		INNER JOIN APP_Application A WITH (NOLOCK) ON T.vsaAppId = A.id
		LEFT OUTER JOIN #SLAExclusion E ON T.ClientId = E.clientId
WHERE	T.ClientType = 4 AND T.vsaAppId > 0 AND E.clientId IS NULL
UPDATE	T SET Category = E.Category, PlanId = E.planId
FROM	#VSASubclient T
		INNER JOIN #SLAExclusion E ON T.clientId = E.clientId
			AND E.appTypeId IN (T.appTypeId, 0) AND E.instanceId IN (T.instanceId, 0)
			AND E.backupsetId IN (T.backupsetId, 0) AND E.appId IN (T.appId, 0)
WHERE	T.Category = 0
INSERT	INTO #SLAExclusion
SELECT	T.ClientId, 0, S.AppTypeId, S.InstanceId, S.BackupsetId, S.AppId, S.Category, @CS_SLADays, S.PlanId
FROM	#tblClient T
		INNER JOIN #VSASubclient S ON T.vsaAppId = S.AppId AND S.Category > 0
WHERE	T.vsaAppId > 0
-- Exclude Virtual Server only clients
INSERT	INTO #SLAExclusion
SELECT	C.ClientId, 0, 106, 0, 0, 0, 11, @CS_SLADays, 0
FROM	#tblClient C
		INNER JOIN APP_IDAName IDA WITH (NOLOCK) ON C.ClientId = IDA.clientId AND IDA.appTypeId = 106
		LEFT OUTER JOIN (SELECT DISTINCT clientId FROM APP_Application WITH (NOLOCK) WHERE appTypeId <> 106 AND subclientStatus&(2|4) = 0) VS ON C.ClientId = VS.clientId
		LEFT OUTER JOIN #SLAExclusion E ON C.ClientId = E.clientId
WHERE	C.clientType <> 4 AND VS.clientId IS NULL AND E.clientId IS NULL
DECLARE	@ClientGroupSLADays TABLE (clientGroupId INT, slaDays INT)
INSERT	INTO @ClientGroupSLADays
SELECT	componentId, longVal
FROM	APP_ComponentProp WITH (NOLOCK)
WHERE	componentType = 8 AND propertyTypeId = 3300 AND modified = 0
DELETE	CG
FROM	@ClientGroupSLADays CG
		INNER JOIN APP_ComponentProp CP WITH (NOLOCK)
ON CP.componentType = 8 AND CP.propertyTypeId = 3327 AND longVal = 1 AND modified = 0
IF EXISTS (SELECT 1 FROM @ClientGroupSLADays)
BEGIN
	UPDATE	T SET slaDays = S.slaDays
	FROM	#SLAExclusion T
			INNER JOIN	(
				SELECT CGA.clientId, MIN(CG.slaDays) AS slaDays
				FROM	@ClientGroupSLADays CG
					INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON CG.clientGroupId = CGA.clientGroupId
				WHERE	CGA.clientId IN (SELECT DISTINCT clientId FROM #SLAExclusion)
				GROUP BY CGA.clientId
			) S ON T.clientId = S.clientId
END
DELETE	E
FROM	#SLAExclusion E
		INNER JOIN (
			SELECT	clientId, appTypeId, instanceId, backupsetId, appId
			FROM	#SLAExclusion
			WHERE	category = 8
		) T ON E.clientId = T.clientId AND E.appTypeId = T.appTypeId AND E.instanceId = T.instanceId
			AND E.backupsetId = T.backupsetId AND E.appId = T.appId
WHERE	category <> 8
-- Repopulate RptSLAExclusion table
DELETE	FROM RptSLAExclusion
INSERT	INTO RptSLAExclusion (
		clientId, clientGroupId, appTypeId, instanceId, backupsetId, appId, category, slaDays, planId)
SELECT	clientId, clientGroupId, appTypeId, instanceId, backupsetId, appId, category, slaDays, planId
FROM	#SLAExclusion
DROP TABLE #SLAExclusion
DROP TABLE #VSASubclient
DROP TABLE #tblSubclient
DROP TABLE #tblClient
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptUpdateSLAExclusion')
	delete from GxQscripts where name = 'RptUpdateSLAExclusion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptUpdateSLAExclusion')
	delete from GXDBVersions where aliasname = 'RptUpdateSLAExclusion'
GO

insert into GXDBVersions values(2, 'RptUpdateSLAExclusion',  'v1.1.2.22.6.1', 'RptUpdateSLAExclusion', 'v1.1.2.22.6.1')
GO

