

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptStubRecallHistory.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptStubRecallHistory.sp,v $ $Id: RptStubRecallHistory.sp,v 1.31.12.5 2018/11/18 03:52:52 skatz Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "rptStubRecallHistory"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptStubRecallHistory')
BEGIN
	print '>>> Drop Stored Procedure: rptStubRecallHistory <<<'
	drop procedure rptStubRecallHistory
END
IF EXISTS (select * from GxQscripts where name='rptStubRecallHistory')
	delete from GxQscripts where name = 'rptStubRecallHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptStubRecallHistory')
	delete from GXDBVersions where aliasname = 'rptStubRecallHistory'
GO
print '... Creating Procedure: rptStubRecallHistory'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptStubRecallHistory
  @i_jobId integer
AS
  DECLARE @o_recallId integer;
  DECLARE @o_srcClientId integer;
  DECLARE @o_srcClientName nchar(255);
  DECLARE @o_destClientId integer;
  DECLARE @o_destClientName nchar(255);
  DECLARE @o_appType integer;
  DECLARE @o_appTypeName char(255);
  DECLARE @o_instance integer;
  DECLARE @o_instanceName nchar(255);
  DECLARE @o_backupSet integer;
  DECLARE @o_backupSetName nchar(255);
  DECLARE @o_size bigint;
  DECLARE @o_userName nchar(255);
  DECLARE @o_startTime integer;
  DECLARE @o_endTime integer;
  DECLARE @o_status integer;
  DECLARE @o_objectName varchar(MAX);
  DECLARE @o_srcClientGrp nvarchar(MAX);
  DECLARE @o_destClientGrp nvarchar(MAX);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userId		integer
DECLARE @startTime	integer
DECLARE @order		integer
DECLARE @endTime	integer
DECLARE @clOpt		integer
DECLARE @appTypeOpt	integer
DECLARE @tblClients	TABLE (t_clId int)
DECLARE @tblApptypes	TABLE (t_appTypeId int)
CREATE TABLE #tblJobList (t_id int,t_srcClId int,t_destClId int,t_apptypeId int,t_instId int,t_bkpSetId int)
SET @userId	= dbo.GetOptionInt(140019, @i_jobId, 0, 0)
SET @order	= dbo.GetOptionInt(705619325, @i_jobId, 0, 0)
EXEC RptOptGetTime @i_jobId, @startTime OUTPUT, @endTime OUTPUT
INSERT INTO @tblClients EXEC rptOptGetClients @i_jobId, @clOpt OUTPUT
INSERT INTO @tblApptypes EXEC rptOptGetAppTypes @i_jobId, @appTypeOpt OUTPUT
/*--skipping to allow all types of apptypes
IF @appTypeOpt = 0
BEGIN
INSERT INTO @tblAppTypes VALUES (1)
INSERT INTO @tblAppTypes VALUES (11)
INSERT INTO @tblApptypes VALUES (33)
INSERT INTO @tblAppTypes VALUES (34)
INSERT INTO @tblApptypes VALUES (42)
INSERT INTO @tblApptypes VALUES (43)
INSERT INTO @tblApptypes VALUES (45)
INSERT INTO @tblApptypes VALUES (56)
INSERT INTO @tblApptypes VALUES (57)
INSERT INTO @tblApptypes VALUES (58)
INSERT INTO @tblApptypes VALUES (66)
INSERT INTO @tblApptypes VALUES (73)
INSERT INTO @tblApptypes VALUES (82)
INSERT INTO @tblApptypes VALUES (83)
INSERT INTO @tblApptypes VALUES (90)
INSERT INTO @tblApptypes VALUES (89)
END
-- If the apptype CV_APPTYPE_WINDOWS_FILESYSTEM is present in GUI selection,
-- We must consider all the WIN FS AppTypes.
-- This I have added because I need to merge all flavours of Windows AppTypes to one
-- For backward compatibility with 8.0 and 9.0 I am adding this.
DECLARE @WindowsFSSelected INT
SET @WindowsFSSelected = CASE WHEN EXISTS (SELECT * FROM @tblAppTypes WHERE t_appTypeId = 33) THEN 1 ELSE 0 END
IF @WindowsFSSelected <> 0 AND @appTypeOpt <> 0
BEGIN
INSERT INTO @tblAppTypes VALUES (1)
INSERT INTO @tblAppTypes VALUES (11)
	--INSERT INTO @tblAppTypes VALUES (CV_APPTYPE_WINDOWS_FILESYSTEM) -- Already there
INSERT INTO @tblAppTypes VALUES (34)
INSERT INTO @tblAppTypes VALUES (42)
INSERT INTO @tblAppTypes VALUES (43)
END
*/
IF object_id('tempdb.dbo.#tblStubRecallJobs') is not null DROP TABLE #tblStubRecallJobs
SELECT	* INTO #tblStubRecallJobs
FROM	JMStubRecallJobs
WHERE	commcellId=2 AND ((CASE WHEN originalAppType = 0 THEN appType ELSE originalAppType END) in (select t_appTypeId from @tblApptypes) OR @appTypeOpt = 0) AND
	(@startTime = 0 OR itemEndTime >= @startTime) AND (@endTime = 0 OR itemStartTime <= @endTime)
IF @clOpt = 0
	INSERT INTO #tblJobList
	SELECT	DISTINCT t_id=recallId,t_srcClId=srcClientId,t_destClId=destClientId,t_apptypeId=(CASE WHEN originalAppType = 0 THEN appType ELSE originalAppType END),t_instId=instanceID,t_bkpSetId=bkpSetID
	FROM	#tblStubRecallJobs
ELSE
	INSERT INTO #tblJobList
	SELECT	DISTINCT t_id=recallId,t_srcClId=srcClientId,t_destClId=destClientId,t_apptypeId=(CASE WHEN originalAppType = 0 THEN appType ELSE originalAppType END),t_instId=instanceID,t_bkpSetId=bkpSetID
	FROM	#tblStubRecallJobs
	WHERE	srcClientId in (select t_clId from @tblClients)
--got all qualified entries, do the security check before more details and summary
DECLARE @isUserAdmin INT = 0
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
IF @userId > 0 AND @isUserAdmin = 0 AND @clOpt = 0
BEGIN
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @userId, 2009, 0, '#rptUserObjects'
	delete #rptUserObjects
	WHERE clientGroupId <> 0 OR mediaAgentId <> 0 OR libraryID <> 0 OR archGroupID <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	OR taskId <> 0
	delete #tblJobList
	WHERE 0 = (	select	count(*) from #rptUserObjects
			where	clientId in (0, t_srcClId, t_destClId) AND
				appTypeId in (0,t_apptypeId) AND
				instanceId in (0,t_instId) AND
				backupsetId in (0,t_bkpSetId))
	DROP TABLE #rptUserObjects
END
IF object_id('tempdb.dbo.#finalReturnList') IS NOT null DROP TABLE #finalReturnList
SELECT	recallId,
	t_srcClId,srcClientName=(select displayName from APP_Client where id=t_srcClId),
	t_destClId,destClientName=(select displayName from APP_Client where id=t_destClId),
	t_apptypeId,appTypeName=(select name from APP_iDAType where type=t_apptypeId),
	t_instId,instanceName=(select name from APP_InstanceName where id=t_instId),
	t_bkpSetId,backupSetName=(select name from APP_BackupSetName where id=t_bkpSetId),
	Size,UserName,itemStartTime,itemEndTime,Status,objectName, CAST(N'' AS NVARCHAR(MAX)) AS 'srcClientGrp', CAST(N'' AS NVARCHAR(MAX)) AS 'destClientGrp'
INTO	#finalReturnList
FROM	#tblJobList LEFT JOIN #tblStubRecallJobs ON t_id=RecallId
DROP TABLE #tblJobList
UPDATE	#finalReturnList
SET		srcClientGrp = V.ClientGroups
FROM	ClientGroupsStringView V
WHERE	t_srcClId = V.ClientId
UPDATE	#finalReturnList
SET		destClientGrp = V.ClientGroups
FROM	ClientGroupsStringView V
WHERE	t_destClId = V.ClientId
UPDATE #finalReturnList
SET    userName = AG.name
FROM   APP_GUID AG
WHERE  AG.GUID = '{'+#finalReturnList.userName+'}' and AG.status=8
IF @order = 9
	SELECT * FROM #finalReturnList ORDER BY srcClientName, recallId DESC
ELSE IF @order = 8
	SELECT * FROM #finalReturnList ORDER BY destClientName, recallId DESC
ELSE IF @order = 1
	SELECT * FROM #finalReturnList ORDER BY appTypeName, recallId DESC
ELSE
	SELECT * FROM #finalReturnList ORDER BY recallId DESC
DROP TABLE #finalReturnList
DROP TABLE #tblStubRecallJobs
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptStubRecallHistory')
	delete from GxQscripts where name = 'RptStubRecallHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptStubRecallHistory')
	delete from GXDBVersions where aliasname = 'RptStubRecallHistory'
GO

insert into GXDBVersions values(2, 'RptStubRecallHistory',  '00010031001200050000', 'RptStubRecallHistory', '00010031001200050000')
GO

