

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptStorageUsageByTime.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptStorageUsageByTime.sp,v $ $Id: RptStorageUsageByTime.sp,v 1.3.72.18 2020/11/18 13:05:12 junlu Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptStorageUsageByTime')
BEGIN
	print '>>> Drop Stored Procedure: RptStorageUsageByTime <<<'
	drop procedure RptStorageUsageByTime
END
IF EXISTS (select * from GxQscripts where name='RptStorageUsageByTime')
	delete from GxQscripts where name = 'RptStorageUsageByTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptStorageUsageByTime')
	delete from GXDBVersions where aliasname = 'RptStorageUsageByTime'
GO
print '... Creating Procedure: RptStorageUsageByTime'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptStorageUsageByTime
  @i_Begin DATETIME,
  @i_End DATETIME
AS
  DECLARE @retVal integer;
SET NOCOUNT ON
DECLARE @TimeRangeBegin	INT = 0
DECLARE @TimeRangeEnd	INT = 0x7FFFFFFF
DECLARE @csTimeZone		VARCHAR(256)
SELECT  @csTimeZone = timeZone FROM APP_CommCell WITH (NOLOCK) WHERE id = 2
SELECT	@csTimeZone = TimeZoneStdName
FROM	SchedTimeZone WITH (NOLOCK)
WHERE	TimeZoneName= SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)
IF ISNULL(@i_Begin, '01/01/1970') <> '01/01/1970'
	SET @TimeRangeBegin = dbo.GetUnixTime(dbo.LocalToUTCTime(@i_Begin, @csTimeZone))
IF @i_End IS NOT NULL
	SET @TimeRangeEnd	= dbo.GetUnixTime(dbo.LocalToUTCTime(@i_End, @csTimeZone))
DECLARE @ShortTimeRange INT = 0
IF (@TimeRangeEnd - @TimeRangeBegin)/3600 <= 24
	SET @ShortTimeRange = 1
/* This temp table should be created by the caller
CREATE TABLE #AppCopySize
(
	vmClientId		INT,
	appId			INT,
	copyId			INT,
	dataProtected	BIGINT,
	dataWritten		BIGINT,
	dedupRatio		FLOAT
)*/
-- Size on media of a job in a dedup copy is calculated from (app size of the job)*(average dedup ratio of the copy).
-- Size on media of a job in a non-dedup copy is retrieved from total size of archive files (totalBackupSize of JMBkpStats table).
-- Size on media of a job in a snap copy can not be calculated from app size of snap job. Use sizeOnMedia of JMJobDataStats table.
-- App size of IndexongV2 VSA snap jobs are not set correctly in totalUncompBytes of JMBkpStats table. Use vmUsedSpace of APP_VMProp table.
-- Partially copied jobs
CREATE TABLE #PartialJobSize (jobId INT, commCellId INT, appId INT, archGrpCopyId INT,
		totalAppSize BIGINT, totalBackupSize BIGINT, appSize BIGINT, backupSize BIGINT)
CREATE TABLE #VSA_AppIDs (appId INT, isIndexingV2 INT)
-- Before IndexingV2, JMJobDataStats and archFile tables only have entries of parent jobs. Count parent jobs.
-- Since IndexingV2, JMJobDataStats and archFile tables have entries of both parent and child jobs. Count child jobs.
-- Parent jobs associated with appId of IndexingV2 VSA subclients will be excluded in calcultion.
INSERT	INTO #VSA_AppIDs
SELECT	A.id, ISNULL(CP.attrVal, 0)
FROM	APP_Application A WITH (NOLOCK)
		INNER JOIN APP_InstanceProp IP WITH (NOLOCK) ON IP.componentNameId = A.instance
			AND IP.attrName = 'Virtual Server Instance Type' AND IP.attrVal <> '' AND IP.modified = 0
		LEFT OUTER JOIN APP_ClientProp CP WITH (NOLOCK) ON CP.componentNameId = A.clientId
			AND CP.attrName = 'IndexingV2_VSA' AND CP.modified = 0 AND CP.attrVal = '1'
WHERE	A.appTypeId = 106 AND A.subclientStatus&0x00020 = 0
-- IndexingV2 VSA and other iDAs
IF NOT EXISTS (SELECT 1 FROM archFileCopy WITH (NOLOCK) WHERE unCompSize < 0 AND physicalSize > 0)
BEGIN
	INSERT INTO #AppCopySize
	SELECT  0, AF.appId, AFC.archCopyId, SUM(CASE WHEN AF.fileType IN (1,4) THEN AFC.unCompSize ELSE 0 END), SUM(AFC.physicalSize), 1
	FROM	archFileCopy AFC WITH (NOLOCK)
			INNER JOIN archFile AF WITH (NOLOCK) ON AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId
			LEFT OUTER JOIN #VSA_AppIDs VA ON AF.appId = VA.appId
WHERE	AFC.unCompSize >= 0 AND AFC.physicalSize > 0 AND AFC.flags&256 = 0
		AND (AFC.isValid = 1 OR @ShortTimeRange = 0) AND AFC.modifiedTime BETWEEN @TimeRangeBegin AND @TimeRangeEnd
		AND AF.isValid = 1
		AND VA.appId IS NULL
	GROUP BY AF.appId, AFC.archCopyId
END
ELSE -- In case unCompSize is not set for some valid archFileCopy entries
BEGIN
	CREATE TABLE #CopyAppSize (appId INT, copyId INT, dataProtected BIGINT, dataWritten BIGINT)
	CREATE TABLE #JobCopyToSetAppSize (jobId INT, commCellId INT, appId INT, archGrpCopyId INT, totalAppSize BIGINT, totalBackupSize BIGINT)
	INSERT	INTO #JobCopyToSetAppSize
	SELECT  AF.jobId, AF.commCellId, AF.appId, AFC.archCopyId, 0, SUM(AFC.physicalSize)
	FROM	archFileCopy AFC WITH (NOLOCK)
			INNER JOIN archFile AF WITH (NOLOCK) ON AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId
			LEFT OUTER JOIN #VSA_AppIDs VA ON AF.appId = VA.appId
WHERE	AFC.unCompSize < 0 AND AFC.physicalSize > 0 AND AFC.flags&256 = 0
		AND (AFC.isValid = 1 OR @ShortTimeRange = 0) AND AFC.modifiedTime BETWEEN @TimeRangeBegin AND @TimeRangeEnd
		AND AF.isValid = 1
		AND VA.appId IS NULL
	GROUP BY AF.jobId, AF.commCellId, AF.appId, AFC.archCopyId
	INSERT INTO #CopyAppSize
	SELECT  AF.appId, AFC.archCopyId, SUM(CASE WHEN AF.fileType IN (1,4) THEN AFC.unCompSize ELSE 0 END), SUM(AFC.physicalSize)
	FROM	archFileCopy AFC WITH (NOLOCK)
			INNER JOIN archFile AF WITH (NOLOCK) ON AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId
			LEFT OUTER JOIN #VSA_AppIDs VA ON AF.appId = VA.appId
			LEFT OUTER JOIN (
				SELECT	F.id, F.commCellId, F.appId, J.archGrpCopyId
				FROM	archFile F WITH (NOLOCK)
						INNER JOIN #JobCopyToSetAppSize J ON F.jobId = J.jobId AND F.commCellId = J.commCellId
				) T ON AFC.archFileId = T.id AND AFC.commCellId = T.commCellId AND AFC.archCopyId = T.archGrpCopyId
WHERE	AFC.unCompSize > 0 AND AFC.physicalSize > 0 AND AFC.flags&256 = 0
		AND (AFC.isValid = 1 OR @ShortTimeRange = 0) AND AFC.modifiedTime BETWEEN @TimeRangeBegin AND @TimeRangeEnd
		AND AF.isValid = 1
		AND VA.appId IS NULL
	GROUP BY AF.appId, AFC.archCopyId
	UPDATE	T SET totalAppSize = B.totalUncompBytes,
			totalBackupSize = CASE WHEN AGC.isSnapCopy = 1 THEN T.totalBackupSize ELSE B.totalBackupSize END
	FROM	#JobCopyToSetAppSize T
			INNER JOIN JMBkpStats B WITH (NOLOCK) ON T.jobId = B.jobId AND T.commCellId = B.commCellId
			INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON T.archGrpCopyId = AGC.id
	UPDATE	T SET totalAppSize = A.totalBackupSize, totalBackupSize = A.totalBackupSize
	FROM	#JobCopyToSetAppSize T
			INNER JOIN JMAdminJobStatsTable A WITH (NOLOCK) ON T.jobId = A.jobId AND T.commCellId = A.commCellId
	INSERT	INTO #CopyAppSize
	SELECT	appId, archGrpCopyId, SUM(totalAppSize), SUM(totalBackupSize)
	FROM	#JobCopyToSetAppSize
	GROUP BY appId, archGrpCopyId
	INSERT	INTO #PartialJobSize
	SELECT	J.jobId, J.commCellId, J.appId, J.archGrpCopyId, T.totalAppSize, T.totalBackupSize, 0, 0
	FROM	JMJobDataStats J WITH (NOLOCK)
			INNER JOIN #JobCopyToSetAppSize T ON J.jobId = T.jobId AND J.commCellId = T.commCellId AND J.archGrpCopyId = T.archGrpCopyId
	WHERE	J.status <> 1000
	GROUP BY J.jobId, J.commCellId, J.appId, J.archGrpCopyId, T.totalAppSize, T.totalBackupSize
	HAVING MAX(J.status) IN (102, 103) OR MIN(J.status) = 100 AND MAX(J.status) = 101
	UPDATE	P SET backupSize = T.backupSize,
			appSize = CASE WHEN totalBackupSize > T.backupSize THEN ((1.0*T.backupSize)/totalBackupSize)*totalAppSize ELSE T.backupSize END
	FROM	#PartialJobSize P
			INNER JOIN (
				SELECT J.jobId, J.commCellId, J.archGrpCopyId, SUM(AFC.physicalSize) AS backupSize
				FROM	#PartialJobSize J
						INNER JOIN archFile AF  WITH (NOLOCK)
							ON AF.jobId = J.jobId AND AF.commCellId = J.commCellId AND AF.fileType IN (1, 4) AND AF.isValid = 1
						INNER JOIN archFileCopy AFC  WITH (NOLOCK)
							ON AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = J.archGrpCopyId
				WHERE	(AFC.isValid = 1 OR @ShortTimeRange = 0)
				GROUP BY J.jobId, J.commCellId, J.archGrpCopyId
				) T ON P.jobId = T.jobId AND P.commCellId = T.commCellId AND P.archGrpCopyId = T.archGrpCopyId AND T.backupSize > 0
	INSERT	INTO #CopyAppSize
	SELECT	appId, archGrpCopyId, -SUM(totalAppSize - appSize), -SUM(totalBackupSize - backupSize)
	FROM	#PartialJobSize
	GROUP BY appId, archGrpCopyId
	INSERT	INTO #AppCopySize
	SELECT	0, appId, copyId, SUM(dataProtected), SUM(dataWritten), 1
	FROM	#CopyAppSize
	GROUP BY appId, copyId
	DELETE FROM #PartialJobSize
	DROP TABLE #CopyAppSize
	DROP TABLE #JobCopyToSetAppSize
END
IF EXISTS (SELECT 1 FROM #VSA_AppIDs WHERE isIndexingV2 = 1)
BEGIN
	CREATE TABLE #VMSnapCopy (vmClientId INT, appId INT, copyId INT)
	UPDATE	S SET vmClientId = A.clientId
	FROM	#AppCopySize S
			INNER JOIN APP_Application A WITH (NOLOCK) ON S.appId = A.id AND A.appTypeId = 106
	-- Correct app size of snap jobs of VMs are not set in totalUncompBytes column of JMBkpStats table.
	-- The value of app size of a VM child job display in GUI is from vmUsedSpace of APP_VMProp table.
	IF @@ROWCOUNT > 0
		INSERT	INTO #VMSnapCopy
		SELECT	vmClientId, appId, copyId
		FROM	#AppCopySize AC
				INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AC.copyId = AGC.id AND AGC.isSnapCopy = 1
		WHERE	vmClientId > 0
	IF EXISTS (SELECT 1 FROM #VMSnapCopy)
	BEGIN
		UPDATE	S SET dataProtected = T.vmUsedSpace
		FROM	#AppCopySize S
				INNER JOIN (
					SELECT	VC.vmClientId, VC.appId, VC.copyId, SUM(CAST(VM.attrVal AS BIGINT)) AS vmUsedSpace
					FROM	#VMSnapCopy VC
							INNER JOIN APP_VMProp VM WITH (NOLOCK) ON VC.vmClientId = VM.VMClientId AND VM.attrName = 'vmUsedSpace'
							INNER JOIN JMJobDataStats J WITH (NOLOCK) ON VM.clientJobId = J.jobId AND VM.commCellId = J.commCellId
								AND VC.copyId = J.archGrpCopyId
WHERE	J.dataType = 1 AND J.status IN (100,102,103) AND J.disabled&256 = 0
						AND J.copiedTime BETWEEN @TimeRangeBegin AND @TimeRangeEnd
					GROUP BY VC.vmClientId, VC.appId, VC.copyId
					) T ON S.vmClientId = T.vmClientId AND S.appId = T.appId AND S.copyId = T.copyId
	END
	-- Replace child appId by parent appId. Reports display VMs with VSA info.
	UPDATE	S SET appId = J.parentAppId
	FROM	#AppCopySize S
			INNER JOIN (
				SELECT	JL.childAppId, JL.parentAppId, ROW_NUMBER() OVER (PARTITION BY JL.childAppId ORDER BY JL.childJobId DESC) AS rowId
				FROM	JMJobDataLink JL WITH (NOLOCK)
						INNER JOIN #VSA_AppIDs VA ON JL.parentAppId = VA.appId AND VA.isIndexingV2 = 1
AND JL.linkType IN (7, 8)
				) J ON S.appId = J.childAppId
	WHERE	S.vmClientId > 0 AND J.rowId = 1
	DROP TABLE #VMSnapCopy
END
-- non-IndexingV2 VSA
IF EXISTS (SELECT 1 FROM #VSA_AppIDs WHERE isIndexingV2 = 0)
BEGIN
	CREATE	TABLE #JobVMs (
		jobId INT, commCellId INT, appId INT, bkpLevel INT, startDate INT, endDate INT, vmClientId INT,
		vmStatus INT, vmFailureReason VARCHAR(512),	vmAppSize BIGINT, vmGuestSize BIGINT, vmSize BIGINT
	)
	CREATE	TABLE #VMJobCopy (
		jobId INT, archGrpCopyId INT, commCellId INT, appId INT, bkpLevel INT, startDate INT, endDate INT,
		totalUncompBytes BIGINT, totalBackupSize BIGINT, CompBytes BIGINT
	)
	CREATE	TABLE #VMJobSize (jobId INT, commCellId INT, dataRead BIGINT)
	INSERT	INTO #PartialJobSize
	SELECT	J.jobId, J.commCellId, J.appId, J.archGrpCopyId, B.totalUncompBytes, B.totalBackupSize,
			SUM(CASE WHEN J.dataType IN (1,4) THEN J.unCompSize ELSE 0 END), SUM(J.sizeOnMedia)
	FROM	JMJobDataStats J WITH (NOLOCK)
			INNER JOIN JMBkpStats B WITH (NOLOCK) ON J.jobId = B.jobId AND J.commCellId = B.commCellId
			INNER JOIN #VSA_AppIDs VA ON B.appId = VA.appId AND VA.isIndexingV2 = 0
	WHERE	J.status <> 1000 AND J.sizeOnMedia > 0
	GROUP BY J.jobId, J.commCellId, J.appId, J.archGrpCopyId, B.totalUncompBytes, B.totalBackupSize
	HAVING MAX(J.status) IN (102, 103) OR MIN(J.status) = 100 AND MAX(J.status) = 101
	UPDATE	P SET backupSize = T.backupSize,
			appSize = CASE WHEN totalBackupSize > T.backupSize THEN ((1.0*T.backupSize)/totalBackupSize)*totalAppSize ELSE T.backupSize END
	FROM	#PartialJobSize P
			INNER JOIN (
				SELECT J.jobId, J.commCellId, J.archGrpCopyId, SUM(AFC.physicalSize) AS backupSize
				FROM	#PartialJobSize J
						INNER JOIN archFile AF WITH (NOLOCK)
							ON AF.jobId = J.jobId AND AF.commCellId = J.commCellId AND AF.fileType IN (1, 4) AND AF.isValid = 1
						INNER JOIN archFileCopy AFC WITH (NOLOCK)
							ON AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = J.archGrpCopyId
				WHERE	(AFC.isValid = 1 OR @ShortTimeRange = 0)
				GROUP BY J.jobId, J.commCellId, J.archGrpCopyId
			) T ON P.jobId = T.jobId AND P.commCellId = T.commCellId AND P.archGrpCopyId = T.archGrpCopyId AND T.backupSize > 0
	INSERT INTO #VMJobCopy
	SELECT	S.jobId, S.archGrpCopyId, S.commCellId, J.appId, J.bkpLevel, J.servStartDate, J.servEndDate,
			J.totalUncompBytes, J.totalBackupSize, CASE WHEN AGC.isSnapCopy = 1 THEN SUM(S.sizeOnMedia) ELSE J.totalBackupSize END
	FROM	JMJobDataStats S WITH (NOLOCK)
			INNER JOIN JMBkpStats J WITH (NOLOCK) ON S.jobId = J.jobId AND S.commCellId = J.commCellId AND J.appType = 106
			INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON S.archGrpCopyId = AGC.id
			INNER JOIN #VSA_AppIDs VA ON J.appId = VA.appId AND VA.isIndexingV2 = 0
			LEFT OUTER JOIN #PartialJobSize P ON S.jobId = P.jobId AND S.commCellId = P.commCellId AND S.archGrpCopyId = P.archGrpCopyId
	WHERE	J.servEndDate <= @TimeRangeEnd
		AND J.status IN (1, 3, 14)
		AND J.totalBackupSize > 0
		AND S.copiedTime BETWEEN @TimeRangeBegin AND @TimeRangeEnd
AND S.status = 100 AND (S.disabled & 256) = 0
		AND	P.jobId IS NULL
	GROUP BY S.jobId, S.archGrpCopyId, S.commCellId, J.appId, J.bkpLevel, J.servStartDate, J.servEndDate,
			J.totalUncompBytes, J.totalBackupSize, AGC.isSnapCopy
	INSERT INTO #JobVMs
	SELECT	DISTINCT jobId, commCellId, appId, bkpLevel, startDate, endDate, 0, 0, '', 0, 0, 0
	FROM	#VMJobCopy
	CREATE INDEX JobVMs_jobId_commCellId_idx ON #JobVMs (jobId, commCellId)
	-- Populate #JobVMs table for non-IndexingV2 VMs and remove initial entries (with vmClientId = 0)
	EXEC AppSizeOfJobVMs 0
	UPDATE  T SET appId = S.appId
	FROM    #VMJobCopy T
			INNER JOIN (SELECT DISTINCT jobId, commCellId, appId FROM #JobVMs) S ON T.jobId = S.jobId AND T.commCellId = S.commCellId
	WHERE   T.appId <> S.appId
	INSERT INTO #VMJobSize
	SELECT	jobId, commCellId, SUM(vmAppSize)
	FROM	#JobVMs
	GROUP BY jobId, commCellId
	INSERT	INTO #AppCopySize
	SELECT	V.VMclientId, S.appId, S.archGrpCopyId,
			SUM((1.0*S.CompBytes/S.totalBackupSize)*ISNULL(1.0*V.vmAppSize/J.dataRead, 1)*S.totalUncompBytes),
			SUM(ISNULL(1.0*V.vmAppSize/J.dataRead, 1)*S.CompBytes), 1
	FROM	#VMJobCopy S
			INNER JOIN #VMJobSize J ON S.jobId = J.jobId AND S.commCellId = J.commCellId AND J.dataRead > 0
			INNER JOIN #JobVMs V ON J.jobId = V.jobId AND J.commCellId = V.commCellId
	WHERE	S.totalBackupSize > 0
	GROUP BY V.VMclientId, S.appId, S.archGrpCopyId
	DROP TABLE #JobVMs
	DROP TABLE #VMJobSize
	DROP TABLE #VMJobCopy
END
DROP TABLE #VSA_AppIDs
DROP TABLE #PartialJobSize
--------------------------------------------
-- Calculate dedup ratio of dedupe copies --
--------------------------------------------
DECLARE @latestTime DATETIME
DECLARE @type TINYINT
IF	@i_End IS NOT NULL
BEGIN
	IF	ISNULL(@i_Begin, '01/01/1970') <> '01/01/1970' AND DATENAME(DAY, @i_Begin) = '1' AND DATEDIFF(DAY, @i_Begin, @i_End) >= 28
		SELECT @type = 2, @latestTime = startDT FROM RptDedupRatios WITH(NOLOCK) WHERE startDT BETWEEN @i_Begin AND @i_End AND type = 2
	IF	@latestTime IS NULL
		SELECT @type = 1, @latestTime = MAX(startDT) FROM RptDedupRatios WITH(NOLOCK) WHERE startDT <= @i_End AND type = 1
	IF	@latestTime IS NULL
		SELECT @type = 3, @latestTime = MAX(startDT) FROM RptDedupRatios WITH(NOLOCK) WHERE startDT <= @i_End AND type = 3
	IF	@latestTime IS NULL
		SELECT @type = 2, @latestTime = MAX(startDT) FROM RptDedupRatios WITH(NOLOCK) WHERE startDT <= @i_End AND type = 2
	IF	@latestTime IS NULL
		SELECT @type = 3, @latestTime = MIN(startDT) FROM RptDedupRatios WITH(NOLOCK) WHERE startDT > @i_End AND type = 3
END
ELSE
	SELECT @type = 1, @latestTime = MAX(startDT) FROM RptDedupRatios WITH(NOLOCK) WHERE type = 1
IF	@latestTime IS NOT NULL
	UPDATE	#AppCopySize
	SET		dataWritten = #AppCopySize.dataProtected * R.dedupRatio, dedupRatio = R.dedupRatio
	FROM	RptDedupRatios R WITH(NOLOCK)
	WHERE	#AppCopySize.copyId = R.copyId AND R.startDT = @latestTime AND R.type = @type
ELSE
BEGIN
	CREATE TABLE #DedupeCopy (
		archGrpCopyId INT, activeStoreId INT, dedupeFlags INT,
		dataRead BIGINT, dataWritten BIGINT, dedupRatio FLOAT, dedupSaving DECIMAL(10,2)
	)
	EXEC DedupCopySaving 0
	UPDATE	#AppCopySize
	SET		dataWritten = #AppCopySize.dataProtected * C.dedupRatio, dedupRatio = C.dedupRatio
	FROM	#DedupeCopy C
	WHERE	#AppCopySize.copyId = C.archGrpCopyId
	DROP TABLE #DedupeCopy
END
SELECT	@retVal
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptStorageUsageByTime')
	delete from GxQscripts where name = 'RptStorageUsageByTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptStorageUsageByTime')
	delete from GXDBVersions where aliasname = 'RptStorageUsageByTime'
GO

insert into GXDBVersions values(2, 'RptStorageUsageByTime',  '00010003007200180000', 'RptStorageUsageByTime', '00010003007200180000')
GO

