

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptSetClientGroupQuotaUsage.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptSetClientGroupQuotaUsage.sp,v $ $Id: RptSetClientGroupQuotaUsage.sp,v 1.1.2.6 2018/03/27 09:17:05 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "RptGetClientGroupQuotaUsage"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptSetClientGroupQuotaUsage <<<'

IF EXISTS (select * from sysobjects where name='RptSetClientGroupQuotaUsage')
	drop procedure RptSetClientGroupQuotaUsage
IF EXISTS (select * from GxQscripts where name='RptSetClientGroupQuotaUsage')
	delete from GxQscripts where name = 'RptSetClientGroupQuotaUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSetClientGroupQuotaUsage')
	delete from GXDBVersions where aliasname = 'RptSetClientGroupQuotaUsage'
GO
print '... Creating Procedure: RptSetClientGroupQuotaUsage'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptSetClientGroupQuotaUsage
  @i_dummy integer
AS
  DECLARE @o_error INT;
SET NOCOUNT ON
/* Caller will CREATE TABLE #ClientGroupQuotaUsage
(
	clientGroupId	INT,
	ClientGroupName NVARCHAR(512),
	globalUsedGB	BIGINT,
	globalLimitGB	BIGINT,
	updateTime		TIME_T,
	quotaType		INT,
	expiryTime		TIME_T
)
*/
UPDATE	T SET clientGroupId = CG.id
FROM	#ClientGroupQuotaUsage T
		INNER JOIN APP_ClientGroup CG ON T.ClientGroupName = CG.name
UPDATE	T SET globalLimitGB = CP.longlongVal, updateTime = CP.created
FROM	#ClientGroupQuotaUsage T
		INNER JOIN APP_ComponentProp CP ON T.clientGroupId = CP.componentId AND T.quotaType = 0
WHERE	CP.componentType = 8 AND CP.propertyTypeId = 3400 AND CP.longlongVal > 0 AND CP.modified = 0
	AND T.updateTime < CP.created
SELECT @o_error = @@ERROR
IF @o_error > 0 RETURN @o_error
UPDATE	U SET globalUsedGB = T.globalUsedGB, globalLimitGB = T.globalLimitGB, updateTime = T.updateTime
FROM	RptClientGroupQuotaUsage U
		INNER JOIN #ClientGroupQuotaUsage T ON U.clientGroupId = T.clientGroupId AND U.quotaType = T.quotaType
WHERE	U.clientGroupId > 0
UPDATE	U SET globalUsedGB = T.globalUsedGB,
		globalLimitGB = CASE WHEN U.updateTime < T.updateTime THEN T.globalLimitGB ELSE U.globalLimitGB END,
		updateTime    = CASE WHEN U.updateTime < T.updateTime THEN T.updateTime ELSE U.updateTime END,
		expiryTime    = CASE WHEN U.updateTime < T.updateTime THEN T.expiryTime ELSE U.expiryTime END
FROM	RptClientGroupQuotaUsage U
		INNER JOIN #ClientGroupQuotaUsage T ON U.clientGroupId = T.clientGroupId AND U.quotaType = T.quotaType
WHERE	U.clientGroupId = 0
INSERT	INTO RptClientGroupQuotaUsage
SELECT	0, 0, T.globalUsedGB, T.globalLimitGB, T.updateTime, T.quotaType, T.expiryTime
FROM	#ClientGroupQuotaUsage T
		LEFT OUTER JOIN (SELECT quotaType FROM RptClientGroupQuotaUsage WHERE clientGroupId = 0) U ON T.quotaType = U.quotaType
WHERE	T.ClientGroupName = 'CommCell Inherited Capacity' AND U.quotaType IS NULL
SELECT @o_error = @@ERROR
RETURN @o_error
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptSetClientGroupQuotaUsage')
	delete from GxQscripts where name = 'RptSetClientGroupQuotaUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSetClientGroupQuotaUsage')
	delete from GXDBVersions where aliasname = 'RptSetClientGroupQuotaUsage'
GO

insert into GXDBVersions values(2, 'RptSetClientGroupQuotaUsage',  '00010001000200060000', 'RptSetClientGroupQuotaUsage', '00010001000200060000')
GO

