

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptSaveStorageUsage.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptSaveStorageUsage.sp,v $ $Id: RptSaveStorageUsage.sp,v 1.8.34.44 2020/12/22 04:43:13 junlu Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptSaveStorageUsage')
BEGIN
	print '>>> Drop Stored Procedure: RptSaveStorageUsage <<<'
	drop procedure RptSaveStorageUsage
END
IF EXISTS (select * from GxQscripts where name='RptSaveStorageUsage')
	delete from GxQscripts where name = 'RptSaveStorageUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSaveStorageUsage')
	delete from GXDBVersions where aliasname = 'RptSaveStorageUsage'
GO
print '... Creating Procedure: RptSaveStorageUsage'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptSaveStorageUsage
  @dummy integer
AS
  DECLARE @retVal integer;
SET NOCOUNT ON
SET DATEFIRST 1
DECLARE @DSTFlag				INT = 0
DECLARE @Bias					INT = 0
DECLARE @csTimeZoneId			INT = 0
DECLARE @csTimeZone				NVARCHAR(1024) = ''
SELECT  @csTimeZoneId = attrVal FROM APP_ClientProp WITH (NOLOCK) WHERE attrName = 'Commcell timezone Id' AND modified = 0
IF @csTimeZoneId = 0
	SELECT  @csTimeZoneId = attrVal FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = 2 AND attrName = 'timezone Id' AND modified = 0
SELECT	@csTimeZone = TimeZoneStdName, @DSTFlag = DSTFlag, @Bias = Bias FROM SchedTimeZone WITH (NOLOCK) WHERE TimeZoneID = @csTimeZoneId
-- 1. Populate RptStorageUsage table
CREATE TABLE #AppCopySizeAll
(
	vmClientId		INT,
	appId			INT,
	copyId			INT,
	dataProtected	BIGINT,
	dataWritten		BIGINT,
	dedupRatio		FLOAT
)
CREATE TABLE #AppCopySize
(
	vmClientId		INT,
	appId			INT,
	copyId			INT,
	dataProtected	BIGINT,
	dataWritten		BIGINT,
	dedupRatio		FLOAT
)
DECLARE	@tblRetVal	TABLE (retVal INT)
DECLARE	@firstDate	DATETIME
DECLARE	@lastDate	DATETIME = (SELECT MAX(startDT) FROM RptStorageUsage)
DECLARE	@currDate	DATETIME = DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()), 0)
DECLARE	@currMonth	DATETIME = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0)
DECLARE	@lastMonth	DATETIME = DATEADD(MONTH, -1, @currMonth)
DECLARE	@startDate	DATETIME = (SELECT MAX(endDT) FROM RptStorageUsage)
DECLARE	@endDate	DATETIME
DECLARE @updatestatus INT = 0
SET @retVal = 0
-- Add a monthly entry if no entry for the last month
IF @lastDate IS NULL OR @lastDate < @lastMonth
BEGIN
	SET	@startDate	= @lastMonth
	SET	@endDate	= DATEADD(SECOND, -1, @currMonth)
	INSERT INTO @tblRetVal
	EXEC RptStorageUsageByTime '01/01/1970', @endDate
	SET	@retVal = @@ERROR
	IF	@retVal =  0 SELECT @retVal = retVal FROM @tblRetVal
	IF	@retVal <> 0 GOTO ERR_RETURN
	INSERT	INTO #AppCopySizeAll (vmClientId, appId, copyId, dataProtected, dataWritten, dedupRatio)
	SELECT	vmClientId, appId, copyId, SUM(dataProtected), SUM(dataWritten), MAX(dedupRatio)
	FROM	#AppCopySize
	GROUP BY vmClientId, appId, copyId
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
	TRUNCATE TABLE #AppCopySize
	INSERT INTO @tblRetVal
	EXEC RptStorageUsageByTime @startDate, @endDate
	SET	@retVal = @@ERROR
	IF	@retVal =  0 SELECT @retVal = retVal FROM @tblRetVal
	IF	@retVal <> 0 GOTO ERR_RETURN
	INSERT	INTO RptStorageUsage (startDT, endDT, type, appId, vmClientId, copyId, dedupRatio, dataProtected, dataWritten, allAppSize, allMediaSize)
	SELECT	@startDate, @endDate, 2, A.appId, A.vmClientId, A.copyId, A.dedupRatio,
			ISNULL(B.dataProtected, 0), ISNULL(B.dataWritten, 0), A.dataProtected, A.dataWritten
	FROM	#AppCopySizeAll A LEFT OUTER JOIN
			(SELECT	vmClientId, appId, copyId, SUM(dataProtected) AS dataProtected, SUM(dataWritten) AS dataWritten
			FROM	#AppCopySize
			GROUP BY vmClientId, appId, copyId
			) B ON A.vmClientId = B.vmClientId AND A.appId = B.appId AND A.copyId = B.copyId
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
	SET	@startDate	= DATEADD(MONTH, 1, @startDate)
	SET	@endDate	= DATEADD(DAY, 1, @endDate)
END
ELSE
BEGIN
	SET	@startDate	= DATEADD(SECOND, 1, @startDate)
	SET	@endDate	= DATEADD(DAY, DATEDIFF(DAY, 0, @startDate)+1, 0)
	SET	@endDate	= DATEADD(SECOND, -1, @endDate)
END
WHILE (@startDate < @currDate)
BEGIN
	TRUNCATE TABLE #AppCopySizeAll
	TRUNCATE TABLE #AppCopySize
	INSERT INTO @tblRetVal
	EXEC RptStorageUsageByTime '01/01/1970', @endDate
	SET	@retVal = @@ERROR
	IF	@retVal =  0 SELECT @retVal = retVal FROM @tblRetVal
	IF	@retVal <> 0 GOTO ERR_RETURN
	INSERT	INTO #AppCopySizeAll (vmClientId, appId, copyId, dataProtected, dataWritten, dedupRatio)
	SELECT	vmClientId, appId, copyId, SUM(dataProtected), SUM(dataWritten), MAX(dedupRatio)
	FROM	#AppCopySize
	GROUP BY vmClientId, appId, copyId
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
	TRUNCATE TABLE #AppCopySize
	INSERT INTO @tblRetVal
	EXEC RptStorageUsageByTime @startDate, @endDate
	SET	@retVal = @@ERROR
	IF	@retVal =  0 SELECT @retVal = retVal FROM @tblRetVal
	IF	@retVal <> 0 GOTO ERR_RETURN
	INSERT	INTO RptStorageUsage (startDT, endDT, type, appId, vmClientId, copyId, dedupRatio, dataProtected, dataWritten, allAppSize, allMediaSize)
	SELECT	@startDate, @endDate, 1, A.appId, A.vmClientId, A.copyId, A.dedupRatio,
			ISNULL(B.dataProtected, 0), ISNULL(B.dataWritten, 0), A.dataProtected, A.dataWritten
	FROM	#AppCopySizeAll A LEFT OUTER JOIN
			(SELECT	vmClientId, appId, copyId, SUM(dataProtected) AS dataProtected, SUM(dataWritten) AS dataWritten
			FROM	#AppCopySize
			GROUP BY vmClientId, appId, copyId
			) B ON A.vmClientId = B.vmClientId AND A.appId = B.appId AND A.copyId = B.copyId
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
	SET	@startDate	= DATEADD(SECOND, 1, @endDate)
	SET	@endDate	= DATEADD(DAY, DATEDIFF(DAY, 0, @startDate)+1, 0)
	SET	@endDate	= DATEADD(SECOND, -1, @endDate)
END
DROP TABLE #AppCopySize
DROP TABLE #AppCopySizeAll
-- 2. Populate RptCapacityUsage table
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#tmpCommcellUsageReport'))
	DROP TABLE #tmpCommcellUsageReport
create table #tmpCommcellUsageReport ( [EnterpriseBackupSize]	bigint , [CoreBackupSize]		bigint , [EnterpriseArchiveSize] bigint , [CoreArchiveSize]		bigint , [SnapshotSize]			bigint , [ReplicationSize]		bigint , [nJobType]				int , [appId]					int , [jobID]					int , [ClientName]			nvarchar(255) , [ClientId]				int , [AppTypeId]				int , [AppTypeName]			nvarchar(255) , [BackupSetName]			nvarchar(128) , [InstanceName]			nvarchar(512) , [SubclientName]			nvarchar(128) , [SPId]					int , [SPName]				nvarchar(144) , [UncompBytes]			bigint , [DedupEnabled]          int , [SecondaryEncryption]   int , [flag]					int	, [Snapshot]				int default 0, [ClientGroup]			nvarchar(1024) default '')
CREATE TABLE #CapacityUsage (
	startDT			DATETIME NOT NULL,
	type			TINYINT NOT NULL, -- 1 for daily, 2 for monthly
	appId			INT NOT NULL,
	vmClientId		INT NOT NULL,
	jobType			INT NOT NULL, -- 0 for Backup, 1 for Archive, 2 for Sanpshot, 3 for Replication
	frontendSize	BIGINT NOT NULL,
	jobStartDT		DATETIME NULL)
CREATE TABLE #VSAFullJob (VMclientId INT, appId INT, jobId INT)
CREATE TABLE #VMFrontEndSize (VMclientId INT, lastJobId INT, frontendSize BIGINT)
CREATE TABLE #VSA_AppIDs (appId INT, isIndexingV2 INT)
-- IndexingV2 VMs can have multiple child subclients. Capacity of one child sunclient should be counted.
-- If a VM has both IndexingV2 and non-IndexingV2 VSA backup jobs, only count IndexingV2 VSA capacity.
-- Before IndexingV2, JMJobDataStats and archFile tables only have entries of parent jobs. Count parent jobs.
-- Since IndexingV2, JMJobDataStats and archFile tables have entries of both parent and child jobs. Count child jobs.
-- Parent jobs associated with appId of IndexingV2 VSA subclients will be excluded in calcultion.
INSERT	INTO #VSA_AppIDs
SELECT	A.id, ISNULL(CP.attrVal, 0)
FROM	APP_Application A WITH (NOLOCK)
		INNER JOIN APP_InstanceProp IP WITH (NOLOCK) ON IP.componentNameId = A.instance
			AND IP.attrName = 'Virtual Server Instance Type' AND IP.attrVal <> '' AND IP.modified = 0
		LEFT OUTER JOIN APP_ClientProp CP WITH (NOLOCK) ON CP.componentNameId = A.clientId
			AND CP.attrName = 'IndexingV2_VSA' AND CP.modified = 0 AND CP.attrVal = '1'
WHERE	A.appTypeId = 106 AND A.subclientStatus&0x00020 = 0
DECLARE	@TimeRangeEnd	INT = 0x7FFFFFFF
SET @lastDate = (SELECT MAX(startDT) FROM RptCapacityUsage)
IF @lastDate IS NULL OR @lastDate < @lastMonth
BEGIN
	SET	@startDate	= @lastMonth
	SET	@endDate	= DATEADD(SECOND, -1, @currMonth)
	-- Table will be populated inside QS_CommCellUsageReport #tmpCommcellUsageReport
	-- QS_CommCellUsageReport is buggy for VMs. Recalculte the maximum guest size of jobs in the last full cycle.
	-- Set 3rd parameter to 4 for not excluding subclients with Object Instance license
	EXEC QS_CommCellUsageReport @endDate, 0, 4
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
	SET @TimeRangeEnd = dbo.GetUnixTime(dbo.LocalToUTCTime(@endDate, @csTimeZone))
	SET @updatestatus = 1
	-- Non-IndexingV2 VMs
	INSERT	INTO #VSAFullJob
	SELECT	V.VMclientId, 0, MAX(J.jobId)
	FROM	JMBkpStats J WITH (NOLOCK)
			INNER JOIN APP_VMProp V WITH (NOLOCK) ON J.jobId = V.jobId AND J.commCellId = V.commCellId AND V.attrName = 'vmStatus'
			INNER JOIN #VSA_AppIDs VA ON J.appId = VA.appId AND VA.isIndexingV2 = 0
	WHERE	J.commCellId = 2 AND J.appType = 106
			AND J.servEndDate <= @TimeRangeEnd
			AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
			AND J.status IN (1, 3, 14)
			AND J.bkpLevel IN (1, 64, 128, 1024, 16384, 32768)
			AND J.fullCycleNum > 0 AND J.dataStatus = 0 AND J.totalUncompBytes > 0
	GROUP BY V.VMclientId
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
	-- vmGuestSize = Actual VM application size. vmUsedSpace = Data read during backup.
	-- All jobs have vmUsedSpace before 10.0. All jobs have vmGuestSize since 10.0. Only Full jobs have vmUsedSpace since 10.0.
	INSERT	INTO #VMFrontEndSize
	SELECT	P.VMclientId, MAX(jobId), MAX(ISNULL([vmGuestSize], [vmUsedSpace]))
	FROM	(SELECT	V.VMclientId, V.jobId, (V.jobId - F.jobId) AS nonFull, V.attrName, CAST(V.attrVal AS BIGINT) AS size
			FROM	APP_VMProp V WITH (NOLOCK)
					INNER JOIN JMBkpStats J WITH (NOLOCK) ON V.jobId = J.jobId AND V.commCellId = J.commCellId
					INNER JOIN #VSAFullJob F ON V.VMclientId = F.VMclientId AND V.jobId >= F.jobId AND V.commCellId = 2
			WHERE	V.attrName IN ('vmStatus', 'vmUsedSpace', 'vmGuestSize', 'vmIsGuestSizeValid')) S
			PIVOT (MAX(size) FOR attrName IN ([vmStatus], [vmUsedSpace], [vmGuestSize], [vmIsGuestSizeValid])) AS P
	WHERE	P.vmStatus IN (0, 3) AND (ISNULL(P.vmIsGuestSizeValid, 1) = 1 OR P.nonFull = 0)
	GROUP BY P.VMclientId
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
	TRUNCATE TABLE #VSAFullJob
	-- IndexingV2 VMs (child job ID)
	INSERT	INTO #VSAFullJob
	SELECT	A.clientId, 0, MAX(J.jobId)
	FROM	JMBkpStats J WITH (NOLOCK)
			INNER JOIN APP_Application A WITH (NOLOCK) ON J.appId = A.id
			LEFT OUTER JOIN #VSA_AppIDs VA ON J.appId = VA.appId
	WHERE	J.commCellId = 2 AND J.appType = 106
			AND J.servEndDate <= @TimeRangeEnd
			AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
			AND J.status IN (1, 3, 14)
			AND J.bkpLevel IN (1, 64, 128, 1024, 16384, 32768)
			AND J.fullCycleNum > 0 AND J.dataStatus = 0 AND J.totalUncompBytes > 0
			AND VA.appId IS NULL
	GROUP BY A.clientId
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
	-- Replace child job ID by parent job ID except for synthetic full jobs. APP_VMProp.jobId is child job ID for synthetic full jobs.
	UPDATE	F SET jobId = L.parentJobId
	FROM	#VSAFullJob F
			INNER JOIN JMBkpStats J WITH (NOLOCK) ON F.jobId = J.jobId AND J.commCellId = 2 AND J.bkpLevel NOT IN (64, 128, 16384)
			INNER JOIN JMJobDataLink L WITH (NOLOCK) ON J.jobId = L.childJobId AND J.commCellId = L.commCellId AND L.linkType = 7
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
	INSERT	INTO #VMFrontEndSize
	SELECT	P.VMclientId, MAX(jobId), MAX(ISNULL([vmGuestSize], [vmUsedSpace]))
	FROM	(SELECT	V.VMclientId, V.jobId, (V.jobId - F.jobId) AS nonFull, V.attrName, CAST(V.attrVal AS BIGINT) AS size
			FROM	APP_VMProp V WITH (NOLOCK)
					INNER JOIN JMBkpStats J WITH (NOLOCK) ON V.jobId = J.jobId AND V.commCellId = J.commCellId
					INNER JOIN #VSAFullJob F ON V.VMclientId = F.VMclientId AND V.jobId >= F.jobId AND V.commCellId = 2
			WHERE	V.attrName IN ('vmStatus', 'vmUsedSpace', 'vmGuestSize', 'vmIsGuestSizeValid')) S
			PIVOT (MAX(size) FOR attrName IN ([vmStatus], [vmUsedSpace], [vmGuestSize], [vmIsGuestSizeValid])) AS P
	WHERE	P.vmStatus IN (0, 3) AND (ISNULL(P.vmIsGuestSizeValid, 1) = 1 OR P.nonFull = 0)
	GROUP BY P.VMclientId
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
	DELETE	S
	FROM	#VMFrontEndSize S
			INNER JOIN (
				SELECT	VMclientId, MAX(lastJobId) AS lastJobId
				FROM	#VMFrontEndSize
				GROUP BY VMclientId
			) T ON S.VMclientId = T.VMclientId
	WHERE	S.lastJobId <> T.lastJobId
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
  BEGIN TRAN
	INSERT INTO RptCapacityUsage (startDT, type, appId, vmClientId, jobType, frontendSize)
	SELECT	@startDate, 2, appId, 0, nJobType, UncompBytes
	FROM	#tmpCommcellUsageReport
	WHERE	AppTypeId <> 106
	UNION ALL
	SELECT	@startDate, 2, J.appId, V.VMclientId, 0, MAX(ISNULL(V.frontendSize, 0))
	FROM	#VMFrontEndSize V
			INNER JOIN JMBkpStats J WITH (NOLOCK) ON J.jobId = V.lastJobId AND J.commCellId = 2
	GROUP BY J.appId, V.VMclientId
	SET	@retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
		ROLLBACK TRAN
		GOTO ERR_RETURN
	END
  COMMIT TRAN
	SET	@startDate	= DATEADD(MONTH, 1, @startDate)
	SET	@endDate	= DATEADD(DAY, 1, @endDate)
END
ELSE
BEGIN
	SET	@startDate	= DATEADD(DAY, 1, @lastDate)
	SET	@endDate	= DATEADD(DAY, DATEDIFF(DAY, 0, @startDate)+1, 0)
	SET	@endDate	= DATEADD(SECOND, -1, @endDate)
END
WHILE (@startDate < @currDate)
BEGIN
	TRUNCATE TABLE #tmpCommcellUsageReport
	TRUNCATE TABLE #VSAFullJob
	TRUNCATE TABLE #VMFrontEndSize
	TRUNCATE TABLE #CapacityUsage
	-- Table will be populated inside QS_CommCellUsageReport #tmpCommcellUsageReport
	-- QS_CommCellUsageReport is buggy for VMs. Recalculte the maximum guest size of jobs in the last full cycle.
	-- Set 3rd parameter to 4 for not excluding subclients with Object Instance license
	EXEC QS_CommCellUsageReport @endDate, 0, 4
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
	SET @TimeRangeEnd = dbo.GetUnixTime(dbo.LocalToUTCTime(@endDate, @csTimeZone))
	SET @updatestatus = 1
	-- Non-IndexingV2 VMs
	INSERT	INTO #VSAFullJob
	SELECT	V.VMclientId, 0, MAX(J.jobId)
	FROM	JMBkpStats J WITH (NOLOCK)
            INNER JOIN APP_VMProp V WITH (NOLOCK) ON J.jobId = V.jobId AND J.commCellId = V.commCellId AND V.attrName = 'vmStatus'
			INNER JOIN #VSA_AppIDs VA ON J.appId = VA.appId AND VA.isIndexingV2 = 0
	WHERE	J.commCellId = 2 AND J.appType = 106
			AND J.servEndDate <= @TimeRangeEnd
			AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
			AND J.status IN (1, 3, 14)
			AND J.bkpLevel IN (1, 64, 128, 1024, 16384, 32768)
			AND J.fullCycleNum > 0 AND J.dataStatus = 0 AND J.totalUncompBytes > 0
	GROUP BY V.VMclientId
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
	-- vmGuestSize = Actual VM application size. vmUsedSpace = Data read during backup.
	-- All jobs have vmUsedSpace before 10.0. All jobs have vmGuestSize since 10.0. Only Full jobs have vmUsedSpace since 10.0.
	INSERT	INTO #VMFrontEndSize
	SELECT	P.VMclientId, MAX(jobId), MAX(ISNULL([vmGuestSize], [vmUsedSpace]))
	FROM	(SELECT	V.VMclientId, V.jobId, (V.jobId - F.jobId) AS nonFull, V.attrName, CAST(V.attrVal AS BIGINT) AS size
			FROM	APP_VMProp V WITH (NOLOCK)
					INNER JOIN JMBkpStats J WITH (NOLOCK) ON V.jobId = J.jobId AND V.commCellId = J.commCellId
					INNER JOIN #VSAFullJob F ON V.VMclientId = F.VMclientId AND V.jobId >= F.jobId AND V.commCellId = 2
			WHERE	V.attrName IN ('vmStatus', 'vmUsedSpace', 'vmGuestSize', 'vmIsGuestSizeValid')) S
			PIVOT (MAX(size) FOR attrName IN ([vmStatus], [vmUsedSpace], [vmGuestSize], [vmIsGuestSizeValid])) AS P
	WHERE	P.vmStatus IN (0, 3) AND (ISNULL(P.vmIsGuestSizeValid, 1) = 1 OR P.nonFull = 0)
	GROUP BY P.VMclientId
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
	TRUNCATE TABLE #VSAFullJob
	-- IndexingV2 VMs (child job ID)
	INSERT	INTO #VSAFullJob
	SELECT	A.clientId, 0, MAX(J.jobId)
	FROM	JMBkpStats J WITH (NOLOCK)
			INNER JOIN APP_Application A WITH (NOLOCK) ON J.appId = A.id
			LEFT OUTER JOIN #VSA_AppIDs VA ON J.appId = VA.appId
	WHERE	J.commCellId = 2 AND J.appType = 106
			AND J.servEndDate <= @TimeRangeEnd
			AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
			AND J.status IN (1, 3, 14)
			AND J.bkpLevel IN (1, 64, 128, 1024, 16384, 32768)
			AND J.fullCycleNum > 0 AND J.dataStatus = 0 AND J.totalUncompBytes > 0
			AND VA.appId IS NULL
	GROUP BY A.clientId
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
	-- Replace child job ID by parent job ID except for synthetic full jobs. APP_VMProp.jobId is child job ID for synthetic full jobs.
	UPDATE	F SET jobId = L.parentJobId
	FROM	#VSAFullJob F
			INNER JOIN JMBkpStats J WITH (NOLOCK) ON F.jobId = J.jobId AND J.commCellId = 2 AND J.bkpLevel NOT IN (64, 128, 16384)
			INNER JOIN JMJobDataLink L WITH (NOLOCK) ON J.jobId = L.childJobId AND J.commCellId = L.commCellId AND L.linkType = 7
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
	INSERT	INTO #VMFrontEndSize
	SELECT	P.VMclientId, MAX(jobId), MAX(ISNULL([vmGuestSize], [vmUsedSpace]))
	FROM	(SELECT	V.VMclientId, V.jobId, (V.jobId - F.jobId) AS nonFull, V.attrName, CAST(V.attrVal AS BIGINT) AS size
			FROM	APP_VMProp V WITH (NOLOCK)
					INNER JOIN JMBkpStats J WITH (NOLOCK) ON V.jobId = J.jobId AND V.commCellId = J.commCellId
					INNER JOIN #VSAFullJob F ON V.VMclientId = F.VMclientId AND V.jobId >= F.jobId AND V.commCellId = 2
			WHERE	V.attrName IN ('vmStatus', 'vmUsedSpace', 'vmGuestSize', 'vmIsGuestSizeValid')) S
			PIVOT (MAX(size) FOR attrName IN ([vmStatus], [vmUsedSpace], [vmGuestSize], [vmIsGuestSizeValid])) AS P
	WHERE	P.vmStatus IN (0, 3) AND (ISNULL(P.vmIsGuestSizeValid, 1) = 1 OR P.nonFull = 0)
	GROUP BY P.VMclientId
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
	DELETE	S
	FROM	#VMFrontEndSize S
			INNER JOIN (
				SELECT	VMclientId, MAX(lastJobId) AS lastJobId
				FROM	#VMFrontEndSize
				GROUP BY VMclientId
			) T ON S.VMclientId = T.VMclientId
	WHERE	S.lastJobId <> T.lastJobId
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
  BEGIN TRAN
	INSERT INTO #CapacityUsage (startDT, type, appId, vmClientId, jobType, frontendSize, jobStartDT)
	SELECT	@startDate, 1, U.appId, 0, U.nJobType, U.UncompBytes, DATEADD(SS, J.servStartDate + @Bias, '1970-01-01')
	FROM	#tmpCommcellUsageReport U
			INNER JOIN JMBkpStats J WITH (NOLOCK) ON J.jobId = U.jobId AND J.commCellId = 2
	WHERE	U.AppTypeId <> 106
	UNION ALL
	SELECT	@startDate, 1, J.appId, V.VMclientId, 0, MAX(ISNULL(V.frontendSize, 0)), DATEADD(SS, J.servStartDate + @Bias, '1970-01-01')
	FROM	#VMFrontEndSize V
			INNER JOIN JMBkpStats J WITH (NOLOCK) ON J.jobId = V.lastJobId AND J.commCellId = 2
	GROUP BY J.appId, V.VMclientId, J.servStartDate
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
	IF @DSTFlag = 1
		UPDATE	U SET jobStartDT = DATEADD(SS, DSTBias, U.jobStartDT)
		FROM	#CapacityUsage U
				INNER JOIN SchedTimeZoneDates D ON TimeZoneID = @csTimeZoneId AND U.jobStartDT BETWEEN DSTDate AND STDDate
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
	INSERT INTO RptCapacityUsage (startDT, type, appId, vmClientId, jobType, frontendSize, jobStartDT)
	SELECT	startDT, type, appId, vmClientId, jobType, frontendSize, jobStartDT
	FROM	#CapacityUsage
	SET	@retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
		ROLLBACK TRAN
		GOTO ERR_RETURN
	END
  COMMIT TRAN
	SET	@startDate	= DATEADD(SECOND, 1, @endDate)
	SET	@endDate	= DATEADD(DAY, DATEDIFF(DAY, 0, @startDate)+1, 0)
	SET	@endDate	= DATEADD(SECOND, -1, @endDate)
END
DROP TABLE #VSA_AppIDs
DROP TABLE #VSAFullJob
DROP TABLE #VMFrontEndSize
-- update at least once when Registry key is Set
IF @updatestatus = 0 AND EXISTS (SELECT 1 FROM APP_AdvanceSettings WITH (NOLOCK) WHERE keyName = 'nRptCalcUsageFreqHrs' AND entityId = 2 AND entityType = 3 AND enabled = 1)
BEGIN
    TRUNCATE TABLE #tmpCommcellUsageReport
	-- Table will be populated inside QS_CommCellUsageReport #tmpCommcellUsageReport
	EXEC QS_CommCellUsageReport '', 0, 1
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
	SET @updatestatus = 1
END
-- Update RptClientGroupQuotaUsage table for Quota Management at client group level
CREATE TABLE #ClientGroup (clientGroupId INT)
INSERT	INTO #ClientGroup
SELECT	clientGroupId
FROM	RptClientGroupQuotaUsage WITH(NOLOCK)
UNION
SELECT	componentId
FROM	APP_ComponentProp WITH(NOLOCK)
WHERE	componentType = 8 AND propertyTypeId = 3400 AND longlongVal > 0 AND modified = 0
SET @lastDate = (SELECT MAX(startDT) FROM RptCapacityUsage)
CREATE TABLE #ClientGroupSize (clientGroupId INT, licType INT, frontendSizeGB BIGINT)
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#CapacityType'))
DROP TABLE #CapacityType
CREATE TABLE #CapacityType (t_njobtype INT, t_lictype INT)
INSERT INTO #CapacityType VALUES (0,100002),(1,100004),(2,100005),(3,100006)
-- ClientGroupId = 0 is for "CommCell Inherited Capacity"
IF @updatestatus = 1
BEGIN
INSERT  INTO #ClientGroupSize
SELECT 0, C.t_lictype, ISNULL(T.CapacitySize,0)
FROM #CapacityType C LEFT JOIN (SELECT njobtype,SUM(1.0*UncompBytes/1024/1024/1024) AS CapacitySize FROM #tmpCommcellUsageReport WHERE flag = 0 GROUP BY nJobType) T ON C.t_njobtype = T.njobtype
END
DROP TABLE #tmpCommcellUsageReport
DECLARE @InheritedLicType	INT = 0
SELECT	@InheritedLicType = CAST(attrVal AS INT) FROM LicUsageBasedConfig WITH (NOLOCK) WHERE attrName = 'InheritedLicType'
-- Get quota limit for "CommCell Inherited Capacity" from the license server
IF @InheritedLicType&4 = 4
BEGIN
	DECLARE @permField	VARCHAR(2048)=''
	DECLARE @evalField	VARCHAR(2048)=''
	DECLARE @licType	INT = 0
	DECLARE @permIssued	INT = 0
	DECLARE @permUsed	INT = 0
	DECLARE @evalIssued	INT = 0
	DECLARE @evalUsed	INT = 0
	DECLARE @bEval		INT = 0
	DECLARE @evalExpiry	INT = 0
	DECLARE @permExpiry	INT = 0
	DECLARE @quotaType	INT = 0
	DECLARE @expTime	INT = 0
	DECLARE @globalLimitGB	INT = 0
	DECLARE CapacityLic CURSOR FOR
	SELECT	CAST(SUBSTRING(attrName,0, CHARINDEX(' ',attrName)) AS int), attrVal
	FROM	LicUsageBasedConfig WITH (NOLOCK)
	WHERE	attrName like '1000% issued' AND attrName <> '100031 Issued'
	OPEN CapacityLic
		FETCH NEXT FROM CapacityLic INTO @licType, @permField
	WHILE @@FETCH_STATUS <> -1
	BEGIN
		SET @permIssued = 0
		SET @permUsed	= 0
		SET @globalLimitGB = 0
		DECLARE @licEntAttrVal varchar(5000) =''
		EXEC miscProc2 @permField, @licEntAttrVal OUTPUT
		SET @expTime = 0
		SELECT @expTime = CAST(SUBSTRING(@licEntAttrVal,1,CHARINDEX(':-',@licEntAttrVal)-1) AS INT)
		SELECT @globalLimitGB = CAST(SUBSTRING(@licEntAttrVal,CHARINDEX(':-',@licEntAttrVal)+2,LEN(@licEntAttrVal))as INT)
		IF EXISTS (SELECT * FROM RptClientGroupQuotaUsage WHERE clientGroupId = 0 AND quotaType = @licType)
			UPDATE RptClientGroupQuotaUsage SET	globalLimitGB = @globalLimitGB, updateTime = dbo.GetUnixTime(GETUTCDATE()),
			expiryTime = @expTime
			WHERE  clientGroupId = 0 AND quotaType = @licType
		ELSE
			INSERT INTO RptClientGroupQuotaUsage
			SELECT 0, 0, 0, @globalLimitGB, dbo.GetUnixTime(GETUTCDATE()), @licType, @expTime
		FETCH NEXT FROM CapacityLic INTO @licType, @permField
	END
	CLOSE CapacityLic
	DEALLOCATE CapacityLic
	--code added here
	CREATE TABLE #TempTable (LicType INT, permfld varchar(2048), evalfld varchar(2048))
	INSERT INTO #TempTable
	SELECT quotaType, '', ''
	FROM RptClientGroupQuotaUsage WITH (NOLOCK)
	WHERE quotaType IN (100011, 100014, 100015, 100020, 100021, 100022, 100023, 100024, 100025, 100026)
	UPDATE #TempTable
	SET permfld = perm_fld1, evalfld = eval_fld1
	FROM LicAal WITH (NOLOCK)
	WHERE  LicAal.simLicAppTypeId = #TempTable.LicType
	UPDATE R
	SET globalLimitGB = 0, expiryTime = 0, updateTime = dbo.GetUnixTime(GETUTCDATE())
	FROM RptClientGroupQuotaUsage R
	INNER JOIN #TempTable T ON R.quotaType = T.LicType
	WHERE T.permfld = '' and T.evalfld = '' AND (R.globalLimitGB <> 0 OR R.expiryTime > 0)
	DROP TABLE #TempTable
	--end
	DECLARE UsageBasedLic CURSOR FOR
	SELECT	simLicAppTypeId, RTRIM(perm_fld1), RTRIM(eval_fld1)
	FROM	LicAAL WITH (NOLOCK)
	WHERE	simLicAppTypeId IN (100011, 100014, 100015, 100020, 100021, 100022, 100023, 100024, 100025, 100026) AND commcellId = 2
	OPEN UsageBasedLic
		FETCH NEXT FROM UsageBasedLic INTO @licType, @permField, @evalField
	WHILE @@FETCH_STATUS <> -1
	BEGIN
		SET @permIssued = 0
		SET @permUsed	= 0
		SET @globalLimitGB = 0
		IF (@permField <> '')
			EXEC dbo.xp_getAALInfo2 @permField, @permIssued OUTPUT, @permUsed OUTPUT, @bEval OUTPUT, @permExpiry OUTPUT
		SET @expTime = @permExpiry
		SET @evalIssued = 0
		SET @evalUsed	= 0
		SET @bEval		= 0
		SET @evalExpiry = 0
		IF (@evalField <> '')
		BEGIN
			EXEC dbo.xp_getAALInfo2 @evalField, @evalIssued OUTPUT, @evalUsed OUTPUT, @bEval OUTPUT, @evalExpiry OUTPUT
			-- case1: Eval license is still valid
			-- case2: -- only eval license present and expired in this case use expiration time of eval
			IF @evalExpiry > dbo.GetUnixTime(GETUTCDATE()) OR @permField = ''
				SET @expTime = @evalExpiry
			ELSE
				SET @evalIssued = 0 --Eval is expired and permanent is present, its issued quantity is not valid.
		END
		SET @globalLimitGB = CASE WHEN (@permIssued < 0 OR @evalIssued < 0) THEN -1 ELSE (@permIssued + @evalIssued) END
		IF EXISTS (SELECT * FROM RptClientGroupQuotaUsage WHERE clientGroupId = 0 AND quotaType = @licType)
			UPDATE RptClientGroupQuotaUsage SET	globalLimitGB = @globalLimitGB, updateTime = dbo.GetUnixTime(GETUTCDATE()),
			expiryTime = @expTime
			WHERE  clientGroupId = 0 AND quotaType = @licType --AND globalLimitGB <> (@permIssued + @evalIssued)
		ELSE
			INSERT INTO RptClientGroupQuotaUsage
			SELECT 0, 0, 0, @globalLimitGB, dbo.GetUnixTime(GETUTCDATE()), @licType, @expTime
			--WHERE (@permIssued + @evalIssued) > 0
		FETCH NEXT FROM UsageBasedLic INTO @licType, @permField, @evalField
	END
	CLOSE UsageBasedLic
	DEALLOCATE UsageBasedLic
	UPDATE RptClientGroupQuotaUsage
	SET expiryTime = 0, updateTime = dbo.GetUnixTime(GETUTCDATE())
	WHERE clientGroupId = 0 AND globalLimitGB = 0 AND expiryTime > 0
END
IF @updatestatus = 1 AND @InheritedLicType&1 = 1 AND EXISTS (SELECT 1 FROM LicAal WITH(NOLOCK) WHERE simLicAppTypeId = 205) AND EXISTS
(SELECT 1
	FROM (SELECT COUNT(quotaType) OVER (PARTITION BY globalLimitGB) AS Occurance
		FROM RptClientGroupQuotaUsage WITH(NOLOCK) WHERE quotaType in (100002,100004) AND clientGroupId = 0 AND globalLimitGB > 0) t
	WHERE Occurance = 2)
BEGIN
	DECLARE @CvCpltTotal INT
	SELECT @CvCpltTotal = SUM(frontendSizeGB) FROM #ClientGroupSize WHERE clientGroupId = 0 AND licType in (100002,100004)
	UPDATE #ClientGroupSize
	SET frontendSizeGB = @CvCpltTotal
	WHERE clientGroupId = 0 AND licType in (100002,100004)
END
IF @InheritedLicType&1 = 1
BEGIN
	CREATE TABLE #tmpLicUsage11 (licType INT, usage BIGINT)
	EXEC LicCALUsage 0,0
	UPDATE U SET quotaUsedGB = T.usage
	FROM	RptClientGroupQuotaUsage U
			INNER JOIN #tmpLicUsage11 T ON U.quotaType = T.licType
	WHERE	U.clientGroupId = 0
	DROP TABLE #tmpLicUsage11
END
INSERT  INTO #ClientGroupSize
SELECT	CG.clientGroupId, C.t_lictype, SUM(1.0*CU.frontendSize/1024/1024/1024)
FROM	#ClientGroup CG
		INNER JOIN APP_ClientGroupAssoc CGA WITH(NOLOCK) ON CG.clientGroupId = CGA.clientGroupId
		INNER JOIN APP_Application A WITH(NOLOCK) ON CGA.clientId = A.clientId
		INNER JOIN RptCapacityUsage CU WITH(NOLOCK) ON A.id = CU.appId AND CU.vmClientId = 0
		INNER JOIN #CapacityType C ON C.t_njobtype = CU.jobType
WHERE	CU.type = 1 AND CU.startDT = @lastDate
GROUP BY CG.clientGroupId, C.t_lictype
INSERT  INTO #ClientGroupSize
SELECT	CG.clientGroupId, C.t_lictype, SUM(1.0*CU.frontendSize/1024/1024/1024)
FROM	#ClientGroup CG
		INNER JOIN APP_ClientGroupAssoc CGA WITH(NOLOCK) ON CG.clientGroupId = CGA.clientGroupId
		INNER JOIN RptCapacityUsage CU WITH(NOLOCK) ON CGA.clientId = CU.vmClientId AND CU.vmClientId > 0
		INNER JOIN #CapacityType C ON C.t_njobtype = CU.jobType
WHERE	CU.type = 1 AND CU.startDT = @lastDate
GROUP BY CG.clientGroupId, C.t_lictype
UPDATE	Q SET quotaUsedGB = 0
FROM	RptClientGroupQuotaUsage Q
		LEFT OUTER JOIN (SELECT DISTINCT clientGroupId, licType FROM #ClientGroupSize) T
		ON Q.clientGroupId = T.clientGroupId AND Q.quotaType = T.licType
WHERE	Q.clientGroupId > 0 AND T.licType IS NULL
MERGE	RptClientGroupQuotaUsage Q
USING	(SELECT clientGroupId, licType, SUM(frontendSizeGB) AS frontendSizeGB FROM #ClientGroupSize GROUP BY clientGroupId, licType) T
		ON Q.clientGroupId = T.clientGroupId AND Q.quotaType = T.licType
WHEN MATCHED THEN
		UPDATE SET quotaUsedGB = T.frontendSizeGB, globalUsedGB = CASE WHEN Q.globalUsedGB < T.frontendSizeGB THEN T.frontendSizeGB ELSE Q.globalUsedGB END
WHEN NOT MATCHED THEN
		INSERT (clientGroupId, quotaUsedGB, globalUsedGB, globalLimitGB, updateTime, quotaType, expiryTime)
		VALUES (T.clientGroupId, T.frontendSizeGB, T.frontendSizeGB, 0, 0, T.licType, 0);
DROP TABLE #ClientGroup
DROP TABLE #ClientGroupSize
DROP TABLE #CapacityType
-- 3. Consolidate old daily entries into monthly entries
DECLARE	@lastMonthly	DATETIME = '1970-01-01'
SELECT	@lastMonthly = MAX(startDT) FROM RptStorageUsage WHERE type = 2
IF @lastMonthly IS NULL
BEGIN
	SELECT @firstDate = MIN(startDT) FROM RptStorageUsage WHERE type = 1
	IF  @firstDate IS NOT NULL
		SET @lastMonthly = DATEADD(MONTH, DATEDIFF(MONTH, 0, @firstDate), 0)
END
ELSE
	SET @lastMonthly = DATEADD(MONTH, 1, @lastMonthly)
IF @lastMonthly IS NOT NULL AND DATEDIFF(MONTH, @lastMonthly, @lastMonth) >= 0
BEGIN
	INSERT	INTO RptStorageUsage (startDT, endDT, type, appId, vmClientId, copyId, dedupRatio, dataProtected, dataWritten, allAppSize, allMediaSize)
	SELECT	T.firstDay, U.endDT, 2, U.appId, U.vmClientId, U.copyId, U.dedupRatio, ISNULL(T.dataProtected, 0),
			CASE WHEN U.dedupRatio > 0 AND U.dedupRatio < 1 THEN ISNULL(T.dataProtected, 0)*U.dedupRatio ELSE ISNULL(T.dataWritten, 0) END,
			U.allAppSize, U.allMediaSize
	FROM	RptStorageUsage U
			INNER JOIN (
			SELECT	DATEADD(MONTH, DATEDIFF(MONTH, 0, startDT), 0) AS firstDay, MAX(startDT) AS lastDay,
					appId, vmClientId, copyId, SUM(dataProtected) AS dataProtected, SUM(dataWritten) AS dataWritten
			FROM	RptStorageUsage
			WHERE	startDT >= @lastMonthly AND startDT < @currMonth AND type = 1
			GROUP BY DATEADD(MONTH, DATEDIFF(MONTH, 0, startDT), 0), appId, vmClientId, copyId
			) T ON U.startDT = T.lastDay AND U.appId = T.appId AND U.vmClientId = T.vmClientId AND U.copyId = T.copyId
	WHERE	U.type = 1
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
	UPDATE	U SET dedupRatio = R.dedupRatio, dataWritten = U.dataProtected*R.dedupRatio, allMediaSize = U.allAppSize*R.dedupRatio
	FROM	RptStorageUsage U
			INNER JOIN RptDedupRatios R ON U.startDT = R.startDT AND U.type = R.type AND U.copyId = R.copyId
	WHERE	U.type = 2
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
END
SET		@lastMonthly = NULL
SELECT	@lastMonthly = MAX(startDT) FROM RptCapacityUsage WHERE type = 2
IF @lastMonthly IS NULL
BEGIN
	SELECT @firstDate = MIN(startDT) FROM RptCapacityUsage WHERE type = 1
	IF  @firstDate IS NOT NULL
		SET @lastMonthly = DATEADD(MONTH, DATEDIFF(MONTH, 0, @firstDate), 0)
END
ELSE
	SET @lastMonthly = DATEADD(MONTH, 1, @lastMonthly)
IF @lastMonthly IS NOT NULL AND DATEDIFF(MONTH, @lastMonthly, @lastMonth) >= 0
BEGIN
	INSERT	INTO RptCapacityUsage (startDT, type, appId, vmClientId, jobType, frontendSize)
	SELECT	DATEADD(MONTH, DATEDIFF(MONTH, 0, startDT), 0), 2, appId, vmClientId, jobType, MAX(frontendSize)
	FROM	RptCapacityUsage
	WHERE	startDT >= @lastMonthly AND startDT < @currMonth AND type = 1 AND ISNULL(jobStartDT, @currDate) >= startDT
	GROUP BY DATEADD(MONTH, DATEDIFF(MONTH, 0, startDT), 0), appId, vmClientId, jobType
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
	TRUNCATE TABLE #CapacityUsage
	INSERT	INTO #CapacityUsage (startDT, type, appId, vmClientId, jobType, frontendSize)
	SELECT	DATEADD(MONTH, DATEDIFF(MONTH, 0, startDT), 0), 2, appId, vmClientId, jobType, MAX(frontendSize)
	FROM	RptCapacityUsage U
	WHERE	startDT >= @lastMonthly AND startDT < @currMonth AND type = 1 AND ISNULL(jobStartDT, @currDate) < startDT
	GROUP BY DATEADD(MONTH, DATEDIFF(MONTH, 0, startDT), 0), appId, vmClientId, jobType
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
	INSERT	INTO RptCapacityUsage (startDT, type, appId, vmClientId, jobType, frontendSize)
	SELECT	T.startDT, T.type, T.appId, T.vmClientId, T.jobType, T.frontendSize
	FROM	#CapacityUsage T
			LEFT OUTER JOIN RptCapacityUsage U
			ON T.startDT = U.startDT AND T.type = U.type AND T.appId = U.appId AND T.vmClientId = U.vmClientId AND T.jobType = U.jobType
	WHERE	U.startDT IS NULL
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
END
--  Consolidate old daily entries into weekly entries
DECLARE	@currWeek	DATETIME = DATEADD(DAY, 1-DATEPART(WEEKDAY, @currDate), @currDate)
DECLARE	@lastWeek	DATETIME = DATEADD(WEEK, -1, @currWeek)
DECLARE	@lastWeekly	DATETIME = '1970-01-01'
SELECT	@lastWeekly = MAX(startDT) FROM RptStorageUsage WHERE type = 3
IF @lastWeekly IS NULL
BEGIN
	SELECT @firstDate = MIN(startDT) FROM RptStorageUsage WHERE type = 1
	IF  @firstDate IS NOT NULL
		SET @lastWeekly = DATEADD(DAY, 1-DATEPART(WEEKDAY, @firstDate), @firstDate)
END
ELSE
	SET @lastWeekly = DATEADD(WEEK, 1, @lastWeekly)
IF  @lastWeekly IS NOT NULL AND DATEDIFF(WEEK, @lastWeekly, @lastWeek) >= 0
BEGIN
	INSERT	INTO RptStorageUsage (startDT, endDT, type, appId, vmClientId, copyId, dedupRatio, dataProtected, dataWritten, allAppSize, allMediaSize)
	SELECT	T.firstDay, U.endDT, 3, U.appId, U.vmClientId, U.copyId, U.dedupRatio, ISNULL(T.dataProtected, 0),
			CASE WHEN U.dedupRatio > 0 AND U.dedupRatio < 1 THEN ISNULL(T.dataProtected, 0)*U.dedupRatio ELSE ISNULL(T.dataWritten, 0) END,
			U.allAppSize, U.allMediaSize
	FROM	RptStorageUsage U
			INNER JOIN (
			SELECT	DATEADD(DAY, 1-DATEPART(WEEKDAY, startDT), startDT) AS firstDay, MAX(startDT) AS lastDay,
					appId, vmClientId, copyId, SUM(dataProtected) AS dataProtected, SUM(dataWritten) AS dataWritten
			FROM	RptStorageUsage
			WHERE	startDT >= @lastWeekly AND startDT < @currWeek AND type = 1
			GROUP BY DATEADD(DAY, 1-DATEPART(WEEKDAY, startDT), startDT), appId, vmClientId, copyId
			) T ON U.startDT = T.lastDay AND U.appId = T.appId AND U.vmClientId = T.vmClientId AND U.copyId = T.copyId
	WHERE	U.type = 1
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
	UPDATE	U SET dedupRatio = R.dedupRatio, dataWritten = U.dataProtected*R.dedupRatio, allMediaSize = U.allAppSize*R.dedupRatio
	FROM	RptStorageUsage U
			INNER JOIN RptDedupRatios R ON U.startDT = R.startDT AND U.type = R.type AND U.copyId = R.copyId
	WHERE	U.type = 3
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
END
SET		@lastWeekly = NULL
SELECT	@lastWeekly = MAX(startDT) FROM RptCapacityUsage WHERE type = 3
IF @lastWeekly IS NULL
BEGIN
	SELECT @firstDate = MIN(startDT) FROM RptCapacityUsage WHERE type = 1
	IF  @firstDate IS NOT NULL
		SET @lastWeekly = DATEADD(DAY, 1-DATEPART(WEEKDAY, @firstDate), @firstDate)
END
ELSE
	SET @lastWeekly = DATEADD(WEEK, 1, @lastWeekly)
IF  @lastWeekly IS NOT NULL AND DATEDIFF(WEEK, @lastWeekly, @lastWeek) >= 0
BEGIN
	INSERT	INTO RptCapacityUsage (startDT, type, appId, vmClientId, jobType, frontendSize)
	SELECT	DATEADD(DAY, 1-DATEPART(WEEKDAY, startDT), startDT), 3, appId, vmClientId, jobType, MAX(frontendSize)
	FROM	RptCapacityUsage
	WHERE	startDT >= @lastWeekly AND startDT < @currWeek AND type = 1 AND ISNULL(jobStartDT, @currDate) >= startDT
	GROUP BY DATEADD(DAY, 1-DATEPART(WEEKDAY, startDT), startDT), appId, vmClientId, jobType
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
	TRUNCATE TABLE #CapacityUsage
	INSERT	INTO #CapacityUsage (startDT, type, appId, vmClientId, jobType, frontendSize)
	SELECT	DATEADD(DAY, 1-DATEPART(WEEKDAY, startDT), startDT), 3, appId, vmClientId, jobType, MAX(frontendSize)
	FROM	RptCapacityUsage
	WHERE	startDT >= @lastWeekly AND startDT < @currWeek AND type = 1 AND ISNULL(jobStartDT, @currDate) < startDT
	GROUP BY DATEADD(DAY, 1-DATEPART(WEEKDAY, startDT), startDT), appId, vmClientId, jobType
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
	INSERT	INTO RptCapacityUsage (startDT, type, appId, vmClientId, jobType, frontendSize)
	SELECT	T.startDT, T.type, T.appId, T.vmClientId, T.jobType, T.frontendSize
	FROM	#CapacityUsage T
			LEFT OUTER JOIN RptCapacityUsage U
			ON T.startDT = U.startDT AND T.type = U.type AND T.appId = U.appId AND T.vmClientId = U.vmClientId AND T.jobType = U.jobType
	WHERE	U.startDT IS NULL
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
END
-- 4. Prune old entries
DECLARE	@agingDate		DATETIME
DECLARE	@agingMonths	INT = 0
DECLARE	@agingWeeks		INT = 0
SELECT	@agingMonths = CAST(value AS INT)
FROM	GXGlobalParam WITH (NOLOCK)
WHERE	name = 'Months to keep daily storage usage'
IF @agingMonths > 0
	SET	@agingDate = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()) - @agingMonths, 0)
ELSE
	SET	@agingDate = DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()) - 30, 0)
SELECT @lastMonthly = MAX(endDT) FROM RptStorageUsage WHERE type = 2
SELECT @lastWeekly  = MAX(endDT) FROM RptStorageUsage WHERE type = 3
DELETE RptStorageUsage WHERE startDT < @agingDate AND startDT < @lastMonthly AND startDT < @lastWeekly AND type = 1
SELECT @lastMonthly = MAX(startDT) FROM RptCapacityUsage WHERE type = 2
SET	   @lastMonthly = DATEADD(MONTH, 1, @lastMonthly)
SELECT @lastWeekly  = MAX(startDT) FROM RptCapacityUsage WHERE type = 3
SET	   @lastWeekly  = DATEADD(WEEK, 1, @lastWeekly)
DELETE RptCapacityUsage WHERE startDT < @agingDate AND startDT < @lastMonthly AND startDT < @lastWeekly AND type = 1
SET	@agingMonths = 13
SELECT	@agingMonths = CAST(value AS INT)
FROM	GXGlobalParam WITH (NOLOCK)
WHERE	name = 'Months to keep monthly storage usage'
IF	@agingMonths < 2
	SET	@agingMonths = 2
SET	@agingDate = DATEADD(MONTH, -@agingMonths, @currDate)
DELETE RptStorageUsage WHERE startDT < @agingDate AND type = 2
DELETE RptCapacityUsage WHERE startDT < @agingDate AND type = 2
SET	@agingWeeks = 13
SELECT	@agingWeeks = CAST(value AS INT)
FROM	GXGlobalParam WITH (NOLOCK)
WHERE	name = 'Weeks to keep weekly storage usage'
IF	@agingWeeks < 2
	SET	@agingWeeks = 2
SET	@agingDate = DATEADD(WEEK, -@agingWeeks, @currDate)
DELETE RptStorageUsage WHERE startDT < @agingDate AND type = 3
DELETE RptCapacityUsage WHERE startDT < @agingDate AND type = 3
DELETE Q FROM RptClientGroupQuotaUsage Q
	LEFT OUTER JOIN APP_ClientGroup CG ON Q.clientGroupId = CG.id
WHERE Q.clientGroupId > 0 AND CG.id IS NULL
ERR_RETURN:
SELECT	@retVal
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptSaveStorageUsage')
	delete from GxQscripts where name = 'RptSaveStorageUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSaveStorageUsage')
	delete from GXDBVersions where aliasname = 'RptSaveStorageUsage'
GO

insert into GXDBVersions values(2, 'RptSaveStorageUsage',  '00010008003400440000', 'RptSaveStorageUsage', '00010008003400440000')
GO

