

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptSaveRpoRto.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptSaveRpoRto.sp,v $ $Id: RptSaveRpoRto.sp,v 1.1.2.9.20.1 2021/03/20 05:41:21 junlu Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptSaveRpoRto')
BEGIN
	print '>>> Drop Stored Procedure: RptSaveRpoRto <<<'
	drop procedure RptSaveRpoRto
END
IF EXISTS (select * from GxQscripts where name='RptSaveRpoRto')
	delete from GxQscripts where name = 'RptSaveRpoRto'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSaveRpoRto')
	delete from GXDBVersions where aliasname = 'RptSaveRpoRto'
GO
print '... Creating Procedure: RptSaveRpoRto'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptSaveRpoRto
  @i_dummy INT = 0
AS
SET NOCOUNT ON
CREATE TABLE #Client (clientId INT, clientName NVARCHAR(256), clientType INT, rpoMinutes INT, rtoMinutes INT, PRIMARY KEY (clientId))
CREATE TABLE #SubclientStats (clientId INT, appTypeId INT, appId INT, fullCycleNum INT,
		LastJobId INT, commCellId INT, lastBackupTime INT, opType INT, archGrpId INT, protectionType INT,
		maxAppSize BIGINT, tapeExported INT, rstThruputMbps FLOAT, restoreTime INT, rpoMinutes INT, planId INT)
CREATE TABLE #ClientRecovery (clientId INT, lastBackupTime INT, appSize BIGINT, tapeExported INT, restoreTime INT, rpoStatus INT, rtoStatus INT)
CREATE TABLE #RpoRtoSummary (date DATETIME, clientType INT, clientsMetRpo INT, clientsMissedRpo INT, clientsMetRto INT, clientsMissedRto INT)
DECLARE @nstring NVARCHAR(MAX)
DECLARE @csRelId INT = (SELECT releaseId FROM APP_Client WHERE id = 2)
DECLARE	@currTime DATETIME = GETDATE()
DECLARE	@today    DATETIME = DATEADD(DAY, DATEDIFF(DAY,0,@currTime), 0)
DECLARE @MM  VARCHAR(32)
DECLARE @HH  VARCHAR(32)
DECLARE @DD  VARCHAR(32)
DECLARE	@RPOInMinutes INT = 24*60
DECLARE	@RTOInMinutes INT = 24*60
DECLARE	@TapeImportMinutes INT = 24*60
DECLARE	@RstBkpTimeRatio FLOAT = 1.10
SELECT	@RPOInMinutes = longVal
FROM	APP_ComponentProp WITH (NOLOCK)
WHERE	componentType = 1 AND componentId = 2 AND propertyTypeId = 3306 AND modified = 0
SELECT	@RTOInMinutes = longVal
FROM	APP_ComponentProp WITH (NOLOCK)
WHERE	componentType = 1 AND componentId = 2 AND propertyTypeId = 3307 AND modified = 0
-- ClientType: 1 for Server, 2 for Laptop, 4 for VM
INSERT	INTO #Client
SELECT	DISTINCT CL.id, CL.displayName, 1+(CL.status&0x1000)/0x1000, @RPOInMinutes, @RTOInMinutes
FROM	APP_Client CL WITH (NOLOCK) INNER JOIN RptSLAClient S ON CL.id = S.clientId
WHERE	S.days = -1 AND S.fullJobsOnly = 0 AND S.clientId > 1 AND (S.status IN (1,2) OR S.status = 3 AND S.category = 6)
UPDATE	T SET ClientType = 4
FROM	#Client T
INNER JOIN APP_ClientProp CP WITH (NOLOCK)
 	 ON T.ClientId = CP.componentNameId
	AND	CP.attrName = 'Virtual Server Discovered Clients' AND CP.attrVal = '1' AND CP.modified =0
INNER JOIN APP_ClientProp ACP WITH (NOLOCK) ON ACP.componentNameId=T.ClientID AND ACP.attrName='Last Backup JobID'
		AND ACP.attrVal <>'0' AND  ACP.Modified=0
IF OBJECT_ID('tempdb.dbo.#ClientGroupParam') IS NOT NULL DROP TABLE #ClientGroupParam
	CREATE TABLE #ClientGroupParam (ClientGroupId INT, RPOMinutes INT, RTOMinutes INT)
INSERT	INTO #ClientGroupParam
SELECT	componentId, [3306], [3307]
FROM	(
		SELECT	componentId, propertyTypeId, longVal
		FROM	APP_ComponentProp WITH (NOLOCK)
		WHERE	componentType = 8 AND propertyTypeId IN (3304, 3305, 3306, 3307) AND modified = 0
		) T PIVOT (MAX(longVal) FOR propertyTypeId IN ([3304], [3305], [3306], [3307])) P
IF OBJECT_ID('tempdb.dbo.#ClientParam') IS NOT NULL DROP TABLE #ClientParam
	CREATE TABLE #ClientParam (ClientId INT, RPOMinutes INT, RTOMinutes INT)
INSERT	INTO #ClientParam
SELECT	componentNameId, [RPO Minutes], [RTO Minutes]
FROM	(
		SELECT	componentNameId, attrName, CAST(attrVal AS INT) AS intVal
		FROM	APP_ClientProp WITH (NOLOCK)
		WHERE	attrName IN ('RPO Minutes', 'RTO Minutes') AND modified = 0
		) T PIVOT (MAX(intVal) FOR attrName IN ([RPO Minutes], [RTO Minutes])) P
UPDATE	T SET RPOMinutes = S.RPOMinutes, RTOMinutes = S.RTOMinutes
FROM	#Client T
		INNER JOIN (
		SELECT	C.clientId, MIN(ISNULL(P.RPOMinutes, C.RPOMinutes)) AS RPOMinutes, MIN(ISNULL(P.RTOMinutes, C.RTOMinutes)) AS RTOMinutes
		FROM	#Client C INNER JOIN APP_ClientGroupAssoc A WITH (NOLOCK) ON C.clientId = A.clientId
				INNER JOIN #ClientGroupParam P ON A.clientGroupId = P.ClientGroupId
		GROUP BY C.clientId
		) S ON T.clientId = S.clientId
UPDATE	T SET RPOMinutes = ISNULL(P.RPOMinutes, T.RPOMinutes), RTOMinutes = ISNULL(P.RTOMinutes, T.RTOMinutes)
FROM	#Client T
		INNER JOIN #ClientParam P ON T.clientId = P.ClientId
CREATE TABLE #TapeOnlySP (archGrpId INT)
INSERT	INTO #TapeOnlySP
SELECT	AG.id
FROM	archGroup AG WITH (NOLOCK)
		INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AG.id = AGC.archGroupId AND AG.defaultSnapCopy = 0
		INNER JOIN MMDataPath DPT WITH (NOLOCK) ON AGC.id = DPT.CopyId AND DPT.Flag&1 = 1
		INNER JOIN MMDrivePool DPL WITH (NOLOCK) ON DPT.DrivePoolId = DPL.DrivePoolId AND DPL.DrivePoolType = 10001
GROUP BY AG.id
HAVING COUNT(DISTINCT DPT.DrivePoolId) = 0
DECLARE	@now   BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @OneMB BIGINT = 1024*1024
DECLARE @OneGB BIGINT = 1024*1024*1024
INSERT	INTO #SubclientStats
SELECT	S.clientId, S.appTypeId, S.appId, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, C.rpoMinutes, 0
FROM	RptSLASubclient S
		INNER JOIN #Client C ON S.clientId = C.clientId
WHERE	S.fullJobsOnly = 0 AND S.category IN (1,2,3,4,12,13)
UPDATE	S
SET		appId = J.appId, fullCycleNum = J.fullCycleNum*T.completed,
		LastJobId = J.jobId*T.completed, commCellId = J.commCellId*T.completed, lastBackupTime = J.servStartDate*T.completed,
		opType = J.opType, archGrpId = CASE WHEN J.dataArchGrpId > 1 THEN J.dataArchGrpId ELSE J.logArchGrpId END
FROM	#SubclientStats S
		INNER JOIN (
		SELECT	V.VMclientId,
				CASE WHEN MAX(CASE WHEN V.attrVal IN ('0', '3') THEN V.jobId ELSE 0 END) > 0
				     THEN MAX(CASE WHEN V.attrVal IN ('0', '3') THEN V.jobId ELSE 0 END)
				     ELSE MAX(V.jobId) END AS jobId,
				CASE WHEN MAX(CASE WHEN V.attrVal IN ('0', '3') THEN V.jobId ELSE 0 END) > 0 THEN 1
				     ELSE 0 END AS completed
		FROM	JMBkpStats B WITH (NOLOCK)
				INNER JOIN APP_VMProp V WITH (NOLOCK) ON B.jobId = V.jobId AND B.commCellId = V.commCellId
		WHERE	V.attrName = 'vmStatus'
			AND B.status IN (1, 3, 14) AND B.bkpLevel NOT IN (64, 128, 16384) AND B.dataStatus IN (0, 1, 3)
		GROUP BY V.VMclientId
		) T ON S.clientId = T.VMclientId
		INNER JOIN JMBkpStats J WITH (NOLOCK) ON T.jobId = J.jobId AND J.commCellId = 2
WHERE	S.appTypeId = 106
UPDATE	#SubclientStats SET maxAppSize = T.appSize
FROM	#SubclientStats S
		INNER JOIN
		(SELECT	V.VMclientId, MAX(CAST(V.attrVal AS BIGINT)) AS appSize
		FROM	JMBkpStats B WITH (NOLOCK)
				INNER JOIN #SubclientStats S1 ON B.appId = S1.appId AND B.fullCycleNum = S1.fullCycleNum
				INNER JOIN APP_VMProp V WITH (NOLOCK) ON B.jobId = V.jobId AND B.commCellId = V.commCellId
		WHERE	B.status IN (1, 3, 14) AND V.attrName = 'vmGuestSize'
		GROUP BY V.VMclientId
		) T ON S.clientId = T.VMclientId
WHERE	S.appTypeId = 106
UPDATE	S
SET		appTypeId = J.appType, fullCycleNum = J.fullCycleNum*T.completed,
		LastJobId = J.jobId*T.completed, commCellId = J.commCellId*T.completed, lastBackupTime = J.servStartDate*T.completed,
		opType = J.opType, archGrpId = CASE WHEN J.dataArchGrpId > 1 THEN J.dataArchGrpId ELSE J.logArchGrpId END
FROM	#SubclientStats S
		INNER JOIN (
		SELECT	B.appId,
				CASE WHEN MAX(CASE WHEN B.status IN (1, 14) OR B.status = 3 AND I.isCWEjobValid = 1 THEN B.jobId ELSE 0 END) > 0
				     THEN MAX(CASE WHEN B.status IN (1, 14) OR B.status = 3 AND I.isCWEjobValid = 1 THEN B.jobId ELSE 0 END)
				     ELSE MAX(B.jobId) END AS jobId,
				CASE WHEN MAX(CASE WHEN B.status IN (1, 14) OR B.status = 3 AND I.isCWEjobValid = 1 THEN B.jobId ELSE 0 END) > 0 THEN 1
				     ELSE 0 END AS completed
		FROM	JMBkpStats B WITH (NOLOCK)
				INNER JOIN APP_iDAType I WITH (NOLOCK) ON B.appType = I.type AND I.type <> 106
		WHERE	B.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
			AND B.bkpLevel NOT IN (64, 128, 16384) AND B.dataStatus IN (0, 1, 3)
		GROUP BY B.appId
		) T ON S.appId = T.appId
		INNER JOIN JMBkpStats J WITH (NOLOCK) ON T.jobId = J.jobId AND J.commCellId = 2
WHERE	S.appTypeId <> 106
UPDATE S SET rpoMinutes = PP.attrVal, planId = P.id
FROM #SubclientStats S
	INNER JOIN APP_SubClientProp SP WITH (NOLOCK) ON S.appId = SP.componentNameId AND SP.attrName = 'Associated plan'
		AND SP.cs_attrName = CHECKSUM(N'Associated Plan') AND SP.modified = 0
	INNER JOIN App_PlanProp PP WITH (NOLOCK) ON SP.attrVal = PP.componentNameId AND PP.attrName = 'RPO In Minutes' AND PP.modified = 0
	INNER JOIN App_Plan P WITH (NOLOCK)  ON P.id = PP.componentNameId
UPDATE C SET RPOMinutes = T.rpoMinutes
FROM #Client C
	INNER JOIN (
		SELECT clientId, MIN(rpominutes) AS rpoMinutes
		FROM  #SubclientStats
		GROUP BY clientid
	) T ON C.clientId = T.clientid
UPDATE	S SET maxAppSize = T.appSize
FROM	#SubclientStats S
		INNER JOIN
		(SELECT	B.appId, MAX(B.totalUncompBytes) AS appSize
		FROM	JMBkpStats B WITH (NOLOCK)
				INNER JOIN #SubclientStats S1 ON B.appId = S1.appId AND B.fullCycleNum >= S1.fullCycleNum
		WHERE	S1.appTypeId <> 106
		GROUP BY B.appId
		) T ON S.appId = T.appId
WHERE	S.appTypeId <> 106 AND S.maxAppSize = 0
UPDATE	S SET rstThruputMbps = (1.0*T.AppSize/T.WriteTime/@OneMB)/@RstBkpTimeRatio
FROM	#SubclientStats S
		INNER JOIN
		(SELECT	B.appId, SUM(B.totalUncompBytes) AS AppSize, SUM(B.totalWriteTime) AS WriteTime
		FROM	#SubclientStats S1
				INNER JOIN JMBkpStats B WITH (NOLOCK) ON S1.appId = B.appId
		WHERE	B.opType NOT IN (59, 65) AND B.bkpLevel IN (1, 64, 128, 1024, 16384, 32768)
			AND B.totalUncompBytes > 100*@OneMB AND B.totalWriteTime > 0
		GROUP BY B.appId
		) T ON S.appId = T.appId
-- Apply average throughput at app type or app group levels if not set
CREATE TABLE #RstThruputByClientAppType (clientId INT, appTypeId INT, duration BIGINT, appSizeMB FLOAT, thruputMbps FLOAT)
CREATE TABLE #RstThruputByAppType (appTypeId INT, duration BIGINT, appSizeMB FLOAT, thruputMbps FLOAT)
CREATE TABLE #RstThruputByApp (appName VARCHAR(256), thruputMbps FLOAT)
CREATE TABLE #RstThruputByAppGroup (appGroupName VARCHAR(256), thruputMbps FLOAT)
DECLARE @rstThruputGBPerHr FLOAT
INSERT	#RstThruputByClientAppType
SELECT	clientId, appTypeId, duration, appSizeMB, (1.0*appSizeMB)/(1.0*duration)
FROM	(SELECT	clientId, appTypeId,
				SUM(1.0*maxAppSize/@OneMB/rstThruputMbps) AS duration,
				SUM(1.0*maxAppSize/@OneMB) AS appSizeMB
		FROM	#SubclientStats
		WHERE	maxAppSize > 100*@OneMB AND rstThruputMbps > 0
		GROUP BY clientId, appTypeId
		) S
WHERE	duration > 0
INSERT	#RstThruputByAppType
SELECT	appTypeId, SUM(duration), SUM(appSizeMB), SUM(appSizeMB)/(1.0*SUM(duration))
FROM	#RstThruputByClientAppType
GROUP BY appTypeId
INSERT	INTO #RstThruputByApp
SELECT	ATG.app, SUM(T.appSizeMB)/(1.0*SUM(duration))
FROM	#RstThruputByAppType T
		INNER JOIN APP_AppTypeGroups ATG WITH (NOLOCK) ON T.appTypeId = ATG.appTypeId
GROUP BY ATG.app
INSERT	INTO #RstThruputByAppGroup
SELECT	ATG.appGroup, SUM(T.appSizeMB)/(1.0*SUM(duration))
FROM	#RstThruputByAppType T
		INNER JOIN APP_AppTypeGroups ATG WITH (NOLOCK) ON T.appTypeId = ATG.appTypeId
GROUP BY ATG.appGroup
SELECT	@rstThruputGBPerHr = SUM(appSizeMB)/(1.0*SUM(duration))
FROM	#RstThruputByAppType
UPDATE	#SubclientStats SET rstThruputMbps = T.thruputMbps
FROM	#SubclientStats S
		INNER JOIN #RstThruputByClientAppType T ON S.clientId = T.clientId AND S.appTypeId = T.appTypeId
WHERE	opType NOT IN (59, 65) AND rstThruputMbps = 0
UPDATE	#SubclientStats SET rstThruputMbps = T.thruputMbps
FROM	#SubclientStats S
		INNER JOIN #RstThruputByAppType T ON S.appTypeId = T.appTypeId
WHERE	opType NOT IN (59, 65) AND rstThruputMbps = 0
UPDATE	#SubclientStats SET rstThruputMbps = T.thruputMbps
FROM	#SubclientStats S
		INNER JOIN APP_AppTypeGroups ATG WITH (NOLOCK) ON S.appTypeId = ATG.appTypeId
		INNER JOIN #RstThruputByApp T ON ATG.app = T.appName
WHERE	opType NOT IN (59, 65) AND rstThruputMbps = 0
UPDATE	#SubclientStats SET rstThruputMbps = T.thruputMbps
FROM	#SubclientStats S
		INNER JOIN APP_AppTypeGroups ATG WITH (NOLOCK) ON S.appTypeId = ATG.appTypeId
		INNER JOIN #RstThruputByAppGroup T ON ATG.appGroup = T.appGroupName
WHERE	opType NOT IN (59, 65) AND rstThruputMbps = 0
UPDATE	#SubclientStats SET rstThruputMbps = @rstThruputGBPerHr
WHERE	opType NOT IN (59, 65) AND rstThruputMbps = 0
DROP TABLE #RstThruputByClientAppType
DROP TABLE #RstThruputByAppType
DROP TABLE #RstThruputByApp
DROP TABLE #RstThruputByAppGroup
-- If tape exported
CREATE TABLE #ChunksOnTape (appId INT, archChunkId INT, chunkCommCellId INT)
IF EXISTS (SELECT 1 FROM #TapeOnlySP)
BEGIN
	INSERT	INTO #ChunksOnTape
	SELECT	DISTINCT S.appId, ACM.archChunkId, ACM.chunkCommCellId
	FROM	#SubclientStats S
			INNER JOIN JMBkpStats B WITH (NOLOCK) ON S.appId = B.appId AND S.fullCycleNum = B.fullCycleNum
			INNER JOIN #TapeOnlySP T ON B.dataArchGrpId = T.archGrpId OR B.logArchGrpId = T.archGrpId
			INNER JOIN archChunkMapping ACM WITH (NOLOCK) ON B.jobId = ACM.jobId AND B.commCellId = ACM.commCellId
	WHERE	ACM.flags&256 = 0 AND ACM.physicalSize > 0
	UPDATE	S SET tapeExported = 1
	FROM	#SubclientStats S
			INNER JOIN
			(SELECT	T.appId, COUNT(V.MediaId) AS tapeExported
			FROM	#ChunksOnTape T
					INNER JOIN archChunk AC WITH (NOLOCK) ON T.archChunkId = AC.id AND T.chunkCommCellId = AC.commCellId
					INNER JOIN MMVolume V WITH (NOLOCK) ON AC.volumeId = V.VolumeId
					INNER JOIN MMMedia M WITH (NOLOCK) ON V.MediaId = M.MediaId
			WHERE	M.MediaLocation >= 3
			GROUP BY T.appId
			HAVING COUNT(V.MediaId) > 0
			) T ON S.appId = T.appId
END
DROP TABLE #ChunksOnTape
DROP TABLE #TapeOnlySP
-- restoreTime from snap remains 0
UPDATE	#SubclientStats SET restoreTime = (1.0*maxAppSize)/@OneMB/rstThruputMbps
WHERE	opType NOT IN (59, 65) AND rstThruputMbps > 0
CREATE TABLE #DBAgentStats (clientId INT, appTypeId INT, instanceId INT, backupsetId INT, lastBackupTime INT, maxAppSize FLOAT, tapeExported INT, restoreTime INT)
-- For Informix, SyBase, Oracle, SAP for Oracle, Oracle for SAP DB, Oracle RAC and MySQL
INSERT	INTO #DBAgentStats
SELECT	T.clientId, T.appTypeId, T.instance, 0, T.lastBackupTime, T.maxAppSize, T.tapeExported, (1.0*T.maxAppSize)/@OneMB/T.rstThruputMbps
FROM	(SELECT	S.clientId, S.appTypeId, A.instance, S.lastBackupTime, S.maxAppSize, S.rstThruputMbps, S.tapeExported,
				ROW_NUMBER() OVER (PARTITION BY S.clientId, S.appTypeId, A.instance ORDER BY lastBackupTime DESC) AS RowNo
		FROM	#SubclientStats S
				INNER JOIN APP_Application A WITH (NOLOCK) ON S.appId = A.id
		WHERE	opType NOT IN (59, 65) AND S.appTypeId IN (3,5,22,61,79,80,104,128)
		) T
WHERE	RowNo = 1
-- For DB2, UNIX DB2, DB2 DPF and SAP HANA
INSERT	INTO #DBAgentStats
SELECT	T.clientId, T.appTypeId, T.instance, T.backupSet, T.lastBackupTime, T.maxAppSize, T.tapeExported, (1.0*T.maxAppSize)/@OneMB/T.rstThruputMbps
FROM	(SELECT	S.clientId, S.appTypeId, A.instance, A.backupSet, S.lastBackupTime, S.maxAppSize, S.rstThruputMbps, S.tapeExported,
				ROW_NUMBER() OVER (PARTITION BY S.clientId, S.appTypeId, A.instance ORDER BY lastBackupTime DESC) AS RowNo
		FROM	#SubclientStats S
				INNER JOIN APP_Application A WITH (NOLOCK) ON S.appId = A.id
		WHERE	opType NOT IN (59, 65) AND S.appTypeId IN (37,62,103,135)
		) T
WHERE	RowNo = 1
INSERT	INTO #ClientRecovery
SELECT	clientId, MIN(lastBackupTime), SUM(maxAppSize), MAX(tapeExported), SUM(restoreTime), 0, 0
FROM	#SubclientStats
WHERE	appTypeId NOT IN (3,5,22,61,79,80,104,128,37,62,103,135)
GROUP BY clientId
UPDATE	#ClientRecovery
SET		lastBackupTime = CASE WHEN T.lastBackupTime < S.lastBackupTime THEN T.lastBackupTime ELSE S.lastBackupTime END,
		appSize += S.appSize,
		restoreTime += S.restoreTime,
		tapeExported |= S.tapeExported
FROM	#ClientRecovery T
		INNER JOIN (
			SELECT	clientId, MIN(lastBackupTime) AS lastBackupTime, SUM(maxAppSize) AS appSize,
					SUM(restoreTime) AS restoreTime, MAX(tapeExported) AS tapeExported
			FROM	#DBAgentStats
			GROUP BY clientId
		) S ON T.clientId = S.clientId
DELETE	#DBAgentStats
FROM	#DBAgentStats S INNER JOIN #ClientRecovery T ON T.clientId = S.clientId
INSERT	INTO #ClientRecovery
SELECT	clientId, MIN(lastBackupTime), SUM(maxAppSize), MAX(tapeExported), SUM(restoreTime), 0, 0
FROM	#DBAgentStats
GROUP BY clientId
DROP TABLE #DBAgentStats
UPDATE	T SET restoreTime += @TapeImportMinutes*60
FROM	#ClientRecovery T
WHERE	tapeExported > 0
UPDATE	S
SET		lastBackupTime = CASE WHEN S.lastBackupTime > ISNULL(VR.lastBackupTime,0) THEN S.lastBackupTime ELSE VR.lastBackupTime END,
		restoreTime = 600, -- Need to update actual VM BOOT time
		protectionType = 1 -- 'Live Sync'
FROM	#SubclientStats S
		INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON S.clientId = CP.componentNameId AND CP.attrName = 'Virtual Machine Instance UUID' AND CP.modified = 0
		INNER JOIN APP_VSAReplication VR WITH (NOLOCK) ON VR.sourceGuid = CP.attrVal
		INNER JOIN TM_SubTask ST WITH (NOLOCK) ON VR.taskId = ST.taskId
		INNER JOIN TM_SubTaskXMLOptions SX WITH (NOLOCK) ON SX.subtaskId = ST.subtaskid
WHERE	S.appTypeId = 106
UPDATE	R SET rpoStatus = 1
FROM	#ClientRecovery R INNER JOIN #Client C ON R.clientId = C.clientId
WHERE	(@now-R.lastBackupTime) < C.rpoMinutes*60
UPDATE	R SET rtoStatus = 1
FROM	#ClientRecovery R INNER JOIN #Client C ON R.clientId = C.clientId
WHERE	R.lastBackupTime > 0 AND R.restoreTime < C.rtoMinutes*60
DELETE	RptRpoRtoSubclient WHERE date >= @today
DECLARE @LatestRPTSLAClientCollection DATETIME
SELECT  @LatestRPTSLAClientCollection=(SELECT MAX(DATE) FROM RptSLAclient)
INSERT	INTO RptRpoRtoSubclient
SELECT	@currTime, clientId, appId, appTypeId, LastJobId, lastBackupTime, protectionType, maxAppSize, restoreTime, tapeExported, planId, rpoMinutes
FROM	#SubclientStats S
WHERE    NOT EXISTS
			(SELECT 1 FROM RptSLAclient R WHERE R.ClientID=S.ClientID  AND R.Status=3 AND days=-1 AND R.DATE=@LatestRPTSLAClientCollection)
DELETE	RptRpoRtoClient WHERE date >= @today
INSERT	INTO RptRpoRtoClient
SELECT	@currTime, C.clientId, C.clientType, R.lastBackupTime, R.appSize, R.restoreTime, C.rpoMinutes, C.rtoMinutes, R.rpoStatus, R.rtoStatus
FROM	#Client C INNER JOIN #ClientRecovery R ON C.clientId = R.clientId
WHERE    NOT EXISTS
			(SELECT 1 FROM RptSLAclient RC WHERE RC.ClientID=C.ClientID AND RC.Status=3 AND days=-1 AND RC.DATE=@LatestRPTSLAClientCollection)
-- Nothing to Backup , Mark as Met
	UPDATE R
				 SET rpoStatus=1
				FROM RptRpoRtoClient R JOIN
				(SELECT ClientID ,Count(distinct appId) SubclientTot ,SUM(CASE WHEN Category=13 THEN 1 else 0 end ) NothignTobackup
						FROM
							RptSLASubclient WHERE Date=@LatestRPTSLAClientCollection
					GROUP By ClientID
				) NTB
				ON R.ClientID=NTB.clientId
				  WHERE
						SubclientTot=NothignTobackup and R.RpoStatus=0 AND R.Date=@today
		DECLARE @csTimeZone NVARCHAR(1024) = ''
		SELECT  @csTimeZone = dbo.GetClientTimeZone(2)
		IF ISNULL(@csTimeZone, '') = ''
		BEGIN
		    SELECT @csTimeZone = timeZone FROM APP_CommCell WITH (NOLOCK) WHERE id = 2
		    SELECT @csTimeZone = TimeZoneStdName FROM SchedTimeZone WITH (NOLOCK)
		    WHERE  TimeZoneName = SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)
		END
		DECLARE @LastUpdateDate DATETIME ,@t int
        SET @LastUpdateDate = (SELECT MAX(date) FROM RptRpoRtoSubclient)
IF @LastUpdateDate IS NOT NULL
BEGIN
	SET @t = dbo.GetUnixTime(dbo.LocalToUTCTime(@LastUpdateDate, @csTimeZone))
	UPDATE R
				SET rpoStatus=MetRPO
				 FROM RptRpoRtoClient R JOIN
				 (SELECT s.ClientID ,MAX(CASE WHEN (@t-S.recoveryPoint) < S.RPOMinutes*60 THEN 1 ELSE 0 END )   MetRPO
				 	FROM RptRpoRtoSubclient S
					 JOIN RptRpoRtoSubclient s2 ON s.clientId =s2.clientId
				   WHERE s2.apptypeid=106 and
				s.date<=@today  and s2.date<=@today
					GROUP By s.ClientID
					) VirtualServer
					ON R.ClientID=VirtualServer.clientId
                    WHERE R.Date= @today and R.RpoStatus=0
END
INSERT	INTO #RpoRtoSummary
SELECT	@currTime, 0, SUM(rpoStatus), COUNT(clientId)-SUM(rpoStatus), SUM(rtoStatus), COUNT(clientId)-SUM(rtoStatus)
FROM	#ClientRecovery
UNION ALL
SELECT	@currTime, C.clientType, SUM(R.rpoStatus), COUNT(R.clientId)-SUM(R.rpoStatus), SUM(R.rtoStatus), COUNT(R.clientId)-SUM(R.rtoStatus)
FROM	#ClientRecovery R INNER JOIN #Client C ON R.clientId = C.clientId
GROUP BY C.clientType
DELETE	RptRpoRtoSummary WHERE date >= @today
INSERT	INTO RptRpoRtoSummary
SELECT	date, clientType, ISNULL(clientsMetRpo, 0), ISNULL(clientsMissedRpo, 0), ISNULL(clientsMetRto, 0), ISNULL(clientsMissedRto, 0)
FROM	#RpoRtoSummary
DROP TABLE #RpoRtoSummary
DROP TABLE #SubclientStats
DROP TABLE #ClientRecovery
DROP TABLE #Client
-- Prune RptRpoRtoSubclient, RptRpoRtoClient and RptRpoRtoSummary tables
DECLARE	@agingDate	DATETIME
SET	@agingDate = DATEADD(DAY, -8, @today)
DELETE RptRpoRtoClient WHERE date < @agingDate
DELETE RptRpoRtoSubclient WHERE date < @agingDate
DELETE RptRpoRtoSummary WHERE date < @agingDate
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptSaveRpoRto')
	delete from GxQscripts where name = 'RptSaveRpoRto'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSaveRpoRto')
	delete from GXDBVersions where aliasname = 'RptSaveRpoRto'
GO

insert into GXDBVersions values(2, 'RptSaveRpoRto',  'v1.1.2.9.20.1', 'RptSaveRpoRto', 'v1.1.2.9.20.1')
GO

