

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptSaveDedupRatios.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptSaveDedupRatios.sp,v $ $Id: RptSaveDedupRatios.sp,v 1.1.2.6 2020/06/25 15:28:08 junlu Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptSaveDedupRatios')
BEGIN
	print '>>> Drop Stored Procedure: RptSaveDedupRatios <<<'
	drop procedure RptSaveDedupRatios
END
IF EXISTS (select * from GxQscripts where name='RptSaveDedupRatios')
	delete from GxQscripts where name = 'RptSaveDedupRatios'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSaveDedupRatios')
	delete from GXDBVersions where aliasname = 'RptSaveDedupRatios'
GO
print '... Creating Procedure: RptSaveDedupRatios'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptSaveDedupRatios
  @dummy integer
AS
  DECLARE @retVal integer = 0;
SET NOCOUNT ON
SET DATEFIRST 1
-- Insert hourly entries. This procedure is executed once an hour by EvMgrS process.
IF OBJECT_ID('tempdb.dbo.#DedupeCopy') IS NOT NULL DROP TABLE #DedupeCopy
CREATE TABLE #DedupeCopy (
	archGrpCopyId INT, activeStoreId INT, dedupeFlags INT,
	dataRead BIGINT, dataWritten BIGINT,
	dedupRatio FLOAT, dedupSaving DECIMAL(10,2)
)
EXEC DedupCopySaving 0
DECLARE @currTime DATETIME = GETDATE()
DECLARE @currDate DATETIME = CAST(@currTime AS DATE)
INSERT	INTO RptDedupRatios
SELECT	@currTime, 0, archGrpCopyId, dedupRatio
FROM	#DedupeCopy
-- Insert daily entries
DECLARE @fromDate DATETIME = (SELECT MAX(startDT) FROM RptDedupRatios WHERE type = 1)
IF  @fromDate IS NULL
BEGIN
	SET @fromDate = (SELECT MIN(startDT) FROM RptDedupRatios WHERE type = 0)
	IF  ISNULL(@fromDate, '1970-01-01') < DATEADD(DAY, -1, @currDate)
		SET @fromDate = DATEADD(DAY, -1, @currDate)
	ELSE
		SET @fromDate = DATEADD(DAY, DATEDIFF(DAY, 0, @fromDate), 0)
END
ELSE
	SET @fromDate = DATEADD(DAY, 1, @fromDate)
IF OBJECT_ID('tempdb.dbo.#AvgDedupRatio') IS NOT NULL DROP TABLE #AvgDedupRatio
CREATE TABLE #AvgDedupRatio (startDT DATE, copyId INT, avgRatio FLOAT, stDevRatio FLOAT)
IF  DATEDIFF(DAY, @fromDate, @currDate) >= 1
BEGIN
	INSERT	INTO #AvgDedupRatio
	SELECT	CAST(startDT AS DATE), copyId, AVG(dedupRatio), ISNULL(STDEV(dedupRatio),0)+0.0000000001
	FROM	RptDedupRatios
	WHERE	startDT >= @fromDate AND startDT < @currDate AND type = 0 AND dedupRatio > 0 AND dedupRatio < 1
	GROUP BY CAST(startDT AS DATE), copyId
	INSERT	INTO RptDedupRatios
	SELECT	T.startDT, 1, T.copyId, AVG(R.dedupRatio)
	FROM	RptDedupRatios R
			INNER JOIN #AvgDedupRatio T ON CAST(R.startDT AS DATE) = T.startDT AND R.copyId = T.copyId
	WHERE	R.startDT >= @fromDate AND R.startDT < @currDate AND R.type = 0 AND R.dedupRatio > 0 AND R.dedupRatio < 1
			AND R.dedupRatio BETWEEN (avgRatio-stDevRatio) AND (avgRatio+stDevRatio)
	GROUP BY T.startDT, T.copyId
	INSERT	INTO RptDedupRatios
	SELECT	T.startDT, 1, T.copyId, 1
	FROM	(SELECT	DISTINCT CAST(startDT AS DATE) AS startDT, copyId
			FROM	RptDedupRatios
			WHERE	startDT >= @fromDate AND startDT < @currDate AND type = 0
			) T
			LEFT OUTER JOIN RptDedupRatios R ON T.startDT = R.startDT AND T.copyId = R.copyId AND R.type = 1
	WHERE	R.copyId IS NULL
END
-- Insert weekly entries
DECLARE	@currWeek DATETIME = DATEADD(DAY, 1-DATEPART(WEEKDAY, @currDate), @currDate)
SET @fromDate = (SELECT MAX(startDT) FROM RptDedupRatios WHERE type = 3)
IF  @fromDate IS NULL
BEGIN
	SET @fromDate = (SELECT MIN(startDT) FROM RptDedupRatios WHERE type = 0)
	IF  ISNULL(@fromDate, '1970-01-01') < DATEADD(DAY, -7, @currWeek)
		SET @fromDate = DATEADD(DAY, -7, @currWeek)
	ELSE
		SET @fromDate = DATEADD(DAY, 1-DATEPART(WEEKDAY, @fromDate), @fromDate)
END
ELSE
	SET @fromDate = DATEADD(DAY, 7, @fromDate)
IF  DATEDIFF(DAY, @fromDate, @currWeek) >= 7
BEGIN
	DELETE	FROM #AvgDedupRatio
	INSERT	INTO #AvgDedupRatio
	SELECT	DATEADD(DAY, 1-DATEPART(WEEKDAY, startDT), CAST(startDT AS DATE)), copyId, AVG(dedupRatio), ISNULL(STDEV(dedupRatio),0)+0.0000000001
	FROM	RptDedupRatios
	WHERE	startDT >= @fromDate AND startDT < @currWeek AND type = 0 AND dedupRatio > 0 AND dedupRatio < 1
	GROUP BY DATEADD(DAY, 1-DATEPART(WEEKDAY, startDT), CAST(startDT AS DATE)), copyId
	INSERT	INTO RptDedupRatios
	SELECT	T.startDT, 3, T.copyId, AVG(R.dedupRatio)
	FROM	RptDedupRatios R
			INNER JOIN #AvgDedupRatio T ON DATEADD(DAY, 1-DATEPART(WEEKDAY, R.startDT), CAST(R.startDT AS DATE)) = T.startDT AND R.copyId = T.copyId
	WHERE	R.startDT >= @fromDate AND R.startDT < @currWeek AND R.type = 0 AND dedupRatio > 0 AND R.dedupRatio < 1
			AND dedupRatio BETWEEN (avgRatio-stDevRatio) AND (avgRatio+stDevRatio)
	GROUP BY T.startDT, T.copyId
	INSERT	INTO RptDedupRatios
	SELECT	T.startDT, 3, T.copyId, 1
	FROM	(SELECT	DISTINCT DATEADD(DAY, 1-DATEPART(WEEKDAY, startDT), CAST(startDT AS DATE)) AS startDT, copyId
			FROM	RptDedupRatios
			WHERE	startDT >= @fromDate AND startDT < @currWeek AND type = 0
			) T
			LEFT OUTER JOIN RptDedupRatios R ON T.startDT = R.startDT AND T.copyId = R.copyId AND R.type = 3
	WHERE	R.copyId IS NULL
END
-- Insert monthly entries
DECLARE	@currMonth DATETIME = DATEADD(MONTH, DATEDIFF(MONTH, 0, @currDate), 0)
SET @fromDate = (SELECT MAX(startDT) FROM RptDedupRatios WHERE type = 2)
IF  @fromDate IS NULL
BEGIN
	SET @fromDate = (SELECT MIN(startDT) FROM RptDedupRatios WHERE type = 0)
	IF  ISNULL(@fromDate, '1970-01-01') < DATEADD(MONTH, -1, @currMonth)
		SET @fromDate = DATEADD(MONTH, -1, @currMonth)
	ELSE
		SET @fromDate = DATEADD(MONTH, DATEDIFF(MONTH, 0, @fromDate), 0)
END
ELSE
	SET @fromDate = DATEADD(MONTH, 1, @fromDate)
IF  DATEDIFF(MONTH, @fromDate, @currMonth) >= 1
BEGIN
	DELETE	FROM #AvgDedupRatio
	INSERT	INTO #AvgDedupRatio
	SELECT	DATEADD(MONTH, DATEDIFF(MONTH, 0, startDT), 0), copyId, AVG(dedupRatio), ISNULL(STDEV(dedupRatio),0)+0.0000000001
	FROM	RptDedupRatios
	WHERE	startDT >= @fromDate AND startDT < @currMonth AND type = 0 AND dedupRatio > 0 AND dedupRatio < 1
	GROUP BY DATEADD(MONTH, DATEDIFF(MONTH, 0, startDT), 0), copyId
	INSERT	INTO RptDedupRatios
	SELECT	T.startDT, 2, T.copyId, AVG(R.dedupRatio)
	FROM	RptDedupRatios R
			INNER JOIN #AvgDedupRatio T ON DATEADD(MONTH, DATEDIFF(MONTH, 0, R.startDT), 0) = T.startDT AND R.copyId = T.copyId
	WHERE	R.startDT >= @fromDate AND R.startDT < @currMonth AND R.type = 0 AND dedupRatio > 0 AND R.dedupRatio < 1
			AND dedupRatio BETWEEN (avgRatio-stDevRatio) AND (avgRatio+stDevRatio)
	GROUP BY T.startDT, T.copyId
	INSERT	INTO RptDedupRatios
	SELECT	T.startDT, 2, T.copyId, 1
	FROM	(SELECT	DISTINCT DATEADD(MONTH, DATEDIFF(MONTH, 0, startDT), 0) AS startDT, copyId
			FROM	RptDedupRatios
			WHERE	startDT >= @fromDate AND startDT < @currMonth AND type = 0
			) T
			LEFT OUTER JOIN RptDedupRatios R ON T.startDT = R.startDT AND T.copyId = R.copyId AND R.type = 2
	WHERE	R.copyId IS NULL
END
-- Prune old entries
DECLARE	@agingDate	DATETIME
DECLARE	@agingDays	INT = 32
SELECT	@agingDays = CAST(value AS INT)
FROM	GXGlobalParam WITH (NOLOCK)
WHERE	name = 'Days to keep hourly dedup ratio of copies'
SET	@agingDate = DATEADD(DAY, -@agingDays, @currDate)
DELETE RptDedupRatios WHERE startDT < @agingDate AND type IN (0, 1)
SET	@agingDays = 52*7
SET	@agingDate = DATEADD(DAY, -@agingDays, @currDate)
DELETE RptDedupRatios WHERE startDT < @agingDate AND type = 3
SET	@agingDate = DATEADD(MONTH, -24, @currDate)
DELETE RptDedupRatios WHERE startDT < @agingDate AND type = 2
SELECT	@retVal
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptSaveDedupRatios')
	delete from GxQscripts where name = 'RptSaveDedupRatios'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSaveDedupRatios')
	delete from GXDBVersions where aliasname = 'RptSaveDedupRatios'
GO

insert into GXDBVersions values(2, 'RptSaveDedupRatios',  '00010001000200060000', 'RptSaveDedupRatios', '00010001000200060000')
GO

