

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptSaveActivityStat.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptSaveActivityStat.sp,v $ $Id: RptSaveActivityStat.sp,v 1.6.34.2 2018/03/20 00:46:49 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptSaveActivityStat <<<'

IF EXISTS (select * from sysobjects where name='RptSaveActivityStat')
	drop procedure RptSaveActivityStat
IF EXISTS (select * from GxQscripts where name='RptSaveActivityStat')
	delete from GxQscripts where name = 'RptSaveActivityStat'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSaveActivityStat')
	delete from GXDBVersions where aliasname = 'RptSaveActivityStat'
GO
print '... Creating Procedure: RptSaveActivityStat'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptSaveActivityStat
  @dummy integer
AS
  DECLARE @retVal integer;
SET NOCOUNT ON
-- 1. Starting from v11, RptActivityStat table is created in package
-- 2. Populate RptActivityStat table
DECLARE @csTZ NVARCHAR(255) = ''
SELECT	@csTZ = dbo.GetClientTimeZone(2)
IF ISNULL(@csTZ, '') = ''
BEGIN
	SELECT	@csTZ = timeZone FROM APP_CommCell WITH (NOLOCK) WHERE id = 2
	SELECT  @csTZ = TimeZoneStdName
	FROM    SchedTimeZone WITH (NOLOCK)
	WHERE   TimeZoneName = SUBSTRING(@csTZ, CHARINDEX(':', @csTZ, CHARINDEX(':', @csTZ, 0) + 1) + 1, 255)
END
DECLARE	@lastDate	DATETIME = (SELECT MAX(date) FROM RptActivityStat)
DECLARE	@currDate	DATETIME = DATEADD(DD, DATEDIFF(DD, 0, GETDATE()), 0)
DECLARE @ExcludedAppIds TABLE (appId INT)
INSERT INTO @ExcludedAppIds
SELECT componentNameId FROM APP_subclientProp WITH (NOLOCK) WHERE attrName IN ('DDB Backup', 'SILO Copy ID') AND attrVal <> '0' AND modified = 0
UNION
SELECT id FROM APP_Application WITH (NOLOCK)
WHERE clientId IN (SELECT componentNameId FROM APP_ClientProp WITH (NOLOCK) WHERE attrName = 'Content Index Server' AND attrVal = '1' AND modified = 0)
-- At the first time, start from the current month
IF	@lastDate IS NULL
	SET @lastDate = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0)
ELSE
	SET @lastDate = DATEADD(DD, DATEDIFF(DD, 0, @lastDate) + 1, 0)
DECLARE	@dtBegin	DATETIME = @lastDate
DECLARE	@dtEnd		DATETIME = DATEADD(DAY, 1, @dtBegin)
DECLARE	@utBegin	INT = dbo.GetUnixTime(dbo.LocalToUTCTime(@dtBegin, @csTZ))
DECLARE	@utEnd		INT = dbo.GetUnixTime(dbo.LocalToUTCTime(@dtEnd, @csTZ))
WHILE (@dtBegin < @currDate)
BEGIN
	INSERT INTO RptActivityStat
	SELECT	@dtBegin,
			ISNULL(SUM(CASE WHEN status = 1 THEN 1 ELSE 0 END), 0),
			ISNULL(SUM(CASE WHEN status = 3 THEN 1 ELSE 0 END), 0),
			ISNULL(SUM(CASE WHEN status = 14 THEN 1 ELSE 0 END), 0),
			ISNULL(SUM(CASE WHEN status = 4 THEN 1 ELSE 0 END), 0),
			ISNULL(SUM(CASE WHEN status IN (1,3,14,4) THEN 0 ELSE 1 END), 0),
			appType
	FROM	JMBkpStats WITH (NOLOCK)
	WHERE	servEndDate >= @utBegin AND servEndDate < @utEnd
		AND opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
		AND appId NOT IN (SELECT appId FROM @ExcludedAppIds)
	GROUP BY appType
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO ERR_RETURN
	SET @dtBegin = @dtEnd
	SET @dtEnd   = DATEADD(DAY, 1, @dtBegin)
	SET @utBegin = dbo.GetUnixTime(dbo.LocalToUTCTime(@dtBegin, @csTZ))
	SET @utEnd   = dbo.GetUnixTime(dbo.LocalToUTCTime(@dtEnd, @csTZ))
END
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO ERR_RETURN
-- 3. Prune old RptActivityStat entries
DECLARE	@agingDate	DATETIME
DECLARE	@agingDays	INT = 400
SELECT	@agingDays = CAST(value AS INT)
FROM	GXGlobalParam WITH (NOLOCK)
WHERE	name = 'Days to keep job stats'
SET	@agingDate = DATEADD(DAY, -@agingDays, @currDate)
DELETE RptActivityStat WHERE date < @agingDate
ERR_RETURN:
SELECT	@retVal
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptSaveActivityStat')
	delete from GxQscripts where name = 'RptSaveActivityStat'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSaveActivityStat')
	delete from GXDBVersions where aliasname = 'RptSaveActivityStat'
GO

insert into GXDBVersions values(2, 'RptSaveActivityStat',  '00010006003400020000', 'RptSaveActivityStat', '00010006003400020000')
GO

