

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptRstHistoryInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems,  Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems,  Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptRstHistoryInfo.sp,v $ $Id: RptRstHistoryInfo.sp,v 1.89.36.10 2020/01/07 06:09:28 jge Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "rptRstHistoryInfo"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptRstHistoryInfo')
BEGIN
	print '>>> Drop Stored Procedure: rptRstHistoryInfo <<<'
	drop procedure rptRstHistoryInfo
END
IF EXISTS (select * from GxQscripts where name='rptRstHistoryInfo')
	delete from GxQscripts where name = 'rptRstHistoryInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptRstHistoryInfo')
	delete from GXDBVersions where aliasname = 'rptRstHistoryInfo'
GO
print '... Creating Procedure: rptRstHistoryInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptRstHistoryInfo
  @i_jobId integer
AS
  DECLARE @o_type integer;
  DECLARE @o_total integer;
  DECLARE @o_success integer;
  DECLARE @o_active integer;
  DECLARE @o_partSuc integer;
  DECLARE @o_killed integer;
  DECLARE @o_commcellId integer;
  DECLARE @o_srcClientId integer;
  DECLARE @o_srcClientName nchar(255);
  DECLARE @o_destClientId integer;
  DECLARE @o_destClientName nchar(255);
  DECLARE @o_appType integer;
  DECLARE @o_appTypeName char(255);
  DECLARE @o_instance integer;
  DECLARE @o_instanceName nchar(255);
  DECLARE @o_backupSet integer;
  DECLARE @o_backupSetName nchar(255);
  DECLARE @o_jobId integer;
  DECLARE @o_status integer;
  DECLARE @o_state integer;
  DECLARE @o_startTime integer;
  DECLARE @o_endTime integer;
  DECLARE @o_duration integer;
  DECLARE @o_currentPhaseName char(255);
  DECLARE @o_rstSize bigint;
  DECLARE @o_object bigint;
  DECLARE @o_totSuc bigint;
  DECLARE @o_totSkipped bigint;
  DECLARE @o_totFailed bigint;
  DECLARE @o_initFrom integer;
  DECLARE @o_userName nchar(255);
  DECLARE @o_optype integer;
  DECLARE @o_cellName char(255);
  DECLARE @o_path nchar(1024);
  DECLARE @o_mediaList char(1024);
  DECLARE @o_failReasonIds char(255);
  DECLARE @o_failReason nvarchar(MAX);
  DECLARE @o_jobDescription nvarchar(MAX);
  DECLARE @o_clientDesc nvarchar(MAX);
  DECLARE @o_idaDesc nvarchar(MAX);
  DECLARE @o_instanceDesc nvarchar(MAX);
  DECLARE @o_bkpSetDesc nvarchar(MAX);
  DECLARE @o_MediaDesc nvarchar(MAX);
  DECLARE @o_srcClientGrp nvarchar(MAX);
  DECLARE @o_destClientGrp nvarchar(MAX);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @selJobId		integer = 0 --filter results based on user given job Id
DECLARE @userId			integer
DECLARE @locId			integer
DECLARE @rptType		integer
DECLARE @startTime		integer
DECLARE @endTime		integer
DECLARE @active			integer
DECLARE @history		integer
DECLARE @needStatus		integer
DECLARE @noBkp			integer
DECLARE @noRun			integer
DECLARE @failed			integer
DECLARE @delayed		integer
DECLARE @order			integer
DECLARE @clOpt			integer
DECLARE @appTypeOpt		integer
DECLARE @useCSTime		integer
DECLARE @flags			bigint
DECLARE @tblStatus		TABLE (status int)
DECLARE @tblClients		TABLE (t_clId int)
DECLARE @tblApptypes		TABLE (t_appTypeId int)
DECLARE @tblRptApptypes		TABLE (t_rptTypeId int, t_appTypeId int)
DECLARE @tblSummary		TABLE (tot INT, tid INT, st INT, et INT, ts BIGINT)
DECLARE @jobDesc		nvarchar(4000)
DECLARE @includeClientDesc		integer
DECLARE	@performanceJobsOnly	integer
DECLARE @errorCode	integer = 0
DECLARE @errorCodeFilter	int = 0
DECLARE @showSyncRestores INT = ISNULL((SELECT CAST(value AS INT) FROM GXGlobalParam WITH (NOLOCK)
								WHERE name = 'JMShowSyncRestoreJobs' ), 0)
DECLARE @useAbsTimeRangeForJobSummaryRpt INTEGER
IF object_id('tempdb.dbo.#TempJobList') IS NOT null DROP TABLE #TempJobList
 CREATE TABLE #TempJobList(
	CcId		INT,
	jobId		INT,
	opType		INT,
	srcClient	INT,
	destClient	INT,
	status		INT,
	state		INT,
	appType		INT,
	instance	INT,
	backupSet	INT,
	startTime	INT,
	endTime		INT,
	duration	INT,
	currentPhase	INT,
	rstSize		BIGINT,
	objects		BIGINT,
	totSuc		BIGINT,
	totSkipped	BIGINT,
	totFailed	BIGINT,
	initFrom	INT,
	cellName	varchar(512),
	failIds		varchar(512),
	mediaList	varchar(1024),
	failureReason	ntext,
	username	nvarchar(1024),
	jobDescription nvarchar(MAX) default(N''),
	clientDesc		nvarchar(MAX) default(N''),
	idaDesc			nvarchar(MAX) default(N''),
	instanceDesc	nvarchar(MAX) default(N''),
	bkpSetDesc		nvarchar(MAX) default(N''),
	mediaDesc		nvarchar(MAX) default(N''),
	srcClientGrp	nvarchar(MAX) default(N''),
	destClientGrp	nvarchar(MAX) default(N'')
)
INSERT INTO @tblRptApptypes VALUES(7733, 84)
INSERT INTO @tblRptApptypes VALUES(7718, 47)
INSERT INTO @tblRptApptypes VALUES(7718, 50)
INSERT INTO @tblRptApptypes VALUES(7719, 45)
INSERT INTO @tblRptApptypes VALUES(7719, 56)
INSERT INTO @tblRptApptypes VALUES(7719, 57)
INSERT INTO @tblRptApptypes VALUES(7719, 58)
INSERT INTO @tblRptApptypes VALUES(7719, 66)
INSERT INTO @tblRptApptypes VALUES(7719, 73)
INSERT INTO @tblRptApptypes VALUES(7719, 82)
INSERT INTO @tblRptApptypes VALUES(7719, 83)
INSERT INTO @tblRptApptypes VALUES(7719, 67)
INSERT INTO @tblRptApptypes VALUES(7719, 68)
INSERT INTO @tblRptApptypes VALUES(7719, 90)
INSERT INTO @tblRptApptypes VALUES(7719, 89)
DECLARE @i_taskId integer
SET @i_taskId = @i_jobId
SET @rptType 		= dbo.GetOptionInt(2039186688, @i_jobId, 0, 0)
SET @userId		= dbo.GetOptionInt(140019, @i_jobId, 0, 0)
SET @locId		= dbo.GetOptionInt(1421724997, @i_jobId, 0, 0)
SET @order		= dbo.GetOptionInt(705619325, @i_jobId, 0, 0)
SET @useCSTime		= dbo.GetOptionInt(695030402, @i_jobId, 0, 0)
SET @selJobId		= dbo.GetOptionInt(127117398, @i_jobId, 0, 0)
SET @jobDesc		= dbo.GetOptionString(305418106, @i_jobId, 0, 0)
SET	@includeClientDesc	= dbo.GetOptionInt(756316779, @i_jobId, 0, 0)
SET @errorCode			= dbo.GetOptionInt(1307886748,@i_jobId,0,0)
IF @errorCode > 0
BEGIN
SET @errorCodeFilter		= CAST((dbo.GetOptionString(676022536,@i_jobId,0,0)) AS INT);
END
EXEC RptOptGetTime @i_jobId, @startTime OUTPUT, @endTime OUTPUT
INSERT INTO @tblClients EXEC rptOptGetClients @i_jobId, @clOpt OUTPUT
INSERT INTO @tblApptypes EXEC rptOptGetAppTypes @i_jobId, @appTypeOpt OUTPUT
INSERT INTO @tblStatus EXEC rptOptGetJobStatus @i_jobId, @active OUTPUT, @history OUTPUT, @noBkp OUTPUT, @noRun OUTPUT, @failed OUTPUT, @delayed OUTPUT
--MR 159274: CMR to only include jobs that started AND ended in the given time frame if time range is specified in days (regKey based)
SET @useAbsTimeRangeForJobSummaryRpt = 0
IF EXISTS (
	SELECT *
	FROM APP_AdvanceSettings WITH(NOLOCK)
	WHERE keyName = 'bUseAbsTimeRangeForJobSummaryRpt'
			AND type = 'BOOLEAN'
			AND relativePath = 'Reports'
			AND enabled = 1
			AND deleted = 0
			AND entityType = 3
			AND entityId = 2
			AND CONVERT(NVARCHAR(20), value) = N'true'
) AND (SELECT dbo.GetOptionString(1399039985, @i_jobId, 0, 0)) = 11 --TimeRangeType_RELATIVE_DAYS
AND (SELECT dbo.GetOptionInt(162723971, @i_jobId, 0, 0)) = (60*60*24) --Selected Time Range = 1 day
	SET @useAbsTimeRangeForJobSummaryRpt = 1
SET @performanceJobsOnly = dbo.GetOptionInt(1444196908, @i_jobId, 0, 0)
-- If the apptype CV_APPTYPE_WINDOWS_FILESYSTEM is present in GUI selection,
-- We must consider all the WIN FS AppTypes.
-- This I have added because I need to merge all flavours of Windows AppTypes to one(MR: 62562)
-- For backward compatibility with 8.0 and 9.0 I am adding this.
DECLARE @WindowsFSSelected INT
SET @WindowsFSSelected = CASE WHEN EXISTS (SELECT * FROM @tblAppTypes WHERE t_appTypeId = 33) THEN 1 ELSE 0 END
IF @WindowsFSSelected <> 0
BEGIN
INSERT INTO @tblAppTypes VALUES (1)
INSERT INTO @tblAppTypes VALUES (11)
	--INSERT INTO @tblAppTypes VALUES (CV_APPTYPE_WINDOWS_FILESYSTEM) -- Already there
INSERT INTO @tblAppTypes VALUES (34)
INSERT INTO @tblAppTypes VALUES (42)
INSERT INTO @tblAppTypes VALUES (43)
END
SET @needStatus = (select count(*) from @tblStatus)
IF @appTypeOpt <> 0
	DELETE @tblApptypes
WHERE	@rptType = 7720 AND t_appTypeId IN (select t_appTypeId from @tblRptApptypes) OR
@rptType <> 7720 AND t_appTypeId NOT IN (select t_appTypeId from @tblRptApptypes where t_rptTypeId = @rptType)
ELSE IF @rptType IN (select t_rptTypeId from @tblRptApptypes)
BEGIN
	SET @appTypeOpt = 1
	INSERT INTO @tblApptypes
	SELECT	t_appTypeId
	FROM	@tblRptApptypes
	WHERE	t_rptTypeId = @rptType
END
IF @rptType = 7795 OR @rptType = 7784
BEGIN
	--SET @active = 0
	--SET @history = 1
	SET @appTypeOpt =0
	SET @clOpt =0
	SET @order = 0
END
-- For Search Restore Jobs dont filter any AppTypes
IF @rptType = 7789
	DELETE FROM @tblRptApptypes
-- For All Job Report do not filter any appTypes
IF @rptType = 7795
	DELETE FROM @tblRptApptypes
IF @selJobId > 0
BEGIN
	INSERT INTO #TempJobList
	SELECT	J.commcellId, J.jobId, J.opType, srcClientId, destClientId, 0, state, appType, instanceID, bkpSetID, jobStartTime, lastStartOrRun, jobElapsedTime, currentPhase,
			totUncompBytes, totFiles2Xfer, totSuccess, totSkipped, totFailures, initFrom, '', failureReason,
			dbo.GetMediaList(J.jobId), dbo.JMGetLocalizedMessageMaxFunc(@locId, failureReason), (select login from UMUsers where id=userId),
			J.jobDescription, N'', N'', N'', N'', N'', N'', N''
		FROM	JMJobInfo J WITH (READUNCOMMITTED), JMrstJobInfo I WITH (READUNCOMMITTED)
		WHERE	J.commcellId = I.commcellId AND J.jobId = I.jobId AND J.JobId = @selJobId AND
			(@appTypeOpt <> 0 AND appType in (select t_appTypeId from @tblApptypes) OR
			-- For regular restore jobs with all apptypes selected: @appTypeOpt = 0
			 @appTypeOpt = 0 AND appType NOT in (select t_appTypeId from @tblRptApptypes))
			 AND ( (@showSyncRestores = 1) OR ((rstattributes & 0x100 /*JMRST_SYNC_RESTORE*/) = 0) ) -- Exclude completes sync restore jobs based on key
	UNION
	SELECT	J.commcellId, J.jobId, J.opType, srcClientId, destClientId, R.status, 0, appType, instanceID, bkpSetID, servStartTime, servEndTime, duration, 0,
			(convert(bigint,totUncompBytes_h)*2147483648+convert(bigint,totUncompBytes_l)),
			(convert(bigint,totFiles2Xfer_h)*2147483648+convert(bigint,totFiles2Xfer_l)),
			(convert(bigint,totSuccess_h)*2147483648+convert(bigint,totSuccess_l)),
			totSkipped, totFailed, initFrom, '', failureReason,
			dbo.GetMediaList(J.jobId), dbo.JMGetLocalizedMessageMaxFunc(@locId,failureReason), username,
			J.jobDescription, N'', N'', N'', N'', N'', N'', N''
		FROM	JmJobStats J WITH (READUNCOMMITTED), JMRestoreStats R WITH (READUNCOMMITTED)
		WHERE	J.commcellId = R.commcellId AND J.jobId = R.jobId AND J.jobId = @selJobId AND
				(@appTypeOpt <> 0 AND appType in (select t_appTypeId from @tblApptypes) OR
				-- For regular restore jobs with all apptypes selected: @appTypeOpt = 0
				@appTypeOpt = 0 AND appType NOT in (select t_appTypeId from @tblRptApptypes))
				AND ( (@showSyncRestores = 1) OR ((rstattributes & 0x100 /*JMRST_SYNC_RESTORE*/) = 0) ) -- Exclude completes sync restore jobs based on key
END
ELSE
BEGIN
	--active but not delayed jobs
	IF @active > 0
	BEGIN
		INSERT INTO #TempJobList
		SELECT J.commcellId, J.jobId, J.opType, srcClientId, destClientId, 0, state, appType, instanceID, bkpSetID, jobStartTime, lastStartOrRun, jobElapsedTime, currentPhase,
			totUncompBytes, totFiles2Xfer, totSuccess, totSkipped, totFailures, initFrom, '', failureReason,
			dbo.GetMediaList(J.jobId), dbo.JMGetLocalizedMessageMaxFunc(@locId, failureReason), (select login from UMUsers where id=userId),
			J.jobDescription, N'', N'', N'', N'', N'', N'', N''
		FROM	JMJobInfo J WITH (READUNCOMMITTED), JMrstJobInfo I WITH (READUNCOMMITTED)
		WHERE	J.commcellId = I.commcellId AND J.jobId = I.jobId AND J.subOpType <> 129 AND
			(@appTypeOpt <> 0 AND appType in (select t_appTypeId from @tblApptypes) OR
			-- For regular restore jobs with all apptypes selected: @appTypeOpt = 0
			 @appTypeOpt = 0 AND appType NOT in (select t_appTypeId from @tblRptApptypes)) AND
			(@clOpt = 0 OR
(CASE WHEN @rptType <> 7733 THEN srcClientId ELSE destClientId END) in (select t_clId from @tblClients)) AND
			(@endTime = 0 OR jobStartTime <= @endTime) AND state in (1,4,9) -- RUNNING=1 , COMPLETED=4 ,COMPLETEDSUCCESS=9
			AND ( (@showSyncRestores = 1) OR ((rstattributes & 0x100 /*JMRST_SYNC_RESTORE*/) = 0) ) -- Exclude completes sync restore jobs based on key
	END
	--delayed jobs
	IF @delayed > 0
	BEGIN
		INSERT INTO #TempJobList
		SELECT J.commcellId, J.jobId, J.opType, srcClientId, destClientId, 0, state, appType, instanceID, bkpSetID, jobStartTime, lastStartOrRun, jobElapsedTime, currentPhase,
			totUncompBytes, totFiles2Xfer, totSuccess, totSkipped, totFailures, initFrom, '', failureReason,
			dbo.GetMediaList(J.jobId), dbo.JMGetLocalizedMessageMaxFunc(@locId, failureReason), (select login from UMUsers WITH (READUNCOMMITTED) where id=userId),
			J.jobDescription, N'', N'', N'', N'', N'', N'', N''
		FROM	JMJobInfo J WITH (READUNCOMMITTED), JMrstJobInfo I WITH (READUNCOMMITTED)
		WHERE	J.commcellId = I.commcellId AND J.jobId = I.jobId AND J.subOpType <> 129 AND
			(@appTypeOpt <> 0 AND appType in (select t_appTypeId from @tblApptypes) OR
			-- For regular restore jobs with all apptypes selected: @appTypeOpt = 0
			 @appTypeOpt = 0 AND appType NOT in (select t_appTypeId from @tblRptApptypes)) AND
			(@clOpt = 0 OR
(CASE WHEN @rptType <> 7733 THEN srcClientId ELSE destClientId END) in (select t_clId from @tblClients)) AND
			(@endTime = 0 OR jobStartTime <= @endTime)
			AND state NOT in (1,4,9) -- RUNNING=1 , COMPLETED=4 ,COMPLETEDSUCCESS=9
			AND ( (@showSyncRestores = 1) OR ((rstattributes & 0x100 /*JMRST_SYNC_RESTORE*/) = 0) ) -- Exclude completes sync restore jobs based on key
	END
	IF @history > 0
	BEGIN
		INSERT INTO #TempJobList
		SELECT J.commcellId, J.jobId, J.opType, srcClientId, destClientId, R.status, 0, appType, instanceID, bkpSetID, servStartTime, servEndTime, duration, 0,
			(convert(bigint,totUncompBytes_h)*2147483648+convert(bigint,totUncompBytes_l)),
			(convert(bigint,totFiles2Xfer_h)*2147483648+convert(bigint,totFiles2Xfer_l)),
			(convert(bigint,totSuccess_h)*2147483648+convert(bigint,totSuccess_l)),
			totSkipped, totFailed, initFrom, '', failureReason,
			dbo.GetMediaList(J.jobId),dbo.JMGetLocalizedMessageMaxFunc(@locId,failureReason),username,
			J.jobDescription, N'', N'', N'', N'', N'', N'', N''
		FROM	JMJobStats J WITH (READUNCOMMITTED), JMrestoreStats R WITH (READUNCOMMITTED)
		WHERE	J.commcellId = R.commcellId AND J.jobId = R.jobId AND J.subOpType <> 129 AND
			(@appTypeOpt <> 0 AND appType in (select t_appTypeId from @tblApptypes) OR
			-- For regular restore jobs with all apptypes selected: @appTypeOpt = 0
			 @appTypeOpt = 0 AND appType NOT in (select t_appTypeId from @tblRptApptypes)) AND
			(@clOpt = 0 OR
(CASE WHEN @rptType <> 7733 THEN srcClientId ELSE destClientId END) in (select t_clId from @tblClients)) AND
			(@needStatus = 0 OR R.status in (select status from @tblStatus)) AND
			(@startTime = 0 OR servEndTime >= @startTime) AND (@endTime = 0 OR servStartTime <= @endTime)
			AND ( (@showSyncRestores = 1) OR ((rstattributes & 0x100 /*JMRST_SYNC_RESTORE*/) = 0) ) -- Exclude completes sync restore jobs based on key
	END
END
UPDATE	#TempJobList
SET		state = 100
FROM	#TempJobList L INNER JOIN JMJobInfo J ON	J.commcellId = L.CcId AND J.jobId = L.jobId
WHERE	J.guiAlertColorLevel = 40 --NO_RESPONSE_GUI_COLOR
IF @errorCodeFilter > 0
BEGIN
	DECLARE @tmpTab TABLE(JOBID INT, MARK INT);
	DELETE FROM #TempJobList
	WHERE failIds IS NULL OR failIds = ''
	IF EXISTS(SELECT * FROM #TempJobList)
	BEGIN
		INSERT INTO @tmpTab
		SELECT jobId, dbo.MarkNonErrorForDel(@errorCodeFilter, failIds)
		FROM #TempJobList
		DELETE FROM #TempJobList
		WHERE JOBID IN (SELECT JOBID FROM @tmpTab WHERE MARK = 0)
	END
END
IF @useAbsTimeRangeForJobSummaryRpt = 1
BEGIN
	DELETE FROM #TempJobList WHERE startTime <= @startTime OR endTime >= @endTime
END
-- SEARCH RESTORE OPTYPES: 49=SEARCHANDRETRIEVE; 54=POWERRESTORE;55=POWERSEARCHANDRETRIEVE
IF @rptType=7789
BEGIN
	DELETE #TempJobList WHERE optype NOT IN (49, 54, 55)
	UPDATE #TempJobList SET srcClient=AP.clientId
	FROM #TempJobList TJ
	JOIN SchedRestoreSearchFiles SF ON SF.searchId = TJ.jobId
	JOIN APP_Application AP ON AP.id = SF.appId
END
ELSE
	DELETE #TempJobList WHERE optype IN (49, 54, 55)
--if SILO Retrieve Report, delete other Restore jobs and vice versa.
IF @rptType=7759
	  DELETE FROM #TempJobList WHERE backupSet NOT IN (SELECT componentNameId FROM APP_BackupSetProp WITH (READUNCOMMITTED) WHERE  attrName = 'SILO Copy ID' AND attrVal > '0')
ELSE
	  DELETE FROM #TempJobList WHERE backupSet IN (SELECT componentNameId FROM APP_BackupSetProp WITH (READUNCOMMITTED)  WHERE  attrName = 'SILO Copy ID' AND attrVal > '0')
IF @rptType != 7795
BEGIN
IF @rptType=8014
	  DELETE FROM #TempJobList WHERE optype!=105    ---REPLICATION = 105
ELSE
	  DELETE FROM #TempJobList WHERE optype=105    ---REPLICATION = 105
END
--If selected, delete all jobs other than performance jobs
IF @performanceJobsOnly = 1
DELETE FROM #TempJobList WHERE dbo.GetOptionInt(312685036, jobId, 0, 0) <> 1
ELSE
DELETE FROM #TempJobList WHERE dbo.GetOptionInt(312685036, jobId, 0, 0) = 1
--got all qualified entries, do the security check before more details and summary
DECLARE @isUserAdmin INT = 0
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
IF @userId > 0 AND @isUserAdmin = 0 AND @clOpt <= 0
BEGIN
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2009, 0, '#rptUserObjects'	-- 2009 = CLIENT_ITEM
	delete #rptUserObjects
	WHERE clientGroupId <> 0 OR mediaAgentId <> 0 OR libraryID <> 0 OR archGroupID <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	delete #TempJobList
	WHERE NOT EXISTS (	select	* from #rptUserObjects
				where	clientId in (0, srcClient, destClient) AND
					appTypeId in (0,appType) AND
					instanceId in (0,instance) AND
					backupsetId in (0,backupSet))
	DROP TABLE #rptUserObjects
END
--Cell number
UPDATE #TempJobList
SET cellName = C.aliasName
FROM APP_Commcell C WITH (READUNCOMMITTED), #TempJobList T
WHERE c.id =T.CcId
---include description at various level
IF  @includeClientDesc> 0
	UPDATE #TempJobList
	SET clientDesc=ISNULL((SELECT clientDescription FROM APP_Client WITH (READUNCOMMITTED) WHERE id= T.srcClient and T.srcClient> 0),N''),
		bkpSetDesc=ISNULL((SELECT attrVal FROM APP_BackupSetProp WITH (READUNCOMMITTED) WHERE componentNameId= T.backupSet and T.backupSet> 0 AND attrName ='User Description' and modified =0),N''),
		instanceDesc=ISNULL((SELECT attrVal FROM APP_InstanceProp WITH (READUNCOMMITTED) WHERE componentNameId= T.instance and T.instance> 0 AND attrName ='User Description' and modified =0),N''),
		idaDesc=ISNULL((SELECT attrVal FROM APP_IDAProp WITH (READUNCOMMITTED) WHERE componentNameId = (select id from APP_IDAName where clientId= T.srcClient and appTypeId = T.appType and T.srcClient>0) AND attrName ='IDA Description' and modified =0),N'')
	FROM #TempJobList T
-- Update all Windows app types to CV_APPTYPE_WINDOWS_FILESYSTEM. MR:62562
-- if we do not do this we end up showing the aggregations several times for the same app type name in summary of the report.
UPDATE	#TempJobList
SET		appType = 33
WHERE	appType in (1, 11, 34, 42, 43)
-- We may not need the above statement if all the clients registered to this CS are 10.0 or greater.
UPDATE	#tempJobList
SET		srcClientGrp	= dbo.GetClientGroup(srcClient),
		destClientGrp	= dbo.GetClientGroup(destClient)
-- Update mediaDesc
CREATE TABLE #JobMediaName (jobId INT, mediaName NVARCHAR(1024))
IF object_id('tempdb.dbo.#JobMedia') IS NOT null
begin
	DROP TABLE #JobMedia
end
CREATE TABLE #JobMedia (jobId INT, MediaId INT)
INSERT INTO #JobMedia
SELECT RH.jobId, RH.MediaId
FROM JMJobResourceHistory RH
INNER JOIN #TempJobList J ON RH.jobId = J.jobId AND RH.commCellId = J.CcId
GROUP BY RH.jobId, RH.MediaId
INSERT INTO #JobMediaName
SELECT J.jobId, MP.MountPathName
FROM #JobMedia J
INNER JOIN MMMediaSide MS ON J.MediaId = MS.MediaId
INNER JOIN MMS2getMountPathNameGUIView MP ON MS.MediaSideId = MP.MediaSideId
GROUP BY J.jobId, MP.MountPathName
INSERT INTO #JobMediaName
SELECT J.jobId, M.Barcode
FROM #JobMedia J
INNER JOIN MMMedia M ON J.MediaId = M.MediaId AND M.MediaTypeId <> 10001
GROUP BY J.jobId, M.Barcode
UPDATE	#tempJobList
SET		mediaDesc = STUFF(S.mediaDesc, 1, 1, '')
FROM	(SELECT	J.jobId, (SELECT ',' + mediaName FROM #JobMediaName WHERE jobId = J.jobId ORDER BY mediaName FOR XML PATH('')) AS mediaDesc
		FROM	#tempJobList J) S
WHERE	#tempJobList.jobId = S.jobId
DROP TABLE #JobMediaName
-- End of Update mediaDesc
IF @jobDesc not like N''
BEGIN
	SET @jobDesc = N'%' + @jobDesc + N'%'
	DELETE #TempJobList
	FROM #TempJobList
	WHERE jobDescription NOT LIKE @jobDesc OR jobDescription IS NULL
END
IF object_id('tempdb.dbo.#RST_FINAL') IS NOT NULL DROP TABLE #RST_FINAL
SELECT type=0,total=0,success=0,running=0,partSuc=0,killed=0,ccId,
	srcClient,srcClientName=(select displayName from APP_Client WITH (READUNCOMMITTED) where id=srcClient),
	destClient,destClientName=(select displayName from APP_Client WITH (READUNCOMMITTED) where id=destClient),
	appType,appTypeName=(select name from APP_iDAType WITH (READUNCOMMITTED) where type = appType),
	instance,instanceName=(select name from APP_InstanceName WITH (READUNCOMMITTED) where id=instance),
	backupSet,backupSetName=(select name from APP_BackupSetName WITH (READUNCOMMITTED) where id=backupSet),
	jobId,status,state,startTime,endTime,duration,
	currentPhaseName=(case currentPhase when 0 then '' else
	 (select name from JMPhase as P WITH (READUNCOMMITTED) , JMOpTable as O WITH (READUNCOMMITTED)  where O.appTypeType=appType and O.operation=opType and
	 P.opTableId=O.id and P.phase=currentPhase) end),rstSize,objects,totSuc,totSkipped,totFailed,initFrom,userName,optype,
	 cellName,
	path=(case opType WHEN 29 THEN
		ISNULL((SELECT attributeValue FROM JMJobOptions WITH (READUNCOMMITTED) WHERE attributeName like 'Destination Path' AND jobId=#TempJobList.jobId),'') ELSE '' END),
	mediaList, failIds, failureReason, jobDescription, clientDesc, idaDesc, instanceDesc,bkpSetDesc, mediaDesc, srcClientGrp, destClientGrp
INTO #RST_FINAL
FROM #TempJobList
INSERT INTO #RST_FINAL
SELECT 2,count(*),(select count(*) from #TempJobList where status=1),
(select count(*) from #TempJobList where status=0 and state in (1,4,9,100)),
	(select count(*) from #TempJobList where status=3),
	(select count(*) from #TempJobList where status=4),
	0,0,'',0,'',0,'',0,'',0,'',
0,0,(select count(*) from #TempJobList where status=0 and state NOT in (1,4,9,100)),isnull(min(startTime),0),isnull(max(endTime),0),0,'',isnull(sum(rstSize),0),0,
	(select count(*) from #TempJobList where status=14),0,0,0,'',0,'','','','','','', N'', N'', N'', N'', N'', N'', N''
FROM #TempJobList
IF @useCSTime = 0
	UPDATE #RST_FINAL
	SET	startTime = DBO.rptgetJobClientTime(srcClient, ISNULL(startTime,0)),
		endTime = DBO.rptgetJobClientTime(srcClient, ISNULL(endTime,0))
IF @order = 1
BEGIN
	INSERT INTO @tblSummary
	SELECT count(*),appType,isnull(min(startTime),0),isnull(max(endTime),0),sum(rstSize)
	FROM #TempJobList GROUP BY appType
	INSERT INTO #RST_FINAL
	SELECT 1,tot,(select count(*) from #TempJobList where appType=tid and status=1),
(select count(*) from #TempJobList where appType=tid and status=0 and state in (1,4,9,100)),
		(select count(*) from #TempJobList where appType=tid and status=3),
		(select count(*) from #TempJobList where appType=tid and status=4),
0,0,'',0,'',tid,(select name from APP_iDAType WITH (READUNCOMMITTED) where type=tid),0,'',0,'',0,0,(select count(*) from #TempJobList where appType=tid and status=0 and state NOT in (1,4,9,100)),st,et,0,'',ts,0,
		(select count(*) from #TempJobList where appType=tid and status=14),0,0,0,'',0,'','','','','','', N'', N'', N'', N'', N'', N'', N''
	FROM @tblSummary
	SELECT * FROM #RST_FINAL ORDER BY type DESC, appTypeName, startTime DESC
END
ELSE IF @order = 9
BEGIN
	INSERT INTO @tblSummary
	SELECT count(*),srcClient,isnull(min(startTime),0),isnull(max(endTime),0),sum(rstSize)
	FROM #TempJobList GROUP BY srcClient
	INSERT INTO #RST_FINAL
	SELECT 1,tot,(select count(*) from #TempJobList where srcClient=tid and status=1),
(select count(*) from #TempJobList where srcClient=tid and status=0 and state in (1,4,9,100)),
		(select count(*) from #TempJobList where srcClient=tid and status=3),
		(select count(*) from #TempJobList where srcClient=tid and status=4),
0,tid,(select displayName from APP_Client WITH (READUNCOMMITTED) where id=tid),0,'',0,'',0,'',0,'',0,0,(select count(*) from #TempJobList where srcClient=tid and status=0 and state NOT in (1,4,9,100)),st,et,0,'',ts,0,
		(select count(*) from #TempJobList where srcClient=tid and status=14),0,0,0,'',0,'','','','','','', N'', N'', N'', N'', N'', N'', N''
	FROM @tblSummary
	SELECT * FROM #RST_FINAL ORDER BY type DESC, srcClientName, startTime DESC
END
ELSE IF @order = 8
BEGIN
	INSERT INTO @tblSummary
	SELECT count(*),destClient,isnull(min(startTime),0),isnull(max(endTime),0),sum(rstSize)
	FROM #TempJobList GROUP BY destClient
	INSERT INTO #RST_FINAL
	SELECT 1,tot,(select count(*) from #TempJobList where destClient=tid and status=1),
(select count(*) from #TempJobList where destClient=tid and status=0 and state in (1,4,9,100)),
		(select count(*) from #TempJobList where destClient=tid and status=3),
		(select count(*) from #TempJobList where destClient=tid and status=4),
0,0,'',tid,(select displayName from APP_Client WITH (READUNCOMMITTED) where id=tid),0,'',0,'',0,'',0,0,(select count(*) from #TempJobList where destClient=tid and status=0 and state NOT in (1,4,9,100)),st,et,0,'',ts,0,
		(select count(*) from #TempJobList where destClient=tid and status=14),0,0,0,'',0,'','','','','','', N'', N'', N'', N'', N'', N'', N''
	FROM @tblSummary
	SELECT * FROM #RST_FINAL ORDER BY type DESC, destClientName, startTime DESC
END
ELSE
	SELECT * FROM #RST_FINAL ORDER BY type DESC, startTime DESC
DROP TABLE #TempJobList
DROP TABLE #RST_FINAL
SET NOCOUNT OFF
GO
--dummy check-in becuase one update on build 52 failed to get built correctly Form (52563).

IF EXISTS (select * from GxQscripts where name = 'RptRstHistoryInfo')
	delete from GxQscripts where name = 'RptRstHistoryInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptRstHistoryInfo')
	delete from GXDBVersions where aliasname = 'RptRstHistoryInfo'
GO

insert into GXDBVersions values(2, 'RptRstHistoryInfo',  '00010089003600100000', 'RptRstHistoryInfo', '00010089003600100000')
GO

