

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptReplicationVMsForJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptReplicationVMsForJob.sp,v $ $Id: RptReplicationVMsForJob.sp,v 1.4.2.5 2020/06/01 22:15:05 pktr Exp $";
-- 	+---------------------------------------------------------------------------+
--	| 						Stored Proc: "RptReplicationVMsForJob"								|
--	|																			|
--  |Gets the list of subclients with no DM schedule set.		|
-- 	+---------------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptReplicationVMsForJob')
BEGIN
	print '>>> Drop Stored Procedure: RptReplicationVMsForJob <<<'
	drop procedure RptReplicationVMsForJob
END
IF EXISTS (select * from GxQscripts where name='RptReplicationVMsForJob')
	delete from GxQscripts where name = 'RptReplicationVMsForJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptReplicationVMsForJob')
	delete from GXDBVersions where aliasname = 'RptReplicationVMsForJob'
GO
print '... Creating Procedure: RptReplicationVMsForJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptReplicationVMsForJob
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @jobId int = 0
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
SET NOCOUNT ON
  DECLARE @o_vmSourceVM NVARCHAR(255)
  DECLARE @o_vmDestinationVM NVARCHAR(255)
  DECLARE @o_vmHost NVARCHAR(255)
  DECLARE @o_vmStatus INTEGER
  DECLARE @o_vmFailureReason NVARCHAR(255)
  DECLARE @o_vmAgent NVARCHAR(255)
  DECLARE @o_vmToolsVersion NVARCHAR(255)
  DECLARE @o_vmTransportMode NVARCHAR(255)
  DECLARE @o_vmPowerStatus INTEGER
  DECLARE @o_vmRestoredSize BIGINT
  DECLARE @o_syncStatus INTEGER
  DECLARE @o_lastSyncedBackupJob BIGINT
  DECLARE @o_failoverStatus BIGINT
  DECLARE @o_scheduleName NVARCHAR(255)
  IF OBJECT_ID ('tempdb..#vmJobDetails') IS NOT NULL DROP TABLE #vmJobDetails
   CREATE TABLE #vmJobDetails (
    VMclientId			 INT,
    sourceName           nvarchar(128),
	vmDestinationVM		 nvarchar(128),
	vmHost               nvarchar(1024),
	vmStatus			 INT,
	vmFailureReason      nvarchar(1024),
	vmAgent              nvarchar(128),
	vmToolsVersion		 nvarchar(128),
	vmTransportMode      nvarchar(128),
	vmPowerStatus        INT,
	vmRestoredSize       BIGINT,
	syncStatus           INT,
	lastSyncedBackupJob  INT,
	failoverStatus       INT,
	scheduleName		 nvarchar(128)
  )
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
INSERT  INTO #vmJobDetails select DISTINCT VMclientId, sourceName, vmDestinationVM, vmHost,
CASE WHEN vmStatus='' THEN 1 ELSE vmStatus END,
vmFailureReason, vmAgent, vmToolsVersion, vmTransportMode,
CASE WHEN vmPowerStatus='' THEN 2 ELSE vmPowerStatus END,
CASE WHEN vmRestoredSize='' THEN CAST(0 AS BIGINT) ELSE vmRestoredSize END,
CASE WHEN syncStatus='' THEN -1 ELSE syncStatus END as syncStatus,
CASE WHEN lastSyncedBackupJob='' THEN CAST(0 AS BIGINT) ELSE lastSyncedBackupJob END,
AV.FailoverStatus,
ST.subTaskName
from
(select VMclientId,
    MAX(CASE attrName when 'vmGUID' THEN attrVal  else '' END) vmGUID,
    MAX(CASE attrName when 'vmDestinationVM' THEN attrVal else '' END) vmDestinationVM,
    MAX(CASE attrName when 'vmHost' THEN attrVal else '' END) vmHost,
    MAX(CASE attrName when 'vmStatus' THEN attrVal else '' END) vmStatus,
    MAX(CASE attrName when 'vmFailureReason' THEN attrVal else '' END) vmFailureReason,
    MAX(CASE attrName when 'vmAgent' THEN attrVal else '' END) vmAgent,
    MAX(CASE attrName when 'vmToolsVersion' THEN attrVal else '' END) vmToolsVersion,
    MAX(CASE attrName when 'vmTransportMode' THEN attrVal else '' END) vmTransportMode,
    MAX(CASE attrName when 'vmPowerStatus' THEN attrVal else '' END) vmPowerStatus,
    MAX(CASE attrName when 'vmRestoredSize' THEN attrVal else '' END) vmRestoredSize,
    MAX(CASE attrName when 'vmSyncStatus' THEN attrVal else '' END) syncStatus,
    MAX(CASE attrName when 'vmLastSyncedBkpJob' THEN attrVal else '' END) lastSyncedBackupJob
from APP_VMProp where jobId=@jobId group by VMclientId) RVM,
APP_VSAReplication AV, TM_SubTask ST
where RVM.vmGUID=AV.sourceGuid AND AV.taskId = ST.taskId
update #vmJobDetails set vmToolsVersion=cl.attrVal from APP_ClientProp cl where vmToolsVersion='' AND cl.componentNameId=VMclientId AND cl.attrName='Virtual Machine Tools Version' AND cl.modified=0
ALTER TABLE #vmJobDetails DROP COLUMN VMclientId
select *from #vmJobDetails
  IF OBJECT_ID ('tempdb..#vmJobDetails') IS NOT NULL DROP TABLE #vmJobDetails
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'RptReplicationVMsForJob')
	delete from GxQscripts where name = 'RptReplicationVMsForJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptReplicationVMsForJob')
	delete from GXDBVersions where aliasname = 'RptReplicationVMsForJob'
GO

insert into GXDBVersions values(2, 'RptReplicationVMsForJob',  '00010004000200050000', 'RptReplicationVMsForJob', '00010004000200050000')
GO

