

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptQuarterlyPptCsData.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptQuarterlyPptCsData.sp,v $ $Id: RptQuarterlyPptCsData.sp,v 1.1.2.2 2018/03/20 00:40:59 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		        Procedure   : "RptQuarterlyPptCsData"	         		|
--  |           Gets the data required by the QBR PPT from the CSDB         |
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptQuarterlyPptCsData <<<'

IF EXISTS (select * from sysobjects where name='RptQuarterlyPptCsData')
	drop procedure RptQuarterlyPptCsData
IF EXISTS (select * from GxQscripts where name='RptQuarterlyPptCsData')
	delete from GxQscripts where name = 'RptQuarterlyPptCsData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptQuarterlyPptCsData')
	delete from GXDBVersions where aliasname = 'RptQuarterlyPptCsData'
GO
print '... Creating Procedure: RptQuarterlyPptCsData'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptQuarterlyPptCsData
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @i_CommServUniqueID INT = 0,
  @i_param INT = NUll,
  @i_fromMonth INT = 0, --The input is the difference between the current month and the "from" month selected
  @i_toMonth INT = 0  --The input is the difference between the current month and the "to" month selected
AS
SET NOCOUNT ON
SET ANSI_WARNINGS OFF
DECLARE @ProfileEntity_TASK INT = 1 --Enum ProfileEntity.Task
DECLARE @6MonthsFromNow BIGINT = (SELECT dbo.GetUnixTimeBig(DATEADD(MONTH, DATEDIFF(MONTH, 0, GetDate()) + 6, 0)))
DECLARE @isInternalUser INT =0
IF (SELECT dbo.isCommvaultUser(@i_UserId)) = 1 OR (@i_UserId=-1)
SET @isInternalUser = 1
IF OBJECT_ID('tempdb..#ProfileTaskData') IS NOT NULL DROP TABLE #ProfileTaskData
CREATE TABLE #ProfileTaskData
(
	ccGroupId		INT,
	TaskId			INT,
	TaskName		NVARCHAR(MAX),
	TaskType		INT,
	TaskDescription	NVARCHAR(MAX),
	TaskStatus		INT,
	CreatedId		INT,
	CreatedBy		NVARCHAR(MAX),
	AssignedId		INT,
	AssignedTo		NVARCHAR(MAX),
	TargetDate		BIGINT,
	StartDate		BIGINT,
	URL				NVARCHAR(MAX),
	Notes			NVARCHAR(MAX),
	ModifiedId		INT,
	ModifiedBy		NVARCHAR(MAX),
	EmailTo			NVARCHAR(MAX),
	CommcellId		NVARCHAR(MAX),
	TouchId			INT,
	ShareFolderId	BIGINT,
	DocumentPath	NVARCHAR(MAX),
	CreationDate	BIGINT,
	FolderPath		NVARCHAR(MAX),
	LastModified	BIGINT,
	Internal		NVARCHAR(MAX)
)
IF @isInternalUser = 1
    INSERT INTO #ProfileTaskData
    EXEC wr_GetProfileData @i_UserId, @ProfileEntity_TASK, @i_GroupId, 0, 0, 0, 0, 0
ELSE
    INSERT INTO #ProfileTaskData(ccGroupId, TaskId, TaskName, TaskType, TaskDescription, TaskStatus, CreatedId, CreatedBy, AssignedId, AssignedTo,
        TargetDate, StartDate, URL, Notes, ModifiedId, ModifiedBy, EmailTo, CommcellId, TouchId, ShareFolderId, DocumentPath, CreationDate, FolderPath, LastModified)
    EXEC wr_GetProfileData @i_UserId, @ProfileEntity_TASK, @i_GroupId, 0, 0, 0, 0, 0
DECLARE @TaskType NVARCHAR(MAX) = 0
DECLARE @TaskStatus NVARCHAR(MAX) = 0
DECLARE @TargetDateMAX NVARCHAR(MAX) = 0
DECLARE @TargetDateMIN NVARCHAR(MAX) = 0
DECLARE @ColumnName NVARCHAR(MAX) = 'default'
DECLARE @NoDataFoundText NVARCHAR(MAX) = 'No data found'
IF @i_param = 1 --CUSTOMER_OBJECTIVES
BEGIN
    SET @TaskType = '4' --Customer Projects
    SET @ColumnName = 'CustomerObjective'
    SET @NoDataFoundText = 'No Customer Projects found.'
END
ELSE IF @i_param = 2 --CRITICAL_SUCCESS_FACTORS
BEGIN
    SET @TaskType = '3' --Commvault projects
    SET @ColumnName = 'CriticalSuccessFactor'
    SET @NoDataFoundText = 'No Commvault Projects found.'
END
ELSE IF @i_param = 3 --KEY_INITIATIVES
BEGIN
    SELECT 'KeyInitiative1' AS KeyInitiative
    UNION ALL
    SELECT 'KeyInitiative2'
    UNION ALL
    SELECT 'KeyInitiative3'
    UNION ALL
    SELECT 'KeyInitiative4'
END
ELSE IF @i_param = 4 --ACTIVE_PROJECTS
BEGIN
    SET @TaskStatus = '1' -- Open
    SET @ColumnName = 'ActiveProject'
    SET @NoDataFoundText = 'No Tasks found.'
    SET @TargetDateMAX = CAST(@6MonthsFromNow AS NVARCHAR(MAX))
END
ELSE IF @i_param = 5 --PROJECTS_ON_HOLD
BEGIN
    SET @TaskStatus = '5' -- On Hold
    SET @ColumnName = 'ProjectOnHold'
    SET @NoDataFoundText = 'No Tasks found.'
END
ELSE IF @i_param = 6 --ARCHIVED_PROJECTS
BEGIN
    SET @TaskStatus = '3' -- Closed
    SET @ColumnName = 'ArchivedProject'
    SET @NoDataFoundText = 'No Tasks found.'
END
ELSE IF @i_param = 7 --LONG_TERM_PROJECTS
BEGIN
    SET @TaskStatus = '1' -- Open
    SET @ColumnName = 'LongTermProject'
    SET @NoDataFoundText = 'No Tasks found.'
    SET @TargetDateMIN = CAST(@6MonthsFromNow AS NVARCHAR(MAX))
END
ELSE IF @i_param = 8 --QUARTERLY_ESP_TASKS
BEGIN
    IF OBJECT_ID('tempdb..#MonthsInLastQuarter') IS NOT NULL DROP TABLE #MonthsInLastQuarter
    CREATE TABLE #MonthsInLastQuarter
    (
        MonthName   VARCHAR(3),
        MonthStart  BIGINT,
        MonthEnd    BIGINT
    )
    ;WITH MONTHS(Num, MonthStart , MonthEnd ) AS
    (
        SELECT 1, DATEADD(MONTH, DATEDIFF(MONTH, 0, GetDate()) - @i_toMonth, 0), DATEADD(MONTH, DATEDIFF(MONTH, 0, GetDate()) - @i_toMonth + 1, 0)
        UNION ALL
        SELECT Num+1,  DATEADD(MONTH, -1, MonthStart),MonthStart
        FROM MONTHS WHERE Num < 3
    )
    INSERT INTO #MonthsInLastQuarter
    SELECT CONVERT(VARCHAR(3), MonthStart, 100) , dbo.GetUnixTimeBig(MonthStart), dbo.GetUnixTimeBig(MonthEnd)
    FROM MONTHS
    SELECT M.MonthName AS 'Month', D.TaskName AS 'Task'
    FROM #ProfileTaskData D
        INNER JOIN #MonthsInLastQuarter M ON M.MonthStart <= D.StartDate AND M.MonthEnd > D.StartDate
    ORDER BY D.StartDate
    IF OBJECT_ID('tempdb..#MonthsInLastQuarter') IS NOT NULL DROP TABLE #MonthsInLastQuarter
END
IF @i_param IN (1, 2, 4, 5, 6, 7)
BEGIN
    IF OBJECT_ID('tempdb..#Results') IS NOT NULL DROP TABLE #Results
    CREATE TABLE #Results (result NVARCHAR(MAX))
    DECLARE @query NVARCHAR(MAX) = 'INSERT INTO #Results SELECT TaskName FROM #ProfileTaskData WHERE (' + @TaskType + ' = 0 OR ' + @TaskType + ' = TaskType) AND (' + @TaskStatus + ' = 0 OR ' + @TaskStatus + ' = TaskStatus) AND (' + @TargetDateMIN + ' = 0 OR ' + @TargetDateMIN + ' <= TargetDate) AND (' + @TargetDateMAX + ' = 0 OR ' + @TargetDateMAX + ' > TargetDate)'
    EXECUTE sp_executesql @query
    IF(@@ROWCOUNT = 0)
        INSERT INTO #Results VALUES(@NoDataFoundText)
    SET @query = 'SELECT result AS ' + @ColumnName + ' FROM #Results'
    EXECUTE sp_executesql @query
    IF OBJECT_ID('tempdb..#Results') IS NOT NULL DROP TABLE #Results
END
IF OBJECT_ID('tempdb..#ProfileTaskData') IS NOT NULL DROP TABLE #ProfileTaskData
GO

IF EXISTS (select * from GxQscripts where name = 'RptQuarterlyPptCsData')
	delete from GxQscripts where name = 'RptQuarterlyPptCsData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptQuarterlyPptCsData')
	delete from GXDBVersions where aliasname = 'RptQuarterlyPptCsData'
GO

insert into GXDBVersions values(2, 'RptQuarterlyPptCsData',  '00010001000200020000', 'RptQuarterlyPptCsData', '00010001000200020000')
GO

