

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptOptGetTime.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptOptGetTime.sp,v $ $Id: RptOptGetTime.sp,v 1.15.278.3 2018/03/22 03:06:59 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		CURSOR : "rptOptGetTime"				|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptOptGetTime')
BEGIN
	print '>>> Drop Stored Procedure: rptOptGetTime <<<'
	drop procedure rptOptGetTime
END
IF EXISTS (select * from GxQscripts where name='rptOptGetTime')
	delete from GxQscripts where name = 'rptOptGetTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptOptGetTime')
	delete from GXDBVersions where aliasname = 'rptOptGetTime'
GO
print '... Creating Procedure: rptOptGetTime'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptOptGetTime
  @i_jobId integer,
  @o_startTime integer OUTPUT,
  @o_endTime integer OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- PER ANIL, TYPE WILL BE IMPLEMENTED LATER
DECLARE @lastDays	integer
DECLARE @lastHours	integer
DECLARE @timeLimit	integer
DECLARE @type		varchar(1024)
DECLARE @relStartT	integer
DECLARE @relEndT	integer
declare @VTOption	integer
SET @type			= dbo.GetOptionString(1399039985, @i_jobId, 0, 0)
SET @relStartT		= dbo.GetOptionInt(162723971, @i_jobId, 0, 0)
SET @relEndT		= dbo.GetOptionInt(1244966932, @i_jobId, 0, 0)
SET @o_startTime	= dbo.GetOptionInt(1244966932, @i_jobId, 0, 0)
SET @o_endTime		= dbo.GetOptionInt(162723971 , @i_jobId, 0, 0)
SET @VTOption		= dbo.GetOptionInt(2007361542, @i_jobId, 0, 0)
IF @type = 11 --TimeRangeType_RELATIVE_DAYS
BEGIN
	SET @timeLimit = dbo.GetUnixTime(GetUTCDate())/((60*60*24) - 60)
	set @lastDays = @relStartT /(60*60*24)
IF @VTOption =2			--endTime =0
		SET @o_endTime =0
	--MR 159274: CMR to make time range absolute for last n days (for job summary report) (regKey based)
ELSE IF (	SELECT	CASE WHEN EXISTS ( 	SELECT *	FROM APP_AdvanceSettings WITH(NOLOCK)	WHERE keyName = 'bUseAbsTimeRangeForJobSummaryRpt' 	AND type = 'BOOLEAN' 	AND relativePath = 'Reports' 	AND enabled = 1	AND deleted = 0	AND entityType = 3	AND entityId = 2	AND CONVERT(NVARCHAR(20), value) = N'true'	)	THEN 1	ELSE 0	END	) = 1 AND (	SELECT 	CASE WHEN (SELECT dbo.GetOptionInt(2039186688 /*reportType*/, @i_jobId, 0, 0)) IN (7715, 7716, 7717, 8003, 7792, 7788, 7758, 7795, 7784, 7775, 7785, 7790, 7786, 7736, 7782, 7783, 7771, 7787,	8013, 7742, 7757, 7746, 7762, 7741, 7751, 7752, 7794, 8001, 8002, 8005, 8004, 8006, 8011, 8009, 7720, 7718, 7719, 7733, 7789, 7759, 8014)	THEN 1	ELSE 0	END	) = 1 AND @lastDays = 1
		--set endTime to end of last day
		SET @o_endTime = dbo.GetUnixTime(DATEADD(MINUTE, DATEDIFF(MINUTE, GETDATE(), GETUTCDATE()), DATEADD(DAY, DATEDIFF(DAY, '19000101', GETDATE()), '00:00:00'))) --Datetime in UTC for the last minute of the previous day.
	ELSE
		SET @o_endTime =dbo.GetUnixTime(GetUTCDate())
	IF @lastDays <=@timeLimit
	BEGIN
IF @VTOption =2		--next days
			SET @o_startTime = dbo.GetUnixTime(GetUTCDate()) + 60*60*24*@lastDays + 60
		ELSE
			SET @o_startTime = @o_endTime - 60*60*24*@lastDays - 60
	END
	ELSE IF @lastDays > @timeLimit
		SET @o_startTime =0
END
ELSE IF @type = 13 --TimeRangeType_RELATIVE_HOURS
BEGIN
		SET @timeLimit = dbo.GetUnixTime(GetUTCDate())/((60*60) - 60)
		set @lastHours = @relStartT /(60*60)
		IF @lastHours <=@timeLimit
			SET @o_startTime = dbo.GetUnixTime(GetUTCDate()) - 60*60*@lastHours - 60
		ELSE IF @lastHours > @timeLimit
			SET @o_startTime =0
		--SET @o_endTime =0
		SET @o_endTime =dbo.GetUnixTime(GetUTCDate())
END
ELSE IF @type = 12 -- TimeRangeType_RELATIVE_WEEKS
BEGIN
		SET @timeLimit = dbo.GetUnixTime(GetUTCDate())/((60*60*24*7) - 60)
		set @lastHours = @relStartT /(60*60*24*7)
		IF @lastHours <=@timeLimit
		BEGIN
IF @VTOption =2		--next weeks
				SET @o_startTime = dbo.GetUnixTime(GetUTCDate()) + 60*60*24*7*@lastHours + 60
			ELSE
				SET @o_startTime = dbo.GetUnixTime(GetUTCDate()) - 60*60*24*7*@lastHours - 60
		END
		ELSE IF @lastHours > @timeLimit
			SET @o_startTime =0
IF @VTOption =2
			SET @o_endTime =0
		ELSE
			SET @o_endTime =dbo.GetUnixTime(GetUTCDate())
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptOptGetTime')
	delete from GxQscripts where name = 'RptOptGetTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptOptGetTime')
	delete from GXDBVersions where aliasname = 'RptOptGetTime'
GO

insert into GXDBVersions values(2, 'RptOptGetTime',  '00010015027800030000', 'RptOptGetTime', '00010015027800030000')
GO

