

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptOptGetSubclients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptOptGetSubclients.sp,v $ $Id: RptOptGetSubclients.sp,v 1.8.88.1 2018/03/22 03:04:16 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		CURSOR : "rptOptGetSubclients"				|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptOptGetSubclients')
BEGIN
	print '>>> Drop Stored Procedure: rptOptGetSubclients <<<'
	drop procedure rptOptGetSubclients
END
IF EXISTS (select * from GxQscripts where name='rptOptGetSubclients')
	delete from GxQscripts where name = 'rptOptGetSubclients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptOptGetSubclients')
	delete from GXDBVersions where aliasname = 'rptOptGetSubclients'
GO
print '... Creating Procedure: rptOptGetSubclients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure rptOptGetSubclients
  @i_jobId integer,
  @o_id integer OUTPUT
AS
  DECLARE @o_clientId integer;
  DECLARE @o_agentId integer;
  DECLARE @o_instanceId integer;
  DECLARE @o_backupsetId integer;
  DECLARE @o_subclientId integer;
  DECLARE @o_exclude integer;
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @xmlText XML;
DECLARE @handle INT;
DECLARE @tblSubclientSelection TABLE(t_clientId int, t_agentId int, t_instanceId int, t_backupsetId int, t_subclientId int, t_exclude int);
-- Selection Status [o_id]: -1 - none; 1 - list
--SET @xmlText = ISNULL((SELECT xmlValue FROM TM_JobXMLOptions WHERE jobId = @i_jobId), '')
SET @xmlText = (SELECT dbo.GetXMLJobOptions(@i_jobId))
EXEC sp_xml_preparedocument @handle OUTPUT, @xmlText
INSERT INTO @tblSubclientSelection
SELECT ISNULL(clientId,0) as clientId, ISNULL(applicationId,0) as applicationId, ISNULL(instanceId,0) as instanceId, ISNULL(backupsetId, 0) as backupsetId, ISNULL(subclientId, 0) as subclientId, 0
FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/reportOption/subclientFilterList', 1) WITH
  (clientId int,
   applicationId int,
   instanceId int,
   backupsetId int,
   subclientId int)
UPDATE @tblSubclientSelection
SET t_exclude = A.excl
FROM (SELECT *
FROM OPENXML(@handle, 'TMMsg_JobOption/adminOpts/reportOption/subclientFilterList/flags', 2)
WITH (clntId int '../@clientId',
	appId int '../@applicationId',
	instId int '../@instanceId',
	bkpsetId int '../@backupsetId',
	subclntId int '../@subclientId',
	excl int '@exclude')) A
WHERE	(t_clientId = A.clntId OR ISNULL(A.clntId, 0) = 0)
		and (t_agentId = A.appId OR ISNULL(A.appId, 0) = 0)
		and (t_instanceId = A.instId OR ISNULL(A.instId, 0) = 0)
		and (t_backupsetId = A.bkpsetId OR ISNULL(A.bkpsetId, 0) = 0)
		and (t_subclientId = A.subClntId OR ISNULL(A.subClntId, 0) = 0)
EXEC sp_xml_removedocument @handle
SELECT @o_id = count(*) FROM @tblSubclientSelection
IF @o_id = 0
	SET @o_id = -1
ELSE
	SET @o_id = 1
SELECT * FROM @tblSubclientSelection
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptOptGetSubclients')
	delete from GxQscripts where name = 'RptOptGetSubclients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptOptGetSubclients')
	delete from GXDBVersions where aliasname = 'RptOptGetSubclients'
GO

insert into GXDBVersions values(2, 'RptOptGetSubclients',  '00010008008800010000', 'RptOptGetSubclients', '00010008008800010000')
GO

