

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptOptGetJobStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptOptGetJobStatus.sp,v $ $Id: RptOptGetJobStatus.sp,v 1.25.88.3 2018/03/22 03:03:15 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		CURSOR : "rptOptGetJobStatus"				|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptOptGetJobStatus')
BEGIN
	print '>>> Drop Stored Procedure: rptOptGetJobStatus <<<'
	drop procedure rptOptGetJobStatus
END
IF EXISTS (select * from GxQscripts where name='rptOptGetJobStatus')
	delete from GxQscripts where name = 'rptOptGetJobStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptOptGetJobStatus')
	delete from GXDBVersions where aliasname = 'rptOptGetJobStatus'
GO
print '... Creating Procedure: rptOptGetJobStatus'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptOptGetJobStatus
  @i_taskId integer,
  @o_active integer OUTPUT,
  @o_history integer OUTPUT,
  @o_noBkp integer OUTPUT,
  @o_noRun integer OUTPUT,
  @o_failed integer OUTPUT,
  @o_delayed integer OUTPUT,
  @o_skipped integer = 0		OUTPUT	--optional output param
AS
  DECLARE @o_status integer;
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @isAll			integer
DECLARE @isCompleted		integer
DECLARE @isFailed		integer
DECLARE @isCompletedWithError	integer
DECLARE @isCompletedWithWarning	integer
DECLARE @isKilled		integer
DECLARE @isActive		integer
DECLARE @isDelayed		integer
DECLARE @isNoProtection		integer
DECLARE @isSkipped		integer	= 0
DECLARE @isCommitted		integer = 0
DECLARE @reportType	integer
DECLARE @isBkp		integer
DECLARE @tblStatus		TABLE (status int)
DECLARE @i_jobId integer
SET @i_jobId = @i_taskId
SET @isAll			= dbo.GetOptionInt(144860792, @i_jobId, 0, 0)
SET @isCompleted		= dbo.GetOptionInt(1269386482, @i_jobId, 0, 0)
SET @isFailed			= dbo.GetOptionInt(1027282678, @i_jobId, 0, 0)
SET @isCompletedWithError	= dbo.GetOptionInt(702742544, @i_jobId, 0, 0)
SET	@isCompletedWithWarning	= dbo.GetOptionInt(834599247, @i_jobId, 0, 0)
SET @isKilled			= dbo.GetOptionInt(1177905974, @i_jobId, 0, 0)
SET @isActive			= dbo.GetOptionInt(886309311, @i_jobId, 0, 0)
SET @isDelayed			= dbo.GetOptionInt(122963401, @i_jobId, 0, 0)
SET @o_noBkp			= dbo.GetOptionInt(755016845, @i_jobId, 0, 0)
SET @o_noRun			= dbo.GetOptionInt(1760193743, @i_jobId, 0, 0)
SET @reportType			= dbo.GetOptionInt(2039186688, @i_jobId, 0, 0)
SET @isSkipped			= dbo.GetOptionInt(720059287, @i_jobId, 0, 0)
SET @isCommitted		= dbo.GetOptionInt(1181175331, @i_jobId, 0, 0)
SET @isBkp				= (case @reportType	when 7715 then 1
when 7716 then 1
when 7717 then 1
when 7792 then 1
when 7744 then 2
when 8003 then 1
								else 0 end)
IF @isAll > 0
BEGIN
 IF @isBkp =1
	BEGIN
		SET @o_active 	= 1
		SET @o_history	= 1
		SET @o_noBkp	= 1
		SET @o_noRun	= 1
		SET @o_failed	= 1
		SET @o_delayed	= 1
		SET @o_skipped	= 1
	END
 ELSE IF @isBkp =2
	BEGIN
		SET @o_active 	= 1
		SET @o_history	= 1
		SET @o_noBkp	= 0
		SET @o_noRun	= 1
		SET @o_failed	= 1
		SET @o_delayed	= 1
	END
 ELSE
	BEGIN
		SET @o_active 	= 1
		SET @o_history	= 1
		SET @o_noBkp	= 0
		SET @o_noRun	= 0
		SET @o_failed	= 1
		SET @o_delayed	= 1
		SET @o_skipped	= 0
	END
END
ELSE
BEGIN
	IF @isActive > 0
		SET @o_active = 1
	IF @isDelayed > 0
		SET @o_delayed	= 1
	IF @isSkipped is null OR @isSkipped < 1
		SET @o_skipped	= 0
	ELSE
		SET @o_skipped	= 1
	IF @isCompleted > 0 OR @isFailed > 0 OR @isCompletedWithError > 0 OR @isCompletedWithWarning > 0 OR @isKilled > 0 OR @isCommitted > 0
		SET @o_history = 1
	ELSE
		SET @o_history = 0
	IF @o_noBkp is null OR @o_noBkp < 1
		SET @o_noBkp = 0
	ELSE
		SET @o_noBkp = 1
	IF @o_noRun is null OR @o_noRun < 1
		SET @o_noRun = 0
	ELSE
		SET @o_noRun = 1
	IF @isFailed is null or @isFailed <= 0
		SET @o_failed = 0
	ELSE
		SET @o_failed = 1
	IF (@isCompleted > 0)
		INSERT INTO @tblStatus VALUES(1)	--JMSUCCESS
	IF (@isCompletedWithError > 0)
		INSERT INTO @tblStatus VALUES(3)	--PARTIALSUCCESS
	IF (@isCompletedWithWarning > 0)
		INSERT INTO @tblStatus VALUES(14)	--PARTIALSUCCESS
	IF (@isKilled > 0)
		INSERT INTO @tblStatus VALUES(4)	--KILLED
	IF (@isFailed > 0)
	BEGIN
		INSERT INTO @tblStatus VALUES(2)	--FAIL
		INSERT INTO @tblStatus VALUES(9)	--DROPPED
	END
	IF(@isCommitted IS NOT NULL AND @isCommitted > 0)
		INSERT INTO @tblStatus VALUES(16)	--COMMITTED
	IF (@o_noRun > 0 OR @o_skipped > 0)
		INSERT INTO @tblStatus VALUES(9)    --DROPPED
END
SELECT status FROM @tblStatus
SET NOCOUNT OFF
GO


IF EXISTS (select * from GxQscripts where name = 'RptOptGetJobStatus')
	delete from GxQscripts where name = 'RptOptGetJobStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptOptGetJobStatus')
	delete from GXDBVersions where aliasname = 'RptOptGetJobStatus'
GO

insert into GXDBVersions values(2, 'RptOptGetJobStatus',  '00010025008800030000', 'RptOptGetJobStatus', '00010025008800030000')
GO

