

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptOptGetClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptOptGetClients.sp,v $ $Id: RptOptGetClients.sp,v 1.19.200.5 2020/01/09 08:44:17 jge Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		CURSOR : "rptOptGetClients"				|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptOptGetClients')
BEGIN
	print '>>> Drop Stored Procedure: rptOptGetClients <<<'
	drop procedure rptOptGetClients
END
IF EXISTS (select * from GxQscripts where name='rptOptGetClients')
	delete from GxQscripts where name = 'rptOptGetClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptOptGetClients')
	delete from GXDBVersions where aliasname = 'rptOptGetClients'
GO
print '... Creating Procedure: rptOptGetClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure rptOptGetClients
  @i_jobId integer,
  @o_id integer OUTPUT
AS
  DECLARE @o_clientId integer;
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @tblClients	TABLE (id int)
DECLARE @tblClientGrps	TABLE (id int)
DECLARE @tblOutlookAddinClients	TABLE (clientId int)
DECLARE @xmlText XML;
DECLARE @handle INT;
DECLARE @includeAll INT;
DECLARE @endUserSecurity INT;
DECLARE @includeOutlookAddinClients INT;
SET @xmlText = (SELECT dbo.GetXMLJobOptions(@i_jobid))
EXEC sp_xml_preparedocument @handle OUTPUT, @xmlText
SET @includeOutlookAddinClients		= dbo.GetOptionInt(1742658279, @i_jobId, 0, 0)
-- Selection Status [o_id]: -1 - none; 0 - all; 1 - list
	SET @includeAll = ISNULL((SELECT TOP 1 includeAll FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/reportOption/computerSelectionList', 1) WITH (includeAll int)), 0)
	SET @endUserSecurity = ISNULL((SELECT TOP 1 endUserSecurity FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/reportOption/commonOpt', 1) WITH (endUserSecurity int)), 0)
	IF @includeAll = 0		--some clients selected
	BEGIN
		INSERT INTO @tblClients
		SELECT clientId FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/reportOption/computerSelectionList/clientList', 1) WITH (clientId int)
		INSERT INTO @tblClientGrps
		SELECT clientGroupId FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/reportOption/computerSelectionList/clientGroupList', 1) WITH (clientGroupId int)
		INSERT INTO @tblClients
		SELECT clientId FROM APP_ClientGroupAssoc WHERE clientGroupId in (SELECT id FROM @tblClientGrps)
		-- if selected, include outlook addin clients
		IF @includeOutlookAddinClients > 0
			INSERT INTO @tblClients
			SELECT componentNameId FROM APP_ClientProp
			WHERE attrName = 'Outlook Addin Client' AND attrVal ='1' AND modified = 0
		SET @o_id = (SELECT COUNT(*) FROM @tblClients)
		DECLARE    @o_idgroup integer = 0
		SET @o_idgroup  = (SELECT COUNT(*) FROM @tblClientGrps)
		if ((@o_id =0) AND (@o_idgroup>0))
			SET @o_id =-1
		EXEC sp_xml_removedocument @handle
	END
	ELSE
		BEGIN		--all clients selected
			IF @includeOutlookAddinClients > 0
				SET @o_id = 0					--all
			ELSE
				BEGIN		--remove outlookaddinclients
					INSERT INTO @tblOutlookAddinClients
					SELECT componentNameId FROM APP_ClientProp
					WHERE attrName = 'Outlook Addin Client' AND attrVal ='1' AND modified = 0
					SET @o_id = (SELECT COUNT(*) FROM @tblOutlookAddinClients)
					IF @o_id > 0
						INSERT INTO @tblClients
						SELECT id FROM APP_Client
							WHERE id NOT IN (SELECT clientId FROM @tblOutlookAddinClients)
						UNION
						SELECT DISTINCT O.clientId
							FROM @tblOutlookAddinClients O
								INNER JOIN simInstalledPackages I
									ON O.clientId = I.ClientId
				END
		END
declare @isUserAdmin int
declare @userId int = dbo.GetOptionInt(140019, @i_jobId, 0, 0)
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
-- if "end user security" isn't enabled or the user is admin, then nothing changes.
if @endUserSecurity = 0 or @isUserAdmin != 0
begin
	SELECT DISTINCT id FROM @tblClients
end
else
begin
	IF object_ID('tempdb..#clients4User') IS NOT NULL
		DROP table #clients4User
create table  #clients4User ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
    EXEC sec_getUserObjects @userId, 0, 0, '#clients4User'
	--@o_id is 0, then it means "include all", but "end user security" is enabled and the user isn't admin, so we can't return
	-- 0, otherwise the user will get all the clients in the CS. Instead we return the client list which he has permission
	-- with.
	if @o_id = 0
	begin
		--check if #clients4User is empty
		if exists(SELECT 1 FROM #clients4User)
		begin
			SET @o_id = 1
			SELECT distinct clientid FROM #clients4User
		end
		else
		begin
			SET @o_id = -1
			delete from @tblClients
			SELECT DISTINCT id FROM @tblClients
		end
	end
	else if @o_id > 0
	begin
		--check if the join result is empty
		if exists(SELECT 1 FROM @tblClients as A
		inner join #clients4User as B
		on A.id = B.clientId)
		begin
			SET @o_id = 1
			SELECT DISTINCT A.id FROM @tblClients as A
			inner join #clients4User as B
			on A.id = B.clientId
		end
		else
		begin
			SET @o_id = -1
			delete from @tblClients
			SELECT DISTINCT id FROM @tblClients
		end
	end
	else
	begin
		delete from @tblClients
		SELECT DISTINCT id FROM @tblClients
	end
end
SET NOCOUNT OFF
GO


IF EXISTS (select * from GxQscripts where name = 'RptOptGetClients')
	delete from GxQscripts where name = 'RptOptGetClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptOptGetClients')
	delete from GXDBVersions where aliasname = 'RptOptGetClients'
GO

insert into GXDBVersions values(2, 'RptOptGetClients',  '00010019020000050000', 'RptOptGetClients', '00010019020000050000')
GO

