

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptNBUPpt.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptNBUPpt.sp,v $ $Id: RptNBUPpt.sp,v 1.3.2.17 2020/10/08 15:51:44 mmansano Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptNBUPpt')
BEGIN
	print '>>> Drop Stored Procedure: RptNBUPpt <<<'
	drop procedure RptNBUPpt
END
IF EXISTS (select * from GxQscripts where name='RptNBUPpt')
	delete from GxQscripts where name = 'RptNBUPpt'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptNBUPpt')
	delete from GXDBVersions where aliasname = 'RptNBUPpt'
GO
print '... Creating Procedure: RptNBUPpt'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptNBUPpt
  @i_userid INT,
  @i_param INT = NULL
AS
BEGIN
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @ExcludedAppIds TABLE (appId INT)
	IF @i_param IN (1, 3, 4, 5 , 6, 8, 9, 10, 11, 12, 15)
	BEGIN
		INSERT INTO @ExcludedAppIds
		SELECT componentNameId FROM APP_subclientProp WITH (NOLOCK) WHERE attrName IN ('DDB Backup', 'SILO Copy ID') AND attrVal <> '0' AND modified = 0
		UNION
		SELECT id FROM APP_Application WITH (NOLOCK)
		WHERE clientId IN (SELECT componentNameId FROM APP_ClientProp WITH (NOLOCK) WHERE attrName = 'Content Index Server' AND attrVal = '1' AND modified = 0)
	END
	--IF @i_param IN (2, 14) -- 2: Clients Protected (slide 1), 11: Agent wise client count (ex: For Windows: 30 clients, Unix: 12 clients etc..) (slide 10)
	--BEGIN
	--	DECLARE @shouldExecute INT = 0
	--	IF OBJECT_ID('tempDB..#inst_table') IS NULL
	--		SET @shouldExecute = 1
	--	ELSE IF OBJECT_ID('tempDB..#inst_table') IS NOT NULL
	--		IF NOT EXISTS(SELECT * FROM #inst_table WHERE clientid = -1000) -- Check for dummy row. If exists, then param 2 has already been executed else compute the client list.
	--			SET @shouldExecute = 1
	--	IF @shouldExecute = 1
	--	BEGIN
	--			IF OBJECT_ID('tempDB..#inst_table') IS NOT NULL
	--				DROP TABLE #inst_table
	--			IF OBJECT_ID('tempDB..#ClientInstalledProp') IS NOT NULL
	--				DROP TABLE #ClientInstalledProp
	--			CREATE TABLE #inst_table (clientid INTEGER PRIMARY KEY)
	--			DECLARE @installed INTEGER
	--			CREATE TABLE #ClientInstalledProp
	--			(
	--				id INT, name NVARCHAR(255), displayName NVARCHAR(255), description NVARCHAR(MAX), netHostName NVARCHAR(255), OSId INT,
	--				OSName NVARCHAR(255), hwId INT, hwName VARCHAR(255), licenses INT, bkpEnabled INT,
	--				rstEnabled INT, deleted INT, priority INT, clientFlag INT, isCommServer INT,
	--				encryption INT, rsaPubKey NVARCHAR(1024), rsaPriKeySF NVARCHAR(1024), releaseId INT, status INT,
	--				virtual INT, isLicensed INT, physClientId INT, physClientName NVARCHAR(1024), DCinstalled INT,
	--				contentIndexingEnabled INT, CIActivityEnabled INT, updateStatus INT, snapBackupsEnabled INT, snapBackupsMAInstalled INT,
	--				collectDelegateInfo INT, donotSingleInstance INT, noPhysMachPresent INT, proxyFSClientId INT, proxyFSClientName NVARCHAR(1024),
	--				evmgrcPort INT, miniSRM INT, virtualDiscovered INT, EDCDiscovered INT, specialStatusFlags INT, outlookAddin INT,
	--				commNetClientCount INT, clientVersion VARCHAR(255), releasedIDWhenClientWasInstalled INT, ArchiverEnabled INT, virtualEntityFlags INT,
	--				isAdvancedFSPackageInstalled INT, isRemoteCacheEnabled INT, isWebServerInstalled INT, cvdPort INT, dataSecurityEnabled INT,sharePointFarmClient INT,
	--				canSchedule integer,canClientGroup integer,canSubclientPolicy integer,canPseudoClientCreate integer,canAdmin integer,canLogMonitor integer,canAlert integer,
	--				canReport INT, SPVersionInfo VARCHAR(255), SPVersionAndPatchInfo VARCHAR(MAX), isIndexingV2 INT, isQsnapInstalled INT
	--			)
	--			IF EXISTS (SELECT id FROM APP_Client WHERE id = 2 AND releaseId = 15)
	--			BEGIN
	--				ALTER TABLE #ClientInstalledProp DROP COLUMN sharePointFarmClient
	--				ALTER TABLE #ClientInstalledProp DROP COLUMN canAlert
	--				ALTER TABLE #ClientInstalledProp DROP COLUMN displayName
	--				ALTER TABLE #ClientInstalledProp DROP COLUMN isIndexingV2
	--				ALTER TABLE #ClientInstalledProp DROP COLUMN isQsnapInstalled
	--				ALTER TABLE #ClientInstalledProp DROP COLUMN canReport
	--			END
	--			-- getClientListAndInitialProps procedure is used for displaying clients in CommCell GUI
	--			INSERT INTO #ClientInstalledProp
	--			EXEC getClientListAndInitialProps 0, 1, 1
	--			INSERT INTO #inst_table
	--			SELECT id FROM #ClientInstalledProp WHERE ISNULL(deleted, 0) = 0
	--			IF OBJECT_ID('tempDB..#ClientInstalledProp') IS NOT NULL
	--				DROP TABLE #ClientInstalledProp
	--			-- Insert a dummy row of -1000 id to make that when next time this stored procedure is called, we don't compute this whole thing again.
	--			INSERT INTO #inst_table
	--			VALUES (-1000)
	--	END
	--END
	IF @i_param IN (1,3) -- Data backed up weekly and data protected back-end agent wise (slide 1)
	BEGIN
		IF OBJECT_ID('tempdb..#TotalDataProtected') IS NOT NULL
			DROP TABLE #TotalDataProtected
		-- 1 - Monthly
		-- 3 - Daily
		-- 2 - Today
		DECLARE @lastJobDate INT = (SELECT MAX(servEndDate)
							FROM JmBkpStats J WITH (NOLOCK)
							WHERE J.commCellId IN (SELECT id FROM App_CommCell WHERE type <> 1))
		DECLARE @nDays INT = -7
		--SELECT CAST(DATEADD(DD, @nDays, dbo.getdateTime(@lastJobDate)) AS DATE)
		DECLARE @LastWeekDate INT = dbo.getunixtime(CAST(DATEADD(DD, @nDays, dbo.getdateTime(@lastJobDate)) AS DATE))
		SELECT OS, SUM(totalUncompBytes)/1024.0/1024.0/1024.0 AS TotalAppSizeGB
		INTO #TotalDataProtected
		FROM (SELECT DISTINCT CASE WHEN ISNULL(AAT.osGroup+' '+AAT.App,'') = '' THEN I.name
						   WHEN ISNULL(AAT.osGroup,'') = '' THEN AAT.App
						   ELSE AAT.osGroup END AS OS,
					  totalUncompBytes
			FROM JMBkpStats J WITH (NOLOCK)
				INNER JOIN APP_Application A WITH (NOLOCK)
					ON J.appId= A.id AND (@i_param = 3 OR J.servEndDate >= @LastWeekDate )
					AND J.commCellId IN (SELECT id FROM App_CommCell WHERE type <> 1)
					AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
					AND  (J.status IN (1, 14) OR (status = 3 AND appType IN (SELECT type FROM APP_iDAType WITH (NOLOCK) WHERE isCWEjobValid = 1)))
				INNER JOIN APP_iDAType I WITH (NOLOCK) ON I.type = J.appType
				LEFT JOIN App_AppTypeGroups AAT WITH (NOLOCK) ON J.appType=AAT.appTypeId
			WHERE A.id NOT IN (SELECT appId FROM @ExcludedAppIds)
			) I
		GROUP BY I.OS
		DECLARE @TotalDataBackedUp DECIMAL(20,2) =  (SELECT SUM(TotalAppSizeGB) FROM #TotalDataProtected)
		IF @i_param = 1
			SELECT dbo.FormatBytes(@TotalDataBackedUp,'GB') AS 'Data Backed Up Weekly'
		ELSE
			SELECT OS, CASE WHEN @TotalDataBackedUp = 0 THEN 0 ELSE CAST((100.0 * TotalAppSizeGB/@TotalDataBackedUp) AS DECIMAL(10,2)) END AS [PercentageOfDataProtected] FROM #TotalDataProtected
			WHERE TotalAppSizeGB <> 0 OR @TotalDataBackedUp <> 0
			ORDER BY [PercentageOfDataProtected] DESC
	END
	ELSE IF @i_param IN (2, 14) -- 2: Clients Protected(Slide 1), 11: Agent wise client count (ex: For Windows: 30 clients, Unix: 12 clients etc..) (slide 10)
	BEGIN
		IF OBJECT_ID('tempDB..#ClientInstalledProp') IS NOT NULL
			DROP TABLE #ClientInstalledProp
		DECLARE @installed INTEGER
		CREATE TABLE #ClientInstalledProp
		(
			clientid INT, name NVARCHAR(255), displayName NVARCHAR(255), description NVARCHAR(MAX), netHostName NVARCHAR(255), OSId INT,
			OSName NVARCHAR(255), hwId INT, hwName VARCHAR(255), licenses INT, bkpEnabled INT,
			rstEnabled INT, deleted INT, priority INT, clientFlag INT, isCommServer INT,
			encryption INT, rsaPubKey NVARCHAR(1024), rsaPriKeySF NVARCHAR(1024), releaseId INT, status INT,
			virtual INT, isLicensed INT, physClientId INT, physClientName NVARCHAR(1024), DCinstalled INT,
			contentIndexingEnabled INT, CIActivityEnabled INT, updateStatus INT, snapBackupsEnabled INT, snapBackupsMAInstalled INT,
			collectDelegateInfo INT, donotSingleInstance INT, noPhysMachPresent INT, proxyFSClientId INT, proxyFSClientName NVARCHAR(1024),
			evmgrcPort INT, miniSRM INT, virtualDiscovered INT, EDCDiscovered INT, specialStatusFlags INT, outlookAddin INT,
			commNetClientCount INT, clientVersion VARCHAR(255), releasedIDWhenClientWasInstalled INT, ArchiverEnabled INT, virtualEntityFlags INT,
			isAdvancedFSPackageInstalled INT, isRemoteCacheEnabled INT, isWebServerInstalled INT, cvdPort INT, dataSecurityEnabled INT,sharePointFarmClient INT,
			canSchedule integer,canClientGroup integer,canSubclientPolicy integer,canPseudoClientCreate integer,canAdmin integer,canLogMonitor integer,canAlert integer,
			canReport INT, SPVersionInfo VARCHAR(255), SPVersionAndPatchInfo VARCHAR(MAX), isIndexingV2 INT, isQsnapInstalled INT, isDescriptionInHTMLFormat integer,
			refCopyClientType integer, isFileShareArchiverClientPackageInstalled INT, isAgentLicenseConsumed INT, clientType INT, clusterType INT, isIndexingV2NAS INT, isVirtualServerPresent INT, is1TouchClient INT,
			clientGuid VARCHAR(40), cloudStatus INT, nasOSType INT, nasCapabilities BIGINT, isExchangePackageInstalled INT, clientAppType INT, isIndexingV2VSA INT,
			retireClientPhase INT, agentList varchar(255), indexingV2EnabledMask BIGINT
		)
		IF EXISTS (SELECT id FROM APP_Client WHERE id = 2 AND releaseId = 15)
		BEGIN
			ALTER TABLE #ClientInstalledProp DROP COLUMN sharePointFarmClient
			ALTER TABLE #ClientInstalledProp DROP COLUMN canAlert
			ALTER TABLE #ClientInstalledProp DROP COLUMN displayName
			ALTER TABLE #ClientInstalledProp DROP COLUMN isIndexingV2
			ALTER TABLE #ClientInstalledProp DROP COLUMN isQsnapInstalled
			ALTER TABLE #ClientInstalledProp DROP COLUMN canReport
			ALTER TABLE #ClientInstalledProp DROP COLUMN isDescriptionInHTMLFormat
			ALTER TABLE #ClientInstalledProp DROP COLUMN refCopyClientType
			ALTER TABLE #ClientInstalledProp DROP COLUMN isFileShareArchiverClientPackageInstalled
			ALTER TABLE #ClientInstalledProp DROP COLUMN isAgentLicenseConsumed
			ALTER TABLE #ClientInstalledProp DROP COLUMN clientType
			ALTER TABLE #ClientInstalledProp DROP COLUMN clusterType
			ALTER TABLE #ClientInstalledProp DROP COLUMN isIndexingV2NAS
			ALTER TABLE #ClientInstalledProp DROP COLUMN isVirtualServerPresent
			ALTER TABLE #ClientInstalledProp DROP COLUMN is1TouchClient
			ALTER TABLE #ClientInstalledProp DROP COLUMN cloudStatus
			ALTER TABLE #ClientInstalledProp DROP COLUMN isIndexingV2VSA
			ALTER TABLE #ClientInstalledProp DROP COLUMN retireClientPhase
			ALTER TABLE #ClientInstalledProp DROP COLUMN agentList
			ALTER TABLE #ClientInstalledProp DROP COLUMN indexingV2EnabledMask
		END
		-- getClientListAndInitialProps procedure is used for displaying clients in CommCell GUI
		INSERT INTO #ClientInstalledProp
		EXEC getClientListAndInitialProps 0, 1, 1
		IF @i_param = 2
		BEGIN
			SET @installed=(SELECT COUNT(*) FROM #ClientInstalledProp WHERE clientid NOT IN (2, -1000,-2000))
			SELECT @installed AS 'Clients Protected'
		END
		ELSE IF @i_param = 14
		BEGIN
			SELECT TOP 10 OS, COUNT(DISTINCT clientId) AS Clients
			FROM (SELECT DISTINCT A.clientId,
						CASE WHEN ISNULL(AAT.osGroup+' '+AAT.App,'') = '' THEN I.name
								WHEN ISNULL(AAT.osGroup,'') = '' THEN AAT.App
								ELSE AAT.osGroup END AS OS
			FROM APP_Application A WITH (NOLOCK)
				INNER JOIN #ClientInstalledProp Ins ON Ins.clientid = A.clientId AND Ins.clientid NOT IN (-1000,-2000)
				INNER JOIN App_Client AC ON AC.id = A.clientId AND AC.origCCId IN (SELECT id FROM App_CommCell WHERE type <> 1)
				INNER JOIN APP_iDAType I WITH (NOLOCK) ON A.appTypeId = I.type
				LEFT JOIN App_AppTypeGroups AAT WITH (NOLOCK) ON A.appTypeId = AAT.appTypeId ) I
			GROUP BY I.OS
			ORDER BY Clients DESC
		END
		IF OBJECT_ID('tempDB..#ClientInstalledProp') IS NOT NULL
			DROP TABLE #ClientInstalledProp
		--IF EXISTS(SELECT * FROM #inst_table WHERE clientid = -2000)
		--BEGIN
		--	IF OBJECT_ID('tempDB..#inst_table') IS NOT NULL
		--		DROP TABLE #inst_table
		--END
		--ELSE
		--	INSERT INTO #inst_table
		--	VALUES(-2000)
	END
	ELSE IF @i_param = 4 -- Slide 2, total jobs and completion %
	BEGIN
		DECLARE @successfulJobs INT = (SELECT COUNT(Jobid) FROM JMBkpStats J WITH (NOLOCK) INNER JOIN App_Application App WITH (NOLOCK)
											ON J.appId = App.id
									WHERE J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) AND J.commCellId IN (SELECT id FROM App_CommCell WHERE type <> 1)
										AND  (J.status IN (1, 14) OR (J.status = 3 AND J.appType IN (SELECT type FROM APP_iDAType WITH (NOLOCK) WHERE isCWEjobValid = 1)))
										AND App.id NOT IN (SELECT appId FROM @ExcludedAppIds))
		DECLARE @FailedJobs INT = (SELECT COUNT(Jobid) FROM JMBkpStats J WITH (NOLOCK)INNER JOIN App_Application App WITH (NOLOCK)
											ON J.appId = App.id
									WHERE J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) AND J.commCellId IN (SELECT id FROM App_CommCell WHERE type <> 1)
										AND (J.status = 2 OR (J.status = 3 AND J.appType NOT IN (SELECT type FROM APP_iDAType WITH (NOLOCK) WHERE isCWEjobValid = 1)))
										AND App.id NOT IN (SELECT appId FROM @ExcludedAppIds))
		SELECT 'Success' AS Param, @successfulJobs AS 'Backup Jobs'
		UNION
		SELECT 'Failed' AS Param, @FailedJobs AS 'Backup Jobs'
	END
	ELSE IF @i_param = 5 -- Top 25 Highest Backup Performing Jobs (Slide 3)
	BEGIN
		SELECT TOP 25 CAST(J.jobId AS VARCHAR(15))+'('+AC.displayName+')' AS Job,
				CASE WHEN totalWriteTime > 0 THEN CAST((totalUnCompBytes/1024.0/1024.0/totalWriteTime) AS DECIMAL(10,2)) ELSE 0 END AS [Throughput(MB/sec)]
		FROM JmBkpStats J WITH (NOLOCK)
			INNER JOIN App_Application A WITH (NOLOCK)
				ON J.appId = A.id AND totalWriteTime > 0
			INNER JOIN App_Client AC WITH (NOLOCK)
				ON AC.id = A.clientId
		WHERE J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
			AND J.commCellId IN (SELECT id FROM App_CommCell WHERE type <> 1)
			AND  (J.status IN (1, 14) OR (J.status = 3 AND J.appType IN (SELECT type FROM APP_iDAType WITH (NOLOCK) WHERE isCWEjobValid = 1)))
			AND A.id NOT IN (SELECT appId FROM @ExcludedAppIds)
		ORDER BY [Throughput(MB/sec)] DESC
	END
	ELSE IF @i_param = 6 -- Top 25 Longest Running Jobs (slide 4)
	BEGIN
		DECLARE @now INT = dbo.GetUnixTime(GETUTCDATE())
		DECLARE @tblLongRunJobs TABLE (jobId INT, appId INT, [Duration(Hrs)] DECIMAL(10,2))
		INSERT INTO @tblLongRunJobs
		SELECT  TOP 25 B.jobId,B.appId, (B.servEndDate - B.servStartDate)/60.0/60.0 AS [Duration(Hrs)]
		FROM    JMBkpStats B WITH (NOLOCK) INNER JOIN App_Application A WITH (NOLOCK) ON B.appId = A.id
		WHERE   (B.status IN (1, 14) OR (B.status = 3 AND appType IN (SELECT type FROM APP_iDAType WITH (NOLOCK) WHERE isCWEjobValid = 1)))
			AND B.commCellId IN (SELECT id FROM App_CommCell WHERE type <> 1)
			AND B.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
			AND A.id NOT IN (SELECT appId FROM @ExcludedAppIds)
		ORDER BY [Duration(Hrs)] DESC
		DECLARE @LongRunSeconds INT = (SELECT MIN([Duration(Hrs)]) FROM @tblLongRunJobs)
		INSERT INTO @tblLongRunJobs
		SELECT  J.jobId, B.applicationId, (@now - J.jobStartTime)/60.0/60.0 AS [Duration(Hrs)]
		FROM    JMBkpJobInfo B WITH (NOLOCK)
				INNER JOIN JMJobInfo J WITH (NOLOCK)
				ON J.jobId = B.jobId AND J.commCellId = B.commcellId AND J.commCellId IN (SELECT id FROM App_CommCell WHERE type <> 1)
					AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
					AND (@now - J.jobStartTime) >= @LongRunSeconds
		SELECT TOP 25 CAST(LJ.jobId AS VARCHAR(15))+' ('+AC.displayName+')' AS Job, [Duration(Hrs)]
		FROM @tblLongRunJobs LJ
			INNER JOIN App_Application APP
				ON LJ.appId = APP.id
			INNER JOIN App_Client AC
				ON APP.clientId = AC.id
		WHERE [Duration(Hrs)] > 0
		ORDER BY [Duration(Hrs)] DESC
	END
	ELSE IF @i_param = 7 -- Performance of Last 25 Recovery Jobs (presenly not in PPT)
	BEGIN
		SELECT  TOP 25 R.jobId, CAST(ROUND(SUM(A.UncompBytes_l)/1024.0/1024.0/SUM(A.elapsedTime),3) AS DECIMAL(10,3)) AS [Throughput(MB/s)]
		FROM    JMRestoreStats R WITH (NOLOCK)
		INNER JOIN JMRestoreAtmptStats A WITH (NOLOCK) ON R.jobId = A.jobId
		INNER JOIN JMOpTable O WITH (NOLOCK) ON O.appTypeType = R.appType AND R.opType = O.operation
		INNER JOIN JMPhase P WITH (NOLOCK) ON A.phase = P.phase AND P.OpTableId = O.id
		WHERE   R.opType IN (5, 40) AND (R.rstattributes & 256) = 0  AND A.phase = 2 AND R.status IN (1, 3, 14)
		GROUP BY R.jobId
		ORDER BY R.jobId DESC
	END
	ELSE IF @i_param = 8 -- Top 25 Lowest Backup Performing Jobs (slide 5)
	BEGIN
		SELECT TOP 25 CAST(J.jobId AS VARCHAR(15))+' ('+AC.displayName+')' AS Job,
				CASE WHEN totalWriteTime > 0 THEN CAST((totalUnCompBytes/1024.0/1024.0/totalWriteTime) AS DECIMAL(20,6)) ELSE 0 END AS [Throughput(MB/sec)]
		FROM JmBkpStats J WITH (NOLOCK)
			INNER JOIN App_Application A WITH (NOLOCK) ON J.appId = A.id
			INNER JOIN App_Client AC WITH (NOLOCK) ON A.clientId = AC.id
		WHERE J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
			AND J.commCellId IN (SELECT id FROM App_CommCell WHERE type <> 1)
			AND  (J.status IN (1, 14) OR (J.status = 3 AND J.appType IN (SELECT type FROM APP_iDAType WITH (NOLOCK) WHERE isCWEjobValid = 1)))
			AND A.id NOT IN (SELECT appId FROM @ExcludedAppIds)
			AND totalWriteTime <> 0 AND totalUnCompBytes <> 0
		ORDER BY [Throughput(MB/sec)]
	END
	ELSE IF @i_param = 9 -- Top 10 unreliable clients (slide 6)
	BEGIN
		SELECT TOP 10 AC.displayName AS ClientName, COUNT(DISTINCT J.jobId ) AS FailuresCount
		FROM JmBkpStats J WITH (NOLOCK)
			INNER JOIN App_Application A WITH (NOLOCK)
				ON J.appId = A.id
				   AND (J.status = 2 OR (J.status = 3 AND J.appType NOT IN (SELECT type FROM APP_iDAType WITH (NOLOCK) WHERE isCWEjobValid = 1)))
				   AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
				   AND J.commCellId IN (SELECT id FROM App_CommCell WHERE type <> 1)
				   AND A.id NOT IN (SELECT appId FROM @ExcludedAppIds)
			INNER JOIN App_Client AC WITH (NOLOCK)
				ON AC.id = A.clientId
		GROUP BY A.clientId, AC.displayName
		ORDER BY FailuresCount DESC
	END
	ELSE IF @i_param = 10 -- Top 10 unreliable clients count (slide 6)
	BEGIN
		SELECT COUNT(DISTINCT A.clientId ) AS ClientCount
		FROM JmBkpStats J WITH (NOLOCK)
			INNER JOIN App_Application A WITH (NOLOCK)
				ON J.appId = A.id
				   AND (J.status = 2 OR (J.status = 3 AND J.appType NOT IN (SELECT type FROM APP_iDAType WITH (NOLOCK) WHERE isCWEjobValid = 1)))
				   AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
				   AND J.commCellId IN (SELECT id FROM App_CommCell WHERE type <> 1)
				   AND A.id NOT IN (SELECT appId FROM @ExcludedAppIds)
	END
	ELSE IF @i_param = 11 -- SLowest clients slide 7
	BEGIN
		IF OBJECT_ID('tempDB..#SlowCLients') IS NOT NULL
			DROP TABLE #SlowCLients
		DECLARE @MultipFactor FLOAT = 1.0, @DividingFact FLOAT = 1.0, @unit VARCHAR(5) = 'MB/s'
		SELECT Top 10 C.name AS ClientName, CAST(([Throughput(MB/sec)]/NoOfJobs) AS DECIMAL(20,6)) AS [Throughput(MB/sec)]
		INTO #SlowCLients
		FROM App_CLient C
		INNER JOIN (SELECT App.clientId, SUM(totalUnCompBytes/1024.0/1024.0/totalWriteTime) AS [Throughput(MB/sec)], COUNT(jobId) AS NoOfJobs
					FROM JmBkpStats J WITH (NOLOCK)
						INNER JOIN App_Application App WITH (NOLOCK)
							ON J.appId = App.id
					WHERE J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) AND J.commCellId IN (SELECT id FROM App_CommCell WHERE type <> 1)
						AND  (J.status IN (1, 14) OR (J.status = 3 AND J.appType IN (SELECT type FROM APP_iDAType WITH (NOLOCK) WHERE isCWEjobValid = 1)))
						AND App.id NOT IN (SELECT appId FROM @ExcludedAppIds)
						AND totalWriteTime <> 0
					GROUP BY App.clientId
					) I
			ON C.id = I.clientId
		ORDER BY [Throughput(MB/sec)]
		--IF (SELECT AVG([Throughput(MB/sec)]) FROM #SlowCLients) < 1.0
		--BEGIN
		--	SELECT ClientName, CAST(([Throughput(MB/sec)] * 1024.0) AS DECIMAL(10,3)) AS Throughput
		--	FROM #SlowCLients
		--END
		--ELSE IF (SELECT AVG([Throughput(MB/sec)]) FROM #SlowCLients) >= 1024.0
		--BEGIN
		--	SELECT ClientName, CAST(([Throughput(MB/sec)]/1024.0) AS DECIMAL(10,3))  AS Throughput
		--	FROM #SlowCLients
		--END
		--ELSE
			SELECT ClientName, CAST([Throughput(MB/sec)] AS DECIMAL(10,3))  AS Throughput
			FROM #SlowCLients
		IF OBJECT_ID('tempDB..#SlowCLients') IS NOT NULL
			DROP TABLE #SlowCLients
	END
	ELSE IF @i_param = 12 -- Largest clients slide 14: 9:Weekly (slide 8)
	BEGIN
		IF OBJECT_ID('tempdb..#LargestCLients') IS NOT NULL
			DROP TABLE #LargestCLients
		SET @lastJobDate = (SELECT MAX(servEndDate)
							FROM JmBkpStats J WITH (NOLOCK)
								INNER JOIN App_Application App WITH (NOLOCK)
									ON J.appId = App.id
							WHERE J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) AND J.commCellId IN (SELECT id FROM App_CommCell WHERE type <> 1)
								AND  (J.status IN (1, 14) OR (J.status = 3 AND J.appType IN (SELECT type FROM APP_iDAType WITH (NOLOCK) WHERE isCWEjobValid = 1)))
								AND App.id NOT IN (SELECT appId FROM @ExcludedAppIds))
		SET @nDays = -7
		--SELECT CAST(DATEADD(DD, @nDays, dbo.getdateTime(@lastJobDate)) AS DATE)
		SET @LastWeekDate = dbo.getunixtime(CAST(DATEADD(DD, @nDays, dbo.getdateTime(@lastJobDate)) AS DATE))
		SELECT  AC.displayName,
					STUFF((SELECT DISTINCT ', '+(CASE WHEN ISNULL(AAT.osGroup+' '+AAT.App,'') = '' THEN I.name
							WHEN ISNULL(AAT.osGroup,'')= '' THEN AAT.App
							ELSE AAT.osGroup END)
						    FROM  App_Application App
								INNER JOIN App_Client AC ON AC.id = App.clientId AND AC.origCCId IN (SELECT id FROM App_CommCell WHERE type <> 1)
								INNER JOIN APP_iDAType I WITH (NOLOCK) ON App.appTypeId = I.type AND App.clientId = A.clientId
								LEFT JOIN App_AppTypeGroups AAT WITH (NOLOCK) ON App.appTypeId = AAT.appTypeId
							FOR XML PATH('')),1,2,'')
						AS OS,
					SUM(totalUncompBytes)/1024.0/1024.0/1024.0 AS TotalAppSizeGB
		INTO #LargestCLients
		FROM JMBkpStats J WITH (NOLOCK)
			INNER JOIN APP_Application A WITH (NOLOCK)
				ON J.appId= A.id AND J.servEndDate >= @LastWeekDate
				AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
				AND  (J.status IN (1, 14) OR (status = 3 AND appType IN (SELECT type FROM APP_iDAType WITH (NOLOCK) WHERE isCWEjobValid = 1)))
			INNER JOIN App_Client AC
				ON A.clientId = AC.id AND AC.origCCId IN (SELECT id FROM App_CommCell WHERE type <> 1)
		WHERE A.id NOT IN (SELECT appId FROM @ExcludedAppIds)
		GROUP BY A.clientId, AC.displayName
		SELECT TOP 10 displayName+'('+OS+')' AS ClientName, CAST(TotalAppSizeGB AS DECIMAL(10,2)) AS TotalAppSizeGB FROM #LargestCLients
		ORDER BY TotalAppSizeGB DESC
		IF OBJECT_ID('tempdb..#LargestCLients') IS NOT NULL
			DROP TABLE #LargestCLients
	END
	ELSE IF @i_param IN (13, 16) -- Disk and Tape Library Info (slide 9)
	BEGIN
		IF OBJECT_ID('tempdb..#LibraryInfo') IS NOT NULL
			DROP TABLE #LibraryInfo
		SELECT CASE WHEN L.LibraryTypeId IN (1, 2) THEN 'Tape'
						ELSE 'Disk' END AS 'Type',
				L.AliasName AS 'Name',
				CASE 1 - (L.LibrarySoftState & L.LibraryEnabled & (1 - L.LibraryBroken) & LC.OnLine)
					WHEN 1 THEN 'Yes'
					ELSE 'No'
				END AS 'Online',
				L.LibraryModel AS 'Model',
				L.SerialNumber AS 'Serial Number',
				L.FirmwareRevision AS 'Firmware Revision'
		INTO #LibraryInfo
		FROM    MMLibrary L WITH (NOLOCK)
				INNER JOIN (
					SELECT  LibraryId, MAX(LibraryControllerSoftState & LibraryControllerEnabled & LibraryControllerActive) AS OnLine
					FROM    MMLibraryController WITH (NOLOCK)
					GROUP BY LibraryId
					) LC ON L.LibraryId = LC.LibraryId
				LEFT OUTER JOIN (
					SELECT  LibraryId
					FROM    MMMountPath WITH (NOLOCK)
					WHERE   MountPathTypeId = 7
					GROUP BY LibraryId
					) CL ON L.LibraryId = CL.LibraryId
		WHERE   L.LibraryId > 0 AND L.LibraryTypeId != 8
				AND CL.LibraryId IS NULL
				AND L.LibraryTypeId IN (1, 2, 3) -- 1,2 : Tape, 3: Disk
		ORDER BY Type, Name
		IF  @i_param = 13
			SELECT TOP 5 * FROM #LibraryInfo WHERE Type = 'Disk'
			UNION
			SELECT TOP 5 * FROM #LibraryInfo WHERE Type = 'Tape'
			ORDER BY Type, Name
		ELSE
		BEGIN
			DECLARE @diskCount INT = ISNULL((SELECT Count(*) AS 'Library Count' FROM #LibraryInfo WHERE Type = 'Disk'), 0)
			DECLARE @tapeCount INT = ISNULL((SELECT Count(*) AS 'Library Count' FROM #LibraryInfo WHERE Type = 'Tape'), 0)
			SELECT 'Disk' AS Type, @diskCount AS 'Library Count'
			UNION
			SELECT 'Tape' AS Type, @tapeCount AS 'Library Count'
		END
		IF OBJECT_ID('tempdb..#LibraryInfo') IS NOT NULL
			DROP TABLE #LibraryInfo
	END
	ELSE IF @i_param  = 15 -- Agent wise backed up data for last month (slide 10)
	BEGIN
		SET @lastJobDate = (SELECT MAX(servEndDate)
							FROM JmBkpStats J WITH (NOLOCK)
								WHERE J.commCellId IN (SELECT id FROM App_CommCell WHERE type <> 1))
		DECLARE @nMonths INT = -1
		--SELECT CAST(DATEADD(DD, @nDays, dbo.getdateTime(@lastJobDate)) AS DATE)
		DECLARE @LastMonthDate INT = dbo.getunixtime(CAST(DATEADD(DD, @nMonths, dbo.getdateTime(@lastJobDate)) AS DATE))
		SELECT TOP 10 OS, CAST((SUM(totalUncompBytes)/1024.0/1024.0/1024.0) AS DECIMAL(10,2)) AS TotalAppSizeGB
		FROM
		( SELECT  DISTINCT
					CASE WHEN ISNULL(AAT.osGroup+' '+AAT.App,'') = '' THEN I.name
							WHEN ISNULL(AAT.osGroup,'') = '' THEN AAT.App
							ELSE AAT.osGroup END AS OS,
					totalUncompBytes
		FROM JMBkpStats J WITH (NOLOCK)
			INNER JOIN APP_Application A WITH (NOLOCK)
				ON J.appId= A.id AND J.servEndDate >= @LastMonthDate
				AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) AND J.commCellId IN (SELECT id FROM App_CommCell WHERE type <> 1)
				AND  (J.status IN (1, 14) OR (status = 3 AND appType IN (SELECT type FROM APP_iDAType WITH (NOLOCK) WHERE isCWEjobValid = 1)))
			INNER JOIN APP_iDAType I WITH (NOLOCK) ON A.appTypeId = I.type
			LEFT JOIN App_AppTypeGroups AAT WITH (NOLOCK) ON A.appTypeId = AAT.appTypeId
		WHERE A.id NOT IN (SELECT appId FROM @ExcludedAppIds)    ) I
		GROUP BY I.OS
		ORDER BY TotalAppSizeGB DESC
	END
SET NOCOUNT OFF
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'RptNBUPpt')
	delete from GxQscripts where name = 'RptNBUPpt'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptNBUPpt')
	delete from GXDBVersions where aliasname = 'RptNBUPpt'
GO

insert into GXDBVersions values(2, 'RptNBUPpt',  '00010003000200170000', 'RptNBUPpt', '00010003000200170000')
GO

