

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptNASClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptNASClients.sp,v $ $Id: RptNASClients.sp,v 1.18.208.5 2018/11/18 03:50:01 skatz Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "RptNASClients"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptNASClients')
BEGIN
	print '>>> Drop Stored Procedure: RptNASClients <<<'
	drop procedure RptNASClients
END
IF EXISTS (select * from GxQscripts where name='RptNASClients')
	delete from GxQscripts where name = 'RptNASClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptNASClients')
	delete from GXDBVersions where aliasname = 'RptNASClients'
GO
print '... Creating Procedure: RptNASClients'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptNASClients
  @i_jobId integer
AS
  DECLARE @o_clientName nchar(255);
  DECLARE @o_archFileName NVARCHAR(2048);
  DECLARE @o_archFileId integer;
  DECLARE @o_commcellId integer;
  DECLARE @o_backupTime integer;
  DECLARE @o_backupLevel integer;
  DECLARE @o_StoragePolicyName NVARCHAR(255);
  DECLARE @o_StoragePolicyCopyName NVARCHAR(255);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userId		integer
DECLARE @startTime	integer
DECLARE @endTime	integer
DECLARE @policyId	integer
DECLARE @tblPolicy	TABLE (poId int)
DECLARE @tblArchFile	TABLE (afId int, name NVARCHAR(2048), ccId int, agId int, appId int, cTime int, bkpLevel int, copyId int)
SET @userId		= dbo.GetOptionInt(140019, @i_jobId, 0, 0)
EXEC RptOptGetTime @i_jobId, @startTime OUTPUT, @endTime OUTPUT
INSERT INTO @tblPolicy EXEC rptOptGetObjectList @i_jobId, 1242473090, @policyId OUTPUT
INSERT INTO @tblArchFile
SELECT	id, name, commCellId, archGroupId, appId, cTime, backupLevel, 0
FROM	archFile
WHERE	isValid = 1 AND (@startTime = 0 OR CTime >= @startTime) AND (@endTime = 0 OR CTime <= @endTime) AND
	(@policyId = 0 OR archGroupId in (select poId from @tblPolicy))
delete @tblArchFile
FROM	archFileCopy C, MMDrivePool P
WHERE	ccId = commCellId AND afId=archFileId AND C.drivePoolId=P.drivePoolId AND P.drivePoolType<>3
--got all qualified entries, do the security check before more details and summary
DECLARE @isUserAdmin INT = 0
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
IF @userId > 0 AND @isUserAdmin = 0 AND @policyId <= 0
BEGIN
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2009, 0, '#rptUserObjects'	-- 2009 = CLIENT_ITEM
	delete #rptUserObjects
	WHERE clientGroupId <> 0 OR mediaAgentId <> 0 OR libraryID <> 0 OR archGroupID <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	OR taskId <> 0
	delete	@tblArchFile
	FROM	APP_Application A, @tblArchFile F
	WHERE	F.appId = A.id AND NOT EXISTS (	select	* from #rptUserObjects U
					 	where	U.clientId IN (0, A.clientId) AND
							U.appTypeId IN (0,A.appTypeId) AND
							U.instanceId IN (0,A.instance) AND
							U.backupsetId IN (0,A.backupSet) AND
							U.subClientId IN (0,A.id))
	DROP TABLE #rptUserObjects
END
UPDATE @tblArchFile
SET	copyId = archCopyId
FROM	archFileCopy
WHERE	ccId = commCellId AND afId=archFileId
SELECT clientName=(select displayName from APP_Client where id=A.clientId), F.name, F.afid, F.ccId, F.cTime, F.bkpLevel,
	StoragePolicyName=(select name from archGroup where id=F.agId),	StoragePolicyCopyName=(select name from archGroupCopy where id=F.copyId)
FROM APP_Application A, @tblArchFile F
WHERE A.appTypeId=13 AND A.id=F.appId
ORDER BY StoragePolicyName, StoragePolicyCopyName
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptNASClients')
	delete from GxQscripts where name = 'RptNASClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptNASClients')
	delete from GXDBVersions where aliasname = 'RptNASClients'
GO

insert into GXDBVersions values(2, 'RptNASClients',  '00010018020800050000', 'RptNASClients', '00010018020800050000')
GO

